// services/network/public/mojom/trust_token_access_observer.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class TrustTokenAccessObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.TrustTokenAccessObserver', scope);
  }
}

/** @interface */
export class TrustTokenAccessObserverInterface {
  
  /**
   * @param { !TrustTokenAccessDetails } details
   */

  onTrustTokensAccessed(details) {}
  
  /**
   * @param { !TrustTokenAccessObserverPendingReceiver } listener
   */

  clone(listener) {}
}

/**
 * @implements { TrustTokenAccessObserverInterface }
 */
export class TrustTokenAccessObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!TrustTokenAccessObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          TrustTokenAccessObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!TrustTokenAccessObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !TrustTokenAccessDetails } details
   */

  onTrustTokensAccessed(
      details) {
    this.proxy.sendMessage(
        0,
        TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsSpec.$,
        null,
        [
          details
        ],
        false);
  }

  
  /**
   * @param { !TrustTokenAccessObserverPendingReceiver } listener
   */

  clone(
      listener) {
    this.proxy.sendMessage(
        1,
        TrustTokenAccessObserver_Clone_ParamsSpec.$,
        null,
        [
          listener
        ],
        false);
  }
}

/**
 * An object which receives request messages for the TrustTokenAccessObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class TrustTokenAccessObserverReceiver {
  /**
   * @param {!TrustTokenAccessObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!TrustTokenAccessObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        TrustTokenAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TrustTokenAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsSpec.$,
        null,
        impl.onTrustTokensAccessed.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        TrustTokenAccessObserver_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class TrustTokenAccessObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.TrustTokenAccessObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!TrustTokenAccessObserverRemote}
   */
  static getRemote() {
    let remote = new TrustTokenAccessObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the TrustTokenAccessObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class TrustTokenAccessObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      TrustTokenAccessObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!TrustTokenAccessObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTrustTokensAccessed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsSpec.$,
        null,
        this.onTrustTokensAccessed.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        TrustTokenAccessObserver_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenIssuanceDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenRedemptionDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenSigningDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const TrustTokenAccessObserver_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const TrustTokenAccessDetailsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    TrustTokenIssuanceDetailsSpec.$,
    'TrustTokenIssuanceDetails',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'issuer', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blocked', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TrustTokenIssuanceDetails {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { (url_mojom_Origin|undefined) } */
    this.issuer;
    /** @type { !boolean } */
    this.blocked;
  }
}



mojo.internal.Struct(
    TrustTokenRedemptionDetailsSpec.$,
    'TrustTokenRedemptionDetails',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'issuer', 8,
        0,
        url_mojom_OriginSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blocked', 16,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class TrustTokenRedemptionDetails {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { (url_mojom_Origin|undefined) } */
    this.issuer;
    /** @type { !boolean } */
    this.blocked;
  }
}



mojo.internal.Struct(
    TrustTokenSigningDetailsSpec.$,
    'TrustTokenSigningDetails',
    [
      mojo.internal.StructField(
        'origin', 0,
        0,
        url_mojom_OriginSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'blocked', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TrustTokenSigningDetails {
  constructor() {
    /** @type { !url_mojom_Origin } */
    this.origin;
    /** @type { !boolean } */
    this.blocked;
  }
}



mojo.internal.Struct(
    TrustTokenAccessObserver_OnTrustTokensAccessed_ParamsSpec.$,
    'TrustTokenAccessObserver_OnTrustTokensAccessed_Params',
    [
      mojo.internal.StructField(
        'details', 0,
        0,
        TrustTokenAccessDetailsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class TrustTokenAccessObserver_OnTrustTokensAccessed_Params {
  constructor() {
    /** @type { !TrustTokenAccessDetails } */
    this.details;
  }
}



mojo.internal.Struct(
    TrustTokenAccessObserver_Clone_ParamsSpec.$,
    'TrustTokenAccessObserver_Clone_Params',
    [
      mojo.internal.StructField(
        'listener', 0,
        0,
        mojo.internal.InterfaceRequest(TrustTokenAccessObserverPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class TrustTokenAccessObserver_Clone_Params {
  constructor() {
    /** @type { !TrustTokenAccessObserverPendingReceiver } */
    this.listener;
  }
}

mojo.internal.Union(
    TrustTokenAccessDetailsSpec.$, 'TrustTokenAccessDetails',
    {
      'issuance': {
        'ordinal': 0,
        'type': TrustTokenIssuanceDetailsSpec.$,
      },
      'redemption': {
        'ordinal': 1,
        'type': TrustTokenRedemptionDetailsSpec.$,
      },
      'signing': {
        'ordinal': 2,
        'type': TrustTokenSigningDetailsSpec.$,
      },
    });

/**
 * @typedef { {
 *   issuance: (!TrustTokenIssuanceDetails|undefined),
 *   redemption: (!TrustTokenRedemptionDetails|undefined),
 *   signing: (!TrustTokenSigningDetails|undefined),
 * } }
 */
export const TrustTokenAccessDetails = {};
