// services/network/public/mojom/tcp_socket.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/tcp_socket.mojom-shared-internal.h"
#include "services/network/public/mojom/address_list.mojom-shared.h"
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"
#include "services/network/public/mojom/ssl_config.mojom-shared.h"
#include "services/network/public/mojom/tls_socket.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom-shared.h"
#include "services/network/public/mojom/socket_connection_tracker.mojom-shared.h"

#include "services/network/public/mojom/tcp_socket.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TCPKeepAliveOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TCPKeepAliveOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TCPKeepAliveOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->enable = Traits::enable(input);

      fragment->delay = Traits::delay(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TCPConnectedSocketOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TCPConnectedSocketOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TCPConnectedSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->send_buffer_size = Traits::send_buffer_size(input);

      fragment->receive_buffer_size = Traits::receive_buffer_size(input);

      fragment->no_delay = Traits::no_delay(input);

      decltype(Traits::keep_alive_options(input)) in_keep_alive_options = Traits::keep_alive_options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->keep_alive_options)::BaseType> keep_alive_options_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::TCPKeepAliveOptionsDataView, send_validation>(
        in_keep_alive_options,
        keep_alive_options_fragment);

      fragment->keep_alive_options.Set(
          keep_alive_options_fragment.is_null() ? nullptr : keep_alive_options_fragment.data());
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::TCPServerSocketOptionsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TCPServerSocketOptionsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::TCPServerSocketOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->backlog = Traits::backlog(input);
      fragment->ipv6_only_$flag = Traits::ipv6_only(input).has_value();
      if (Traits::ipv6_only(input).has_value()) {
        fragment->ipv6_only_$value = Traits::ipv6_only(input).value();
      }
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TCP_SOCKET_MOJOM_SEND_VALIDATION_H_