// services/network/public/mojom/system_dns_resolution.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  AddressFamily as network_mojom_AddressFamily,
  AddressFamilySpec as network_mojom_AddressFamilySpec
} from './address_family.mojom.m.js';

import {
  AddressList as network_mojom_AddressList,
  AddressListSpec as network_mojom_AddressListSpec
} from './address_list.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SystemDnsResolverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.SystemDnsResolver', scope);
  }
}

/** @interface */
export class SystemDnsResolverInterface {
  
  /**
   * @param { ?string } hostname
   * @param { !network_mojom_AddressFamily } addrFamily
   * @param { !number } flags
   * @param { !bigint } network
   * @return {!Promise<{
        addrList: !network_mojom_AddressList,
        osError: !number,
        netError: !number,
   *  }>}
   */

  resolve(hostname, addrFamily, flags, network) {}
}

/**
 * @implements { SystemDnsResolverInterface }
 */
export class SystemDnsResolverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SystemDnsResolverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SystemDnsResolverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SystemDnsResolverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { ?string } hostname
   * @param { !network_mojom_AddressFamily } addrFamily
   * @param { !number } flags
   * @param { !bigint } network
   * @return {!Promise<{
        addrList: !network_mojom_AddressList,
        osError: !number,
        netError: !number,
   *  }>}
   */

  resolve(
      hostname,
      addrFamily,
      flags,
      network) {
    return this.proxy.sendMessage(
        0,
        SystemDnsResolver_Resolve_ParamsSpec.$,
        SystemDnsResolver_Resolve_ResponseParamsSpec.$,
        [
          hostname,
          addrFamily,
          flags,
          network
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SystemDnsResolver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SystemDnsResolverReceiver {
  /**
   * @param {!SystemDnsResolverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SystemDnsResolverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SystemDnsResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SystemDnsResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SystemDnsResolver_Resolve_ParamsSpec.$,
        SystemDnsResolver_Resolve_ResponseParamsSpec.$,
        impl.resolve.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SystemDnsResolver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.SystemDnsResolver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SystemDnsResolverRemote}
   */
  static getRemote() {
    let remote = new SystemDnsResolverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SystemDnsResolver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SystemDnsResolverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SystemDnsResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SystemDnsResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolve =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SystemDnsResolver_Resolve_ParamsSpec.$,
        SystemDnsResolver_Resolve_ResponseParamsSpec.$,
        this.resolve.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemDnsResolver_Resolve_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SystemDnsResolver_Resolve_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    SystemDnsResolver_Resolve_ParamsSpec.$,
    'SystemDnsResolver_Resolve_Params',
    [
      mojo.internal.StructField(
        'hostname', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'addrFamily', 8,
        0,
        network_mojom_AddressFamilySpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'flags', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'network', 16,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class SystemDnsResolver_Resolve_Params {
  constructor() {
    /** @type { (string|undefined) } */
    this.hostname;
    /** @type { !network_mojom_AddressFamily } */
    this.addrFamily;
    /** @type { !number } */
    this.flags;
    /** @type { !bigint } */
    this.network;
  }
}



mojo.internal.Struct(
    SystemDnsResolver_Resolve_ResponseParamsSpec.$,
    'SystemDnsResolver_Resolve_ResponseParams',
    [
      mojo.internal.StructField(
        'addrList', 0,
        0,
        network_mojom_AddressListSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'osError', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'netError', 12,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class SystemDnsResolver_Resolve_ResponseParams {
  constructor() {
    /** @type { !network_mojom_AddressList } */
    this.addrList;
    /** @type { !number } */
    this.osError;
    /** @type { !number } */
    this.netError;
  }
}

