// services/network/public/mojom/structured_headers.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_STRUCTURED_HEADERS_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_STRUCTURED_HEADERS_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/structured_headers.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/structured_headers.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/structured_headers.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/structured_headers_mojom_traits.h"




namespace network::mojom {










class  StructuredHeadersItem {
 public:
  using DataView = StructuredHeadersItemDataView;
  using Data_ = internal::StructuredHeadersItem_Data;
  using Tag = Data_::StructuredHeadersItem_Tag;

  template <typename... Args>
  static StructuredHeadersItemPtr New(Args&&... args) {
    static_assert(
        sizeof...(args) < 0,
        "Do not use Union::New(); to create a union of a given subtype, use "
        "New<SubType>(), not New() followed by set_<sub_type>(). To represent "
        "an empty union, mark the field or parameter as nullable in the mojom "
        "definition.");
    return nullptr;
  }

  // Construct an instance holding |null_value|.
  static StructuredHeadersItemPtr NewNullValue(
      uint8_t value);
  // Construct an instance holding |integer_value|.
  static StructuredHeadersItemPtr NewIntegerValue(
      int64_t value);
  // Construct an instance holding |decimal_value|.
  static StructuredHeadersItemPtr NewDecimalValue(
      double value);
  // Construct an instance holding |string_value|.
  static StructuredHeadersItemPtr NewStringValue(
      const std::string& value);
  // Construct an instance holding |token_value|.
  static StructuredHeadersItemPtr NewTokenValue(
      const std::string& value);
  // Construct an instance holding |byte_sequence_value|.
  static StructuredHeadersItemPtr NewByteSequenceValue(
      const std::string& value);
  // Construct an instance holding |boolean_value|.
  static StructuredHeadersItemPtr NewBooleanValue(
      bool value);

  template <typename U>
  static StructuredHeadersItemPtr From(const U& u) {
    return mojo::TypeConverter<StructuredHeadersItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StructuredHeadersItem>::Convert(*this);
  }
  ~StructuredHeadersItem();

  // Delete the copy constructor and copy assignment operators because `data_`
  // contains raw pointers that must not be copied.
  StructuredHeadersItem(const StructuredHeadersItem& other) = delete;
  StructuredHeadersItem& operator=(const StructuredHeadersItem& other) = delete;

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = StructuredHeadersItemPtr>
  StructuredHeadersItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, StructuredHeadersItem>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  template <typename T,
            typename std::enable_if<std::is_same<
                T, StructuredHeadersItem>::value>::type* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  Tag which() const {
    return tag_;
  }

  bool is_null_value() const { return tag_ == Tag::kNullValue; }
  uint8_t get_null_value() const {
    CHECK(tag_ == Tag::kNullValue);
    return data_.null_value;
  }
  void set_null_value(uint8_t null_value);

  bool is_integer_value() const { return tag_ == Tag::kIntegerValue; }
  int64_t get_integer_value() const {
    CHECK(tag_ == Tag::kIntegerValue);
    return data_.integer_value;
  }
  void set_integer_value(int64_t integer_value);

  bool is_decimal_value() const { return tag_ == Tag::kDecimalValue; }
  double get_decimal_value() const {
    CHECK(tag_ == Tag::kDecimalValue);
    return data_.decimal_value;
  }
  void set_decimal_value(double decimal_value);

  bool is_string_value() const { return tag_ == Tag::kStringValue; }
  const std::string& get_string_value() const {
    CHECK(tag_ == Tag::kStringValue);
    return data_.string_value;
  }
  std::string& get_string_value() {
    CHECK(tag_ == Tag::kStringValue);
    return data_.string_value;
  }
  void set_string_value(const std::string& string_value);

  bool is_token_value() const { return tag_ == Tag::kTokenValue; }
  const std::string& get_token_value() const {
    CHECK(tag_ == Tag::kTokenValue);
    return data_.token_value;
  }
  std::string& get_token_value() {
    CHECK(tag_ == Tag::kTokenValue);
    return data_.token_value;
  }
  void set_token_value(const std::string& token_value);

  bool is_byte_sequence_value() const { return tag_ == Tag::kByteSequenceValue; }
  const std::string& get_byte_sequence_value() const {
    CHECK(tag_ == Tag::kByteSequenceValue);
    return data_.byte_sequence_value;
  }
  std::string& get_byte_sequence_value() {
    CHECK(tag_ == Tag::kByteSequenceValue);
    return data_.byte_sequence_value;
  }
  void set_byte_sequence_value(const std::string& byte_sequence_value);

  bool is_boolean_value() const { return tag_ == Tag::kBooleanValue; }
  bool get_boolean_value() const {
    CHECK(tag_ == Tag::kBooleanValue);
    return data_.boolean_value;
  }
  void set_boolean_value(bool boolean_value);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StructuredHeadersItem::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<StructuredHeadersItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

 private:
  template <typename T>
  friend class ::mojo::InlinedStructPtr;
  template <typename T>
  friend class ::mojo::StructPtr;

  union Union_ {
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kNullValue)>,
        uint8_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kIntegerValue)>,
        int64_t value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kDecimalValue)>,
        double value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kStringValue)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kTokenValue)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kByteSequenceValue)>,
        const std::string& value);
    Union_(
        std::in_place_index_t<static_cast<size_t>(Tag::kBooleanValue)>,
        bool value);
    // The contents of the union are explicitly destroyed by `DestroyActive()`.
    ~Union_() {}

    uint8_t null_value;
    int64_t integer_value;
    double decimal_value;
    std::string string_value;
    std::string token_value;
    std::string byte_sequence_value;
    bool boolean_value;
  };

  StructuredHeadersItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kNullValue)>,
      uint8_t value);
  StructuredHeadersItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kIntegerValue)>,
      int64_t value);
  StructuredHeadersItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kDecimalValue)>,
      double value);
  StructuredHeadersItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kStringValue)>,
      const std::string& value);
  StructuredHeadersItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kTokenValue)>,
      const std::string& value);
  StructuredHeadersItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kByteSequenceValue)>,
      const std::string& value);
  StructuredHeadersItem(
      std::in_place_index_t<static_cast<size_t>(Tag::kBooleanValue)>,
      bool value);

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  StructuredHeadersParameter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StructuredHeadersParameter, T>::value>;
  using DataView = StructuredHeadersParameterDataView;
  using Data_ = internal::StructuredHeadersParameter_Data;

  template <typename... Args>
  static StructuredHeadersParameterPtr New(Args&&... args) {
    return StructuredHeadersParameterPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StructuredHeadersParameterPtr From(const U& u) {
    return mojo::TypeConverter<StructuredHeadersParameterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StructuredHeadersParameter>::Convert(*this);
  }


  StructuredHeadersParameter();

  StructuredHeadersParameter(
      const std::string& key,
      ::net::structured_headers::Item item);

StructuredHeadersParameter(const StructuredHeadersParameter&) = delete;
StructuredHeadersParameter& operator=(const StructuredHeadersParameter&) = delete;

  ~StructuredHeadersParameter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StructuredHeadersParameterPtr>
  StructuredHeadersParameterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StructuredHeadersParameter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StructuredHeadersParameter::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StructuredHeadersParameter::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StructuredHeadersParameter::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StructuredHeadersParameter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StructuredHeadersParameter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StructuredHeadersParameter_UnserializedMessageContext<
            UserType, StructuredHeadersParameter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StructuredHeadersParameter::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StructuredHeadersParameter::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StructuredHeadersParameter_UnserializedMessageContext<
            UserType, StructuredHeadersParameter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StructuredHeadersParameter::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string key;
  
  ::net::structured_headers::Item item;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StructuredHeadersParameter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StructuredHeadersParameter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StructuredHeadersParameter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StructuredHeadersParameter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  StructuredHeadersParameterizedItem {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StructuredHeadersParameterizedItem, T>::value>;
  using DataView = StructuredHeadersParameterizedItemDataView;
  using Data_ = internal::StructuredHeadersParameterizedItem_Data;

  template <typename... Args>
  static StructuredHeadersParameterizedItemPtr New(Args&&... args) {
    return StructuredHeadersParameterizedItemPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StructuredHeadersParameterizedItemPtr From(const U& u) {
    return mojo::TypeConverter<StructuredHeadersParameterizedItemPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StructuredHeadersParameterizedItem>::Convert(*this);
  }


  StructuredHeadersParameterizedItem();

  StructuredHeadersParameterizedItem(
      ::net::structured_headers::Item item,
      std::vector<std::pair<std::string, ::net::structured_headers::Item>> parameters);

StructuredHeadersParameterizedItem(const StructuredHeadersParameterizedItem&) = delete;
StructuredHeadersParameterizedItem& operator=(const StructuredHeadersParameterizedItem&) = delete;

  ~StructuredHeadersParameterizedItem();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StructuredHeadersParameterizedItemPtr>
  StructuredHeadersParameterizedItemPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StructuredHeadersParameterizedItem::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StructuredHeadersParameterizedItem::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StructuredHeadersParameterizedItem::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StructuredHeadersParameterizedItem::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StructuredHeadersParameterizedItem::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StructuredHeadersParameterizedItem::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StructuredHeadersParameterizedItem_UnserializedMessageContext<
            UserType, StructuredHeadersParameterizedItem::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StructuredHeadersParameterizedItem::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StructuredHeadersParameterizedItem::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StructuredHeadersParameterizedItem_UnserializedMessageContext<
            UserType, StructuredHeadersParameterizedItem::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StructuredHeadersParameterizedItem::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::structured_headers::Item item;
  
  std::vector<std::pair<std::string, ::net::structured_headers::Item>> parameters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StructuredHeadersParameterizedItem::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StructuredHeadersParameterizedItem::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StructuredHeadersParameterizedItem::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StructuredHeadersParameterizedItem::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  StructuredHeadersParameterizedMember {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StructuredHeadersParameterizedMember, T>::value>;
  using DataView = StructuredHeadersParameterizedMemberDataView;
  using Data_ = internal::StructuredHeadersParameterizedMember_Data;

  template <typename... Args>
  static StructuredHeadersParameterizedMemberPtr New(Args&&... args) {
    return StructuredHeadersParameterizedMemberPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StructuredHeadersParameterizedMemberPtr From(const U& u) {
    return mojo::TypeConverter<StructuredHeadersParameterizedMemberPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StructuredHeadersParameterizedMember>::Convert(*this);
  }


  StructuredHeadersParameterizedMember();

  StructuredHeadersParameterizedMember(
      std::vector<::net::structured_headers::ParameterizedItem> member,
      bool member_is_inner_list,
      std::vector<std::pair<std::string, ::net::structured_headers::Item>> parameters);

StructuredHeadersParameterizedMember(const StructuredHeadersParameterizedMember&) = delete;
StructuredHeadersParameterizedMember& operator=(const StructuredHeadersParameterizedMember&) = delete;

  ~StructuredHeadersParameterizedMember();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StructuredHeadersParameterizedMemberPtr>
  StructuredHeadersParameterizedMemberPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StructuredHeadersParameterizedMember::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StructuredHeadersParameterizedMember::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StructuredHeadersParameterizedMember::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StructuredHeadersParameterizedMember::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StructuredHeadersParameterizedMember::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StructuredHeadersParameterizedMember::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StructuredHeadersParameterizedMember_UnserializedMessageContext<
            UserType, StructuredHeadersParameterizedMember::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StructuredHeadersParameterizedMember::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StructuredHeadersParameterizedMember::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StructuredHeadersParameterizedMember_UnserializedMessageContext<
            UserType, StructuredHeadersParameterizedMember::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StructuredHeadersParameterizedMember::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::net::structured_headers::ParameterizedItem> member;
  
  bool member_is_inner_list;
  
  std::vector<std::pair<std::string, ::net::structured_headers::Item>> parameters;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StructuredHeadersParameterizedMember::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StructuredHeadersParameterizedMember::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StructuredHeadersParameterizedMember::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StructuredHeadersParameterizedMember::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  StructuredHeadersDictionaryMember {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StructuredHeadersDictionaryMember, T>::value>;
  using DataView = StructuredHeadersDictionaryMemberDataView;
  using Data_ = internal::StructuredHeadersDictionaryMember_Data;

  template <typename... Args>
  static StructuredHeadersDictionaryMemberPtr New(Args&&... args) {
    return StructuredHeadersDictionaryMemberPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StructuredHeadersDictionaryMemberPtr From(const U& u) {
    return mojo::TypeConverter<StructuredHeadersDictionaryMemberPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StructuredHeadersDictionaryMember>::Convert(*this);
  }


  StructuredHeadersDictionaryMember();

  StructuredHeadersDictionaryMember(
      const std::string& key,
      ::net::structured_headers::ParameterizedMember value);

StructuredHeadersDictionaryMember(const StructuredHeadersDictionaryMember&) = delete;
StructuredHeadersDictionaryMember& operator=(const StructuredHeadersDictionaryMember&) = delete;

  ~StructuredHeadersDictionaryMember();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StructuredHeadersDictionaryMemberPtr>
  StructuredHeadersDictionaryMemberPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StructuredHeadersDictionaryMember::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StructuredHeadersDictionaryMember::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StructuredHeadersDictionaryMember::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StructuredHeadersDictionaryMember::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StructuredHeadersDictionaryMember::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StructuredHeadersDictionaryMember::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StructuredHeadersDictionaryMember_UnserializedMessageContext<
            UserType, StructuredHeadersDictionaryMember::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StructuredHeadersDictionaryMember::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StructuredHeadersDictionaryMember::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StructuredHeadersDictionaryMember_UnserializedMessageContext<
            UserType, StructuredHeadersDictionaryMember::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StructuredHeadersDictionaryMember::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::string key;
  
  ::net::structured_headers::ParameterizedMember value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StructuredHeadersDictionaryMember::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StructuredHeadersDictionaryMember::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StructuredHeadersDictionaryMember::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StructuredHeadersDictionaryMember::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  StructuredHeadersDictionary {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StructuredHeadersDictionary, T>::value>;
  using DataView = StructuredHeadersDictionaryDataView;
  using Data_ = internal::StructuredHeadersDictionary_Data;

  template <typename... Args>
  static StructuredHeadersDictionaryPtr New(Args&&... args) {
    return StructuredHeadersDictionaryPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StructuredHeadersDictionaryPtr From(const U& u) {
    return mojo::TypeConverter<StructuredHeadersDictionaryPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StructuredHeadersDictionary>::Convert(*this);
  }


  StructuredHeadersDictionary();

  explicit StructuredHeadersDictionary(
      std::vector<::net::structured_headers::DictionaryMember> members);

StructuredHeadersDictionary(const StructuredHeadersDictionary&) = delete;
StructuredHeadersDictionary& operator=(const StructuredHeadersDictionary&) = delete;

  ~StructuredHeadersDictionary();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StructuredHeadersDictionaryPtr>
  StructuredHeadersDictionaryPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StructuredHeadersDictionary::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, StructuredHeadersDictionary::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, StructuredHeadersDictionary::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StructuredHeadersDictionary::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StructuredHeadersDictionary::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StructuredHeadersDictionary::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StructuredHeadersDictionary_UnserializedMessageContext<
            UserType, StructuredHeadersDictionary::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<StructuredHeadersDictionary::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return StructuredHeadersDictionary::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StructuredHeadersDictionary_UnserializedMessageContext<
            UserType, StructuredHeadersDictionary::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StructuredHeadersDictionary::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<::net::structured_headers::DictionaryMember> members;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StructuredHeadersDictionary::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StructuredHeadersDictionary::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StructuredHeadersDictionary::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StructuredHeadersDictionary::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
StructuredHeadersItemPtr StructuredHeadersItem::Clone() const {
  switch (tag_) {
    case Tag::kNullValue:
      return NewNullValue(
          mojo::Clone(data_.null_value));
    case Tag::kIntegerValue:
      return NewIntegerValue(
          mojo::Clone(data_.integer_value));
    case Tag::kDecimalValue:
      return NewDecimalValue(
          mojo::Clone(data_.decimal_value));
    case Tag::kStringValue:
      return NewStringValue(
          mojo::Clone(data_.string_value));
    case Tag::kTokenValue:
      return NewTokenValue(
          mojo::Clone(data_.token_value));
    case Tag::kByteSequenceValue:
      return NewByteSequenceValue(
          mojo::Clone(data_.byte_sequence_value));
    case Tag::kBooleanValue:
      return NewBooleanValue(
          mojo::Clone(data_.boolean_value));
  }
  return nullptr;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, StructuredHeadersItem>::value>::type*>
bool StructuredHeadersItem::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::kNullValue:
      return mojo::Equals(data_.null_value, other.data_.null_value);
    case Tag::kIntegerValue:
      return mojo::Equals(data_.integer_value, other.data_.integer_value);
    case Tag::kDecimalValue:
      return mojo::Equals(data_.decimal_value, other.data_.decimal_value);
    case Tag::kStringValue:
      return mojo::Equals(data_.string_value, other.data_.string_value);
    case Tag::kTokenValue:
      return mojo::Equals(data_.token_value, other.data_.token_value);
    case Tag::kByteSequenceValue:
      return mojo::Equals(data_.byte_sequence_value, other.data_.byte_sequence_value);
    case Tag::kBooleanValue:
      return mojo::Equals(data_.boolean_value, other.data_.boolean_value);
  }

  return false;
}
template <typename StructPtrType>
StructuredHeadersParameterPtr StructuredHeadersParameter::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(item)
  );
}

template <typename T, StructuredHeadersParameter::EnableIfSame<T>*>
bool StructuredHeadersParameter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->item, other_struct.item))
    return false;
  return true;
}

template <typename T, StructuredHeadersParameter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.item < rhs.item)
    return true;
  if (rhs.item < lhs.item)
    return false;
  return false;
}
template <typename StructPtrType>
StructuredHeadersParameterizedItemPtr StructuredHeadersParameterizedItem::Clone() const {
  return New(
      mojo::Clone(item),
      mojo::Clone(parameters)
  );
}

template <typename T, StructuredHeadersParameterizedItem::EnableIfSame<T>*>
bool StructuredHeadersParameterizedItem::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->item, other_struct.item))
    return false;
  if (!mojo::Equals(this->parameters, other_struct.parameters))
    return false;
  return true;
}

template <typename T, StructuredHeadersParameterizedItem::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.item < rhs.item)
    return true;
  if (rhs.item < lhs.item)
    return false;
  if (lhs.parameters < rhs.parameters)
    return true;
  if (rhs.parameters < lhs.parameters)
    return false;
  return false;
}
template <typename StructPtrType>
StructuredHeadersParameterizedMemberPtr StructuredHeadersParameterizedMember::Clone() const {
  return New(
      mojo::Clone(member),
      mojo::Clone(member_is_inner_list),
      mojo::Clone(parameters)
  );
}

template <typename T, StructuredHeadersParameterizedMember::EnableIfSame<T>*>
bool StructuredHeadersParameterizedMember::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->member, other_struct.member))
    return false;
  if (!mojo::Equals(this->member_is_inner_list, other_struct.member_is_inner_list))
    return false;
  if (!mojo::Equals(this->parameters, other_struct.parameters))
    return false;
  return true;
}

template <typename T, StructuredHeadersParameterizedMember::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.member < rhs.member)
    return true;
  if (rhs.member < lhs.member)
    return false;
  if (lhs.member_is_inner_list < rhs.member_is_inner_list)
    return true;
  if (rhs.member_is_inner_list < lhs.member_is_inner_list)
    return false;
  if (lhs.parameters < rhs.parameters)
    return true;
  if (rhs.parameters < lhs.parameters)
    return false;
  return false;
}
template <typename StructPtrType>
StructuredHeadersDictionaryMemberPtr StructuredHeadersDictionaryMember::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(value)
  );
}

template <typename T, StructuredHeadersDictionaryMember::EnableIfSame<T>*>
bool StructuredHeadersDictionaryMember::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, StructuredHeadersDictionaryMember::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
StructuredHeadersDictionaryPtr StructuredHeadersDictionary::Clone() const {
  return New(
      mojo::Clone(members)
  );
}

template <typename T, StructuredHeadersDictionary::EnableIfSame<T>*>
bool StructuredHeadersDictionary::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->members, other_struct.members))
    return false;
  return true;
}

template <typename T, StructuredHeadersDictionary::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.members < rhs.members)
    return true;
  if (rhs.members < lhs.members)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::StructuredHeadersParameter::DataView,
                                         ::network::mojom::StructuredHeadersParameterPtr> {
  static bool IsNull(const ::network::mojom::StructuredHeadersParameterPtr& input) { return !input; }
  static void SetToNull(::network::mojom::StructuredHeadersParameterPtr* output) { output->reset(); }

  static const decltype(::network::mojom::StructuredHeadersParameter::key)& key(
      const ::network::mojom::StructuredHeadersParameterPtr& input) {
    return input->key;
  }

  static const decltype(::network::mojom::StructuredHeadersParameter::item)& item(
      const ::network::mojom::StructuredHeadersParameterPtr& input) {
    return input->item;
  }

  static bool Read(::network::mojom::StructuredHeadersParameter::DataView input, ::network::mojom::StructuredHeadersParameterPtr* output);
};


template <>
struct  StructTraits<::network::mojom::StructuredHeadersParameterizedItem::DataView,
                                         ::network::mojom::StructuredHeadersParameterizedItemPtr> {
  static bool IsNull(const ::network::mojom::StructuredHeadersParameterizedItemPtr& input) { return !input; }
  static void SetToNull(::network::mojom::StructuredHeadersParameterizedItemPtr* output) { output->reset(); }

  static const decltype(::network::mojom::StructuredHeadersParameterizedItem::item)& item(
      const ::network::mojom::StructuredHeadersParameterizedItemPtr& input) {
    return input->item;
  }

  static const decltype(::network::mojom::StructuredHeadersParameterizedItem::parameters)& parameters(
      const ::network::mojom::StructuredHeadersParameterizedItemPtr& input) {
    return input->parameters;
  }

  static bool Read(::network::mojom::StructuredHeadersParameterizedItem::DataView input, ::network::mojom::StructuredHeadersParameterizedItemPtr* output);
};


template <>
struct  StructTraits<::network::mojom::StructuredHeadersParameterizedMember::DataView,
                                         ::network::mojom::StructuredHeadersParameterizedMemberPtr> {
  static bool IsNull(const ::network::mojom::StructuredHeadersParameterizedMemberPtr& input) { return !input; }
  static void SetToNull(::network::mojom::StructuredHeadersParameterizedMemberPtr* output) { output->reset(); }

  static const decltype(::network::mojom::StructuredHeadersParameterizedMember::member)& member(
      const ::network::mojom::StructuredHeadersParameterizedMemberPtr& input) {
    return input->member;
  }

  static decltype(::network::mojom::StructuredHeadersParameterizedMember::member_is_inner_list) member_is_inner_list(
      const ::network::mojom::StructuredHeadersParameterizedMemberPtr& input) {
    return input->member_is_inner_list;
  }

  static const decltype(::network::mojom::StructuredHeadersParameterizedMember::parameters)& parameters(
      const ::network::mojom::StructuredHeadersParameterizedMemberPtr& input) {
    return input->parameters;
  }

  static bool Read(::network::mojom::StructuredHeadersParameterizedMember::DataView input, ::network::mojom::StructuredHeadersParameterizedMemberPtr* output);
};


template <>
struct  StructTraits<::network::mojom::StructuredHeadersDictionaryMember::DataView,
                                         ::network::mojom::StructuredHeadersDictionaryMemberPtr> {
  static bool IsNull(const ::network::mojom::StructuredHeadersDictionaryMemberPtr& input) { return !input; }
  static void SetToNull(::network::mojom::StructuredHeadersDictionaryMemberPtr* output) { output->reset(); }

  static const decltype(::network::mojom::StructuredHeadersDictionaryMember::key)& key(
      const ::network::mojom::StructuredHeadersDictionaryMemberPtr& input) {
    return input->key;
  }

  static const decltype(::network::mojom::StructuredHeadersDictionaryMember::value)& value(
      const ::network::mojom::StructuredHeadersDictionaryMemberPtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::StructuredHeadersDictionaryMember::DataView input, ::network::mojom::StructuredHeadersDictionaryMemberPtr* output);
};


template <>
struct  StructTraits<::network::mojom::StructuredHeadersDictionary::DataView,
                                         ::network::mojom::StructuredHeadersDictionaryPtr> {
  static bool IsNull(const ::network::mojom::StructuredHeadersDictionaryPtr& input) { return !input; }
  static void SetToNull(::network::mojom::StructuredHeadersDictionaryPtr* output) { output->reset(); }

  static const decltype(::network::mojom::StructuredHeadersDictionary::members)& members(
      const ::network::mojom::StructuredHeadersDictionaryPtr& input) {
    return input->members;
  }

  static bool Read(::network::mojom::StructuredHeadersDictionary::DataView input, ::network::mojom::StructuredHeadersDictionaryPtr* output);
};


template <>
struct  UnionTraits<::network::mojom::StructuredHeadersItem::DataView,
                                        ::network::mojom::StructuredHeadersItemPtr> {
  static bool IsNull(const ::network::mojom::StructuredHeadersItemPtr& input) { return !input; }
  static void SetToNull(::network::mojom::StructuredHeadersItemPtr* output) { output->reset(); }

  static ::network::mojom::StructuredHeadersItem::Tag GetTag(const ::network::mojom::StructuredHeadersItemPtr& input) {
    return input->which();
  }

  static  uint8_t null_value(const ::network::mojom::StructuredHeadersItemPtr& input) {
    return input->get_null_value();
  }

  static  int64_t integer_value(const ::network::mojom::StructuredHeadersItemPtr& input) {
    return input->get_integer_value();
  }

  static  double decimal_value(const ::network::mojom::StructuredHeadersItemPtr& input) {
    return input->get_decimal_value();
  }

  static const std::string& string_value(const ::network::mojom::StructuredHeadersItemPtr& input) {
    return input->get_string_value();
  }

  static const std::string& token_value(const ::network::mojom::StructuredHeadersItemPtr& input) {
    return input->get_token_value();
  }

  static const std::string& byte_sequence_value(const ::network::mojom::StructuredHeadersItemPtr& input) {
    return input->get_byte_sequence_value();
  }

  static  bool boolean_value(const ::network::mojom::StructuredHeadersItemPtr& input) {
    return input->get_boolean_value();
  }

  static bool Read(::network::mojom::StructuredHeadersItem::DataView input, ::network::mojom::StructuredHeadersItemPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_STRUCTURED_HEADERS_MOJOM_H_