// services/network/public/mojom/sri_message_signature.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/sri_message_signature.mojom-shared-internal.h"


namespace network::mojom {
class SRIMessageSignatureComponentParameterDataView;

class SRIMessageSignatureComponentDataView;

class SRIMessageSignatureDataView;

class SRIMessageSignatureIssueDataView;

class SRIMessageSignaturesDataView;



}  // network::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::SRIMessageSignatureComponentParameterDataView> {
  using Data = ::network::mojom::internal::SRIMessageSignatureComponentParameter_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SRIMessageSignatureComponentDataView> {
  using Data = ::network::mojom::internal::SRIMessageSignatureComponent_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SRIMessageSignatureDataView> {
  using Data = ::network::mojom::internal::SRIMessageSignature_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SRIMessageSignatureIssueDataView> {
  using Data = ::network::mojom::internal::SRIMessageSignatureIssue_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::SRIMessageSignaturesDataView> {
  using Data = ::network::mojom::internal::SRIMessageSignatures_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network::mojom {


enum class SRIMessageSignatureError : int32_t {
  
  kMissingSignatureHeader = 0,
  
  kMissingSignatureInputHeader = 1,
  
  kInvalidSignatureHeader = 2,
  
  kInvalidSignatureInputHeader = 3,
  
  kSignatureHeaderValueIsNotByteSequence = 4,
  
  kSignatureHeaderValueIsParameterized = 5,
  
  kSignatureHeaderValueIsIncorrectLength = 6,
  
  kSignatureInputHeaderMissingLabel = 7,
  
  kSignatureInputHeaderValueNotInnerList = 8,
  
  kSignatureInputHeaderValueMissingComponents = 9,
  
  kSignatureInputHeaderInvalidComponentType = 10,
  
  kSignatureInputHeaderInvalidComponentName = 11,
  
  kSignatureInputHeaderInvalidHeaderComponentParameter = 12,
  
  kSignatureInputHeaderInvalidDerivedComponentParameter = 13,
  
  kSignatureInputHeaderKeyIdLength = 14,
  
  kSignatureInputHeaderInvalidParameter = 15,
  
  kSignatureInputHeaderMissingRequiredParameters = 16,
  
  kValidationFailedSignatureExpired = 17,
  
  kValidationFailedInvalidLength = 18,
  
  kValidationFailedSignatureMismatch = 19,
  
  kValidationFailedIntegrityMismatch = 20,
  kMinValue = 0,
  kMaxValue = 20,
};

 std::ostream& operator<<(std::ostream& os, SRIMessageSignatureError value);
inline bool IsKnownEnumValue(SRIMessageSignatureError value) {
  return internal::SRIMessageSignatureError_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class SRIMessageSignatureComponentParameter_Type : int32_t {
  
  kName = 0,
  
  kRequest = 1,
  
  kStrictStructuredFieldSerialization = 2,
  
  kBinaryRepresentation = 3,
  kMinValue = 0,
  kMaxValue = 3,
};

 std::ostream& operator<<(std::ostream& os, SRIMessageSignatureComponentParameter_Type value);
inline bool IsKnownEnumValue(SRIMessageSignatureComponentParameter_Type value) {
  return internal::SRIMessageSignatureComponentParameter_Type_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class SRIMessageSignatureComponentParameterDataView {
 public:
  SRIMessageSignatureComponentParameterDataView() = default;

  SRIMessageSignatureComponentParameterDataView(
      internal::SRIMessageSignatureComponentParameter_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::SRIMessageSignatureComponentParameter_Type>(
        data_value, output);
  }
  SRIMessageSignatureComponentParameter_Type type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SRIMessageSignatureComponentParameter_Type>(data_->type));
  }
  inline void GetValueDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadValue(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `value` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadValue` instead "
    "of `ReadValue if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->value.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SRIMessageSignatureComponentParameter_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SRIMessageSignatureComponentDataView {
 public:
  SRIMessageSignatureComponentDataView() = default;

  SRIMessageSignatureComponentDataView(
      internal::SRIMessageSignatureComponent_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetParamsDataView(
      mojo::ArrayDataView<SRIMessageSignatureComponentParameterDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureComponentParameterDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SRIMessageSignatureComponent_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SRIMessageSignatureDataView {
 public:
  SRIMessageSignatureDataView() = default;

  SRIMessageSignatureDataView(
      internal::SRIMessageSignature_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetLabelDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLabel(UserType* output) {
    
    auto* pointer = data_->label.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSignatureDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignature(UserType* output) {
    
    auto* pointer = data_->signature.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetComponentsDataView(
      mojo::ArrayDataView<SRIMessageSignatureComponentDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadComponents(UserType* output) {
    
    auto* pointer = data_->components.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureComponentDataView>>(
        pointer, output, message_);
  }
  std::optional<int64_t> created() const {

    return data_->created_$flag
        ? std::make_optional(data_->created_$value)
        : std::nullopt;
  }
  std::optional<int64_t> expires() const {

    return data_->expires_$flag
        ? std::make_optional(data_->expires_$value)
        : std::nullopt;
  }
  inline void GetKeyidDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadKeyid(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<uint8_t>, UserType>(),
    "Attempting to read the optional `keyid` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadKeyid` instead "
    "of `ReadKeyid if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->keyid.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetNonceDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadNonce(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `nonce` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadNonce` instead "
    "of `ReadNonce if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->nonce.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetTagDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadTag(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `tag` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadTag` instead "
    "of `ReadTag if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->tag.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetSerializedSignatureParamsDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSerializedSignatureParams(UserType* output) {
    
    auto* pointer = data_->serialized_signature_params.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::SRIMessageSignature_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SRIMessageSignatureIssueDataView {
 public:
  SRIMessageSignatureIssueDataView() = default;

  SRIMessageSignatureIssueDataView(
      internal::SRIMessageSignatureIssue_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::network::mojom::SRIMessageSignatureError>(
        data_value, output);
  }
  SRIMessageSignatureError error() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::network::mojom::SRIMessageSignatureError>(data_->error));
  }
  inline void GetSignatureBaseDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignatureBase(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `signature_base` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadSignatureBase` instead "
    "of `ReadSignatureBase if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->signature_base.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIntegrityAssertionsDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIntegrityAssertions(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::ArrayDataView<mojo::StringDataView>, UserType>(),
    "Attempting to read the optional `integrity_assertions` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadIntegrityAssertions` instead "
    "of `ReadIntegrityAssertions if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->integrity_assertions.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SRIMessageSignatureIssue_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class SRIMessageSignaturesDataView {
 public:
  SRIMessageSignaturesDataView() = default;

  SRIMessageSignaturesDataView(
      internal::SRIMessageSignatures_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetSignaturesDataView(
      mojo::ArrayDataView<SRIMessageSignatureDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSignatures(UserType* output) {
    
    auto* pointer = data_->signatures.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureDataView>>(
        pointer, output, message_);
  }
  inline void GetIssuesDataView(
      mojo::ArrayDataView<SRIMessageSignatureIssueDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadIssues(UserType* output) {
    
    auto* pointer = data_->issues.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::SRIMessageSignatureIssueDataView>>(
        pointer, output, message_);
  }
 private:
  internal::SRIMessageSignatures_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SRI_MESSAGE_SIGNATURE_MOJOM_DATA_VIEW_H_