// services/network/public/mojom/shared_storage.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_STORAGE_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_STORAGE_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/shared_storage.mojom-shared-internal.h"
#include "mojo/public/mojom/base/string16.mojom-shared.h"




#include "services/network/public/mojom/shared_storage.mojom-data-view.h"




namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageKeyArgumentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageKeyArgumentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageKeyArgument_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_data,
      data_fragment);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in SharedStorageKeyArgument struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageKeyArgument_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageKeyArgumentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageValueArgumentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageValueArgumentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageValueArgument_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_data,
      data_fragment);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in SharedStorageValueArgument struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageValueArgument_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageValueArgumentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::LockNameDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::LockNameDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::LockName_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType> data_fragment(
            fragment.message());
    
    mojo::internal::Serialize<mojo::StringDataView>(
      in_data,
      data_fragment);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in LockName struct");
  }

  static bool Deserialize(::network::mojom::internal::LockName_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::LockNameDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageSetMethodDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageSetMethodDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageSetMethod_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SharedStorageKeyArgumentDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in SharedStorageSetMethod struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SharedStorageValueArgumentDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in SharedStorageSetMethod struct");

    fragment->ignore_if_present = Traits::ignore_if_present(input);
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageSetMethod_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageSetMethodDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageAppendMethodDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageAppendMethodDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageAppendMethod_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SharedStorageKeyArgumentDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in SharedStorageAppendMethod struct");

    decltype(Traits::value(input)) in_value = Traits::value(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->value)::BaseType> value_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SharedStorageValueArgumentDataView>(
      in_value,
      value_fragment);

    fragment->value.Set(
        value_fragment.is_null() ? nullptr : value_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->value.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in SharedStorageAppendMethod struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageAppendMethod_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageAppendMethodDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageDeleteMethodDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageDeleteMethodDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageDeleteMethod_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::key(input)) in_key = Traits::key(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->key)::BaseType> key_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::SharedStorageKeyArgumentDataView>(
      in_key,
      key_fragment);

    fragment->key.Set(
        key_fragment.is_null() ? nullptr : key_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->key.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in SharedStorageDeleteMethod struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageDeleteMethod_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageDeleteMethodDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageClearMethodDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageClearMethodDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageClearMethod_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageClearMethod_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageClearMethodDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageModifierMethodWithOptionsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageModifierMethodWithOptionsDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageModifierMethodWithOptions_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::method(input)) in_method = Traits::method(input);
    mojo::internal::MessageFragment<decltype(fragment->method)>
        method_fragment(fragment.message());
    method_fragment.Claim(&fragment->method);
    
    mojo::internal::Serialize<::network::mojom::SharedStorageModifierMethodDataView>(
      in_method,
      method_fragment,
      true);

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->method.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null method in SharedStorageModifierMethodWithOptions struct");

    decltype(Traits::with_lock(input)) in_with_lock = Traits::with_lock(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->with_lock)::BaseType> with_lock_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::network::mojom::LockNameDataView>(
      in_with_lock,
      with_lock_fragment);

    fragment->with_lock.Set(
        with_lock_fragment.is_null() ? nullptr : with_lock_fragment.data());
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageModifierMethodWithOptions_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageModifierMethodWithOptionsDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageBatchUpdateMethodsArgumentDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedStorageBatchUpdateMethodsArgumentDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedStorageBatchUpdateMethodsArgument_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::data(input)) in_data = Traits::data(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->data)::BaseType>
        data_fragment(fragment.message());
    constexpr const mojo::internal::ContainerValidateParams& data_validate_params =
        mojo::internal::GetArrayValidator<0, false, nullptr>();
    
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::SharedStorageModifierMethodWithOptionsDataView>>(
      in_data,
      data_fragment,
      &data_validate_params);

    fragment->data.Set(
        data_fragment.is_null() ? nullptr : data_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->data.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in SharedStorageBatchUpdateMethodsArgument struct");
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageBatchUpdateMethodsArgument_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageBatchUpdateMethodsArgumentDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SharedStorageModifierMethodDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::SharedStorageModifierMethodDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::SharedStorageModifierMethod_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::SharedStorageModifierMethodDataView::Tag::kSetMethod: {
    decltype(Traits::set_method(input))
    in_set_method = Traits::set_method(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_set_method)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::SharedStorageSetMethodDataView>(
  in_set_method,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null set_method in SharedStorageModifierMethod union");
    fragment->data.f_set_method.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::SharedStorageModifierMethodDataView::Tag::kAppendMethod: {
    decltype(Traits::append_method(input))
    in_append_method = Traits::append_method(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_append_method)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::SharedStorageAppendMethodDataView>(
  in_append_method,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null append_method in SharedStorageModifierMethod union");
    fragment->data.f_append_method.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::SharedStorageModifierMethodDataView::Tag::kDeleteMethod: {
    decltype(Traits::delete_method(input))
    in_delete_method = Traits::delete_method(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_delete_method)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::SharedStorageDeleteMethodDataView>(
  in_delete_method,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null delete_method in SharedStorageModifierMethod union");
    fragment->data.f_delete_method.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::SharedStorageModifierMethodDataView::Tag::kClearMethod: {
    decltype(Traits::clear_method(input))
    in_clear_method = Traits::clear_method(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_clear_method)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::SharedStorageClearMethodDataView>(
  in_clear_method,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  mojo::internal::SendValidation::kDefault,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null clear_method in SharedStorageModifierMethod union");
    fragment->data.f_clear_method.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }

  static bool Deserialize(::network::mojom::internal::SharedStorageModifierMethod_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input || input->is_null())
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::SharedStorageModifierMethodDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void SharedStorageKeyArgumentDataView::GetDataDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void SharedStorageValueArgumentDataView::GetDataDataView(
    ::mojo_base::mojom::String16DataView* output) {
  auto pointer = data_->data.Get();
  *output = ::mojo_base::mojom::String16DataView(pointer, message_);
}


inline void LockNameDataView::GetDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->data.Get();
  *output = mojo::StringDataView(pointer, message_);
}


inline void SharedStorageSetMethodDataView::GetKeyDataView(
    SharedStorageKeyArgumentDataView* output) {
  auto pointer = data_->key.Get();
  *output = SharedStorageKeyArgumentDataView(pointer, message_);
}
inline void SharedStorageSetMethodDataView::GetValueDataView(
    SharedStorageValueArgumentDataView* output) {
  auto pointer = data_->value.Get();
  *output = SharedStorageValueArgumentDataView(pointer, message_);
}


inline void SharedStorageAppendMethodDataView::GetKeyDataView(
    SharedStorageKeyArgumentDataView* output) {
  auto pointer = data_->key.Get();
  *output = SharedStorageKeyArgumentDataView(pointer, message_);
}
inline void SharedStorageAppendMethodDataView::GetValueDataView(
    SharedStorageValueArgumentDataView* output) {
  auto pointer = data_->value.Get();
  *output = SharedStorageValueArgumentDataView(pointer, message_);
}


inline void SharedStorageDeleteMethodDataView::GetKeyDataView(
    SharedStorageKeyArgumentDataView* output) {
  auto pointer = data_->key.Get();
  *output = SharedStorageKeyArgumentDataView(pointer, message_);
}




inline void SharedStorageModifierMethodWithOptionsDataView::GetMethodDataView(
    SharedStorageModifierMethodDataView* output) {
  auto pointer = &data_->method;
  *output = SharedStorageModifierMethodDataView(pointer, message_);
}
inline void SharedStorageModifierMethodWithOptionsDataView::GetWithLockDataView(
    LockNameDataView* output) {
  auto pointer = data_->with_lock.Get();
  *output = LockNameDataView(pointer, message_);
}


inline void SharedStorageBatchUpdateMethodsArgumentDataView::GetDataDataView(
    mojo::ArrayDataView<SharedStorageModifierMethodWithOptionsDataView>* output) {
  auto pointer = data_->data.Get();
  *output = mojo::ArrayDataView<SharedStorageModifierMethodWithOptionsDataView>(pointer, message_);
}


inline void SharedStorageModifierMethodDataView::GetSetMethodDataView(
    SharedStorageSetMethodDataView* output) const {
  CHECK(is_set_method());
  *output = SharedStorageSetMethodDataView(data_->data.f_set_method.Get(), message_);
}
inline void SharedStorageModifierMethodDataView::GetAppendMethodDataView(
    SharedStorageAppendMethodDataView* output) const {
  CHECK(is_append_method());
  *output = SharedStorageAppendMethodDataView(data_->data.f_append_method.Get(), message_);
}
inline void SharedStorageModifierMethodDataView::GetDeleteMethodDataView(
    SharedStorageDeleteMethodDataView* output) const {
  CHECK(is_delete_method());
  *output = SharedStorageDeleteMethodDataView(data_->data.f_delete_method.Get(), message_);
}
inline void SharedStorageModifierMethodDataView::GetClearMethodDataView(
    SharedStorageClearMethodDataView* output) const {
  CHECK(is_clear_method());
  *output = SharedStorageClearMethodDataView(data_->data.f_clear_method.Get(), message_);
}


}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_STORAGE_MOJOM_SHARED_H_