// services/network/public/mojom/shared_dictionary_access_observer.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-shared-internal.h"
#include "services/network/public/mojom/shared_dictionary_isolation_key.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"
#include "url/mojom/url.mojom-shared.h"

#include "services/network/public/mojom/shared_dictionary_access_observer.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::SharedDictionaryAccessDetailsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::SharedDictionaryAccessDetailsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::SharedDictionaryAccessDetails_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::SharedDictionaryAccessDetails_Type>(
        Traits::type(input),
        &fragment->type);

      decltype(Traits::url(input)) in_url = Traits::url(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->url)::BaseType> url_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::UrlDataView, send_validation>(
        in_url,
        url_fragment);

      fragment->url.Set(
          url_fragment.is_null() ? nullptr : url_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->url.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null url in SharedDictionaryAccessDetails struct");

      decltype(Traits::isolation_key(input)) in_isolation_key = Traits::isolation_key(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->isolation_key)::BaseType> isolation_key_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SharedDictionaryIsolationKeyDataView, send_validation>(
        in_isolation_key,
        isolation_key_fragment);

      fragment->isolation_key.Set(
          isolation_key_fragment.is_null() ? nullptr : isolation_key_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->isolation_key.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null isolation_key in SharedDictionaryAccessDetails struct");

      fragment->is_blocked = Traits::is_blocked(input);
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_SHARED_DICTIONARY_ACCESS_OBSERVER_MOJOM_SEND_VALIDATION_H_