// services/network/public/mojom/permissions_policy/permissions_policy.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/permissions_policy/permissions_policy.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var permissions_policy_feature$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/permissions_policy/permissions_policy_feature.mojom', 'permissions_policy_feature.mojom.js');
  }
  var origin$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/origin.mojom', '../../../../../url/mojom/origin.mojom.js');
  }



  function OriginWithPossibleWildcards(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  OriginWithPossibleWildcards.prototype.initDefaults_ = function() {
    this.scheme = null;
    this.host = null;
    this.port = -1;
    this.isHostWildcard = false;
    this.isPortWildcard = false;
  };
  OriginWithPossibleWildcards.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  OriginWithPossibleWildcards.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate OriginWithPossibleWildcards.scheme
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate OriginWithPossibleWildcards.host
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;




    return validator.validationError.NONE;
  };

  OriginWithPossibleWildcards.encodedSize = codec.kStructHeaderSize + 24;

  OriginWithPossibleWildcards.decode = function(decoder) {
    var packed;
    var val = new OriginWithPossibleWildcards();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.scheme =
        decoder.decodeStruct(codec.String);
    val.host =
        decoder.decodeStruct(codec.String);
    val.port =
        decoder.decodeStruct(codec.Int32);
    packed = decoder.readUint8();
    val.isHostWildcard = (packed >> 0) & 1 ? true : false;
    val.isPortWildcard = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  OriginWithPossibleWildcards.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(OriginWithPossibleWildcards.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.scheme);
    encoder.encodeStruct(codec.String, val.host);
    encoder.encodeStruct(codec.Int32, val.port);
    packed = 0;
    packed |= (val.isHostWildcard & 1) << 0
    packed |= (val.isPortWildcard & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function ParsedPermissionsPolicyDeclaration(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  ParsedPermissionsPolicyDeclaration.prototype.initDefaults_ = function() {
    this.feature = 0;
    this.matchesAllOrigins = false;
    this.matchesOpaqueSrc = false;
    this.allowedOrigins = null;
    this.selfIfMatches = null;
    this.reportingEndpoint = null;
  };
  ParsedPermissionsPolicyDeclaration.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  ParsedPermissionsPolicyDeclaration.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ParsedPermissionsPolicyDeclaration.feature
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, permissions_policy_feature$.PermissionsPolicyFeature);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ParsedPermissionsPolicyDeclaration.allowedOrigins
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(OriginWithPossibleWildcards), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate ParsedPermissionsPolicyDeclaration.selfIfMatches
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, origin$.Origin, true);
    if (err !== validator.validationError.NONE)
        return err;




    // validate ParsedPermissionsPolicyDeclaration.reportingEndpoint
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, true)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  ParsedPermissionsPolicyDeclaration.encodedSize = codec.kStructHeaderSize + 32;

  ParsedPermissionsPolicyDeclaration.decode = function(decoder) {
    var packed;
    var val = new ParsedPermissionsPolicyDeclaration();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.feature =
        decoder.decodeStruct(new codec.Enum(permissions_policy_feature$.PermissionsPolicyFeature));
    packed = decoder.readUint8();
    val.matchesAllOrigins = (packed >> 0) & 1 ? true : false;
    val.matchesOpaqueSrc = (packed >> 1) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.allowedOrigins =
        decoder.decodeArrayPointer(new codec.PointerTo(OriginWithPossibleWildcards));
    val.selfIfMatches =
        decoder.decodeStructPointer(origin$.Origin);
    val.reportingEndpoint =
        decoder.decodeStruct(codec.String);
    return val;
  };

  ParsedPermissionsPolicyDeclaration.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(ParsedPermissionsPolicyDeclaration.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.feature);
    packed = 0;
    packed |= (val.matchesAllOrigins & 1) << 0
    packed |= (val.matchesOpaqueSrc & 1) << 1
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(OriginWithPossibleWildcards), val.allowedOrigins);
    encoder.encodeStructPointer(origin$.Origin, val.selfIfMatches);
    encoder.encodeStruct(codec.String, val.reportingEndpoint);
  };
  function PermissionsPolicy(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PermissionsPolicy.prototype.initDefaults_ = function() {
    this.origin = null;
    this.headerless = false;
    this.declarations = null;
    this.inheritedPolicies = null;
  };
  PermissionsPolicy.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PermissionsPolicy.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionsPolicy.origin
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, origin$.Origin, false);
    if (err !== validator.validationError.NONE)
        return err;



    // validate PermissionsPolicy.declarations
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(ParsedPermissionsPolicyDeclaration), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PermissionsPolicy.inheritedPolicies
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 24, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PermissionsPolicy.encodedSize = codec.kStructHeaderSize + 32;

  PermissionsPolicy.decode = function(decoder) {
    var packed;
    var val = new PermissionsPolicy();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.origin =
        decoder.decodeStructPointer(origin$.Origin);
    packed = decoder.readUint8();
    val.headerless = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.declarations =
        decoder.decodeArrayPointer(new codec.PointerTo(ParsedPermissionsPolicyDeclaration));
    val.inheritedPolicies =
        decoder.decodeStruct(codec.String);
    return val;
  };

  PermissionsPolicy.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PermissionsPolicy.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(origin$.Origin, val.origin);
    packed = 0;
    packed |= (val.headerless & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(ParsedPermissionsPolicyDeclaration), val.declarations);
    encoder.encodeStruct(codec.String, val.inheritedPolicies);
  };
  exports.OriginWithPossibleWildcards = OriginWithPossibleWildcards;
  exports.ParsedPermissionsPolicyDeclaration = ParsedPermissionsPolicyDeclaration;
  exports.PermissionsPolicy = PermissionsPolicy;
})();