// services/network/public/mojom/p2p.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_BLINK_TEST_UTILS_H_

#include "services/network/public/mojom/p2p.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace network::mojom::blink {


class BLINK_PLATFORM_EXPORT P2PNetworkNotificationClientInterceptorForTesting : public P2PNetworkNotificationClient {
  virtual P2PNetworkNotificationClient* GetForwardingInterface() = 0;
  void NetworkListChanged(const ::blink::Vector<::net::NetworkInterface>& networks, const ::net::IPAddress& default_ipv4_local_address, const ::net::IPAddress& default_ipv6_local_address) override;
};
class BLINK_PLATFORM_EXPORT P2PNetworkNotificationClientAsyncWaiter {
 public:
  explicit P2PNetworkNotificationClientAsyncWaiter(P2PNetworkNotificationClient* proxy);

  P2PNetworkNotificationClientAsyncWaiter(const P2PNetworkNotificationClientAsyncWaiter&) = delete;
  P2PNetworkNotificationClientAsyncWaiter& operator=(const P2PNetworkNotificationClientAsyncWaiter&) = delete;

  ~P2PNetworkNotificationClientAsyncWaiter();

 private:
  P2PNetworkNotificationClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT P2PSocketManagerInterceptorForTesting : public P2PSocketManager {
  virtual P2PSocketManager* GetForwardingInterface() = 0;
  void StartNetworkNotifications(::mojo::PendingRemote<P2PNetworkNotificationClient> client) override;
  void GetHostAddress(const ::blink::String& host_name, std::optional<::net::AddressFamily> address_family, bool enable_mdns, GetHostAddressCallback callback) override;
  void CreateSocket(::network::P2PSocketType type, const ::net::IPEndPoint& local_address, const ::network::P2PPortRange& port_range, const ::network::P2PHostAndIPEndPoint& remote_address, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, const std::optional<::base::UnguessableToken>& devtools_token, ::mojo::PendingRemote<P2PSocketClient> client, ::mojo::PendingReceiver<P2PSocket> socket) override;
};
class BLINK_PLATFORM_EXPORT P2PSocketManagerAsyncWaiter {
 public:
  explicit P2PSocketManagerAsyncWaiter(P2PSocketManager* proxy);

  P2PSocketManagerAsyncWaiter(const P2PSocketManagerAsyncWaiter&) = delete;
  P2PSocketManagerAsyncWaiter& operator=(const P2PSocketManagerAsyncWaiter&) = delete;

  ~P2PSocketManagerAsyncWaiter();
  void GetHostAddress(
      const ::blink::String& host_name, std::optional<::net::AddressFamily> address_family, bool enable_mdns, ::blink::Vector<::net::IPAddress>* out_addresses);
  ::blink::Vector<::net::IPAddress> GetHostAddress(const ::blink::String& host_name, std::optional<::net::AddressFamily> address_family, bool enable_mdns);

 private:
  P2PSocketManager* const proxy_;
};


class BLINK_PLATFORM_EXPORT P2PSocketInterceptorForTesting : public P2PSocket {
  virtual P2PSocket* GetForwardingInterface() = 0;
  void Send(::base::span<const ::uint8_t> data, const ::network::P2PPacketInfo& packet_info) override;
  void SendBatch(::blink::Vector<P2PSendPacketPtr> packet_batch) override;
  void SetOption(::network::P2PSocketOption option, int32_t value) override;
};
class BLINK_PLATFORM_EXPORT P2PSocketAsyncWaiter {
 public:
  explicit P2PSocketAsyncWaiter(P2PSocket* proxy);

  P2PSocketAsyncWaiter(const P2PSocketAsyncWaiter&) = delete;
  P2PSocketAsyncWaiter& operator=(const P2PSocketAsyncWaiter&) = delete;

  ~P2PSocketAsyncWaiter();

 private:
  P2PSocket* const proxy_;
};


class BLINK_PLATFORM_EXPORT P2PSocketClientInterceptorForTesting : public P2PSocketClient {
  virtual P2PSocketClient* GetForwardingInterface() = 0;
  void SocketCreated(const ::net::IPEndPoint& local_address, const ::net::IPEndPoint& remote_address) override;
  void SendComplete(const ::network::P2PSendPacketMetrics& send_metrics) override;
  void SendBatchComplete(const ::blink::Vector<::network::P2PSendPacketMetrics>& send_metrics_batch) override;
  void DataReceived(::blink::Vector<P2PReceivedPacketPtr> packets) override;
};
class BLINK_PLATFORM_EXPORT P2PSocketClientAsyncWaiter {
 public:
  explicit P2PSocketClientAsyncWaiter(P2PSocketClient* proxy);

  P2PSocketClientAsyncWaiter(const P2PSocketClientAsyncWaiter&) = delete;
  P2PSocketClientAsyncWaiter& operator=(const P2PSocketClientAsyncWaiter&) = delete;

  ~P2PSocketClientAsyncWaiter();

 private:
  P2PSocketClient* const proxy_;
};




}  // network::mojom::blink

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_P2P_MOJOM_BLINK_TEST_UTILS_H_