// services/network/public/mojom/network_service.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  ContentSettingPatternSource as contentSettings_mojom_ContentSettingPatternSource,
  ContentSettingPatternSourceSpec as contentSettings_mojom_ContentSettingPatternSourceSpec
} from '../../../../components/content_settings/core/common/content_settings.mojom.m.js';

import {
  ByteString as mojoBase_mojom_ByteString,
  ByteStringSpec as mojoBase_mojom_ByteStringSpec
} from '../../../../mojo/public/mojom/base/byte_string.mojom.m.js';

import {
  File as mojoBase_mojom_File,
  FileSpec as mojoBase_mojom_FileSpec
} from '../../../../mojo/public/mojom/base/file.mojom.m.js';

import {
  MemoryPressureLevel as mojoBase_mojom_MemoryPressureLevel,
  MemoryPressureLevelSpec as mojoBase_mojom_MemoryPressureLevelSpec
} from '../../../../mojo/public/mojom/base/memory_pressure_level.mojom.m.js';

import {
  Time as mojoBase_mojom_Time,
  TimeSpec as mojoBase_mojom_TimeSpec,
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  DictionaryValue as mojoBase_mojom_DictionaryValue,
  DictionaryValueSpec as mojoBase_mojom_DictionaryValueSpec
} from '../../../../mojo/public/mojom/base/values.mojom.m.js';

import {
  Origin as url_mojom_Origin,
  OriginSpec as url_mojom_OriginSpec
} from '../../../../url/mojom/origin.mojom.m.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  CTLogInfo as network_mojom_CTLogInfo,
  CTLogInfoSpec as network_mojom_CTLogInfoSpec
} from './ct_log_info.mojom.m.js';

import {
  GlobalFirstPartySets as network_mojom_GlobalFirstPartySets,
  GlobalFirstPartySetsSpec as network_mojom_GlobalFirstPartySetsSpec
} from './first_party_sets.mojom.m.js';

import {
  SecureDnsMode as network_mojom_SecureDnsMode,
  SecureDnsModeSpec as network_mojom_SecureDnsModeSpec,
  DnsConfigChangeManagerRemote as network_mojom_DnsConfigChangeManagerRemote,
  DnsConfigChangeManagerPendingReceiver as network_mojom_DnsConfigChangeManagerPendingReceiver,
  DnsOverHttpsConfig as network_mojom_DnsOverHttpsConfig,
  DnsOverHttpsConfigSpec as network_mojom_DnsOverHttpsConfigSpec
} from './host_resolver.mojom.m.js';

import {
  PinList as network_mojom_PinList,
  PinListSpec as network_mojom_PinListSpec
} from './key_pinning.mojom.m.js';

import {
  MutableNetworkTrafficAnnotationTag as network_mojom_MutableNetworkTrafficAnnotationTag,
  MutableNetworkTrafficAnnotationTagSpec as network_mojom_MutableNetworkTrafficAnnotationTagSpec
} from './mutable_network_traffic_annotation_tag.mojom.m.js';

import {
  NetLogCaptureMode as network_mojom_NetLogCaptureMode,
  NetLogCaptureModeSpec as network_mojom_NetLogCaptureModeSpec,
  NetLogProxySinkRemote as network_mojom_NetLogProxySinkRemote,
  NetLogProxySinkPendingReceiver as network_mojom_NetLogProxySinkPendingReceiver,
  NetLogProxySourceRemote as network_mojom_NetLogProxySourceRemote,
  NetLogProxySourcePendingReceiver as network_mojom_NetLogProxySourcePendingReceiver
} from './net_log.mojom.m.js';

import {
  NetworkAnnotationMonitorRemote as network_mojom_NetworkAnnotationMonitorRemote,
  NetworkAnnotationMonitorPendingReceiver as network_mojom_NetworkAnnotationMonitorPendingReceiver
} from './network_annotation_monitor.mojom.m.js';

import {
  ConnectionSubtype as network_mojom_ConnectionSubtype,
  ConnectionSubtypeSpec as network_mojom_ConnectionSubtypeSpec,
  ConnectionType as network_mojom_ConnectionType,
  ConnectionTypeSpec as network_mojom_ConnectionTypeSpec,
  NetworkChangeManagerRemote as network_mojom_NetworkChangeManagerRemote,
  NetworkChangeManagerPendingReceiver as network_mojom_NetworkChangeManagerPendingReceiver
} from './network_change_manager.mojom.m.js';

import {
  NetworkContextRemote as network_mojom_NetworkContextRemote,
  NetworkContextPendingReceiver as network_mojom_NetworkContextPendingReceiver,
  NetworkContextParams as network_mojom_NetworkContextParams,
  NetworkContextParamsSpec as network_mojom_NetworkContextParamsSpec
} from './network_context.mojom.m.js';

import {
  NetworkInterface as network_mojom_NetworkInterface,
  NetworkInterfaceSpec as network_mojom_NetworkInterfaceSpec
} from './network_interface.mojom.m.js';

import {
  HttpResponseHeaders as network_mojom_HttpResponseHeaders,
  HttpResponseHeadersSpec as network_mojom_HttpResponseHeadersSpec
} from './network_param.mojom.m.js';

import {
  NetworkQualityEstimatorManagerRemote as network_mojom_NetworkQualityEstimatorManagerRemote,
  NetworkQualityEstimatorManagerPendingReceiver as network_mojom_NetworkQualityEstimatorManagerPendingReceiver
} from './network_quality_estimator_manager.mojom.m.js';

import {
  NetworkServiceTestRemote as network_mojom_NetworkServiceTestRemote,
  NetworkServiceTestPendingReceiver as network_mojom_NetworkServiceTestPendingReceiver
} from './network_service_test.mojom.m.js';

import {
  ParsedHeaders as network_mojom_ParsedHeaders,
  ParsedHeadersSpec as network_mojom_ParsedHeadersSpec
} from './parsed_headers.mojom.m.js';

import {
  IpProtectionProxyBypassPolicy as network_mojom_IpProtectionProxyBypassPolicy,
  IpProtectionProxyBypassPolicySpec as network_mojom_IpProtectionProxyBypassPolicySpec
} from './proxy_config.mojom.m.js';

import {
  SourceType as network_mojom_SourceType,
  SourceTypeSpec as network_mojom_SourceTypeSpec
} from './source_type.mojom.m.js';

import {
  SystemDnsResolverRemote as network_mojom_SystemDnsResolverRemote,
  SystemDnsResolverPendingReceiver as network_mojom_SystemDnsResolverPendingReceiver
} from './system_dns_resolution.mojom.m.js';

import {
  URLLoaderRemote as network_mojom_URLLoaderRemote,
  URLLoaderPendingReceiver as network_mojom_URLLoaderPendingReceiver,
  URLLoaderClientRemote as network_mojom_URLLoaderClientRemote,
  URLLoaderClientPendingReceiver as network_mojom_URLLoaderClientPendingReceiver
} from './url_loader.mojom.m.js';

import {
  URLLoaderNetworkServiceObserverRemote as network_mojom_URLLoaderNetworkServiceObserverRemote,
  URLLoaderNetworkServiceObserverPendingReceiver as network_mojom_URLLoaderNetworkServiceObserverPendingReceiver
} from './url_loader_network_service_observer.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NetworkServicePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.NetworkService', scope);
  }
}

/** @interface */
export class NetworkServiceInterface {
  
  /**
   * @param { !NetworkServiceParams } params
   */

  setParams(params) {}
  
  /**
   * @param { !mojoBase_mojom_File } file
   * @param { !bigint } maxTotalSize
   * @param { !network_mojom_NetLogCaptureMode } captureMode
   * @param { !mojoBase_mojom_DictionaryValue } constants
   * @param { ?mojoBase_mojom_TimeDelta } duration
   */

  startNetLog(file, maxTotalSize, captureMode, constants, duration) {}
  
  /**
   * @param { !network_mojom_NetLogProxySourceRemote } proxySource
   * @param { !network_mojom_NetLogProxySinkPendingReceiver } proxySink
   */

  attachNetLogProxy(proxySource, proxySink) {}
  
  /**
   * @param { !mojoBase_mojom_File } file
   */

  setSSLKeyLogFile(file) {}
  
  /**
   * @param { !network_mojom_NetworkContextPendingReceiver } context
   * @param { !network_mojom_NetworkContextParams } params
   */

  createNetworkContext(context, params) {}
  
  /**
   * @param { !boolean } insecureDnsClientEnabled
   * @param { !boolean } happyEyeballsV3Enabled
   * @param { !network_mojom_SecureDnsMode } secureDnsMode
   * @param { !network_mojom_DnsOverHttpsConfig } dnsOverHttpsConfig
   * @param { !boolean } additionalDnsTypesEnabled
   */

  configureStubHostResolver(insecureDnsClientEnabled, happyEyeballsV3Enabled, secureDnsMode, dnsOverHttpsConfig, additionalDnsTypesEnabled) {}
  
  /**
   */

  disableQuic() {}
  
  /**
   * @param { !HttpAuthStaticParams } httpAuthStaticParams
   */

  setUpHttpAuth(httpAuthStaticParams) {}
  
  /**
   * @param { !HttpAuthDynamicParams } httpAuthDynamicParams
   */

  configureHttpAuthPrefs(httpAuthDynamicParams) {}
  
  /**
   * @param { !number } processId
   * @param { !Array<!url_mojom_Origin> } origins
   */

  setRawHeadersAccess(processId, origins) {}
  
  /**
   * @param { !number } maxConnections
   */

  setMaxConnectionsPerProxyChain(maxConnections) {}
  
  /**
   * @param { !network_mojom_NetworkChangeManagerPendingReceiver } networkChangeManager
   */

  getNetworkChangeManager(networkChangeManager) {}
  
  /**
   * @param { !network_mojom_NetworkQualityEstimatorManagerPendingReceiver } receiver
   */

  getNetworkQualityEstimatorManager(receiver) {}
  
  /**
   * @param { !network_mojom_DnsConfigChangeManagerPendingReceiver } receiver
   */

  getDnsConfigChangeManager(receiver) {}
  
  /**
   * @param { !number } policy
   * @return {!Promise<{
        networks: ?Array<!network_mojom_NetworkInterface>,
   *  }>}
   */

  getNetworkList(policy) {}
  
  /**
   */

  onTrustStoreChanged() {}
  
  /**
   */

  onClientCertStoreChanged() {}
  
  /**
   * @param { !mojoBase_mojom_ByteString } encryptionKey
   */

  setEncryptionKey(encryptionKey) {}
  
  /**
   * @param { !mojoBase_mojom_MemoryPressureLevel } memoryPressureLevel
   */

  onMemoryPressure(memoryPressureLevel) {}
  
  /**
   * @param { !number } count
   */

  onPeerToPeerConnectionsCountChange(count) {}
  
  /**
   * @param { !string } rawCommitments
   * @return {!Promise}
   */

  setTrustTokenKeyCommitments(rawCommitments) {}
  
  /**
   */

  clearSCTAuditingCache() {}
  
  /**
   * @param { !SCTAuditingConfiguration } configuration
   */

  configureSCTAuditing(configuration) {}
  
  /**
   * @param { !Array<!network_mojom_CTLogInfo> } logList
   * @return {!Promise}
   */

  updateCtLogList(logList) {}
  
  /**
   * @param { !Array<!Array<!number>> } sctHashes
   * @return {!Promise}
   */

  updateCtKnownPopularSCTs(sctHashes) {}
  
  /**
   * @param { !boolean } enabled
   * @return {!Promise}
   */

  setCtEnforcementEnabled(enabled) {}
  
  /**
   * @param { !network_mojom_PinList } pinList
   * @param { !mojoBase_mojom_Time } updateTime
   */

  updateKeyPinsList(pinList, updateTime) {}
  
  /**
   * @param { !network_mojom_NetworkServiceTestPendingReceiver } receiver
   */

  bindTestInterfaceForTesting(receiver) {}
  
  /**
   * @param { !network_mojom_GlobalFirstPartySets } sets
   */

  setFirstPartySets(sets) {}
  
  /**
   * @param { !Array<!number> } ports
   */

  setExplicitlyAllowedPorts(ports) {}
  
  /**
   * @param { !mojoBase_mojom_File } defaultFile
   * @param { !bigint } defaultFileSize
   * @param { !mojoBase_mojom_File } regularBrowsingFile
   * @param { !bigint } regularBrowsingFileSize
   */

  updateMaskedDomainList(defaultFile, defaultFileSize, regularBrowsingFile, regularBrowsingFileSize) {}
  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } registry
   */

  updateProbabilisticRevealTokenRegistry(registry) {}
  
  /**
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_HttpResponseHeaders } headers
   * @return {!Promise<{
        parsedHeaders: !network_mojom_ParsedHeaders,
   *  }>}
   */

  parseHeaders(url, headers) {}
  
  /**
   * @param { !boolean } enable
   */

  enableDataUseUpdates(enable) {}
  
  /**
   * @param { !boolean } reachabilityOverride
   */

  setIPv6ReachabilityOverride(reachabilityOverride) {}
  
  /**
   * @param { !network_mojom_NetworkAnnotationMonitorRemote } remote
   */

  setNetworkAnnotationMonitor(remote) {}
  
  /**
   * @param { !Array<!contentSettings_mojom_ContentSettingPatternSource> } settings
   */

  setTpcdMetadataGrants(settings) {}
  
  /**
   * @param { !Array<!network_mojom_SourceType> } contentEncodingTypes
   * @param { !MojoHandle } sourceBody
   * @param { !MojoHandle } destBody
   * @param { !network_mojom_URLLoaderRemote } sourceUrlLoader
   * @param { !network_mojom_URLLoaderClientPendingReceiver } sourceUrlLoaderClient
   * @param { !network_mojom_URLLoaderPendingReceiver } destUrlLoader
   * @param { !network_mojom_URLLoaderClientRemote } destUrlLoaderClient
   */

  interceptUrlLoaderForBodyDecoding(contentEncodingTypes, sourceBody, destBody, sourceUrlLoader, sourceUrlLoaderClient, destUrlLoader, destUrlLoaderClient) {}
  
  /**
   * @param { !Array<!network_mojom_SourceType> } contentEncodingTypes
   * @param { !MojoHandle } sourceBody
   * @param { !MojoHandle } destBody
   * @return {!Promise<{
        errorCode: !number,
   *  }>}
   */

  decodeContentEncoding(contentEncodingTypes, sourceBody, destBody) {}
  
  /**
   * @param { !boolean } enabled
   */

  setTLS13EarlyDataEnabled(enabled) {}
}

/**
 * @implements { NetworkServiceInterface }
 */
export class NetworkServiceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NetworkServicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NetworkServicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NetworkServicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !NetworkServiceParams } params
   */

  setParams(
      params) {
    this.proxy.sendMessage(
        0,
        NetworkService_SetParams_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_File } file
   * @param { !bigint } maxTotalSize
   * @param { !network_mojom_NetLogCaptureMode } captureMode
   * @param { !mojoBase_mojom_DictionaryValue } constants
   * @param { ?mojoBase_mojom_TimeDelta } duration
   */

  startNetLog(
      file,
      maxTotalSize,
      captureMode,
      constants,
      duration) {
    this.proxy.sendMessage(
        1,
        NetworkService_StartNetLog_ParamsSpec.$,
        null,
        [
          file,
          maxTotalSize,
          captureMode,
          constants,
          duration
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_NetLogProxySourceRemote } proxySource
   * @param { !network_mojom_NetLogProxySinkPendingReceiver } proxySink
   */

  attachNetLogProxy(
      proxySource,
      proxySink) {
    this.proxy.sendMessage(
        2,
        NetworkService_AttachNetLogProxy_ParamsSpec.$,
        null,
        [
          proxySource,
          proxySink
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_File } file
   */

  setSSLKeyLogFile(
      file) {
    this.proxy.sendMessage(
        3,
        NetworkService_SetSSLKeyLogFile_ParamsSpec.$,
        null,
        [
          file
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_NetworkContextPendingReceiver } context
   * @param { !network_mojom_NetworkContextParams } params
   */

  createNetworkContext(
      context,
      params) {
    this.proxy.sendMessage(
        4,
        NetworkService_CreateNetworkContext_ParamsSpec.$,
        null,
        [
          context,
          params
        ],
        false);
  }

  
  /**
   * @param { !boolean } insecureDnsClientEnabled
   * @param { !boolean } happyEyeballsV3Enabled
   * @param { !network_mojom_SecureDnsMode } secureDnsMode
   * @param { !network_mojom_DnsOverHttpsConfig } dnsOverHttpsConfig
   * @param { !boolean } additionalDnsTypesEnabled
   */

  configureStubHostResolver(
      insecureDnsClientEnabled,
      happyEyeballsV3Enabled,
      secureDnsMode,
      dnsOverHttpsConfig,
      additionalDnsTypesEnabled) {
    this.proxy.sendMessage(
        5,
        NetworkService_ConfigureStubHostResolver_ParamsSpec.$,
        null,
        [
          insecureDnsClientEnabled,
          happyEyeballsV3Enabled,
          secureDnsMode,
          dnsOverHttpsConfig,
          additionalDnsTypesEnabled
        ],
        false);
  }

  
  /**
   */

  disableQuic() {
    this.proxy.sendMessage(
        6,
        NetworkService_DisableQuic_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !HttpAuthStaticParams } httpAuthStaticParams
   */

  setUpHttpAuth(
      httpAuthStaticParams) {
    this.proxy.sendMessage(
        7,
        NetworkService_SetUpHttpAuth_ParamsSpec.$,
        null,
        [
          httpAuthStaticParams
        ],
        false);
  }

  
  /**
   * @param { !HttpAuthDynamicParams } httpAuthDynamicParams
   */

  configureHttpAuthPrefs(
      httpAuthDynamicParams) {
    this.proxy.sendMessage(
        8,
        NetworkService_ConfigureHttpAuthPrefs_ParamsSpec.$,
        null,
        [
          httpAuthDynamicParams
        ],
        false);
  }

  
  /**
   * @param { !number } processId
   * @param { !Array<!url_mojom_Origin> } origins
   */

  setRawHeadersAccess(
      processId,
      origins) {
    this.proxy.sendMessage(
        9,
        NetworkService_SetRawHeadersAccess_ParamsSpec.$,
        null,
        [
          processId,
          origins
        ],
        false);
  }

  
  /**
   * @param { !number } maxConnections
   */

  setMaxConnectionsPerProxyChain(
      maxConnections) {
    this.proxy.sendMessage(
        10,
        NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec.$,
        null,
        [
          maxConnections
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_NetworkChangeManagerPendingReceiver } networkChangeManager
   */

  getNetworkChangeManager(
      networkChangeManager) {
    this.proxy.sendMessage(
        11,
        NetworkService_GetNetworkChangeManager_ParamsSpec.$,
        null,
        [
          networkChangeManager
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_NetworkQualityEstimatorManagerPendingReceiver } receiver
   */

  getNetworkQualityEstimatorManager(
      receiver) {
    this.proxy.sendMessage(
        12,
        NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_DnsConfigChangeManagerPendingReceiver } receiver
   */

  getDnsConfigChangeManager(
      receiver) {
    this.proxy.sendMessage(
        13,
        NetworkService_GetDnsConfigChangeManager_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !number } policy
   * @return {!Promise<{
        networks: ?Array<!network_mojom_NetworkInterface>,
   *  }>}
   */

  getNetworkList(
      policy) {
    return this.proxy.sendMessage(
        14,
        NetworkService_GetNetworkList_ParamsSpec.$,
        NetworkService_GetNetworkList_ResponseParamsSpec.$,
        [
          policy
        ],
        false);
  }

  
  /**
   */

  onTrustStoreChanged() {
    this.proxy.sendMessage(
        15,
        NetworkService_OnTrustStoreChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onClientCertStoreChanged() {
    this.proxy.sendMessage(
        16,
        NetworkService_OnClientCertStoreChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_ByteString } encryptionKey
   */

  setEncryptionKey(
      encryptionKey) {
    this.proxy.sendMessage(
        17,
        NetworkService_SetEncryptionKey_ParamsSpec.$,
        null,
        [
          encryptionKey
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_MemoryPressureLevel } memoryPressureLevel
   */

  onMemoryPressure(
      memoryPressureLevel) {
    this.proxy.sendMessage(
        18,
        NetworkService_OnMemoryPressure_ParamsSpec.$,
        null,
        [
          memoryPressureLevel
        ],
        false);
  }

  
  /**
   * @param { !number } count
   */

  onPeerToPeerConnectionsCountChange(
      count) {
    this.proxy.sendMessage(
        19,
        NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec.$,
        null,
        [
          count
        ],
        false);
  }

  
  /**
   * @param { !string } rawCommitments
   * @return {!Promise}
   */

  setTrustTokenKeyCommitments(
      rawCommitments) {
    return this.proxy.sendMessage(
        20,
        NetworkService_SetTrustTokenKeyCommitments_ParamsSpec.$,
        NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        [
          rawCommitments
        ],
        false);
  }

  
  /**
   */

  clearSCTAuditingCache() {
    this.proxy.sendMessage(
        21,
        NetworkService_ClearSCTAuditingCache_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !SCTAuditingConfiguration } configuration
   */

  configureSCTAuditing(
      configuration) {
    this.proxy.sendMessage(
        22,
        NetworkService_ConfigureSCTAuditing_ParamsSpec.$,
        null,
        [
          configuration
        ],
        false);
  }

  
  /**
   * @param { !Array<!network_mojom_CTLogInfo> } logList
   * @return {!Promise}
   */

  updateCtLogList(
      logList) {
    return this.proxy.sendMessage(
        23,
        NetworkService_UpdateCtLogList_ParamsSpec.$,
        NetworkService_UpdateCtLogList_ResponseParamsSpec.$,
        [
          logList
        ],
        false);
  }

  
  /**
   * @param { !Array<!Array<!number>> } sctHashes
   * @return {!Promise}
   */

  updateCtKnownPopularSCTs(
      sctHashes) {
    return this.proxy.sendMessage(
        24,
        NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec.$,
        NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec.$,
        [
          sctHashes
        ],
        false);
  }

  
  /**
   * @param { !boolean } enabled
   * @return {!Promise}
   */

  setCtEnforcementEnabled(
      enabled) {
    return this.proxy.sendMessage(
        25,
        NetworkService_SetCtEnforcementEnabled_ParamsSpec.$,
        NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec.$,
        [
          enabled
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_PinList } pinList
   * @param { !mojoBase_mojom_Time } updateTime
   */

  updateKeyPinsList(
      pinList,
      updateTime) {
    this.proxy.sendMessage(
        26,
        NetworkService_UpdateKeyPinsList_ParamsSpec.$,
        null,
        [
          pinList,
          updateTime
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_NetworkServiceTestPendingReceiver } receiver
   */

  bindTestInterfaceForTesting(
      receiver) {
    this.proxy.sendMessage(
        27,
        NetworkService_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_GlobalFirstPartySets } sets
   */

  setFirstPartySets(
      sets) {
    this.proxy.sendMessage(
        28,
        NetworkService_SetFirstPartySets_ParamsSpec.$,
        null,
        [
          sets
        ],
        false);
  }

  
  /**
   * @param { !Array<!number> } ports
   */

  setExplicitlyAllowedPorts(
      ports) {
    this.proxy.sendMessage(
        29,
        NetworkService_SetExplicitlyAllowedPorts_ParamsSpec.$,
        null,
        [
          ports
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_File } defaultFile
   * @param { !bigint } defaultFileSize
   * @param { !mojoBase_mojom_File } regularBrowsingFile
   * @param { !bigint } regularBrowsingFileSize
   */

  updateMaskedDomainList(
      defaultFile,
      defaultFileSize,
      regularBrowsingFile,
      regularBrowsingFileSize) {
    this.proxy.sendMessage(
        30,
        NetworkService_UpdateMaskedDomainList_ParamsSpec.$,
        null,
        [
          defaultFile,
          defaultFileSize,
          regularBrowsingFile,
          regularBrowsingFileSize
        ],
        false);
  }

  
  /**
   * @param { !mojoBase_mojom_DictionaryValue } registry
   */

  updateProbabilisticRevealTokenRegistry(
      registry) {
    this.proxy.sendMessage(
        31,
        NetworkService_UpdateProbabilisticRevealTokenRegistry_ParamsSpec.$,
        null,
        [
          registry
        ],
        false);
  }

  
  /**
   * @param { !url_mojom_Url } url
   * @param { !network_mojom_HttpResponseHeaders } headers
   * @return {!Promise<{
        parsedHeaders: !network_mojom_ParsedHeaders,
   *  }>}
   */

  parseHeaders(
      url,
      headers) {
    return this.proxy.sendMessage(
        32,
        NetworkService_ParseHeaders_ParamsSpec.$,
        NetworkService_ParseHeaders_ResponseParamsSpec.$,
        [
          url,
          headers
        ],
        false);
  }

  
  /**
   * @param { !boolean } enable
   */

  enableDataUseUpdates(
      enable) {
    this.proxy.sendMessage(
        33,
        NetworkService_EnableDataUseUpdates_ParamsSpec.$,
        null,
        [
          enable
        ],
        false);
  }

  
  /**
   * @param { !boolean } reachabilityOverride
   */

  setIPv6ReachabilityOverride(
      reachabilityOverride) {
    this.proxy.sendMessage(
        34,
        NetworkService_SetIPv6ReachabilityOverride_ParamsSpec.$,
        null,
        [
          reachabilityOverride
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_NetworkAnnotationMonitorRemote } remote
   */

  setNetworkAnnotationMonitor(
      remote) {
    this.proxy.sendMessage(
        35,
        NetworkService_SetNetworkAnnotationMonitor_ParamsSpec.$,
        null,
        [
          remote
        ],
        false);
  }

  
  /**
   * @param { !Array<!contentSettings_mojom_ContentSettingPatternSource> } settings
   */

  setTpcdMetadataGrants(
      settings) {
    this.proxy.sendMessage(
        36,
        NetworkService_SetTpcdMetadataGrants_ParamsSpec.$,
        null,
        [
          settings
        ],
        false);
  }

  
  /**
   * @param { !Array<!network_mojom_SourceType> } contentEncodingTypes
   * @param { !MojoHandle } sourceBody
   * @param { !MojoHandle } destBody
   * @param { !network_mojom_URLLoaderRemote } sourceUrlLoader
   * @param { !network_mojom_URLLoaderClientPendingReceiver } sourceUrlLoaderClient
   * @param { !network_mojom_URLLoaderPendingReceiver } destUrlLoader
   * @param { !network_mojom_URLLoaderClientRemote } destUrlLoaderClient
   */

  interceptUrlLoaderForBodyDecoding(
      contentEncodingTypes,
      sourceBody,
      destBody,
      sourceUrlLoader,
      sourceUrlLoaderClient,
      destUrlLoader,
      destUrlLoaderClient) {
    this.proxy.sendMessage(
        37,
        NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec.$,
        null,
        [
          contentEncodingTypes,
          sourceBody,
          destBody,
          sourceUrlLoader,
          sourceUrlLoaderClient,
          destUrlLoader,
          destUrlLoaderClient
        ],
        false);
  }

  
  /**
   * @param { !Array<!network_mojom_SourceType> } contentEncodingTypes
   * @param { !MojoHandle } sourceBody
   * @param { !MojoHandle } destBody
   * @return {!Promise<{
        errorCode: !number,
   *  }>}
   */

  decodeContentEncoding(
      contentEncodingTypes,
      sourceBody,
      destBody) {
    return this.proxy.sendMessage(
        38,
        NetworkService_DecodeContentEncoding_ParamsSpec.$,
        NetworkService_DecodeContentEncoding_ResponseParamsSpec.$,
        [
          contentEncodingTypes,
          sourceBody,
          destBody
        ],
        false);
  }

  
  /**
   * @param { !boolean } enabled
   */

  setTLS13EarlyDataEnabled(
      enabled) {
    this.proxy.sendMessage(
        39,
        NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec.$,
        null,
        [
          enabled
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NetworkService
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NetworkServiceReceiver {
  /**
   * @param {!NetworkServiceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NetworkServiceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NetworkServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NetworkService_SetParams_ParamsSpec.$,
        null,
        impl.setParams.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NetworkService_StartNetLog_ParamsSpec.$,
        null,
        impl.startNetLog.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NetworkService_AttachNetLogProxy_ParamsSpec.$,
        null,
        impl.attachNetLogProxy.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        NetworkService_SetSSLKeyLogFile_ParamsSpec.$,
        null,
        impl.setSSLKeyLogFile.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        NetworkService_CreateNetworkContext_ParamsSpec.$,
        null,
        impl.createNetworkContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        NetworkService_ConfigureStubHostResolver_ParamsSpec.$,
        null,
        impl.configureStubHostResolver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        NetworkService_DisableQuic_ParamsSpec.$,
        null,
        impl.disableQuic.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        NetworkService_SetUpHttpAuth_ParamsSpec.$,
        null,
        impl.setUpHttpAuth.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        NetworkService_ConfigureHttpAuthPrefs_ParamsSpec.$,
        null,
        impl.configureHttpAuthPrefs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        NetworkService_SetRawHeadersAccess_ParamsSpec.$,
        null,
        impl.setRawHeadersAccess.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec.$,
        null,
        impl.setMaxConnectionsPerProxyChain.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        NetworkService_GetNetworkChangeManager_ParamsSpec.$,
        null,
        impl.getNetworkChangeManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec.$,
        null,
        impl.getNetworkQualityEstimatorManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        NetworkService_GetDnsConfigChangeManager_ParamsSpec.$,
        null,
        impl.getDnsConfigChangeManager.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        NetworkService_GetNetworkList_ParamsSpec.$,
        NetworkService_GetNetworkList_ResponseParamsSpec.$,
        impl.getNetworkList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        NetworkService_OnTrustStoreChanged_ParamsSpec.$,
        null,
        impl.onTrustStoreChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        NetworkService_OnClientCertStoreChanged_ParamsSpec.$,
        null,
        impl.onClientCertStoreChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        NetworkService_SetEncryptionKey_ParamsSpec.$,
        null,
        impl.setEncryptionKey.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        NetworkService_OnMemoryPressure_ParamsSpec.$,
        null,
        impl.onMemoryPressure.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec.$,
        null,
        impl.onPeerToPeerConnectionsCountChange.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        NetworkService_SetTrustTokenKeyCommitments_ParamsSpec.$,
        NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        impl.setTrustTokenKeyCommitments.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        NetworkService_ClearSCTAuditingCache_ParamsSpec.$,
        null,
        impl.clearSCTAuditingCache.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        22,
        NetworkService_ConfigureSCTAuditing_ParamsSpec.$,
        null,
        impl.configureSCTAuditing.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        23,
        NetworkService_UpdateCtLogList_ParamsSpec.$,
        NetworkService_UpdateCtLogList_ResponseParamsSpec.$,
        impl.updateCtLogList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        24,
        NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec.$,
        NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec.$,
        impl.updateCtKnownPopularSCTs.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        25,
        NetworkService_SetCtEnforcementEnabled_ParamsSpec.$,
        NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec.$,
        impl.setCtEnforcementEnabled.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        26,
        NetworkService_UpdateKeyPinsList_ParamsSpec.$,
        null,
        impl.updateKeyPinsList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        27,
        NetworkService_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        impl.bindTestInterfaceForTesting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        28,
        NetworkService_SetFirstPartySets_ParamsSpec.$,
        null,
        impl.setFirstPartySets.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        29,
        NetworkService_SetExplicitlyAllowedPorts_ParamsSpec.$,
        null,
        impl.setExplicitlyAllowedPorts.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        30,
        NetworkService_UpdateMaskedDomainList_ParamsSpec.$,
        null,
        impl.updateMaskedDomainList.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        31,
        NetworkService_UpdateProbabilisticRevealTokenRegistry_ParamsSpec.$,
        null,
        impl.updateProbabilisticRevealTokenRegistry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        32,
        NetworkService_ParseHeaders_ParamsSpec.$,
        NetworkService_ParseHeaders_ResponseParamsSpec.$,
        impl.parseHeaders.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        33,
        NetworkService_EnableDataUseUpdates_ParamsSpec.$,
        null,
        impl.enableDataUseUpdates.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        34,
        NetworkService_SetIPv6ReachabilityOverride_ParamsSpec.$,
        null,
        impl.setIPv6ReachabilityOverride.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        35,
        NetworkService_SetNetworkAnnotationMonitor_ParamsSpec.$,
        null,
        impl.setNetworkAnnotationMonitor.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        36,
        NetworkService_SetTpcdMetadataGrants_ParamsSpec.$,
        null,
        impl.setTpcdMetadataGrants.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        37,
        NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec.$,
        null,
        impl.interceptUrlLoaderForBodyDecoding.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        38,
        NetworkService_DecodeContentEncoding_ParamsSpec.$,
        NetworkService_DecodeContentEncoding_ResponseParamsSpec.$,
        impl.decodeContentEncoding.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        39,
        NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec.$,
        null,
        impl.setTLS13EarlyDataEnabled.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NetworkService {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.NetworkService";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NetworkServiceRemote}
   */
  static getRemote() {
    let remote = new NetworkServiceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NetworkService
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NetworkServiceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NetworkServiceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NetworkServiceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setParams =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NetworkService_SetParams_ParamsSpec.$,
        null,
        this.setParams.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startNetLog =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NetworkService_StartNetLog_ParamsSpec.$,
        null,
        this.startNetLog.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.attachNetLogProxy =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NetworkService_AttachNetLogProxy_ParamsSpec.$,
        null,
        this.attachNetLogProxy.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setSSLKeyLogFile =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        NetworkService_SetSSLKeyLogFile_ParamsSpec.$,
        null,
        this.setSSLKeyLogFile.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createNetworkContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        NetworkService_CreateNetworkContext_ParamsSpec.$,
        null,
        this.createNetworkContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configureStubHostResolver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        NetworkService_ConfigureStubHostResolver_ParamsSpec.$,
        null,
        this.configureStubHostResolver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.disableQuic =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        NetworkService_DisableQuic_ParamsSpec.$,
        null,
        this.disableQuic.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setUpHttpAuth =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        NetworkService_SetUpHttpAuth_ParamsSpec.$,
        null,
        this.setUpHttpAuth.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configureHttpAuthPrefs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        NetworkService_ConfigureHttpAuthPrefs_ParamsSpec.$,
        null,
        this.configureHttpAuthPrefs.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setRawHeadersAccess =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        NetworkService_SetRawHeadersAccess_ParamsSpec.$,
        null,
        this.setRawHeadersAccess.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setMaxConnectionsPerProxyChain =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec.$,
        null,
        this.setMaxConnectionsPerProxyChain.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNetworkChangeManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        NetworkService_GetNetworkChangeManager_ParamsSpec.$,
        null,
        this.getNetworkChangeManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNetworkQualityEstimatorManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec.$,
        null,
        this.getNetworkQualityEstimatorManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDnsConfigChangeManager =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        NetworkService_GetDnsConfigChangeManager_ParamsSpec.$,
        null,
        this.getDnsConfigChangeManager.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNetworkList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        NetworkService_GetNetworkList_ParamsSpec.$,
        NetworkService_GetNetworkList_ResponseParamsSpec.$,
        this.getNetworkList.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTrustStoreChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        NetworkService_OnTrustStoreChanged_ParamsSpec.$,
        null,
        this.onTrustStoreChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onClientCertStoreChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        NetworkService_OnClientCertStoreChanged_ParamsSpec.$,
        null,
        this.onClientCertStoreChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setEncryptionKey =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        NetworkService_SetEncryptionKey_ParamsSpec.$,
        null,
        this.setEncryptionKey.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onMemoryPressure =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        NetworkService_OnMemoryPressure_ParamsSpec.$,
        null,
        this.onMemoryPressure.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onPeerToPeerConnectionsCountChange =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec.$,
        null,
        this.onPeerToPeerConnectionsCountChange.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTrustTokenKeyCommitments =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        NetworkService_SetTrustTokenKeyCommitments_ParamsSpec.$,
        NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
        this.setTrustTokenKeyCommitments.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearSCTAuditingCache =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        NetworkService_ClearSCTAuditingCache_ParamsSpec.$,
        null,
        this.clearSCTAuditingCache.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.configureSCTAuditing =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        22,
        NetworkService_ConfigureSCTAuditing_ParamsSpec.$,
        null,
        this.configureSCTAuditing.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateCtLogList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        23,
        NetworkService_UpdateCtLogList_ParamsSpec.$,
        NetworkService_UpdateCtLogList_ResponseParamsSpec.$,
        this.updateCtLogList.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateCtKnownPopularSCTs =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        24,
        NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec.$,
        NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec.$,
        this.updateCtKnownPopularSCTs.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setCtEnforcementEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        25,
        NetworkService_SetCtEnforcementEnabled_ParamsSpec.$,
        NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec.$,
        this.setCtEnforcementEnabled.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateKeyPinsList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        26,
        NetworkService_UpdateKeyPinsList_ParamsSpec.$,
        null,
        this.updateKeyPinsList.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.bindTestInterfaceForTesting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        27,
        NetworkService_BindTestInterfaceForTesting_ParamsSpec.$,
        null,
        this.bindTestInterfaceForTesting.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setFirstPartySets =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        28,
        NetworkService_SetFirstPartySets_ParamsSpec.$,
        null,
        this.setFirstPartySets.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setExplicitlyAllowedPorts =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        29,
        NetworkService_SetExplicitlyAllowedPorts_ParamsSpec.$,
        null,
        this.setExplicitlyAllowedPorts.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateMaskedDomainList =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        30,
        NetworkService_UpdateMaskedDomainList_ParamsSpec.$,
        null,
        this.updateMaskedDomainList.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateProbabilisticRevealTokenRegistry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        31,
        NetworkService_UpdateProbabilisticRevealTokenRegistry_ParamsSpec.$,
        null,
        this.updateProbabilisticRevealTokenRegistry.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.parseHeaders =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        32,
        NetworkService_ParseHeaders_ParamsSpec.$,
        NetworkService_ParseHeaders_ResponseParamsSpec.$,
        this.parseHeaders.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.enableDataUseUpdates =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        33,
        NetworkService_EnableDataUseUpdates_ParamsSpec.$,
        null,
        this.enableDataUseUpdates.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setIPv6ReachabilityOverride =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        34,
        NetworkService_SetIPv6ReachabilityOverride_ParamsSpec.$,
        null,
        this.setIPv6ReachabilityOverride.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setNetworkAnnotationMonitor =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        35,
        NetworkService_SetNetworkAnnotationMonitor_ParamsSpec.$,
        null,
        this.setNetworkAnnotationMonitor.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTpcdMetadataGrants =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        36,
        NetworkService_SetTpcdMetadataGrants_ParamsSpec.$,
        null,
        this.setTpcdMetadataGrants.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.interceptUrlLoaderForBodyDecoding =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        37,
        NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec.$,
        null,
        this.interceptUrlLoaderForBodyDecoding.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.decodeContentEncoding =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        38,
        NetworkService_DecodeContentEncoding_ParamsSpec.$,
        NetworkService_DecodeContentEncoding_ResponseParamsSpec.$,
        this.decodeContentEncoding.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setTLS13EarlyDataEnabled =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        39,
        NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec.$,
        null,
        this.setTLS13EarlyDataEnabled.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpAuthStaticParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HttpAuthDynamicParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const EnvironmentVariableSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkServiceParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SCTAuditingConfigurationSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetParams_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_StartNetLog_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_AttachNetLogProxy_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetSSLKeyLogFile_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_CreateNetworkContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_ConfigureStubHostResolver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_DisableQuic_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetUpHttpAuth_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_ConfigureHttpAuthPrefs_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetRawHeadersAccess_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_GetNetworkChangeManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_GetDnsConfigChangeManager_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_GetNetworkList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_GetNetworkList_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_OnTrustStoreChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_OnClientCertStoreChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetEncryptionKey_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_OnMemoryPressure_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetTrustTokenKeyCommitments_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_ClearSCTAuditingCache_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_ConfigureSCTAuditing_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_UpdateCtLogList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_UpdateCtLogList_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetCtEnforcementEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_UpdateKeyPinsList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_BindTestInterfaceForTesting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetFirstPartySets_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetExplicitlyAllowedPorts_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_UpdateMaskedDomainList_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_UpdateProbabilisticRevealTokenRegistry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_ParseHeaders_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_ParseHeaders_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_EnableDataUseUpdates_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetIPv6ReachabilityOverride_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetNetworkAnnotationMonitor_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetTpcdMetadataGrants_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_DecodeContentEncoding_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_DecodeContentEncoding_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    HttpAuthStaticParamsSpec.$,
    'HttpAuthStaticParams',
    [
      mojo.internal.StructField(
        'gssapiLibraryName', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HttpAuthStaticParams {
  constructor() {
    /** @type { !string } */
    this.gssapiLibraryName;
  }
}



mojo.internal.Struct(
    HttpAuthDynamicParamsSpec.$,
    'HttpAuthDynamicParams',
    [
      mojo.internal.StructField(
        'allowedSchemes', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'patternsAllowedToUseAllSchemes', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serverAllowlist', 16,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'delegateAllowlist', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'delegateByKdcPolicy', 32,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'negotiateDisableCnameLookup', 32,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'enableNegotiatePort', 32,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ntlmV2Enabled', 32,
        3,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'androidNegotiateAccountType', 40,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowGssapiLibraryLoad', 32,
        4,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'basicOverHttpEnabled', 32,
        5,
        mojo.internal.Bool,
        true,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class HttpAuthDynamicParams {
  constructor() {
    /** @type { (Array<!string>|undefined) } */
    this.allowedSchemes;
    /** @type { !Array<!string> } */
    this.patternsAllowedToUseAllSchemes;
    /** @type { !string } */
    this.serverAllowlist;
    /** @type { !string } */
    this.delegateAllowlist;
    /** @type { !boolean } */
    this.delegateByKdcPolicy;
    /** @type { !boolean } */
    this.negotiateDisableCnameLookup;
    /** @type { !boolean } */
    this.enableNegotiatePort;
    /** @type { !boolean } */
    this.ntlmV2Enabled;
    /** @type { !string } */
    this.androidNegotiateAccountType;
    /** @type { !boolean } */
    this.allowGssapiLibraryLoad;
    /** @type { !boolean } */
    this.basicOverHttpEnabled;
  }
}



mojo.internal.Struct(
    EnvironmentVariableSpec.$,
    'EnvironmentVariable',
    [
      mojo.internal.StructField(
        'name', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'value', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class EnvironmentVariable {
  constructor() {
    /** @type { !string } */
    this.name;
    /** @type { !string } */
    this.value;
  }
}



mojo.internal.Struct(
    NetworkServiceParamsSpec.$,
    'NetworkServiceParams',
    [
      mojo.internal.StructField(
        'initialConnectionType', 0,
        0,
        network_mojom_ConnectionTypeSpec.$,
        network_mojom_ConnectionType.CONNECTION_UNKNOWN,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initialConnectionSubtype', 4,
        0,
        network_mojom_ConnectionSubtypeSpec.$,
        network_mojom_ConnectionSubtype.SUBTYPE_UNKNOWN,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'environment', 8,
        0,
        mojo.internal.Array(EnvironmentVariableSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'defaultObserver', 16,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderNetworkServiceObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'firstPartySetsEnabled', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'systemDnsResolver', 28,
        0,
        mojo.internal.InterfaceProxy(network_mojom_SystemDnsResolverRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ipProtectionProxyBypassPolicy', 36,
        0,
        network_mojom_IpProtectionProxyBypassPolicySpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class NetworkServiceParams {
  constructor() {
    /** @type { !network_mojom_ConnectionType } */
    this.initialConnectionType;
    /** @type { !network_mojom_ConnectionSubtype } */
    this.initialConnectionSubtype;
    /** @type { !Array<!EnvironmentVariable> } */
    this.environment;
    /** @type { !network_mojom_URLLoaderNetworkServiceObserverRemote } */
    this.defaultObserver;
    /** @type { !boolean } */
    this.firstPartySetsEnabled;
    /** @type { (network_mojom_SystemDnsResolverRemote|undefined) } */
    this.systemDnsResolver;
    /** @type { !network_mojom_IpProtectionProxyBypassPolicy } */
    this.ipProtectionProxyBypassPolicy;
  }
}



mojo.internal.Struct(
    SCTAuditingConfigurationSpec.$,
    'SCTAuditingConfiguration',
    [
      mojo.internal.StructField(
        'samplingRate', 0,
        0,
        mojo.internal.Double,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'logExpectedIngestionDelay', 8,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'logMaxIngestionRandomDelay', 16,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportUri', 24,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hashdanceLookupUri', 32,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'trafficAnnotation', 40,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hashdanceTrafficAnnotation', 48,
        0,
        network_mojom_MutableNetworkTrafficAnnotationTagSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class SCTAuditingConfiguration {
  constructor() {
    /** @type { !number } */
    this.samplingRate;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.logExpectedIngestionDelay;
    /** @type { !mojoBase_mojom_TimeDelta } */
    this.logMaxIngestionRandomDelay;
    /** @type { !url_mojom_Url } */
    this.reportUri;
    /** @type { !url_mojom_Url } */
    this.hashdanceLookupUri;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.trafficAnnotation;
    /** @type { !network_mojom_MutableNetworkTrafficAnnotationTag } */
    this.hashdanceTrafficAnnotation;
  }
}



mojo.internal.Struct(
    NetworkService_SetParams_ParamsSpec.$,
    'NetworkService_SetParams_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        NetworkServiceParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetParams_Params {
  constructor() {
    /** @type { !NetworkServiceParams } */
    this.params;
  }
}



mojo.internal.Struct(
    NetworkService_StartNetLog_ParamsSpec.$,
    'NetworkService_StartNetLog_Params',
    [
      mojo.internal.StructField(
        'file', 0,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxTotalSize', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'captureMode', 16,
        0,
        network_mojom_NetLogCaptureModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'constants', 24,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'duration', 32,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class NetworkService_StartNetLog_Params {
  constructor() {
    /** @type { !mojoBase_mojom_File } */
    this.file;
    /** @type { !bigint } */
    this.maxTotalSize;
    /** @type { !network_mojom_NetLogCaptureMode } */
    this.captureMode;
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.constants;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.duration;
  }
}



mojo.internal.Struct(
    NetworkService_AttachNetLogProxy_ParamsSpec.$,
    'NetworkService_AttachNetLogProxy_Params',
    [
      mojo.internal.StructField(
        'proxySource', 0,
        0,
        mojo.internal.InterfaceProxy(network_mojom_NetLogProxySourceRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'proxySink', 8,
        0,
        mojo.internal.InterfaceRequest(network_mojom_NetLogProxySinkPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkService_AttachNetLogProxy_Params {
  constructor() {
    /** @type { !network_mojom_NetLogProxySourceRemote } */
    this.proxySource;
    /** @type { !network_mojom_NetLogProxySinkPendingReceiver } */
    this.proxySink;
  }
}



mojo.internal.Struct(
    NetworkService_SetSSLKeyLogFile_ParamsSpec.$,
    'NetworkService_SetSSLKeyLogFile_Params',
    [
      mojo.internal.StructField(
        'file', 0,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetSSLKeyLogFile_Params {
  constructor() {
    /** @type { !mojoBase_mojom_File } */
    this.file;
  }
}



mojo.internal.Struct(
    NetworkService_CreateNetworkContext_ParamsSpec.$,
    'NetworkService_CreateNetworkContext_Params',
    [
      mojo.internal.StructField(
        'context', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_NetworkContextPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'params', 8,
        0,
        network_mojom_NetworkContextParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkService_CreateNetworkContext_Params {
  constructor() {
    /** @type { !network_mojom_NetworkContextPendingReceiver } */
    this.context;
    /** @type { !network_mojom_NetworkContextParams } */
    this.params;
  }
}



mojo.internal.Struct(
    NetworkService_ConfigureStubHostResolver_ParamsSpec.$,
    'NetworkService_ConfigureStubHostResolver_Params',
    [
      mojo.internal.StructField(
        'insecureDnsClientEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'happyEyeballsV3Enabled', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'secureDnsMode', 4,
        0,
        network_mojom_SecureDnsModeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dnsOverHttpsConfig', 8,
        0,
        network_mojom_DnsOverHttpsConfigSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'additionalDnsTypesEnabled', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkService_ConfigureStubHostResolver_Params {
  constructor() {
    /** @type { !boolean } */
    this.insecureDnsClientEnabled;
    /** @type { !boolean } */
    this.happyEyeballsV3Enabled;
    /** @type { !network_mojom_SecureDnsMode } */
    this.secureDnsMode;
    /** @type { !network_mojom_DnsOverHttpsConfig } */
    this.dnsOverHttpsConfig;
    /** @type { !boolean } */
    this.additionalDnsTypesEnabled;
  }
}



mojo.internal.Struct(
    NetworkService_DisableQuic_ParamsSpec.$,
    'NetworkService_DisableQuic_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkService_DisableQuic_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkService_SetUpHttpAuth_ParamsSpec.$,
    'NetworkService_SetUpHttpAuth_Params',
    [
      mojo.internal.StructField(
        'httpAuthStaticParams', 0,
        0,
        HttpAuthStaticParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetUpHttpAuth_Params {
  constructor() {
    /** @type { !HttpAuthStaticParams } */
    this.httpAuthStaticParams;
  }
}



mojo.internal.Struct(
    NetworkService_ConfigureHttpAuthPrefs_ParamsSpec.$,
    'NetworkService_ConfigureHttpAuthPrefs_Params',
    [
      mojo.internal.StructField(
        'httpAuthDynamicParams', 0,
        0,
        HttpAuthDynamicParamsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_ConfigureHttpAuthPrefs_Params {
  constructor() {
    /** @type { !HttpAuthDynamicParams } */
    this.httpAuthDynamicParams;
  }
}



mojo.internal.Struct(
    NetworkService_SetRawHeadersAccess_ParamsSpec.$,
    'NetworkService_SetRawHeadersAccess_Params',
    [
      mojo.internal.StructField(
        'processId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'origins', 8,
        0,
        mojo.internal.Array(url_mojom_OriginSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkService_SetRawHeadersAccess_Params {
  constructor() {
    /** @type { !number } */
    this.processId;
    /** @type { !Array<!url_mojom_Origin> } */
    this.origins;
  }
}



mojo.internal.Struct(
    NetworkService_SetMaxConnectionsPerProxyChain_ParamsSpec.$,
    'NetworkService_SetMaxConnectionsPerProxyChain_Params',
    [
      mojo.internal.StructField(
        'maxConnections', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetMaxConnectionsPerProxyChain_Params {
  constructor() {
    /** @type { !number } */
    this.maxConnections;
  }
}



mojo.internal.Struct(
    NetworkService_GetNetworkChangeManager_ParamsSpec.$,
    'NetworkService_GetNetworkChangeManager_Params',
    [
      mojo.internal.StructField(
        'networkChangeManager', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_NetworkChangeManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_GetNetworkChangeManager_Params {
  constructor() {
    /** @type { !network_mojom_NetworkChangeManagerPendingReceiver } */
    this.networkChangeManager;
  }
}



mojo.internal.Struct(
    NetworkService_GetNetworkQualityEstimatorManager_ParamsSpec.$,
    'NetworkService_GetNetworkQualityEstimatorManager_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_NetworkQualityEstimatorManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_GetNetworkQualityEstimatorManager_Params {
  constructor() {
    /** @type { !network_mojom_NetworkQualityEstimatorManagerPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    NetworkService_GetDnsConfigChangeManager_ParamsSpec.$,
    'NetworkService_GetDnsConfigChangeManager_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_DnsConfigChangeManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_GetDnsConfigChangeManager_Params {
  constructor() {
    /** @type { !network_mojom_DnsConfigChangeManagerPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    NetworkService_GetNetworkList_ParamsSpec.$,
    'NetworkService_GetNetworkList_Params',
    [
      mojo.internal.StructField(
        'policy', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_GetNetworkList_Params {
  constructor() {
    /** @type { !number } */
    this.policy;
  }
}



mojo.internal.Struct(
    NetworkService_GetNetworkList_ResponseParamsSpec.$,
    'NetworkService_GetNetworkList_ResponseParams',
    [
      mojo.internal.StructField(
        'networks', 0,
        0,
        mojo.internal.Array(network_mojom_NetworkInterfaceSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_GetNetworkList_ResponseParams {
  constructor() {
    /** @type { (Array<!network_mojom_NetworkInterface>|undefined) } */
    this.networks;
  }
}



mojo.internal.Struct(
    NetworkService_OnTrustStoreChanged_ParamsSpec.$,
    'NetworkService_OnTrustStoreChanged_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkService_OnTrustStoreChanged_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkService_OnClientCertStoreChanged_ParamsSpec.$,
    'NetworkService_OnClientCertStoreChanged_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkService_OnClientCertStoreChanged_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkService_SetEncryptionKey_ParamsSpec.$,
    'NetworkService_SetEncryptionKey_Params',
    [
      mojo.internal.StructField(
        'encryptionKey', 0,
        0,
        mojoBase_mojom_ByteStringSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetEncryptionKey_Params {
  constructor() {
    /** @type { !mojoBase_mojom_ByteString } */
    this.encryptionKey;
  }
}



mojo.internal.Struct(
    NetworkService_OnMemoryPressure_ParamsSpec.$,
    'NetworkService_OnMemoryPressure_Params',
    [
      mojo.internal.StructField(
        'memoryPressureLevel', 0,
        0,
        mojoBase_mojom_MemoryPressureLevelSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_OnMemoryPressure_Params {
  constructor() {
    /** @type { !mojoBase_mojom_MemoryPressureLevel } */
    this.memoryPressureLevel;
  }
}



mojo.internal.Struct(
    NetworkService_OnPeerToPeerConnectionsCountChange_ParamsSpec.$,
    'NetworkService_OnPeerToPeerConnectionsCountChange_Params',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_OnPeerToPeerConnectionsCountChange_Params {
  constructor() {
    /** @type { !number } */
    this.count;
  }
}



mojo.internal.Struct(
    NetworkService_SetTrustTokenKeyCommitments_ParamsSpec.$,
    'NetworkService_SetTrustTokenKeyCommitments_Params',
    [
      mojo.internal.StructField(
        'rawCommitments', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetTrustTokenKeyCommitments_Params {
  constructor() {
    /** @type { !string } */
    this.rawCommitments;
  }
}



mojo.internal.Struct(
    NetworkService_SetTrustTokenKeyCommitments_ResponseParamsSpec.$,
    'NetworkService_SetTrustTokenKeyCommitments_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkService_SetTrustTokenKeyCommitments_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkService_ClearSCTAuditingCache_ParamsSpec.$,
    'NetworkService_ClearSCTAuditingCache_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkService_ClearSCTAuditingCache_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkService_ConfigureSCTAuditing_ParamsSpec.$,
    'NetworkService_ConfigureSCTAuditing_Params',
    [
      mojo.internal.StructField(
        'configuration', 0,
        0,
        SCTAuditingConfigurationSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_ConfigureSCTAuditing_Params {
  constructor() {
    /** @type { !SCTAuditingConfiguration } */
    this.configuration;
  }
}



mojo.internal.Struct(
    NetworkService_UpdateCtLogList_ParamsSpec.$,
    'NetworkService_UpdateCtLogList_Params',
    [
      mojo.internal.StructField(
        'logList', 0,
        0,
        mojo.internal.Array(network_mojom_CTLogInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_UpdateCtLogList_Params {
  constructor() {
    /** @type { !Array<!network_mojom_CTLogInfo> } */
    this.logList;
  }
}



mojo.internal.Struct(
    NetworkService_UpdateCtLogList_ResponseParamsSpec.$,
    'NetworkService_UpdateCtLogList_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkService_UpdateCtLogList_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkService_UpdateCtKnownPopularSCTs_ParamsSpec.$,
    'NetworkService_UpdateCtKnownPopularSCTs_Params',
    [
      mojo.internal.StructField(
        'sctHashes', 0,
        0,
        mojo.internal.Array(mojo.internal.Array(mojo.internal.Uint8, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_UpdateCtKnownPopularSCTs_Params {
  constructor() {
    /** @type { !Array<!Array<!number>> } */
    this.sctHashes;
  }
}



mojo.internal.Struct(
    NetworkService_UpdateCtKnownPopularSCTs_ResponseParamsSpec.$,
    'NetworkService_UpdateCtKnownPopularSCTs_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkService_UpdateCtKnownPopularSCTs_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkService_SetCtEnforcementEnabled_ParamsSpec.$,
    'NetworkService_SetCtEnforcementEnabled_Params',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetCtEnforcementEnabled_Params {
  constructor() {
    /** @type { !boolean } */
    this.enabled;
  }
}



mojo.internal.Struct(
    NetworkService_SetCtEnforcementEnabled_ResponseParamsSpec.$,
    'NetworkService_SetCtEnforcementEnabled_ResponseParams',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NetworkService_SetCtEnforcementEnabled_ResponseParams {
  constructor() {
  }
}



mojo.internal.Struct(
    NetworkService_UpdateKeyPinsList_ParamsSpec.$,
    'NetworkService_UpdateKeyPinsList_Params',
    [
      mojo.internal.StructField(
        'pinList', 0,
        0,
        network_mojom_PinListSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'updateTime', 8,
        0,
        mojoBase_mojom_TimeSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkService_UpdateKeyPinsList_Params {
  constructor() {
    /** @type { !network_mojom_PinList } */
    this.pinList;
    /** @type { !mojoBase_mojom_Time } */
    this.updateTime;
  }
}



mojo.internal.Struct(
    NetworkService_BindTestInterfaceForTesting_ParamsSpec.$,
    'NetworkService_BindTestInterfaceForTesting_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(network_mojom_NetworkServiceTestPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_BindTestInterfaceForTesting_Params {
  constructor() {
    /** @type { !network_mojom_NetworkServiceTestPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    NetworkService_SetFirstPartySets_ParamsSpec.$,
    'NetworkService_SetFirstPartySets_Params',
    [
      mojo.internal.StructField(
        'sets', 0,
        0,
        network_mojom_GlobalFirstPartySetsSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetFirstPartySets_Params {
  constructor() {
    /** @type { !network_mojom_GlobalFirstPartySets } */
    this.sets;
  }
}



mojo.internal.Struct(
    NetworkService_SetExplicitlyAllowedPorts_ParamsSpec.$,
    'NetworkService_SetExplicitlyAllowedPorts_Params',
    [
      mojo.internal.StructField(
        'ports', 0,
        0,
        mojo.internal.Array(mojo.internal.Uint16, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetExplicitlyAllowedPorts_Params {
  constructor() {
    /** @type { !Array<!number> } */
    this.ports;
  }
}



mojo.internal.Struct(
    NetworkService_UpdateMaskedDomainList_ParamsSpec.$,
    'NetworkService_UpdateMaskedDomainList_Params',
    [
      mojo.internal.StructField(
        'defaultFile', 0,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'defaultFileSize', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'regularBrowsingFile', 16,
        0,
        mojoBase_mojom_FileSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'regularBrowsingFileSize', 24,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class NetworkService_UpdateMaskedDomainList_Params {
  constructor() {
    /** @type { !mojoBase_mojom_File } */
    this.defaultFile;
    /** @type { !bigint } */
    this.defaultFileSize;
    /** @type { !mojoBase_mojom_File } */
    this.regularBrowsingFile;
    /** @type { !bigint } */
    this.regularBrowsingFileSize;
  }
}



mojo.internal.Struct(
    NetworkService_UpdateProbabilisticRevealTokenRegistry_ParamsSpec.$,
    'NetworkService_UpdateProbabilisticRevealTokenRegistry_Params',
    [
      mojo.internal.StructField(
        'registry', 0,
        0,
        mojoBase_mojom_DictionaryValueSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_UpdateProbabilisticRevealTokenRegistry_Params {
  constructor() {
    /** @type { !mojoBase_mojom_DictionaryValue } */
    this.registry;
  }
}



mojo.internal.Struct(
    NetworkService_ParseHeaders_ParamsSpec.$,
    'NetworkService_ParseHeaders_Params',
    [
      mojo.internal.StructField(
        'url', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'headers', 8,
        0,
        network_mojom_HttpResponseHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkService_ParseHeaders_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.url;
    /** @type { !network_mojom_HttpResponseHeaders } */
    this.headers;
  }
}



mojo.internal.Struct(
    NetworkService_ParseHeaders_ResponseParamsSpec.$,
    'NetworkService_ParseHeaders_ResponseParams',
    [
      mojo.internal.StructField(
        'parsedHeaders', 0,
        0,
        network_mojom_ParsedHeadersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_ParseHeaders_ResponseParams {
  constructor() {
    /** @type { !network_mojom_ParsedHeaders } */
    this.parsedHeaders;
  }
}



mojo.internal.Struct(
    NetworkService_EnableDataUseUpdates_ParamsSpec.$,
    'NetworkService_EnableDataUseUpdates_Params',
    [
      mojo.internal.StructField(
        'enable', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_EnableDataUseUpdates_Params {
  constructor() {
    /** @type { !boolean } */
    this.enable;
  }
}



mojo.internal.Struct(
    NetworkService_SetIPv6ReachabilityOverride_ParamsSpec.$,
    'NetworkService_SetIPv6ReachabilityOverride_Params',
    [
      mojo.internal.StructField(
        'reachabilityOverride', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetIPv6ReachabilityOverride_Params {
  constructor() {
    /** @type { !boolean } */
    this.reachabilityOverride;
  }
}



mojo.internal.Struct(
    NetworkService_SetNetworkAnnotationMonitor_ParamsSpec.$,
    'NetworkService_SetNetworkAnnotationMonitor_Params',
    [
      mojo.internal.StructField(
        'remote', 0,
        0,
        mojo.internal.InterfaceProxy(network_mojom_NetworkAnnotationMonitorRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetNetworkAnnotationMonitor_Params {
  constructor() {
    /** @type { !network_mojom_NetworkAnnotationMonitorRemote } */
    this.remote;
  }
}



mojo.internal.Struct(
    NetworkService_SetTpcdMetadataGrants_ParamsSpec.$,
    'NetworkService_SetTpcdMetadataGrants_Params',
    [
      mojo.internal.StructField(
        'settings', 0,
        0,
        mojo.internal.Array(contentSettings_mojom_ContentSettingPatternSourceSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetTpcdMetadataGrants_Params {
  constructor() {
    /** @type { !Array<!contentSettings_mojom_ContentSettingPatternSource> } */
    this.settings;
  }
}



mojo.internal.Struct(
    NetworkService_InterceptUrlLoaderForBodyDecoding_ParamsSpec.$,
    'NetworkService_InterceptUrlLoaderForBodyDecoding_Params',
    [
      mojo.internal.StructField(
        'contentEncodingTypes', 0,
        0,
        mojo.internal.Array(network_mojom_SourceTypeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceBody', 8,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destBody', 12,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceUrlLoader', 16,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderRemote),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceUrlLoaderClient', 24,
        0,
        mojo.internal.InterfaceRequest(network_mojom_URLLoaderClientPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destUrlLoader', 28,
        0,
        mojo.internal.InterfaceRequest(network_mojom_URLLoaderPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destUrlLoaderClient', 32,
        0,
        mojo.internal.InterfaceProxy(network_mojom_URLLoaderClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 48],]);



/**
 * @record
 */
export class NetworkService_InterceptUrlLoaderForBodyDecoding_Params {
  constructor() {
    /** @type { !Array<!network_mojom_SourceType> } */
    this.contentEncodingTypes;
    /** @type { !MojoHandle } */
    this.sourceBody;
    /** @type { !MojoHandle } */
    this.destBody;
    /** @type { !network_mojom_URLLoaderRemote } */
    this.sourceUrlLoader;
    /** @type { !network_mojom_URLLoaderClientPendingReceiver } */
    this.sourceUrlLoaderClient;
    /** @type { !network_mojom_URLLoaderPendingReceiver } */
    this.destUrlLoader;
    /** @type { !network_mojom_URLLoaderClientRemote } */
    this.destUrlLoaderClient;
  }
}



mojo.internal.Struct(
    NetworkService_DecodeContentEncoding_ParamsSpec.$,
    'NetworkService_DecodeContentEncoding_Params',
    [
      mojo.internal.StructField(
        'contentEncodingTypes', 0,
        0,
        mojo.internal.Array(network_mojom_SourceTypeSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'sourceBody', 8,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destBody', 12,
        0,
        mojo.internal.Handle,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class NetworkService_DecodeContentEncoding_Params {
  constructor() {
    /** @type { !Array<!network_mojom_SourceType> } */
    this.contentEncodingTypes;
    /** @type { !MojoHandle } */
    this.sourceBody;
    /** @type { !MojoHandle } */
    this.destBody;
  }
}



mojo.internal.Struct(
    NetworkService_DecodeContentEncoding_ResponseParamsSpec.$,
    'NetworkService_DecodeContentEncoding_ResponseParams',
    [
      mojo.internal.StructField(
        'errorCode', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_DecodeContentEncoding_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.errorCode;
  }
}



mojo.internal.Struct(
    NetworkService_SetTLS13EarlyDataEnabled_ParamsSpec.$,
    'NetworkService_SetTLS13EarlyDataEnabled_Params',
    [
      mojo.internal.StructField(
        'enabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NetworkService_SetTLS13EarlyDataEnabled_Params {
  constructor() {
    /** @type { !boolean } */
    this.enabled;
  }
}

