// services/network/public/mojom/network_service.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_TEST_UTILS_H_

#include "services/network/public/mojom/network_service.mojom.h"


namespace network::mojom {


class  NetworkServiceInterceptorForTesting : public NetworkService {
  virtual NetworkService* GetForwardingInterface() = 0;
  void SetParams(NetworkServiceParamsPtr params) override;
  void StartNetLog(::base::File file, uint64_t max_total_size, ::net::NetLogCaptureMode capture_mode, ::base::Value::Dict constants, std::optional<::base::TimeDelta> duration) override;
  void AttachNetLogProxy(::mojo::PendingRemote<::network::mojom::NetLogProxySource> proxy_source, ::mojo::PendingReceiver<::network::mojom::NetLogProxySink> proxy_sink) override;
  void SetSSLKeyLogFile(::base::File file) override;
  void CreateNetworkContext(::mojo::PendingReceiver<::network::mojom::NetworkContext> context, ::network::mojom::NetworkContextParamsPtr params) override;
  void ConfigureStubHostResolver(bool insecure_dns_client_enabled, bool happy_eyeballs_v3_enabled, ::net::SecureDnsMode secure_dns_mode, const ::net::DnsOverHttpsConfig& dns_over_https_config, bool additional_dns_types_enabled) override;
  void DisableQuic() override;
  void SetUpHttpAuth(HttpAuthStaticParamsPtr http_auth_static_params) override;
  void ConfigureHttpAuthPrefs(HttpAuthDynamicParamsPtr http_auth_dynamic_params) override;
  void SetRawHeadersAccess(int32_t process_id, const std::vector<::url::Origin>& origins) override;
  void SetMaxConnectionsPerProxyChain(int32_t max_connections) override;
  void GetNetworkChangeManager(::mojo::PendingReceiver<::network::mojom::NetworkChangeManager> network_change_manager) override;
  void GetNetworkQualityEstimatorManager(::mojo::PendingReceiver<::network::mojom::NetworkQualityEstimatorManager> receiver) override;
  void GetDnsConfigChangeManager(::mojo::PendingReceiver<::network::mojom::DnsConfigChangeManager> receiver) override;
  void GetNetworkList(uint32_t policy, GetNetworkListCallback callback) override;
  void OnTrustStoreChanged() override;
  void OnClientCertStoreChanged() override;
  void SetEncryptionKey(const std::string& encryption_key) override;
  void OnMemoryPressure(::base::MemoryPressureLevel memory_pressure_level) override;
  void OnPeerToPeerConnectionsCountChange(uint32_t count) override;
  void SetTrustTokenKeyCommitments(const std::string& raw_commitments, SetTrustTokenKeyCommitmentsCallback callback) override;
  void ClearSCTAuditingCache() override;
  void ConfigureSCTAuditing(SCTAuditingConfigurationPtr configuration) override;
  void UpdateCtLogList(std::vector<::network::mojom::CTLogInfoPtr> log_list, UpdateCtLogListCallback callback) override;
  void UpdateCtKnownPopularSCTs(const std::vector<std::vector<uint8_t>>& sct_hashes, UpdateCtKnownPopularSCTsCallback callback) override;
  void SetCtEnforcementEnabled(bool enabled, SetCtEnforcementEnabledCallback callback) override;
  void UpdateKeyPinsList(::network::mojom::PinListPtr pin_list, ::base::Time update_time) override;
  void BindTestInterfaceForTesting(::mojo::PendingReceiver<::network::mojom::NetworkServiceTest> receiver) override;
  void SetFirstPartySets(::net::GlobalFirstPartySets sets) override;
  void SetExplicitlyAllowedPorts(const std::vector<uint16_t>& ports) override;
  void UpdateMaskedDomainList(::base::File default_file, uint64_t default_file_size, ::base::File regular_browsing_file, uint64_t regular_browsing_file_size) override;
  void UpdateProbabilisticRevealTokenRegistry(::base::Value::Dict registry) override;
  void ParseHeaders(const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, ParseHeadersCallback callback) override;
  void EnableDataUseUpdates(bool enable) override;
  void SetIPv6ReachabilityOverride(bool reachability_override) override;
  void SetNetworkAnnotationMonitor(::mojo::PendingRemote<::network::mojom::NetworkAnnotationMonitor> remote) override;
  void SetTpcdMetadataGrants(const std::vector<::ContentSettingPatternSource>& settings) override;
  void InterceptUrlLoaderForBodyDecoding(const std::vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body, ::mojo::PendingRemote<::network::mojom::URLLoader> source_url_loader, ::mojo::PendingReceiver<::network::mojom::URLLoaderClient> source_url_loader_client, ::mojo::PendingReceiver<::network::mojom::URLLoader> dest_url_loader, ::mojo::PendingRemote<::network::mojom::URLLoaderClient> dest_url_loader_client) override;
  void DecodeContentEncoding(const std::vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body, DecodeContentEncodingCallback callback) override;
  void SetTLS13EarlyDataEnabled(bool enabled) override;
};
class  NetworkServiceAsyncWaiter {
 public:
  explicit NetworkServiceAsyncWaiter(NetworkService* proxy);

  NetworkServiceAsyncWaiter(const NetworkServiceAsyncWaiter&) = delete;
  NetworkServiceAsyncWaiter& operator=(const NetworkServiceAsyncWaiter&) = delete;

  ~NetworkServiceAsyncWaiter();
  void GetNetworkList(
      uint32_t policy, std::optional<std::vector<::net::NetworkInterface>>* out_networks);
  std::optional<std::vector<::net::NetworkInterface>> GetNetworkList(uint32_t policy);
  void SetTrustTokenKeyCommitments(
      const std::string& raw_commitments);
  
  void UpdateCtLogList(
      std::vector<::network::mojom::CTLogInfoPtr> log_list);
  
  void UpdateCtKnownPopularSCTs(
      const std::vector<std::vector<uint8_t>>& sct_hashes);
  
  void SetCtEnforcementEnabled(
      bool enabled);
  
  void ParseHeaders(
      const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, ::network::mojom::ParsedHeadersPtr* out_parsed_headers);
  ::network::mojom::ParsedHeadersPtr ParseHeaders(const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers);
  void DecodeContentEncoding(
      const std::vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body, int32_t* out_error_code);
  int32_t DecodeContentEncoding(const std::vector<::net::SourceStreamType>& content_encoding_types, ::mojo::ScopedDataPipeConsumerHandle source_body, ::mojo::ScopedDataPipeProducerHandle dest_body);

 private:
  NetworkService* const proxy_;
};




}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_SERVICE_MOJOM_TEST_UTILS_H_