// services/network/public/mojom/network_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/network_service.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/network_service.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool HttpAuthStaticParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HttpAuthStaticParams_Data* object =
      static_cast<const HttpAuthStaticParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gssapi_library_name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& gssapi_library_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->gssapi_library_name, validation_context,
                                         &gssapi_library_name_validate_params)) {
    return false;
  }

  return true;
}

HttpAuthStaticParams_Data::HttpAuthStaticParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool HttpAuthDynamicParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const HttpAuthDynamicParams_Data* object =
      static_cast<const HttpAuthDynamicParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& allowed_schemes_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->allowed_schemes, validation_context,
                                         &allowed_schemes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->patterns_allowed_to_use_all_schemes, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& patterns_allowed_to_use_all_schemes_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->patterns_allowed_to_use_all_schemes, validation_context,
                                         &patterns_allowed_to_use_all_schemes_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->server_allowlist, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& server_allowlist_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->server_allowlist, validation_context,
                                         &server_allowlist_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->delegate_allowlist, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& delegate_allowlist_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->delegate_allowlist, validation_context,
                                         &delegate_allowlist_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->android_negotiate_account_type, 9, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& android_negotiate_account_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->android_negotiate_account_type, validation_context,
                                         &android_negotiate_account_type_validate_params)) {
    return false;
  }

  return true;
}

HttpAuthDynamicParams_Data::HttpAuthDynamicParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool EnvironmentVariable_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const EnvironmentVariable_Data* object =
      static_cast<const EnvironmentVariable_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->name, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->name, validation_context,
                                         &name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->value, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& value_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->value, validation_context,
                                         &value_validate_params)) {
    return false;
  }

  return true;
}

EnvironmentVariable_Data::EnvironmentVariable_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkServiceParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkServiceParams_Data* object =
      static_cast<const NetworkServiceParams_Data*>(data);


  if (!::network::mojom::internal::ConnectionType_Data
        ::Validate(object->initial_connection_type, validation_context))
    return false;


  if (!::network::mojom::internal::ConnectionSubtype_Data
        ::Validate(object->initial_connection_subtype, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->environment, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& environment_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->environment, validation_context,
                                         &environment_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->default_observer, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->default_observer,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->system_dns_resolver,
                                                 validation_context)) {
    return false;
  }


  if (!::network::mojom::internal::IpProtectionProxyBypassPolicy_Data
        ::Validate(object->ip_protection_proxy_bypass_policy, validation_context))
    return false;

  return true;
}

NetworkServiceParams_Data::NetworkServiceParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool SCTAuditingConfiguration_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const SCTAuditingConfiguration_Data* object =
      static_cast<const SCTAuditingConfiguration_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->log_expected_ingestion_delay, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->log_expected_ingestion_delay, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->log_max_ingestion_random_delay, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->log_max_ingestion_random_delay, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->report_uri, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->report_uri, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hashdance_lookup_uri, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hashdance_lookup_uri, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->traffic_annotation, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->traffic_annotation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hashdance_traffic_annotation, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->hashdance_traffic_annotation, validation_context))
    return false;

  return true;
}

SCTAuditingConfiguration_Data::SCTAuditingConfiguration_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetParams_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetParams_Params_Data* object =
      static_cast<const NetworkService_SetParams_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

NetworkService_SetParams_Params_Data::NetworkService_SetParams_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_StartNetLog_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_StartNetLog_Params_Data* object =
      static_cast<const NetworkService_StartNetLog_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;


  if (!::network::mojom::internal::NetLogCaptureMode_Data
        ::Validate(object->capture_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->constants, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->constants, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->duration, validation_context))
    return false;

  return true;
}

NetworkService_StartNetLog_Params_Data::NetworkService_StartNetLog_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_AttachNetLogProxy_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_AttachNetLogProxy_Params_Data* object =
      static_cast<const NetworkService_AttachNetLogProxy_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->proxy_source, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->proxy_source,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->proxy_sink, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->proxy_sink,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_AttachNetLogProxy_Params_Data::NetworkService_AttachNetLogProxy_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetSSLKeyLogFile_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetSSLKeyLogFile_Params_Data* object =
      static_cast<const NetworkService_SetSSLKeyLogFile_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->file, validation_context))
    return false;

  return true;
}

NetworkService_SetSSLKeyLogFile_Params_Data::NetworkService_SetSSLKeyLogFile_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_CreateNetworkContext_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_CreateNetworkContext_Params_Data* object =
      static_cast<const NetworkService_CreateNetworkContext_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->context, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->context,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->params, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->params, validation_context))
    return false;

  return true;
}

NetworkService_CreateNetworkContext_Params_Data::NetworkService_CreateNetworkContext_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_ConfigureStubHostResolver_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_ConfigureStubHostResolver_Params_Data* object =
      static_cast<const NetworkService_ConfigureStubHostResolver_Params_Data*>(data);


  if (!::network::mojom::internal::SecureDnsMode_Data
        ::Validate(object->secure_dns_mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->dns_over_https_config, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->dns_over_https_config, validation_context))
    return false;

  return true;
}

NetworkService_ConfigureStubHostResolver_Params_Data::NetworkService_ConfigureStubHostResolver_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_DisableQuic_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_DisableQuic_Params_Data* object =
      static_cast<const NetworkService_DisableQuic_Params_Data*>(data);

  return true;
}

NetworkService_DisableQuic_Params_Data::NetworkService_DisableQuic_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetUpHttpAuth_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetUpHttpAuth_Params_Data* object =
      static_cast<const NetworkService_SetUpHttpAuth_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_auth_static_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->http_auth_static_params, validation_context))
    return false;

  return true;
}

NetworkService_SetUpHttpAuth_Params_Data::NetworkService_SetUpHttpAuth_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_ConfigureHttpAuthPrefs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_ConfigureHttpAuthPrefs_Params_Data* object =
      static_cast<const NetworkService_ConfigureHttpAuthPrefs_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->http_auth_dynamic_params, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->http_auth_dynamic_params, validation_context))
    return false;

  return true;
}

NetworkService_ConfigureHttpAuthPrefs_Params_Data::NetworkService_ConfigureHttpAuthPrefs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetRawHeadersAccess_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetRawHeadersAccess_Params_Data* object =
      static_cast<const NetworkService_SetRawHeadersAccess_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origins, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& origins_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->origins, validation_context,
                                         &origins_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_SetRawHeadersAccess_Params_Data::NetworkService_SetRawHeadersAccess_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetMaxConnectionsPerProxyChain_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetMaxConnectionsPerProxyChain_Params_Data* object =
      static_cast<const NetworkService_SetMaxConnectionsPerProxyChain_Params_Data*>(data);

  return true;
}

NetworkService_SetMaxConnectionsPerProxyChain_Params_Data::NetworkService_SetMaxConnectionsPerProxyChain_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetNetworkChangeManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_GetNetworkChangeManager_Params_Data* object =
      static_cast<const NetworkService_GetNetworkChangeManager_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->network_change_manager, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->network_change_manager,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_GetNetworkChangeManager_Params_Data::NetworkService_GetNetworkChangeManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetNetworkQualityEstimatorManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_GetNetworkQualityEstimatorManager_Params_Data* object =
      static_cast<const NetworkService_GetNetworkQualityEstimatorManager_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_GetNetworkQualityEstimatorManager_Params_Data::NetworkService_GetNetworkQualityEstimatorManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetDnsConfigChangeManager_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_GetDnsConfigChangeManager_Params_Data* object =
      static_cast<const NetworkService_GetDnsConfigChangeManager_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_GetDnsConfigChangeManager_Params_Data::NetworkService_GetDnsConfigChangeManager_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetNetworkList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_GetNetworkList_Params_Data* object =
      static_cast<const NetworkService_GetNetworkList_Params_Data*>(data);

  return true;
}

NetworkService_GetNetworkList_Params_Data::NetworkService_GetNetworkList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_GetNetworkList_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_GetNetworkList_ResponseParams_Data* object =
      static_cast<const NetworkService_GetNetworkList_ResponseParams_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& networks_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->networks, validation_context,
                                         &networks_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_GetNetworkList_ResponseParams_Data::NetworkService_GetNetworkList_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_OnTrustStoreChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_OnTrustStoreChanged_Params_Data* object =
      static_cast<const NetworkService_OnTrustStoreChanged_Params_Data*>(data);

  return true;
}

NetworkService_OnTrustStoreChanged_Params_Data::NetworkService_OnTrustStoreChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_OnClientCertStoreChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_OnClientCertStoreChanged_Params_Data* object =
      static_cast<const NetworkService_OnClientCertStoreChanged_Params_Data*>(data);

  return true;
}

NetworkService_OnClientCertStoreChanged_Params_Data::NetworkService_OnClientCertStoreChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetEncryptionKey_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetEncryptionKey_Params_Data* object =
      static_cast<const NetworkService_SetEncryptionKey_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->encryption_key, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->encryption_key, validation_context))
    return false;

  return true;
}

NetworkService_SetEncryptionKey_Params_Data::NetworkService_SetEncryptionKey_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_OnMemoryPressure_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_OnMemoryPressure_Params_Data* object =
      static_cast<const NetworkService_OnMemoryPressure_Params_Data*>(data);


  if (!::mojo_base::mojom::internal::MemoryPressureLevel_Data
        ::Validate(object->memory_pressure_level, validation_context))
    return false;

  return true;
}

NetworkService_OnMemoryPressure_Params_Data::NetworkService_OnMemoryPressure_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data* object =
      static_cast<const NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data*>(data);

  return true;
}

NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data::NetworkService_OnPeerToPeerConnectionsCountChange_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetTrustTokenKeyCommitments_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetTrustTokenKeyCommitments_Params_Data* object =
      static_cast<const NetworkService_SetTrustTokenKeyCommitments_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->raw_commitments, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& raw_commitments_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_commitments, validation_context,
                                         &raw_commitments_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_SetTrustTokenKeyCommitments_Params_Data::NetworkService_SetTrustTokenKeyCommitments_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data* object =
      static_cast<const NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data*>(data);

  return true;
}

NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data::NetworkService_SetTrustTokenKeyCommitments_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_ClearSCTAuditingCache_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_ClearSCTAuditingCache_Params_Data* object =
      static_cast<const NetworkService_ClearSCTAuditingCache_Params_Data*>(data);

  return true;
}

NetworkService_ClearSCTAuditingCache_Params_Data::NetworkService_ClearSCTAuditingCache_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_ConfigureSCTAuditing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_ConfigureSCTAuditing_Params_Data* object =
      static_cast<const NetworkService_ConfigureSCTAuditing_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->configuration, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->configuration, validation_context))
    return false;

  return true;
}

NetworkService_ConfigureSCTAuditing_Params_Data::NetworkService_ConfigureSCTAuditing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_UpdateCtLogList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_UpdateCtLogList_Params_Data* object =
      static_cast<const NetworkService_UpdateCtLogList_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->log_list, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& log_list_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->log_list, validation_context,
                                         &log_list_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_UpdateCtLogList_Params_Data::NetworkService_UpdateCtLogList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_UpdateCtLogList_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_UpdateCtLogList_ResponseParams_Data* object =
      static_cast<const NetworkService_UpdateCtLogList_ResponseParams_Data*>(data);

  return true;
}

NetworkService_UpdateCtLogList_ResponseParams_Data::NetworkService_UpdateCtLogList_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_UpdateCtKnownPopularSCTs_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_UpdateCtKnownPopularSCTs_Params_Data* object =
      static_cast<const NetworkService_UpdateCtKnownPopularSCTs_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sct_hashes, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& sct_hashes_validate_params =
      mojo::internal::GetArrayValidator<0, false, &mojo::internal::GetArrayValidator<0, false, nullptr>()>();
  if (!mojo::internal::ValidateContainer(object->sct_hashes, validation_context,
                                         &sct_hashes_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_UpdateCtKnownPopularSCTs_Params_Data::NetworkService_UpdateCtKnownPopularSCTs_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data* object =
      static_cast<const NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data*>(data);

  return true;
}

NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data::NetworkService_UpdateCtKnownPopularSCTs_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetCtEnforcementEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetCtEnforcementEnabled_Params_Data* object =
      static_cast<const NetworkService_SetCtEnforcementEnabled_Params_Data*>(data);

  return true;
}

NetworkService_SetCtEnforcementEnabled_Params_Data::NetworkService_SetCtEnforcementEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetCtEnforcementEnabled_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 8, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetCtEnforcementEnabled_ResponseParams_Data* object =
      static_cast<const NetworkService_SetCtEnforcementEnabled_ResponseParams_Data*>(data);

  return true;
}

NetworkService_SetCtEnforcementEnabled_ResponseParams_Data::NetworkService_SetCtEnforcementEnabled_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_UpdateKeyPinsList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_UpdateKeyPinsList_Params_Data* object =
      static_cast<const NetworkService_UpdateKeyPinsList_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->pin_list, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->pin_list, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->update_time, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->update_time, validation_context))
    return false;

  return true;
}

NetworkService_UpdateKeyPinsList_Params_Data::NetworkService_UpdateKeyPinsList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_BindTestInterfaceForTesting_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_BindTestInterfaceForTesting_Params_Data* object =
      static_cast<const NetworkService_BindTestInterfaceForTesting_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->receiver, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->receiver,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_BindTestInterfaceForTesting_Params_Data::NetworkService_BindTestInterfaceForTesting_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetFirstPartySets_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetFirstPartySets_Params_Data* object =
      static_cast<const NetworkService_SetFirstPartySets_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sets, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sets, validation_context))
    return false;

  return true;
}

NetworkService_SetFirstPartySets_Params_Data::NetworkService_SetFirstPartySets_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetExplicitlyAllowedPorts_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetExplicitlyAllowedPorts_Params_Data* object =
      static_cast<const NetworkService_SetExplicitlyAllowedPorts_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ports, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& ports_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->ports, validation_context,
                                         &ports_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_SetExplicitlyAllowedPorts_Params_Data::NetworkService_SetExplicitlyAllowedPorts_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_UpdateMaskedDomainList_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_UpdateMaskedDomainList_Params_Data* object =
      static_cast<const NetworkService_UpdateMaskedDomainList_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->default_file, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->default_file, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->regular_browsing_file, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->regular_browsing_file, validation_context))
    return false;

  return true;
}

NetworkService_UpdateMaskedDomainList_Params_Data::NetworkService_UpdateMaskedDomainList_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data* object =
      static_cast<const NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->registry, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->registry, validation_context))
    return false;

  return true;
}

NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data::NetworkService_UpdateProbabilisticRevealTokenRegistry_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_ParseHeaders_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_ParseHeaders_Params_Data* object =
      static_cast<const NetworkService_ParseHeaders_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  return true;
}

NetworkService_ParseHeaders_Params_Data::NetworkService_ParseHeaders_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_ParseHeaders_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_ParseHeaders_ResponseParams_Data* object =
      static_cast<const NetworkService_ParseHeaders_ResponseParams_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->parsed_headers, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->parsed_headers, validation_context))
    return false;

  return true;
}

NetworkService_ParseHeaders_ResponseParams_Data::NetworkService_ParseHeaders_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_EnableDataUseUpdates_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_EnableDataUseUpdates_Params_Data* object =
      static_cast<const NetworkService_EnableDataUseUpdates_Params_Data*>(data);

  return true;
}

NetworkService_EnableDataUseUpdates_Params_Data::NetworkService_EnableDataUseUpdates_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetIPv6ReachabilityOverride_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetIPv6ReachabilityOverride_Params_Data* object =
      static_cast<const NetworkService_SetIPv6ReachabilityOverride_Params_Data*>(data);

  return true;
}

NetworkService_SetIPv6ReachabilityOverride_Params_Data::NetworkService_SetIPv6ReachabilityOverride_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetNetworkAnnotationMonitor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetNetworkAnnotationMonitor_Params_Data* object =
      static_cast<const NetworkService_SetNetworkAnnotationMonitor_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->remote, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->remote,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_SetNetworkAnnotationMonitor_Params_Data::NetworkService_SetNetworkAnnotationMonitor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetTpcdMetadataGrants_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetTpcdMetadataGrants_Params_Data* object =
      static_cast<const NetworkService_SetTpcdMetadataGrants_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->settings, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& settings_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->settings, validation_context,
                                         &settings_validate_params)) {
    return false;
  }

  return true;
}

NetworkService_SetTpcdMetadataGrants_Params_Data::NetworkService_SetTpcdMetadataGrants_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data* object =
      static_cast<const NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_encoding_types, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_encoding_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::SourceType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->content_encoding_types, validation_context,
                                         &content_encoding_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->source_body, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->source_body,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->dest_body, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->dest_body,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->source_url_loader, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->source_url_loader,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->source_url_loader_client, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->source_url_loader_client,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->dest_url_loader, 6, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->dest_url_loader,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->dest_url_loader_client, 7, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->dest_url_loader_client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data::NetworkService_InterceptUrlLoaderForBodyDecoding_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_DecodeContentEncoding_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_DecodeContentEncoding_Params_Data* object =
      static_cast<const NetworkService_DecodeContentEncoding_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->content_encoding_types, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& content_encoding_types_validate_params =
      mojo::internal::GetArrayOfEnumsValidator<0, false, ::network::mojom::internal::SourceType_Data::Validate>();
  if (!mojo::internal::ValidateContainer(object->content_encoding_types, validation_context,
                                         &content_encoding_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->source_body, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->source_body,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->dest_body, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->dest_body,
                                                 validation_context)) {
    return false;
  }

  return true;
}

NetworkService_DecodeContentEncoding_Params_Data::NetworkService_DecodeContentEncoding_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_DecodeContentEncoding_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_DecodeContentEncoding_ResponseParams_Data* object =
      static_cast<const NetworkService_DecodeContentEncoding_ResponseParams_Data*>(data);

  return true;
}

NetworkService_DecodeContentEncoding_ResponseParams_Data::NetworkService_DecodeContentEncoding_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool NetworkService_SetTLS13EarlyDataEnabled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const NetworkService_SetTLS13EarlyDataEnabled_Params_Data* object =
      static_cast<const NetworkService_SetTLS13EarlyDataEnabled_Params_Data*>(data);

  return true;
}

NetworkService_SetTLS13EarlyDataEnabled_Params_Data::NetworkService_SetTLS13EarlyDataEnabled_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network