// services/network/public/mojom/network_isolation_key.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/network_isolation_key.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_partition.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"

#include "services/network/public/mojom/network_isolation_key.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"

namespace mojo::internal {

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::EmptyNetworkIsolationKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::EmptyNetworkIsolationKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::EmptyNetworkIsolationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::NonEmptyNetworkIsolationKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::NonEmptyNetworkIsolationKeyDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::NonEmptyNetworkIsolationKey_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::top_frame_site(input)) in_top_frame_site = Traits::top_frame_site(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top_frame_site)::BaseType> top_frame_site_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView, send_validation>(
        in_top_frame_site,
        top_frame_site_fragment);

      fragment->top_frame_site.Set(
          top_frame_site_fragment.is_null() ? nullptr : top_frame_site_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->top_frame_site.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null top_frame_site in NonEmptyNetworkIsolationKey struct");

      decltype(Traits::frame_site(input)) in_frame_site = Traits::frame_site(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_site)::BaseType> frame_site_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SchemefulSiteDataView, send_validation>(
        in_frame_site,
        frame_site_fragment);

      fragment->frame_site.Set(
          frame_site_fragment.is_null() ? nullptr : frame_site_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->frame_site.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_site in NonEmptyNetworkIsolationKey struct");

      decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nonce)::BaseType> nonce_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_nonce,
        nonce_fragment);

      fragment->nonce.Set(
          nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

      
      mojo::internal::Serialize<::network::mojom::NetworkIsolationPartition>(
        Traits::network_isolation_partition(input),
        &fragment->network_isolation_partition);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::NetworkIsolationKeyDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::network::mojom::NetworkIsolationKeyDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::network::mojom::internal::NetworkIsolationKey_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::network::mojom::NetworkIsolationKeyDataView::Tag::kEmpty: {
    decltype(Traits::empty(input))
    in_empty = Traits::empty(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_empty)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::EmptyNetworkIsolationKeyDataView, send_validation>(
  in_empty,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null empty in NetworkIsolationKey union");
    fragment->data.f_empty.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::network::mojom::NetworkIsolationKeyDataView::Tag::kNonEmpty: {
    decltype(Traits::non_empty(input))
    in_non_empty = Traits::non_empty(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_non_empty)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::network::mojom::NonEmptyNetworkIsolationKeyDataView, send_validation>(
  in_non_empty,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null non_empty in NetworkIsolationKey union");
    fragment->data.f_non_empty.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_ISOLATION_KEY_MOJOM_SEND_VALIDATION_H_