// services/network/public/mojom/network_context.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_BLINK_TEST_UTILS_H_

#include "services/network/public/mojom/network_context.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace network::mojom::blink {


class BLINK_PLATFORM_EXPORT CustomProxyConnectionObserverInterceptorForTesting : public CustomProxyConnectionObserver {
  virtual CustomProxyConnectionObserver* GetForwardingInterface() = 0;
  void OnFallback(const ::net::ProxyChain& bad_chain, int32_t net_error) override;
  void OnTunnelHeadersReceived(const ::net::ProxyChain& proxy_chain, uint64_t chain_index, ::network::mojom::blink::HttpResponseHeadersPtr response_headers) override;
};
class BLINK_PLATFORM_EXPORT CustomProxyConnectionObserverAsyncWaiter {
 public:
  explicit CustomProxyConnectionObserverAsyncWaiter(CustomProxyConnectionObserver* proxy);

  CustomProxyConnectionObserverAsyncWaiter(const CustomProxyConnectionObserverAsyncWaiter&) = delete;
  CustomProxyConnectionObserverAsyncWaiter& operator=(const CustomProxyConnectionObserverAsyncWaiter&) = delete;

  ~CustomProxyConnectionObserverAsyncWaiter();

 private:
  CustomProxyConnectionObserver* const proxy_;
};


class BLINK_PLATFORM_EXPORT CustomProxyConfigClientInterceptorForTesting : public CustomProxyConfigClient {
  virtual CustomProxyConfigClient* GetForwardingInterface() = 0;
  void OnCustomProxyConfigUpdated(CustomProxyConfigPtr proxy_config, OnCustomProxyConfigUpdatedCallback callback) override;
};
class BLINK_PLATFORM_EXPORT CustomProxyConfigClientAsyncWaiter {
 public:
  explicit CustomProxyConfigClientAsyncWaiter(CustomProxyConfigClient* proxy);

  CustomProxyConfigClientAsyncWaiter(const CustomProxyConfigClientAsyncWaiter&) = delete;
  CustomProxyConfigClientAsyncWaiter& operator=(const CustomProxyConfigClientAsyncWaiter&) = delete;

  ~CustomProxyConfigClientAsyncWaiter();
  void OnCustomProxyConfigUpdated(
      CustomProxyConfigPtr proxy_config);
  

 private:
  CustomProxyConfigClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT TrustedHeaderClientInterceptorForTesting : public TrustedHeaderClient {
  virtual TrustedHeaderClient* GetForwardingInterface() = 0;
  void OnBeforeSendHeaders(const ::net::HttpRequestHeaders& headers, OnBeforeSendHeadersCallback callback) override;
  void OnHeadersReceived(const ::blink::String& headers, const ::net::IPEndPoint& remote_endpoint, OnHeadersReceivedCallback callback) override;
};
class BLINK_PLATFORM_EXPORT TrustedHeaderClientAsyncWaiter {
 public:
  explicit TrustedHeaderClientAsyncWaiter(TrustedHeaderClient* proxy);

  TrustedHeaderClientAsyncWaiter(const TrustedHeaderClientAsyncWaiter&) = delete;
  TrustedHeaderClientAsyncWaiter& operator=(const TrustedHeaderClientAsyncWaiter&) = delete;

  ~TrustedHeaderClientAsyncWaiter();
  void OnBeforeSendHeaders(
      const ::net::HttpRequestHeaders& headers, int32_t* out_result, std::optional<::net::HttpRequestHeaders>* out_headers);
  
  void OnHeadersReceived(
      const ::blink::String& headers, const ::net::IPEndPoint& remote_endpoint, int32_t* out_result, ::blink::String* out_headers, std::optional<::blink::KURL>* out_preserve_fragment_on_redirect_url);
  

 private:
  TrustedHeaderClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT TrustedURLLoaderHeaderClientInterceptorForTesting : public TrustedURLLoaderHeaderClient {
  virtual TrustedURLLoaderHeaderClient* GetForwardingInterface() = 0;
  void OnLoaderCreated(int32_t request_id, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) override;
  void OnLoaderForCorsPreflightCreated(const ::network::ResourceRequest& request, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) override;
};
class BLINK_PLATFORM_EXPORT TrustedURLLoaderHeaderClientAsyncWaiter {
 public:
  explicit TrustedURLLoaderHeaderClientAsyncWaiter(TrustedURLLoaderHeaderClient* proxy);

  TrustedURLLoaderHeaderClientAsyncWaiter(const TrustedURLLoaderHeaderClientAsyncWaiter&) = delete;
  TrustedURLLoaderHeaderClientAsyncWaiter& operator=(const TrustedURLLoaderHeaderClientAsyncWaiter&) = delete;

  ~TrustedURLLoaderHeaderClientAsyncWaiter();

 private:
  TrustedURLLoaderHeaderClient* const proxy_;
};


class BLINK_PLATFORM_EXPORT PreloadedSharedDictionaryInfoHandleInterceptorForTesting : public PreloadedSharedDictionaryInfoHandle {
  virtual PreloadedSharedDictionaryInfoHandle* GetForwardingInterface() = 0;
};
class BLINK_PLATFORM_EXPORT PreloadedSharedDictionaryInfoHandleAsyncWaiter {
 public:
  explicit PreloadedSharedDictionaryInfoHandleAsyncWaiter(PreloadedSharedDictionaryInfoHandle* proxy);

  PreloadedSharedDictionaryInfoHandleAsyncWaiter(const PreloadedSharedDictionaryInfoHandleAsyncWaiter&) = delete;
  PreloadedSharedDictionaryInfoHandleAsyncWaiter& operator=(const PreloadedSharedDictionaryInfoHandleAsyncWaiter&) = delete;

  ~PreloadedSharedDictionaryInfoHandleAsyncWaiter();

 private:
  PreloadedSharedDictionaryInfoHandle* const proxy_;
};


class BLINK_PLATFORM_EXPORT DurableMessageCollectorInterceptorForTesting : public DurableMessageCollector {
  virtual DurableMessageCollector* GetForwardingInterface() = 0;
  void Configure(NetworkDurableMessageConfigPtr config) override;
  void Retrieve(const ::blink::String& devtools_request_id, RetrieveCallback callback) override;
};
class BLINK_PLATFORM_EXPORT DurableMessageCollectorAsyncWaiter {
 public:
  explicit DurableMessageCollectorAsyncWaiter(DurableMessageCollector* proxy);

  DurableMessageCollectorAsyncWaiter(const DurableMessageCollectorAsyncWaiter&) = delete;
  DurableMessageCollectorAsyncWaiter& operator=(const DurableMessageCollectorAsyncWaiter&) = delete;

  ~DurableMessageCollectorAsyncWaiter();
  void Retrieve(
      const ::blink::String& devtools_request_id, std::optional<::mojo_base::BigBuffer>* out_message);
  std::optional<::mojo_base::BigBuffer> Retrieve(const ::blink::String& devtools_request_id);

 private:
  DurableMessageCollector* const proxy_;
};


class BLINK_PLATFORM_EXPORT NetworkContextInterceptorForTesting : public NetworkContext {
  virtual NetworkContext* GetForwardingInterface() = 0;
  void SetClient(::mojo::PendingRemote<::network::mojom::blink::NetworkContextClient> client) override;
  void CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::blink::URLLoaderFactory> url_loader_factory, URLLoaderFactoryParamsPtr params) override;
  void ResetURLLoaderFactories() override;
  void GetViaObliviousHttp(::network::mojom::blink::ObliviousHttpRequestPtr request, ::mojo::PendingRemote<::network::mojom::blink::ObliviousHttpClient> client) override;
  void GetCookieManager(::mojo::PendingReceiver<::network::mojom::blink::CookieManager> cookie_manager) override;
  void GetRestrictedCookieManager(::mojo::PendingReceiver<::network::mojom::blink::RestrictedCookieManager> restricted_cookie_manager, ::network::mojom::blink::RestrictedCookieManagerRole role, const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, const ::net::IsolationInfo& isolation_info, ::network::mojom::blink::CookieSettingOverridesPtr cookie_setting_overrides, ::network::mojom::blink::CookieSettingOverridesPtr devtools_cookie_setting_overrides, ::mojo::PendingRemote<::network::mojom::blink::CookieAccessObserver> cookie_observer) override;
  void GetTrustTokenQueryAnswerer(::mojo::PendingReceiver<::network::mojom::blink::TrustTokenQueryAnswerer> trust_token_query_answerer, const ::scoped_refptr<const ::blink::SecurityOrigin>& top_frame_origin) override;
  void ClearTrustTokenData(::network::mojom::blink::ClearDataFilterPtr filter, ClearTrustTokenDataCallback callback) override;
  void ClearTrustTokenSessionOnlyData(ClearTrustTokenSessionOnlyDataCallback callback) override;
  void GetStoredTrustTokenCounts(GetStoredTrustTokenCountsCallback callback) override;
  void GetPrivateStateTokenRedemptionRecords(GetPrivateStateTokenRedemptionRecordsCallback callback) override;
  void GetIpProxyStatus(GetIpProxyStatusCallback callback) override;
  void SetBypassIpProtectionProxy(bool bypass_proxy) override;
  void DeleteStoredTrustTokens(const ::scoped_refptr<const ::blink::SecurityOrigin>& issuer, DeleteStoredTrustTokensCallback callback) override;
  void SetBlockTrustTokens(bool block) override;
  void SetTrackingProtectionContentSetting(::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings) override;
  void ClearNetworkingHistoryBetween(::base::Time start_time, ::base::Time end_time, ClearNetworkingHistoryBetweenCallback callback) override;
  void ClearHttpCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::blink::ClearDataFilterPtr filter, ClearHttpCacheCallback callback) override;
  void ComputeHttpCacheSize(::base::Time start_time, ::base::Time end_time, ComputeHttpCacheSizeCallback callback) override;
  void NotifyBrowserIdle() override;
  void NotifyExternalCacheHit(const ::blink::KURL& url, const ::blink::String& http_method, ::network::mojom::blink::NetworkIsolationKeyPtr key, bool include_credentials) override;
  void ClearHostCache(::network::mojom::blink::ClearDataFilterPtr filter, ClearHostCacheCallback callback) override;
  void ClearHttpAuthCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::blink::ClearDataFilterPtr filter, ClearHttpAuthCacheCallback callback) override;
  void ClearCorsPreflightCache(::network::mojom::blink::ClearDataFilterPtr filter, ClearCorsPreflightCacheCallback callback) override;
  void ClearReportingCacheReports(::network::mojom::blink::ClearDataFilterPtr filter, ClearReportingCacheReportsCallback callback) override;
  void ClearReportingCacheClients(::network::mojom::blink::ClearDataFilterPtr filter, ClearReportingCacheClientsCallback callback) override;
  void ClearNetworkErrorLogging(::network::mojom::blink::ClearDataFilterPtr filter, ClearNetworkErrorLoggingCallback callback) override;
  void ClearDomainReliability(::network::mojom::blink::ClearDataFilterPtr filter, NetworkContext::DomainReliabilityClearMode mode, ClearDomainReliabilityCallback callback) override;
  void ClearSharedDictionaryCache(::base::Time start_time, ::base::Time end_time, ::network::mojom::blink::ClearDataFilterPtr filter, ClearSharedDictionaryCacheCallback callback) override;
  void ClearSharedDictionaryCacheForIsolationKey(::network::mojom::blink::SharedDictionaryIsolationKeyPtr isolation_key, ClearSharedDictionaryCacheForIsolationKeyCallback callback) override;
  void SetDocumentReportingEndpoints(const ::base::UnguessableToken& reporting_source, const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, const ::net::IsolationInfo& isolation_info, const ::blink::HashMap<::blink::String, ::blink::String>& endpoints) override;
  void SetEnterpriseReportingEndpoints(const ::blink::HashMap<::blink::String, ::blink::KURL>& endpoints) override;
  void SendReportsAndRemoveSource(const ::base::UnguessableToken& reporting_source) override;
  void QueueReport(const ::blink::String& type, const ::blink::String& group, const ::blink::KURL& url, const std::optional<::base::UnguessableToken>& reporting_source, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::base::Value::Dict body) override;
  void QueueEnterpriseReport(const ::blink::String& type, const ::blink::String& group, const ::blink::KURL& url, ::base::Value::Dict body) override;
  void QueueSignedExchangeReport(SignedExchangeReportPtr report, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key) override;
  void CloseAllConnections(CloseAllConnectionsCallback callback) override;
  void CloseIdleConnections(CloseIdleConnectionsCallback callback) override;
  void SetNetworkConditions(const ::base::UnguessableToken& throttling_profile_id, ::blink::Vector<MatchedNetworkConditionsPtr> conditions) override;
  void EnableDurableMessageCollector(const ::base::UnguessableToken& throttling_profile_id, ::mojo::PendingReceiver<DurableMessageCollector> receiver) override;
  void SetAcceptLanguage(const ::blink::String& new_accept_language) override;
  void SetEnableReferrers(bool enable_referrers) override;
  void SetCTPolicy(CTPolicyPtr ct_policy) override;
  void CreateUDPSocket(::mojo::PendingReceiver<::network::mojom::blink::UDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> listener) override;
  void CreateRestrictedUDPSocket(const ::net::IPEndPoint& addr, ::network::mojom::blink::RestrictedUDPSocketMode mode, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::network::mojom::blink::RestrictedUDPSocketParamsPtr params, ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> listener, bool allow_multicast, CreateRestrictedUDPSocketCallback callback) override;
  void CreateTCPServerSocket(const ::net::IPEndPoint& local_addr, ::network::mojom::blink::TCPServerSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::blink::TCPServerSocket> socket, CreateTCPServerSocketCallback callback) override;
  void CreateTCPConnectedSocket(const std::optional<::net::IPEndPoint>& local_addr, ::network::mojom::blink::AddressListPtr remote_addr_list, ::network::mojom::blink::TCPConnectedSocketOptionsPtr tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::blink::TCPConnectedSocket> socket, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> observer, CreateTCPConnectedSocketCallback callback) override;
  void CreateTCPBoundSocket(const ::net::IPEndPoint& local_addr, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::blink::TCPBoundSocket> socket, CreateTCPBoundSocketCallback callback) override;
  void CreateProxyResolvingSocketFactory(::mojo::PendingReceiver<::network::mojom::blink::ProxyResolvingSocketFactory> factory) override;
  void LookUpProxyForURL(const ::blink::KURL& url, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::mojo::PendingRemote<::network::mojom::blink::ProxyLookupClient> proxy_lookup_client) override;
  void ForceReloadProxyConfig(ForceReloadProxyConfigCallback callback) override;
  void ClearBadProxiesCache(ClearBadProxiesCacheCallback callback) override;
  void CreateWebSocket(const ::blink::KURL& url, const ::blink::Vector<::blink::String>& requested_protocols, const ::net::SiteForCookies& site_for_cookies, ::net::StorageAccessApiStatus storage_access_api_status, const ::net::IsolationInfo& isolation_info, ::blink::Vector<::network::mojom::blink::HttpHeaderPtr> additional_headers, int32_t process_id, const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, ::network::mojom::blink::ClientSecurityStatePtr client_security_state, uint32_t options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::blink::WebSocketHandshakeClient> handshake_client, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderNetworkServiceObserver> url_loader_network_observer, ::mojo::PendingRemote<::network::mojom::blink::WebSocketAuthenticationHandler> auth_handler, ::mojo::PendingRemote<TrustedHeaderClient> header_client, const std::optional<::base::UnguessableToken>& throttling_profile_id) override;
  void CreateWebTransport(const ::blink::KURL& url, const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::blink::Vector<::network::mojom::blink::WebTransportCertificateFingerprintPtr> fingerprints, const ::blink::Vector<::blink::String>& application_protocols, ::mojo::PendingRemote<::network::mojom::blink::WebTransportHandshakeClient> handshake_client, ::mojo::PendingRemote<::network::mojom::blink::URLLoaderNetworkServiceObserver> url_loader_network_observer, ::network::mojom::blink::ClientSecurityStatePtr client_security_state) override;
  void CreateNetLogExporter(::mojo::PendingReceiver<::network::mojom::blink::NetLogExporter> receiver) override;
  void PreconnectSockets(uint32_t num_streams, const ::blink::KURL& url, ::network::mojom::blink::CredentialsMode credentials_mode, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::network::mojom::blink::ConnectionKeepAliveConfigPtr keepalive_config, ::mojo::PendingRemote<::network::mojom::blink::ConnectionChangeObserverClient> observer_client) override;
  void CreateP2PSocketManager(::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::mojo::PendingRemote<::network::mojom::blink::P2PTrustedSocketManagerClient> client, ::mojo::PendingReceiver<::network::mojom::blink::P2PTrustedSocketManager> trusted_socket_manager, ::mojo::PendingReceiver<::network::mojom::blink::P2PSocketManager> socket_manager) override;
  void CreateMdnsResponder(::mojo::PendingReceiver<::network::mojom::blink::MdnsResponder> responder_receiver) override;
  void ResolveHost(::network::mojom::blink::HostResolverHostPtr host, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::network::mojom::blink::ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<::network::mojom::blink::ResolveHostClient> response_client) override;
  void CreateHostResolver(::network::mojom::blink::DnsConfigOverridesPtr config_overrides, ::mojo::PendingReceiver<::network::mojom::blink::HostResolver> host_resolver) override;
  void VerifyCert(::network::mojom::blink::X509CertificatePtr certificate, const ::net::HostPortPair& host_port, const ::blink::String& ocsp_response, const ::blink::String& sct_list, VerifyCertCallback callback) override;
  void VerifyCertForSignedExchange(::network::mojom::blink::X509CertificatePtr certificate, const ::net::HostPortPair& host_port, const ::blink::String& ocsp_response, const ::blink::String& sct_list, VerifyCertForSignedExchangeCallback callback) override;
  void Verify2QwacCertBinding(const ::blink::String& binding, const ::blink::String& hostname, ::network::mojom::blink::X509CertificatePtr tls_certificate, Verify2QwacCertBindingCallback callback) override;
  void AddHSTS(const ::blink::String& host, ::base::Time expiry, bool include_subdomains, AddHSTSCallback callback) override;
  void IsHSTSActiveForHost(const ::blink::String& host, bool is_top_level_nav, IsHSTSActiveForHostCallback callback) override;
  void GetHSTSState(const ::blink::String& domain, GetHSTSStateCallback callback) override;
  void SetCorsOriginAccessListsForOrigin(const ::scoped_refptr<const ::blink::SecurityOrigin>& source_origin, ::blink::Vector<::network::mojom::blink::CorsOriginPatternPtr> allow_patterns, ::blink::Vector<::network::mojom::blink::CorsOriginPatternPtr> block_patterns, SetCorsOriginAccessListsForOriginCallback callback) override;
  void DeleteDynamicDataForHost(const ::blink::String& host, DeleteDynamicDataForHostCallback callback) override;
  void SetSplitAuthCacheByNetworkAnonymizationKey(bool split_auth_cache_by_network_anonymization_key) override;
  void SaveHttpAuthCacheProxyEntries(SaveHttpAuthCacheProxyEntriesCallback callback) override;
  void LoadHttpAuthCacheProxyEntries(const ::base::UnguessableToken& cache_key, LoadHttpAuthCacheProxyEntriesCallback callback) override;
  void AddAuthCacheEntry(const ::net::AuthChallengeInfo& challenge, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::network::mojom::blink::AuthCredentialsPtr credentials, AddAuthCacheEntryCallback callback) override;
  void SetCorsNonWildcardRequestHeadersSupport(bool value) override;
  void EnableStaticKeyPinningForTesting(EnableStaticKeyPinningForTestingCallback callback) override;
  void VerifyCertificateForTesting(::network::mojom::blink::X509CertificatePtr certificate, const ::blink::String& hostname, const ::blink::String& ocsp_response, const ::blink::String& sct_list, VerifyCertificateForTestingCallback callback) override;
  void GetTrustAnchorIDsForTesting(GetTrustAnchorIDsForTestingCallback callback) override;
  void AddDomainReliabilityContextForTesting(const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, const ::blink::KURL& upload_url, AddDomainReliabilityContextForTestingCallback callback) override;
  void ForceDomainReliabilityUploadsForTesting(ForceDomainReliabilityUploadsForTestingCallback callback) override;
  void SetSCTAuditingMode(SCTAuditingMode mode) override;
  void AddReportingApiObserver(::mojo::PendingRemote<::network::mojom::blink::ReportingApiObserver> observer) override;
  void GetSharedDictionaryUsageInfo(GetSharedDictionaryUsageInfoCallback callback) override;
  void GetSharedDictionaryInfo(::network::mojom::blink::SharedDictionaryIsolationKeyPtr isolation_key, GetSharedDictionaryInfoCallback callback) override;
  void GetSharedDictionaryOriginsBetween(::base::Time start_time, ::base::Time end_time, GetSharedDictionaryOriginsBetweenCallback callback) override;
  void SetSharedDictionaryCacheMaxSize(uint64_t cache_max_size) override;
  void PreloadSharedDictionaryInfoForDocument(const ::blink::Vector<::blink::KURL>& urls, ::mojo::PendingReceiver<PreloadedSharedDictionaryInfoHandle> preload_handle) override;
  void HasPreloadedSharedDictionaryInfoForTesting(HasPreloadedSharedDictionaryInfoForTestingCallback callback) override;
  void FlushCachedClientCertIfNeeded(const ::net::HostPortPair& host, ::network::mojom::blink::X509CertificatePtr certificate) override;
  void FlushMatchingCachedClientCert(::network::mojom::blink::X509CertificatePtr certificate) override;
  void SetCookieDeprecationLabel(const ::blink::String& label) override;
  void RevokeNetworkForNonces(const ::blink::Vector<::base::UnguessableToken>& nonces, RevokeNetworkForNoncesCallback callback) override;
  void ClearNonces(const ::blink::Vector<::base::UnguessableToken>& nonces) override;
  void ExemptUrlFromNetworkRevocationForNonce(const ::blink::KURL& exempted_url, const ::base::UnguessableToken& nonce, ExemptUrlFromNetworkRevocationForNonceCallback callback) override;
  void Prefetch(int32_t request_id, uint32_t options, const ::network::ResourceRequest& request, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation) override;
  void GetBoundNetworkForTesting(GetBoundNetworkForTestingCallback callback) override;
  void GetDeviceBoundSessionManager(::mojo::PendingReceiver<::network::mojom::blink::DeviceBoundSessionManager> device_bound_session_manager) override;
  void AddQuicHints(const ::blink::Vector<::url::SchemeHostPort>& origins, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key) override;
};
class BLINK_PLATFORM_EXPORT NetworkContextAsyncWaiter {
 public:
  explicit NetworkContextAsyncWaiter(NetworkContext* proxy);

  NetworkContextAsyncWaiter(const NetworkContextAsyncWaiter&) = delete;
  NetworkContextAsyncWaiter& operator=(const NetworkContextAsyncWaiter&) = delete;

  ~NetworkContextAsyncWaiter();
  void ClearTrustTokenData(
      ::network::mojom::blink::ClearDataFilterPtr filter);
  
  void ClearTrustTokenSessionOnlyData(
      bool* out_any_data_deleted);
  bool ClearTrustTokenSessionOnlyData();
  void GetStoredTrustTokenCounts(
      ::blink::Vector<::network::mojom::blink::StoredTrustTokensForIssuerPtr>* out_tokens);
  ::blink::Vector<::network::mojom::blink::StoredTrustTokensForIssuerPtr> GetStoredTrustTokenCounts();
  void GetPrivateStateTokenRedemptionRecords(
      ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::Vector<::network::mojom::blink::ToplevelRedemptionRecordPtr>>* out_issuer_redemption_record_map);
  ::blink::HashMap<::scoped_refptr<const ::blink::SecurityOrigin>, ::blink::Vector<::network::mojom::blink::ToplevelRedemptionRecordPtr>> GetPrivateStateTokenRedemptionRecords();
  void GetIpProxyStatus(
      ::ip_protection::mojom::blink::IpProxyStatus* out_status);
  ::ip_protection::mojom::blink::IpProxyStatus GetIpProxyStatus();
  void DeleteStoredTrustTokens(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& issuer, ::network::mojom::blink::DeleteStoredTrustTokensStatus* out_status);
  ::network::mojom::blink::DeleteStoredTrustTokensStatus DeleteStoredTrustTokens(const ::scoped_refptr<const ::blink::SecurityOrigin>& issuer);
  void ClearNetworkingHistoryBetween(
      ::base::Time start_time, ::base::Time end_time);
  
  void ClearHttpCache(
      ::base::Time start_time, ::base::Time end_time, ::network::mojom::blink::ClearDataFilterPtr filter);
  
  void ComputeHttpCacheSize(
      ::base::Time start_time, ::base::Time end_time, bool* out_is_upper_bound, int64_t* out_size_or_error);
  
  void ClearHostCache(
      ::network::mojom::blink::ClearDataFilterPtr filter);
  
  void ClearHttpAuthCache(
      ::base::Time start_time, ::base::Time end_time, ::network::mojom::blink::ClearDataFilterPtr filter);
  
  void ClearCorsPreflightCache(
      ::network::mojom::blink::ClearDataFilterPtr filter);
  
  void ClearReportingCacheReports(
      ::network::mojom::blink::ClearDataFilterPtr filter);
  
  void ClearReportingCacheClients(
      ::network::mojom::blink::ClearDataFilterPtr filter);
  
  void ClearNetworkErrorLogging(
      ::network::mojom::blink::ClearDataFilterPtr filter);
  
  void ClearDomainReliability(
      ::network::mojom::blink::ClearDataFilterPtr filter, NetworkContext::DomainReliabilityClearMode mode);
  
  void ClearSharedDictionaryCache(
      ::base::Time start_time, ::base::Time end_time, ::network::mojom::blink::ClearDataFilterPtr filter);
  
  void ClearSharedDictionaryCacheForIsolationKey(
      ::network::mojom::blink::SharedDictionaryIsolationKeyPtr isolation_key);
  
  void CloseAllConnections(
      );
  
  void CloseIdleConnections(
      );
  
  void CreateRestrictedUDPSocket(
      const ::net::IPEndPoint& addr, ::network::mojom::blink::RestrictedUDPSocketMode mode, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::network::mojom::blink::RestrictedUDPSocketParamsPtr params, ::mojo::PendingReceiver<::network::mojom::blink::RestrictedUDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::blink::UDPSocketListener> listener, bool allow_multicast, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr_out);
  
  void CreateTCPServerSocket(
      const ::net::IPEndPoint& local_addr, ::network::mojom::blink::TCPServerSocketOptionsPtr options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::blink::TCPServerSocket> socket, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr_out);
  
  void CreateTCPConnectedSocket(
      const std::optional<::net::IPEndPoint>& local_addr, ::network::mojom::blink::AddressListPtr remote_addr_list, ::network::mojom::blink::TCPConnectedSocketOptionsPtr tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::blink::TCPConnectedSocket> socket, ::mojo::PendingRemote<::network::mojom::blink::SocketObserver> observer, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr, std::optional<::net::IPEndPoint>* out_peer_addr, ::mojo::ScopedDataPipeConsumerHandle* out_receive_stream, ::mojo::ScopedDataPipeProducerHandle* out_send_stream);
  
  void CreateTCPBoundSocket(
      const ::net::IPEndPoint& local_addr, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::blink::TCPBoundSocket> socket, int32_t* out_result, std::optional<::net::IPEndPoint>* out_local_addr);
  
  void ForceReloadProxyConfig(
      );
  
  void ClearBadProxiesCache(
      );
  
  void VerifyCert(
      ::network::mojom::blink::X509CertificatePtr certificate, const ::net::HostPortPair& host_port, const ::blink::String& ocsp_response, const ::blink::String& sct_list, int32_t* out_error_code, ::network::mojom::blink::CertVerifyResultPtr* out_cv_result, bool* out_pkp_bypassed);
  
  void VerifyCertForSignedExchange(
      ::network::mojom::blink::X509CertificatePtr certificate, const ::net::HostPortPair& host_port, const ::blink::String& ocsp_response, const ::blink::String& sct_list, int32_t* out_error_code, ::network::mojom::blink::CertVerifyResultPtr* out_cv_result, bool* out_pkp_bypassed);
  
  void Verify2QwacCertBinding(
      const ::blink::String& binding, const ::blink::String& hostname, ::network::mojom::blink::X509CertificatePtr tls_certificate, ::network::mojom::blink::X509CertificatePtr* out_verified_cert);
  ::network::mojom::blink::X509CertificatePtr Verify2QwacCertBinding(const ::blink::String& binding, const ::blink::String& hostname, ::network::mojom::blink::X509CertificatePtr tls_certificate);
  void AddHSTS(
      const ::blink::String& host, ::base::Time expiry, bool include_subdomains);
  
  void IsHSTSActiveForHost(
      const ::blink::String& host, bool is_top_level_nav, bool* out_result);
  bool IsHSTSActiveForHost(const ::blink::String& host, bool is_top_level_nav);
  void GetHSTSState(
      const ::blink::String& domain, ::base::Value::Dict* out_state);
  ::base::Value::Dict GetHSTSState(const ::blink::String& domain);
  void SetCorsOriginAccessListsForOrigin(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& source_origin, ::blink::Vector<::network::mojom::blink::CorsOriginPatternPtr> allow_patterns, ::blink::Vector<::network::mojom::blink::CorsOriginPatternPtr> block_patterns);
  
  void DeleteDynamicDataForHost(
      const ::blink::String& host, bool* out_result);
  bool DeleteDynamicDataForHost(const ::blink::String& host);
  void SaveHttpAuthCacheProxyEntries(
      ::base::UnguessableToken* out_cache_key);
  ::base::UnguessableToken SaveHttpAuthCacheProxyEntries();
  void LoadHttpAuthCacheProxyEntries(
      const ::base::UnguessableToken& cache_key);
  
  void AddAuthCacheEntry(
      const ::net::AuthChallengeInfo& challenge, ::network::mojom::blink::NetworkAnonymizationKeyPtr network_anonymization_key, ::network::mojom::blink::AuthCredentialsPtr credentials);
  
  void EnableStaticKeyPinningForTesting(
      );
  
  void VerifyCertificateForTesting(
      ::network::mojom::blink::X509CertificatePtr certificate, const ::blink::String& hostname, const ::blink::String& ocsp_response, const ::blink::String& sct_list, int32_t* out_error_code);
  int32_t VerifyCertificateForTesting(::network::mojom::blink::X509CertificatePtr certificate, const ::blink::String& hostname, const ::blink::String& ocsp_response, const ::blink::String& sct_list);
  void GetTrustAnchorIDsForTesting(
      ::blink::Vector<::blink::Vector<uint8_t>>* out_trust_anchor_ids);
  ::blink::Vector<::blink::Vector<uint8_t>> GetTrustAnchorIDsForTesting();
  void AddDomainReliabilityContextForTesting(
      const ::scoped_refptr<const ::blink::SecurityOrigin>& origin, const ::blink::KURL& upload_url);
  
  void ForceDomainReliabilityUploadsForTesting(
      );
  
  void GetSharedDictionaryUsageInfo(
      ::blink::Vector<::network::mojom::blink::SharedDictionaryUsageInfoPtr>* out_usage_info);
  ::blink::Vector<::network::mojom::blink::SharedDictionaryUsageInfoPtr> GetSharedDictionaryUsageInfo();
  void GetSharedDictionaryInfo(
      ::network::mojom::blink::SharedDictionaryIsolationKeyPtr isolation_key, ::blink::Vector<SharedDictionaryInfoPtr>* out_dictionaries);
  ::blink::Vector<SharedDictionaryInfoPtr> GetSharedDictionaryInfo(::network::mojom::blink::SharedDictionaryIsolationKeyPtr isolation_key);
  void GetSharedDictionaryOriginsBetween(
      ::base::Time start_time, ::base::Time end_time, ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>>* out_origins);
  ::blink::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> GetSharedDictionaryOriginsBetween(::base::Time start_time, ::base::Time end_time);
  void HasPreloadedSharedDictionaryInfoForTesting(
      bool* out_value);
  bool HasPreloadedSharedDictionaryInfoForTesting();
  void RevokeNetworkForNonces(
      const ::blink::Vector<::base::UnguessableToken>& nonces);
  
  void ExemptUrlFromNetworkRevocationForNonce(
      const ::blink::KURL& exempted_url, const ::base::UnguessableToken& nonce);
  
  void GetBoundNetworkForTesting(
      int64_t* out_bound_network);
  int64_t GetBoundNetworkForTesting();

 private:
  NetworkContext* const proxy_;
};




}  // network::mojom::blink

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_BLINK_TEST_UTILS_H_