// services/network/public/mojom/mdns_responder.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_MDNS_RESPONDER_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_MDNS_RESPONDER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/mdns_responder.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/mdns_responder.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/mdns_responder.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_address.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace network::mojom {

class MdnsResponderProxy;

template <typename ImplRefTraits>
class MdnsResponderStub;

class MdnsResponderRequestValidator;
class MdnsResponderResponseValidator;


class MdnsResponder
    : public MdnsResponderInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "network.mojom.MdnsResponder";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = MdnsResponderInterfaceBase;
  using Proxy_ = MdnsResponderProxy;

  template <typename ImplRefTraits>
  using Stub_ = MdnsResponderStub<ImplRefTraits>;

  using RequestValidator_ = MdnsResponderRequestValidator;
  using ResponseValidator_ = MdnsResponderResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCreateNameForAddressMinVersion = 0,
    kRemoveNameForAddressMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct CreateNameForAddress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct RemoveNameForAddress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~MdnsResponder() = default;

  using CreateNameForAddressCallback = base::OnceCallback<void(const std::string&, bool)>;
  using CreateNameForAddressMojoCallback = base::OnceCallback<void(const std::string&, bool)>;

  virtual void CreateNameForAddress(const ::net::IPAddress& address, CreateNameForAddressCallback callback) = 0;

  using RemoveNameForAddressCallback = base::OnceCallback<void(bool, bool)>;
  using RemoveNameForAddressMojoCallback = base::OnceCallback<void(bool, bool)>;

  virtual void RemoveNameForAddress(const ::net::IPAddress& address, RemoveNameForAddressCallback callback) = 0;
};



class  MdnsResponderProxy
    : public MdnsResponder {
 public:
  using InterfaceType = MdnsResponder;

  explicit MdnsResponderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void CreateNameForAddress(const ::net::IPAddress& address, CreateNameForAddressCallback callback) final;
  
  void RemoveNameForAddress(const ::net::IPAddress& address, RemoveNameForAddressCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  MdnsResponderStubDispatch {
 public:
  static bool Accept(MdnsResponder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      MdnsResponder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<MdnsResponder>>
class MdnsResponderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  MdnsResponderStub() = default;
  ~MdnsResponderStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MdnsResponderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return MdnsResponderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  MdnsResponderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  MdnsResponderResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // network::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_MDNS_RESPONDER_MOJOM_H_