// services/network/public/mojom/load_timing_internal_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INTERNAL_INFO_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INTERNAL_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/load_timing_internal_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"




#include "services/network/public/mojom/load_timing_internal_info.mojom-data-view.h"




namespace std {

template <>
struct hash<::network::mojom::SessionSource>
    : public mojo::internal::EnumHashImpl<::network::mojom::SessionSource> {};

template <>
struct hash<::network::mojom::AdvertisedAltSvcState>
    : public mojo::internal::EnumHashImpl<::network::mojom::AdvertisedAltSvcState> {};

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::SessionSource, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::SessionSource, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::SessionSource>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::AdvertisedAltSvcState, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::AdvertisedAltSvcState, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(::mojo::internal::ToKnownEnumValueHelper(
        static_cast<::network::mojom::AdvertisedAltSvcState>(input)), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::LoadTimingInternalInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::LoadTimingInternalInfoDataView, UserType>;

  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::LoadTimingInternalInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

    decltype(Traits::create_stream_delay(input)) in_create_stream_delay = Traits::create_stream_delay(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->create_stream_delay)::BaseType> create_stream_delay_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_create_stream_delay,
      create_stream_delay_fragment);

    fragment->create_stream_delay.Set(
        create_stream_delay_fragment.is_null() ? nullptr : create_stream_delay_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->create_stream_delay.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null create_stream_delay in LoadTimingInternalInfo struct");

    decltype(Traits::connected_callback_delay(input)) in_connected_callback_delay = Traits::connected_callback_delay(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->connected_callback_delay)::BaseType> connected_callback_delay_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_connected_callback_delay,
      connected_callback_delay_fragment);

    fragment->connected_callback_delay.Set(
        connected_callback_delay_fragment.is_null() ? nullptr : connected_callback_delay_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->connected_callback_delay.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null connected_callback_delay in LoadTimingInternalInfo struct");

    decltype(Traits::initialize_stream_delay(input)) in_initialize_stream_delay = Traits::initialize_stream_delay(input);
    mojo::internal::MessageFragment<
        typename decltype(fragment->initialize_stream_delay)::BaseType> initialize_stream_delay_fragment(
            fragment.message());
    
    mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_initialize_stream_delay,
      initialize_stream_delay_fragment);

    fragment->initialize_stream_delay.Set(
        initialize_stream_delay_fragment.is_null() ? nullptr : initialize_stream_delay_fragment.data());

    
    MOJO_INTERNAL_CHECK_SERIALIZATION(
      mojo::internal::SendValidation::kDefault,
      !(fragment->initialize_stream_delay.is_null()),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null initialize_stream_delay in LoadTimingInternalInfo struct");
    fragment->session_source_$flag = Traits::session_source(input).has_value();
    if (Traits::session_source(input).has_value()) {
      
      mojo::internal::Serialize<::network::mojom::SessionSource>(
        Traits::session_source(input).value(),
        &fragment->session_source_$value);
    } else {
      fragment->session_source_$value =
          static_cast<int32_t>(::network::mojom::SessionSource::kMinValue);
    }

    
    mojo::internal::Serialize<::network::mojom::AdvertisedAltSvcState>(
      Traits::advertised_alt_svc_state(input),
      &fragment->advertised_alt_svc_state);

    fragment->http_network_session_quic_enabled = Traits::http_network_session_quic_enabled(input);
  }

  static bool Deserialize(::network::mojom::internal::LoadTimingInternalInfo_Data* input,
                          UserType* output,
                          Message* message) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::LoadTimingInternalInfoDataView data_view(input, message);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network::mojom {

inline void LoadTimingInternalInfoDataView::GetCreateStreamDelayDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->create_stream_delay.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void LoadTimingInternalInfoDataView::GetConnectedCallbackDelayDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->connected_callback_delay.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}
inline void LoadTimingInternalInfoDataView::GetInitializeStreamDelayDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->initialize_stream_delay.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // network::mojom

// Declare TraceFormatTraits for enums, which should be defined in ::perfetto
// namespace.

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::SessionSource> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::SessionSource value);
};

} // namespace perfetto

namespace perfetto {

template <>
struct  TraceFormatTraits<::network::mojom::AdvertisedAltSvcState> {
 static void WriteIntoTrace(perfetto::TracedValue context, ::network::mojom::AdvertisedAltSvcState value);
};

} // namespace perfetto

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_LOAD_TIMING_INTERNAL_INFO_MOJOM_SHARED_H_