// services/network/public/mojom/load_timing_info.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/load_timing_info.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }



  function LoadTimingInfoConnectTiming(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LoadTimingInfoConnectTiming.prototype.initDefaults_ = function() {
    this.domainLookupStart = null;
    this.domainLookupEnd = null;
    this.connectStart = null;
    this.connectEnd = null;
    this.sslStart = null;
    this.sslEnd = null;
  };
  LoadTimingInfoConnectTiming.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LoadTimingInfoConnectTiming.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfoConnectTiming.domainLookupStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfoConnectTiming.domainLookupEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfoConnectTiming.connectStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfoConnectTiming.connectEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfoConnectTiming.sslStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfoConnectTiming.sslEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LoadTimingInfoConnectTiming.encodedSize = codec.kStructHeaderSize + 48;

  LoadTimingInfoConnectTiming.decode = function(decoder) {
    var packed;
    var val = new LoadTimingInfoConnectTiming();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.domainLookupStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.domainLookupEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.connectStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.connectEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.sslStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.sslEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  LoadTimingInfoConnectTiming.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LoadTimingInfoConnectTiming.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(time$.TimeTicks, val.domainLookupStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.domainLookupEnd);
    encoder.encodeStructPointer(time$.TimeTicks, val.connectStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.connectEnd);
    encoder.encodeStructPointer(time$.TimeTicks, val.sslStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.sslEnd);
  };
  function LoadTimingInfo(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  LoadTimingInfo.prototype.initDefaults_ = function() {
    this.socketReused = false;
    this.socketLogId = 0;
    this.requestStartTime = null;
    this.requestStart = null;
    this.proxyResolveStart = null;
    this.proxyResolveEnd = null;
    this.connectTiming = null;
    this.sendStart = null;
    this.sendEnd = null;
    this.receiveHeadersStart = null;
    this.receiveHeadersEnd = null;
    this.receiveNonInformationalHeadersStart = null;
    this.firstEarlyHintsTime = null;
    this.pushStart = null;
    this.pushEnd = null;
    this.serviceWorkerStartTime = null;
    this.serviceWorkerReadyTime = null;
    this.serviceWorkerFetchStart = null;
    this.serviceWorkerRespondWithSettled = null;
    this.serviceWorkerRouterEvaluationStart = null;
    this.serviceWorkerCacheLookupStart = null;
  };
  LoadTimingInfo.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  LoadTimingInfo.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 168}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;




    // validate LoadTimingInfo.requestStartTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.requestStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.proxyResolveStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.proxyResolveEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.connectTiming
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 40, LoadTimingInfoConnectTiming, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.sendStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 48, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.sendEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 56, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.receiveHeadersStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 64, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.receiveHeadersEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 72, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.receiveNonInformationalHeadersStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 80, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.firstEarlyHintsTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 88, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.pushStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 96, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.pushEnd
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 104, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.serviceWorkerStartTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 112, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.serviceWorkerReadyTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 120, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.serviceWorkerFetchStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 128, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.serviceWorkerRespondWithSettled
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 136, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.serviceWorkerRouterEvaluationStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 144, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate LoadTimingInfo.serviceWorkerCacheLookupStart
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 152, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  LoadTimingInfo.encodedSize = codec.kStructHeaderSize + 160;

  LoadTimingInfo.decode = function(decoder) {
    var packed;
    var val = new LoadTimingInfo();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.socketReused = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.socketLogId =
        decoder.decodeStruct(codec.Uint32);
    val.requestStartTime =
        decoder.decodeStructPointer(time$.Time);
    val.requestStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.proxyResolveStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.proxyResolveEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.connectTiming =
        decoder.decodeStructPointer(LoadTimingInfoConnectTiming);
    val.sendStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.sendEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.receiveHeadersStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.receiveHeadersEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.receiveNonInformationalHeadersStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.firstEarlyHintsTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.pushStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.pushEnd =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.serviceWorkerStartTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.serviceWorkerReadyTime =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.serviceWorkerFetchStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.serviceWorkerRespondWithSettled =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.serviceWorkerRouterEvaluationStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    val.serviceWorkerCacheLookupStart =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  LoadTimingInfo.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(LoadTimingInfo.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.socketReused & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.Uint32, val.socketLogId);
    encoder.encodeStructPointer(time$.Time, val.requestStartTime);
    encoder.encodeStructPointer(time$.TimeTicks, val.requestStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.proxyResolveStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.proxyResolveEnd);
    encoder.encodeStructPointer(LoadTimingInfoConnectTiming, val.connectTiming);
    encoder.encodeStructPointer(time$.TimeTicks, val.sendStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.sendEnd);
    encoder.encodeStructPointer(time$.TimeTicks, val.receiveHeadersStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.receiveHeadersEnd);
    encoder.encodeStructPointer(time$.TimeTicks, val.receiveNonInformationalHeadersStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.firstEarlyHintsTime);
    encoder.encodeStructPointer(time$.TimeTicks, val.pushStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.pushEnd);
    encoder.encodeStructPointer(time$.TimeTicks, val.serviceWorkerStartTime);
    encoder.encodeStructPointer(time$.TimeTicks, val.serviceWorkerReadyTime);
    encoder.encodeStructPointer(time$.TimeTicks, val.serviceWorkerFetchStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.serviceWorkerRespondWithSettled);
    encoder.encodeStructPointer(time$.TimeTicks, val.serviceWorkerRouterEvaluationStart);
    encoder.encodeStructPointer(time$.TimeTicks, val.serviceWorkerCacheLookupStart);
  };
  exports.LoadTimingInfoConnectTiming = LoadTimingInfoConnectTiming;
  exports.LoadTimingInfo = LoadTimingInfo;
})();