// services/network/public/mojom/isolation_info.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/isolation_info.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared.h"
#include "services/network/public/mojom/network_isolation_partition.mojom-shared.h"
#include "services/network/public/mojom/site_for_cookies.mojom-shared.h"
#include "services/network/public/mojom/schemeful_site.mojom-shared.h"
#include "url/mojom/origin.mojom-shared.h"

#include "services/network/public/mojom/isolation_info.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::IsolationInfoRequestType, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::IsolationInfoFrameAncestorRelation, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::IsolationInfoDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::IsolationInfoDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::IsolationInfo_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      
      mojo::internal::Serialize<::network::mojom::IsolationInfoRequestType>(
        Traits::request_type(input),
        &fragment->request_type);

      decltype(Traits::top_frame_origin(input)) in_top_frame_origin = Traits::top_frame_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->top_frame_origin)::BaseType> top_frame_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_top_frame_origin,
        top_frame_origin_fragment);

      fragment->top_frame_origin.Set(
          top_frame_origin_fragment.is_null() ? nullptr : top_frame_origin_fragment.data());

      decltype(Traits::frame_origin(input)) in_frame_origin = Traits::frame_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->frame_origin)::BaseType> frame_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_frame_origin,
        frame_origin_fragment);

      fragment->frame_origin.Set(
          frame_origin_fragment.is_null() ? nullptr : frame_origin_fragment.data());

      decltype(Traits::nonce(input)) in_nonce = Traits::nonce(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->nonce)::BaseType> nonce_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView, send_validation>(
        in_nonce,
        nonce_fragment);

      fragment->nonce.Set(
          nonce_fragment.is_null() ? nullptr : nonce_fragment.data());

      decltype(Traits::site_for_cookies(input)) in_site_for_cookies = Traits::site_for_cookies(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->site_for_cookies)::BaseType> site_for_cookies_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView, send_validation>(
        in_site_for_cookies,
        site_for_cookies_fragment);

      fragment->site_for_cookies.Set(
          site_for_cookies_fragment.is_null() ? nullptr : site_for_cookies_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->site_for_cookies.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null site_for_cookies in IsolationInfo struct");

      
      mojo::internal::Serialize<::network::mojom::NetworkIsolationPartition>(
        Traits::network_isolation_partition(input),
        &fragment->network_isolation_partition);
      fragment->frame_ancestor_relation_$flag = Traits::frame_ancestor_relation(input).has_value();
      if (Traits::frame_ancestor_relation(input).has_value()) {
        
        mojo::internal::Serialize<::network::mojom::IsolationInfoFrameAncestorRelation>(
          Traits::frame_ancestor_relation(input).value(),
          &fragment->frame_ancestor_relation_$value);
      } else {
        fragment->frame_ancestor_relation_$value =
            static_cast<int32_t>(::network::mojom::IsolationInfoFrameAncestorRelation::kMinValue);
      }
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_SEND_VALIDATION_H_