// services/network/public/mojom/ip_endpoint.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_IP_ENDPOINT_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_IP_ENDPOINT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/ip_endpoint.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_endpoint.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_endpoint.mojom-forward.h"  // IWYU pragma: export
#include "services/network/public/mojom/ip_address.mojom.h"
#include <string>
#include <vector>




#include "services/network/public/cpp/ip_endpoint_mojom_traits.h"




namespace network::mojom {








class  IPEndPoint {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IPEndPoint, T>::value>;
  using DataView = IPEndPointDataView;
  using Data_ = internal::IPEndPoint_Data;

  template <typename... Args>
  static IPEndPointPtr New(Args&&... args) {
    return IPEndPointPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IPEndPointPtr From(const U& u) {
    return mojo::TypeConverter<IPEndPointPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IPEndPoint>::Convert(*this);
  }


  IPEndPoint();

  IPEndPoint(
      const ::net::IPAddress& address,
      uint16_t port);


  ~IPEndPoint();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IPEndPointPtr>
  IPEndPointPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IPEndPoint::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, IPEndPoint::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, IPEndPoint::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IPEndPoint::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IPEndPoint::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IPEndPoint::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IPEndPoint_UnserializedMessageContext<
            UserType, IPEndPoint::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<IPEndPoint::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return IPEndPoint::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IPEndPoint_UnserializedMessageContext<
            UserType, IPEndPoint::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IPEndPoint::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::net::IPAddress address;
  
  uint16_t port;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IPEndPoint::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IPEndPoint::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IPEndPoint::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IPEndPoint::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IPEndPointPtr IPEndPoint::Clone() const {
  return New(
      mojo::Clone(address),
      mojo::Clone(port)
  );
}

template <typename T, IPEndPoint::EnableIfSame<T>*>
bool IPEndPoint::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->address, other_struct.address))
    return false;
  if (!mojo::Equals(this->port, other_struct.port))
    return false;
  return true;
}

template <typename T, IPEndPoint::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.address < rhs.address)
    return true;
  if (rhs.address < lhs.address)
    return false;
  if (lhs.port < rhs.port)
    return true;
  if (rhs.port < lhs.port)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::IPEndPoint::DataView,
                                         ::network::mojom::IPEndPointPtr> {
  static bool IsNull(const ::network::mojom::IPEndPointPtr& input) { return !input; }
  static void SetToNull(::network::mojom::IPEndPointPtr* output) { output->reset(); }

  static const decltype(::network::mojom::IPEndPoint::address)& address(
      const ::network::mojom::IPEndPointPtr& input) {
    return input->address;
  }

  static decltype(::network::mojom::IPEndPoint::port) port(
      const ::network::mojom::IPEndPointPtr& input) {
    return input->port;
  }

  static bool Read(::network::mojom::IPEndPoint::DataView input, ::network::mojom::IPEndPointPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_IP_ENDPOINT_MOJOM_H_