// services/network/public/mojom/http_request_headers.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_REQUEST_HEADERS_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_REQUEST_HEADERS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/http_request_headers.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/http_request_headers.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/http_request_headers.mojom-blink-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/byte_string.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"




#include "services/network/public/cpp/http_request_headers_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"
#if !BLINK_MOJO_IMPL && !INSIDE_BLINK
#error "File must only be imported inside blink"
#endif




namespace network::mojom::blink {









class BLINK_PLATFORM_EXPORT HttpRequestHeaderKeyValuePair {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpRequestHeaderKeyValuePair, T>::value>;
  using DataView = HttpRequestHeaderKeyValuePairDataView;
  using Data_ = internal::HttpRequestHeaderKeyValuePair_Data;

  template <typename... Args>
  static HttpRequestHeaderKeyValuePairPtr New(Args&&... args) {
    return HttpRequestHeaderKeyValuePairPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpRequestHeaderKeyValuePairPtr From(const U& u) {
    return mojo::TypeConverter<HttpRequestHeaderKeyValuePairPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpRequestHeaderKeyValuePair>::Convert(*this);
  }


  HttpRequestHeaderKeyValuePair();

  HttpRequestHeaderKeyValuePair(
      const ::blink::String& key,
      const std::string& value);


  ~HttpRequestHeaderKeyValuePair();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpRequestHeaderKeyValuePairPtr>
  HttpRequestHeaderKeyValuePairPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpRequestHeaderKeyValuePair::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HttpRequestHeaderKeyValuePair::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HttpRequestHeaderKeyValuePair::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpRequestHeaderKeyValuePair::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpRequestHeaderKeyValuePair::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpRequestHeaderKeyValuePair::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpRequestHeaderKeyValuePair_UnserializedMessageContext<
            UserType, HttpRequestHeaderKeyValuePair::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HttpRequestHeaderKeyValuePair::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HttpRequestHeaderKeyValuePair::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpRequestHeaderKeyValuePair_UnserializedMessageContext<
            UserType, HttpRequestHeaderKeyValuePair::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpRequestHeaderKeyValuePair::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::String key;
  
  std::string value;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpRequestHeaderKeyValuePair::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpRequestHeaderKeyValuePair::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpRequestHeaderKeyValuePair::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpRequestHeaderKeyValuePair::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT HttpRequestHeaders {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpRequestHeaders, T>::value>;
  using DataView = HttpRequestHeadersDataView;
  using Data_ = internal::HttpRequestHeaders_Data;

  template <typename... Args>
  static HttpRequestHeadersPtr New(Args&&... args) {
    return HttpRequestHeadersPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpRequestHeadersPtr From(const U& u) {
    return mojo::TypeConverter<HttpRequestHeadersPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpRequestHeaders>::Convert(*this);
  }


  HttpRequestHeaders();

  explicit HttpRequestHeaders(
      ::blink::Vector<HttpRequestHeaderKeyValuePairPtr> headers);

HttpRequestHeaders(const HttpRequestHeaders&) = delete;
HttpRequestHeaders& operator=(const HttpRequestHeaders&) = delete;

  ~HttpRequestHeaders();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpRequestHeadersPtr>
  HttpRequestHeadersPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpRequestHeaders::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, HttpRequestHeaders::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, HttpRequestHeaders::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpRequestHeaders::DataView, ::blink::Vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static ::blink::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpRequestHeaders::DataView, ::blink::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpRequestHeaders::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpRequestHeaders_UnserializedMessageContext<
            UserType, HttpRequestHeaders::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<HttpRequestHeaders::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return HttpRequestHeaders::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpRequestHeaders_UnserializedMessageContext<
            UserType, HttpRequestHeaders::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpRequestHeaders::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  ::blink::Vector<HttpRequestHeaderKeyValuePairPtr> headers;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpRequestHeaders::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpRequestHeaders::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpRequestHeaders::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpRequestHeaders::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
HttpRequestHeaderKeyValuePairPtr HttpRequestHeaderKeyValuePair::Clone() const {
  return New(
      mojo::Clone(key),
      mojo::Clone(value)
  );
}

template <typename T, HttpRequestHeaderKeyValuePair::EnableIfSame<T>*>
bool HttpRequestHeaderKeyValuePair::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->key, other_struct.key))
    return false;
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  return true;
}

template <typename T, HttpRequestHeaderKeyValuePair::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.key < rhs.key)
    return true;
  if (rhs.key < lhs.key)
    return false;
  if (lhs.value < rhs.value)
    return true;
  if (rhs.value < lhs.value)
    return false;
  return false;
}
template <typename StructPtrType>
HttpRequestHeadersPtr HttpRequestHeaders::Clone() const {
  return New(
      mojo::Clone(headers)
  );
}

template <typename T, HttpRequestHeaders::EnableIfSame<T>*>
bool HttpRequestHeaders::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->headers, other_struct.headers))
    return false;
  return true;
}

template <typename T, HttpRequestHeaders::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.headers < rhs.headers)
    return true;
  if (rhs.headers < lhs.headers)
    return false;
  return false;
}


}  // network::mojom::blink

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::HttpRequestHeaderKeyValuePair::DataView,
                                         ::network::mojom::blink::HttpRequestHeaderKeyValuePairPtr> {
  static bool IsNull(const ::network::mojom::blink::HttpRequestHeaderKeyValuePairPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::HttpRequestHeaderKeyValuePairPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::HttpRequestHeaderKeyValuePair::key)& key(
      const ::network::mojom::blink::HttpRequestHeaderKeyValuePairPtr& input) {
    return input->key;
  }

  static const decltype(::network::mojom::blink::HttpRequestHeaderKeyValuePair::value)& value(
      const ::network::mojom::blink::HttpRequestHeaderKeyValuePairPtr& input) {
    return input->value;
  }

  static bool Read(::network::mojom::blink::HttpRequestHeaderKeyValuePair::DataView input, ::network::mojom::blink::HttpRequestHeaderKeyValuePairPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::HttpRequestHeaders::DataView,
                                         ::network::mojom::blink::HttpRequestHeadersPtr> {
  static bool IsNull(const ::network::mojom::blink::HttpRequestHeadersPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::HttpRequestHeadersPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::HttpRequestHeaders::headers)& headers(
      const ::network::mojom::blink::HttpRequestHeadersPtr& input) {
    return input->headers;
  }

  static bool Read(::network::mojom::blink::HttpRequestHeaders::DataView input, ::network::mojom::blink::HttpRequestHeadersPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_REQUEST_HEADERS_MOJOM_BLINK_H_