// services/network/public/mojom/http_cache_backend_file_operations.mojom-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_TEST_UTILS_H_

#include "services/network/public/mojom/http_cache_backend_file_operations.mojom.h"


namespace network::mojom {


class  FileEnumeratorInterceptorForTesting : public FileEnumerator {
  virtual FileEnumerator* GetForwardingInterface() = 0;
  void GetNext(uint32_t num_entries, GetNextCallback callback) override;
};
class  FileEnumeratorAsyncWaiter {
 public:
  explicit FileEnumeratorAsyncWaiter(FileEnumerator* proxy);

  FileEnumeratorAsyncWaiter(const FileEnumeratorAsyncWaiter&) = delete;
  FileEnumeratorAsyncWaiter& operator=(const FileEnumeratorAsyncWaiter&) = delete;

  ~FileEnumeratorAsyncWaiter();
  void GetNext(
      uint32_t num_entries, std::vector<::disk_cache::BackendFileOperations::FileEnumerationEntry>* out_entries, bool* out_end, bool* out_error);
  

 private:
  FileEnumerator* const proxy_;
};


class  HttpCacheBackendFileOperationsInterceptorForTesting : public HttpCacheBackendFileOperations {
  virtual HttpCacheBackendFileOperations* GetForwardingInterface() = 0;
  void CreateDirectory(const ::base::FilePath& path, CreateDirectoryCallback callback) override;
  void PathExists(const ::base::FilePath& path, PathExistsCallback callback) override;
  void DirectoryExists(const ::base::FilePath& path, DirectoryExistsCallback callback) override;
  void OpenFile(const ::base::FilePath& path, HttpCacheBackendOpenFileFlags flags, OpenFileCallback callback) override;
  void DeleteFile(const ::base::FilePath& path, HttpCacheBackendDeleteFileMode mode, DeleteFileCallback callback) override;
  void RenameFile(const ::base::FilePath& from_path, const ::base::FilePath& to_path, RenameFileCallback callback) override;
  void GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) override;
  void EnumerateFiles(const ::base::FilePath& path, ::mojo::PendingReceiver<FileEnumerator> receiver) override;
  void CleanupDirectory(const ::base::FilePath& path, CleanupDirectoryCallback callback) override;
};
class  HttpCacheBackendFileOperationsAsyncWaiter {
 public:
  explicit HttpCacheBackendFileOperationsAsyncWaiter(HttpCacheBackendFileOperations* proxy);

  HttpCacheBackendFileOperationsAsyncWaiter(const HttpCacheBackendFileOperationsAsyncWaiter&) = delete;
  HttpCacheBackendFileOperationsAsyncWaiter& operator=(const HttpCacheBackendFileOperationsAsyncWaiter&) = delete;

  ~HttpCacheBackendFileOperationsAsyncWaiter();
  void CreateDirectory(
      const ::base::FilePath& path, bool* out_result);
  bool CreateDirectory(const ::base::FilePath& path);
  void PathExists(
      const ::base::FilePath& path, bool* out_result);
  bool PathExists(const ::base::FilePath& path);
  void DirectoryExists(
      const ::base::FilePath& path, bool* out_result);
  bool DirectoryExists(const ::base::FilePath& path);
  void OpenFile(
      const ::base::FilePath& path, HttpCacheBackendOpenFileFlags flags, ::base::File* out_file, ::base::File::Error* out_error);
  
  void DeleteFile(
      const ::base::FilePath& path, HttpCacheBackendDeleteFileMode mode, bool* out_result);
  bool DeleteFile(const ::base::FilePath& path, HttpCacheBackendDeleteFileMode mode);
  void RenameFile(
      const ::base::FilePath& from_path, const ::base::FilePath& to_path, ::base::File::Error* out_error);
  ::base::File::Error RenameFile(const ::base::FilePath& from_path, const ::base::FilePath& to_path);
  void GetFileInfo(
      const ::base::FilePath& path, std::optional<::base::File::Info>* out_info);
  std::optional<::base::File::Info> GetFileInfo(const ::base::FilePath& path);
  void CleanupDirectory(
      const ::base::FilePath& path, bool* out_result);
  bool CleanupDirectory(const ::base::FilePath& path);

 private:
  HttpCacheBackendFileOperations* const proxy_;
};


class  HttpCacheBackendFileOperationsFactoryInterceptorForTesting : public HttpCacheBackendFileOperationsFactory {
  virtual HttpCacheBackendFileOperationsFactory* GetForwardingInterface() = 0;
  void Create(::mojo::PendingReceiver<HttpCacheBackendFileOperations> receiver) override;
};
class  HttpCacheBackendFileOperationsFactoryAsyncWaiter {
 public:
  explicit HttpCacheBackendFileOperationsFactoryAsyncWaiter(HttpCacheBackendFileOperationsFactory* proxy);

  HttpCacheBackendFileOperationsFactoryAsyncWaiter(const HttpCacheBackendFileOperationsFactoryAsyncWaiter&) = delete;
  HttpCacheBackendFileOperationsFactoryAsyncWaiter& operator=(const HttpCacheBackendFileOperationsFactoryAsyncWaiter&) = delete;

  ~HttpCacheBackendFileOperationsFactoryAsyncWaiter();

 private:
  HttpCacheBackendFileOperationsFactory* const proxy_;
};




}  // network::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_HTTP_CACHE_BACKEND_FILE_OPERATIONS_MOJOM_TEST_UTILS_H_