// services/network/public/mojom/host_resolver.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  TimeDelta as mojoBase_mojom_TimeDelta,
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec
} from '../../../../mojo/public/mojom/base/time.mojom.m.js';

import {
  SchemeHostPort as url_mojom_SchemeHostPort,
  SchemeHostPortSpec as url_mojom_SchemeHostPortSpec
} from '../../../../url/mojom/scheme_host_port.mojom.m.js';

import {
  AddressList as network_mojom_AddressList,
  AddressListSpec as network_mojom_AddressListSpec
} from './address_list.mojom.m.js';

import {
  HostResolverEndpointResult as network_mojom_HostResolverEndpointResult,
  HostResolverEndpointResultSpec as network_mojom_HostResolverEndpointResultSpec
} from './host_resolver_endpoint_result.mojom.m.js';

import {
  IPAddress as network_mojom_IPAddress,
  IPAddressSpec as network_mojom_IPAddressSpec
} from './ip_address.mojom.m.js';

import {
  IPEndPoint as network_mojom_IPEndPoint,
  IPEndPointSpec as network_mojom_IPEndPointSpec
} from './ip_endpoint.mojom.m.js';

import {
  NetworkAnonymizationKey as network_mojom_NetworkAnonymizationKey,
  NetworkAnonymizationKeySpec as network_mojom_NetworkAnonymizationKeySpec
} from './network_anonymization_key.mojom.m.js';

import {
  HostPortPair as network_mojom_HostPortPair,
  HostPortPairSpec as network_mojom_HostPortPairSpec,
  ResolveErrorInfo as network_mojom_ResolveErrorInfo,
  ResolveErrorInfoSpec as network_mojom_ResolveErrorInfoSpec
} from './network_param.mojom.m.js';

import {
  RequestPriority as network_mojom_RequestPriority,
  RequestPrioritySpec as network_mojom_RequestPrioritySpec
} from './request_priority.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const OptionalSecureDnsModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const OptionalSecureDnsMode = {
  
  NO_OVERRIDE: 0,
  OFF: 1,
  AUTOMATIC: 2,
  SECURE: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SecureDnsModeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SecureDnsMode = {
  
  OFF: 0,
  AUTOMATIC: 1,
  SECURE: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const SecureDnsPolicySpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const SecureDnsPolicy = {
  
  ALLOW: 0,
  DISABLE: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DnsQueryTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DnsQueryType = {
  
  UNSPECIFIED: 0,
  A: 1,
  AAAA: 2,
  TXT: 3,
  PTR: 4,
  SRV: 5,
  HTTPS: 6,
  MIN_VALUE: 0,
  MAX_VALUE: 6,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ResolveHostHandlePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ResolveHostHandle', scope);
  }
}

/** @interface */
export class ResolveHostHandleInterface {
  
  /**
   * @param { !number } result
   */

  cancel(result) {}
}

/**
 * @implements { ResolveHostHandleInterface }
 */
export class ResolveHostHandleRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ResolveHostHandlePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ResolveHostHandlePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ResolveHostHandlePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } result
   */

  cancel(
      result) {
    this.proxy.sendMessage(
        0,
        ResolveHostHandle_Cancel_ParamsSpec.$,
        null,
        [
          result
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ResolveHostHandle
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ResolveHostHandleReceiver {
  /**
   * @param {!ResolveHostHandleInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ResolveHostHandleRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ResolveHostHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ResolveHostHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ResolveHostHandle_Cancel_ParamsSpec.$,
        null,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ResolveHostHandle {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ResolveHostHandle";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ResolveHostHandleRemote}
   */
  static getRemote() {
    let remote = new ResolveHostHandleRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ResolveHostHandle
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ResolveHostHandleCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ResolveHostHandleRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ResolveHostHandleRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ResolveHostHandle_Cancel_ParamsSpec.$,
        null,
        this.cancel.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class ResolveHostClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.ResolveHostClient', scope);
  }
}

/** @interface */
export class ResolveHostClientInterface {
  
  /**
   * @param { !number } result
   * @param { !network_mojom_ResolveErrorInfo } resolveErrorInfo
   * @param { !network_mojom_AddressList } resolvedAddresses
   * @param { !Array<!network_mojom_HostResolverEndpointResult> } alternativeEndpoints
   */

  onComplete(result, resolveErrorInfo, resolvedAddresses, alternativeEndpoints) {}
  
  /**
   * @param { !Array<!string> } textResults
   */

  onTextResults(textResults) {}
  
  /**
   * @param { !Array<!network_mojom_HostPortPair> } hosts
   */

  onHostnameResults(hosts) {}
}

/**
 * @implements { ResolveHostClientInterface }
 */
export class ResolveHostClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!ResolveHostClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          ResolveHostClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!ResolveHostClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } result
   * @param { !network_mojom_ResolveErrorInfo } resolveErrorInfo
   * @param { !network_mojom_AddressList } resolvedAddresses
   * @param { !Array<!network_mojom_HostResolverEndpointResult> } alternativeEndpoints
   */

  onComplete(
      result,
      resolveErrorInfo,
      resolvedAddresses,
      alternativeEndpoints) {
    this.proxy.sendMessage(
        0,
        ResolveHostClient_OnComplete_ParamsSpec.$,
        null,
        [
          result,
          resolveErrorInfo,
          resolvedAddresses,
          alternativeEndpoints
        ],
        false);
  }

  
  /**
   * @param { !Array<!string> } textResults
   */

  onTextResults(
      textResults) {
    this.proxy.sendMessage(
        1,
        ResolveHostClient_OnTextResults_ParamsSpec.$,
        null,
        [
          textResults
        ],
        false);
  }

  
  /**
   * @param { !Array<!network_mojom_HostPortPair> } hosts
   */

  onHostnameResults(
      hosts) {
    this.proxy.sendMessage(
        2,
        ResolveHostClient_OnHostnameResults_ParamsSpec.$,
        null,
        [
          hosts
        ],
        false);
  }
}

/**
 * An object which receives request messages for the ResolveHostClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class ResolveHostClientReceiver {
  /**
   * @param {!ResolveHostClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!ResolveHostClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        ResolveHostClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ResolveHostClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        ResolveHostClient_OnComplete_ParamsSpec.$,
        null,
        impl.onComplete.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        ResolveHostClient_OnTextResults_ParamsSpec.$,
        null,
        impl.onTextResults.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        ResolveHostClient_OnHostnameResults_ParamsSpec.$,
        null,
        impl.onHostnameResults.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class ResolveHostClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.ResolveHostClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!ResolveHostClientRemote}
   */
  static getRemote() {
    let remote = new ResolveHostClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the ResolveHostClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class ResolveHostClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      ResolveHostClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!ResolveHostClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onComplete =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        ResolveHostClient_OnComplete_ParamsSpec.$,
        null,
        this.onComplete.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTextResults =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        ResolveHostClient_OnTextResults_ParamsSpec.$,
        null,
        this.onTextResults.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHostnameResults =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        ResolveHostClient_OnHostnameResults_ParamsSpec.$,
        null,
        this.onHostnameResults.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class MdnsListenClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.MdnsListenClient', scope);
  }
}

/** @interface */
export class MdnsListenClientInterface {
  
  /**
   * @param { !MdnsListenClient_UpdateType } updateType
   * @param { !DnsQueryType } queryType
   * @param { !network_mojom_IPEndPoint } endpoint
   */

  onAddressResult(updateType, queryType, endpoint) {}
  
  /**
   * @param { !MdnsListenClient_UpdateType } updateType
   * @param { !DnsQueryType } queryType
   * @param { !Array<!string> } textRecords
   */

  onTextResult(updateType, queryType, textRecords) {}
  
  /**
   * @param { !MdnsListenClient_UpdateType } updateType
   * @param { !DnsQueryType } queryType
   * @param { !network_mojom_HostPortPair } host
   */

  onHostnameResult(updateType, queryType, host) {}
  
  /**
   * @param { !MdnsListenClient_UpdateType } updateType
   * @param { !DnsQueryType } queryType
   */

  onUnhandledResult(updateType, queryType) {}
}

/**
 * @implements { MdnsListenClientInterface }
 */
export class MdnsListenClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!MdnsListenClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MdnsListenClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!MdnsListenClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !MdnsListenClient_UpdateType } updateType
   * @param { !DnsQueryType } queryType
   * @param { !network_mojom_IPEndPoint } endpoint
   */

  onAddressResult(
      updateType,
      queryType,
      endpoint) {
    this.proxy.sendMessage(
        0,
        MdnsListenClient_OnAddressResult_ParamsSpec.$,
        null,
        [
          updateType,
          queryType,
          endpoint
        ],
        false);
  }

  
  /**
   * @param { !MdnsListenClient_UpdateType } updateType
   * @param { !DnsQueryType } queryType
   * @param { !Array<!string> } textRecords
   */

  onTextResult(
      updateType,
      queryType,
      textRecords) {
    this.proxy.sendMessage(
        1,
        MdnsListenClient_OnTextResult_ParamsSpec.$,
        null,
        [
          updateType,
          queryType,
          textRecords
        ],
        false);
  }

  
  /**
   * @param { !MdnsListenClient_UpdateType } updateType
   * @param { !DnsQueryType } queryType
   * @param { !network_mojom_HostPortPair } host
   */

  onHostnameResult(
      updateType,
      queryType,
      host) {
    this.proxy.sendMessage(
        2,
        MdnsListenClient_OnHostnameResult_ParamsSpec.$,
        null,
        [
          updateType,
          queryType,
          host
        ],
        false);
  }

  
  /**
   * @param { !MdnsListenClient_UpdateType } updateType
   * @param { !DnsQueryType } queryType
   */

  onUnhandledResult(
      updateType,
      queryType) {
    this.proxy.sendMessage(
        3,
        MdnsListenClient_OnUnhandledResult_ParamsSpec.$,
        null,
        [
          updateType,
          queryType
        ],
        false);
  }
}

/**
 * An object which receives request messages for the MdnsListenClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MdnsListenClientReceiver {
  /**
   * @param {!MdnsListenClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!MdnsListenClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MdnsListenClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MdnsListenClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MdnsListenClient_OnAddressResult_ParamsSpec.$,
        null,
        impl.onAddressResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MdnsListenClient_OnTextResult_ParamsSpec.$,
        null,
        impl.onTextResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MdnsListenClient_OnHostnameResult_ParamsSpec.$,
        null,
        impl.onHostnameResult.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MdnsListenClient_OnUnhandledResult_ParamsSpec.$,
        null,
        impl.onUnhandledResult.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MdnsListenClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.MdnsListenClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!MdnsListenClientRemote}
   */
  static getRemote() {
    let remote = new MdnsListenClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const MdnsListenClient_UpdateTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const MdnsListenClient_UpdateType = {
  
  ADDED: 0,
  CHANGED: 1,
  REMOVED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * An object which receives request messages for the MdnsListenClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MdnsListenClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MdnsListenClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!MdnsListenClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAddressResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MdnsListenClient_OnAddressResult_ParamsSpec.$,
        null,
        this.onAddressResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onTextResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MdnsListenClient_OnTextResult_ParamsSpec.$,
        null,
        this.onTextResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onHostnameResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MdnsListenClient_OnHostnameResult_ParamsSpec.$,
        null,
        this.onHostnameResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onUnhandledResult =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MdnsListenClient_OnUnhandledResult_ParamsSpec.$,
        null,
        this.onUnhandledResult.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HostResolverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.HostResolver', scope);
  }
}

/** @interface */
export class HostResolverInterface {
  
  /**
   * @param { !HostResolverHost } host
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { ?ResolveHostParameters } optionalParameters
   * @param { !ResolveHostClientRemote } responseClient
   */

  resolveHost(host, networkAnonymizationKey, optionalParameters, responseClient) {}
  
  /**
   * @param { !network_mojom_HostPortPair } host
   * @param { !DnsQueryType } queryType
   * @param { !MdnsListenClientRemote } responseClient
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  mdnsListen(host, queryType, responseClient) {}
}

/**
 * @implements { HostResolverInterface }
 */
export class HostResolverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HostResolverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HostResolverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HostResolverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !HostResolverHost } host
   * @param { !network_mojom_NetworkAnonymizationKey } networkAnonymizationKey
   * @param { ?ResolveHostParameters } optionalParameters
   * @param { !ResolveHostClientRemote } responseClient
   */

  resolveHost(
      host,
      networkAnonymizationKey,
      optionalParameters,
      responseClient) {
    this.proxy.sendMessage(
        0,
        HostResolver_ResolveHost_ParamsSpec.$,
        null,
        [
          host,
          networkAnonymizationKey,
          optionalParameters,
          responseClient
        ],
        false);
  }

  
  /**
   * @param { !network_mojom_HostPortPair } host
   * @param { !DnsQueryType } queryType
   * @param { !MdnsListenClientRemote } responseClient
   * @return {!Promise<{
        result: !number,
   *  }>}
   */

  mdnsListen(
      host,
      queryType,
      responseClient) {
    return this.proxy.sendMessage(
        1,
        HostResolver_MdnsListen_ParamsSpec.$,
        HostResolver_MdnsListen_ResponseParamsSpec.$,
        [
          host,
          queryType,
          responseClient
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HostResolver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HostResolverReceiver {
  /**
   * @param {!HostResolverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HostResolverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HostResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HostResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HostResolver_ResolveHost_ParamsSpec.$,
        null,
        impl.resolveHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        HostResolver_MdnsListen_ParamsSpec.$,
        HostResolver_MdnsListen_ResponseParamsSpec.$,
        impl.mdnsListen.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HostResolver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.HostResolver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HostResolverRemote}
   */
  static getRemote() {
    let remote = new HostResolverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HostResolver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HostResolverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HostResolverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HostResolverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resolveHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HostResolver_ResolveHost_ParamsSpec.$,
        null,
        this.resolveHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.mdnsListen =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        HostResolver_MdnsListen_ParamsSpec.$,
        HostResolver_MdnsListen_ResponseParamsSpec.$,
        this.mdnsListen.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DnsConfigChangeManagerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.DnsConfigChangeManagerClient', scope);
  }
}

/** @interface */
export class DnsConfigChangeManagerClientInterface {
  
  /**
   */

  onDnsConfigChanged() {}
}

/**
 * @implements { DnsConfigChangeManagerClientInterface }
 */
export class DnsConfigChangeManagerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DnsConfigChangeManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DnsConfigChangeManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DnsConfigChangeManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onDnsConfigChanged() {
    this.proxy.sendMessage(
        0,
        DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DnsConfigChangeManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DnsConfigChangeManagerClientReceiver {
  /**
   * @param {!DnsConfigChangeManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DnsConfigChangeManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DnsConfigChangeManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DnsConfigChangeManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsSpec.$,
        null,
        impl.onDnsConfigChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DnsConfigChangeManagerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DnsConfigChangeManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DnsConfigChangeManagerClientRemote}
   */
  static getRemote() {
    let remote = new DnsConfigChangeManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DnsConfigChangeManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DnsConfigChangeManagerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DnsConfigChangeManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DnsConfigChangeManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDnsConfigChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsSpec.$,
        null,
        this.onDnsConfigChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class DnsConfigChangeManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.DnsConfigChangeManager', scope);
  }
}

/** @interface */
export class DnsConfigChangeManagerInterface {
  
  /**
   * @param { !DnsConfigChangeManagerClientRemote } client
   */

  requestNotifications(client) {}
}

/**
 * @implements { DnsConfigChangeManagerInterface }
 */
export class DnsConfigChangeManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!DnsConfigChangeManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          DnsConfigChangeManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!DnsConfigChangeManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !DnsConfigChangeManagerClientRemote } client
   */

  requestNotifications(
      client) {
    this.proxy.sendMessage(
        0,
        DnsConfigChangeManager_RequestNotifications_ParamsSpec.$,
        null,
        [
          client
        ],
        false);
  }
}

/**
 * An object which receives request messages for the DnsConfigChangeManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class DnsConfigChangeManagerReceiver {
  /**
   * @param {!DnsConfigChangeManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!DnsConfigChangeManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        DnsConfigChangeManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DnsConfigChangeManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        DnsConfigChangeManager_RequestNotifications_ParamsSpec.$,
        null,
        impl.requestNotifications.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class DnsConfigChangeManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.DnsConfigChangeManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!DnsConfigChangeManagerRemote}
   */
  static getRemote() {
    let remote = new DnsConfigChangeManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the DnsConfigChangeManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class DnsConfigChangeManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      DnsConfigChangeManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!DnsConfigChangeManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestNotifications =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        DnsConfigChangeManager_RequestNotifications_ParamsSpec.$,
        null,
        this.requestNotifications.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DnsOverHttpsServerConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DnsOverHttpsConfigSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DnsConfigOverridesSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResolveHostParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResolveHostHandle_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResolveHostClient_OnComplete_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResolveHostClient_OnTextResults_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const ResolveHostClient_OnHostnameResults_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MdnsListenClient_OnAddressResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MdnsListenClient_OnTextResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MdnsListenClient_OnHostnameResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const MdnsListenClient_OnUnhandledResult_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HostResolver_ResolveHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HostResolver_MdnsListen_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HostResolver_MdnsListen_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const DnsConfigChangeManager_RequestNotifications_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const HostResolverHostSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    DnsOverHttpsServerConfigSpec.$,
    'DnsOverHttpsServerConfig',
    [
      mojo.internal.StructField(
        'serverTemplate', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpoints', 8,
        0,
        mojo.internal.Array(mojo.internal.Array(network_mojom_IPAddressSpec.$, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class DnsOverHttpsServerConfig {
  constructor() {
    /** @type { !string } */
    this.serverTemplate;
    /** @type { !Array<!Array<!network_mojom_IPAddress>> } */
    this.endpoints;
  }
}



mojo.internal.Struct(
    DnsOverHttpsConfigSpec.$,
    'DnsOverHttpsConfig',
    [
      mojo.internal.StructField(
        'servers', 0,
        0,
        mojo.internal.Array(DnsOverHttpsServerConfigSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DnsOverHttpsConfig {
  constructor() {
    /** @type { !Array<!DnsOverHttpsServerConfig> } */
    this.servers;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const DnsConfigOverrides_TristateSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const DnsConfigOverrides_Tristate = {
  
  NO_OVERRIDE: 0,
  TRISTATE_TRUE: 1,
  TRISTATE_FALSE: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};


mojo.internal.Struct(
    DnsConfigOverridesSpec.$,
    'DnsConfigOverrides',
    [
      mojo.internal.StructField(
        'nameservers', 0,
        0,
        mojo.internal.Array(network_mojom_IPEndPointSpec.$, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'search', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'appendToMultiLabelName', 16,
        0,
        DnsConfigOverrides_TristateSpec.$,
        DnsConfigOverrides_Tristate.NO_OVERRIDE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'ndots', 20,
        0,
        mojo.internal.Int8,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'fallbackPeriod', 24,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'attempts', 32,
        0,
        mojo.internal.Int32,
        -1,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'rotate', 36,
        0,
        DnsConfigOverrides_TristateSpec.$,
        DnsConfigOverrides_Tristate.NO_OVERRIDE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'useLocalIpv6', 40,
        0,
        DnsConfigOverrides_TristateSpec.$,
        DnsConfigOverrides_Tristate.NO_OVERRIDE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'dnsOverHttpsConfig', 48,
        0,
        DnsOverHttpsConfigSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'secureDnsMode', 44,
        0,
        OptionalSecureDnsModeSpec.$,
        OptionalSecureDnsMode.NO_OVERRIDE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowDnsOverHttpsUpgrade', 56,
        0,
        DnsConfigOverrides_TristateSpec.$,
        DnsConfigOverrides_Tristate.NO_OVERRIDE,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clearHosts', 21,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 72],]);



/**
 * @record
 */
export class DnsConfigOverrides {
  constructor() {
    /** @type { (Array<!network_mojom_IPEndPoint>|undefined) } */
    this.nameservers;
    /** @type { (Array<!string>|undefined) } */
    this.search;
    /** @type { !DnsConfigOverrides_Tristate } */
    this.appendToMultiLabelName;
    /** @type { !number } */
    this.ndots;
    /** @type { (mojoBase_mojom_TimeDelta|undefined) } */
    this.fallbackPeriod;
    /** @type { !number } */
    this.attempts;
    /** @type { !DnsConfigOverrides_Tristate } */
    this.rotate;
    /** @type { !DnsConfigOverrides_Tristate } */
    this.useLocalIpv6;
    /** @type { (DnsOverHttpsConfig|undefined) } */
    this.dnsOverHttpsConfig;
    /** @type { !OptionalSecureDnsMode } */
    this.secureDnsMode;
    /** @type { !DnsConfigOverrides_Tristate } */
    this.allowDnsOverHttpsUpgrade;
    /** @type { !boolean } */
    this.clearHosts;
  }
}


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ResolveHostParameters_SourceSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ResolveHostParameters_Source = {
  
  ANY: 0,
  SYSTEM: 1,
  DNS: 2,
  MULTICAST_DNS: 3,
  LOCAL_ONLY: 4,
  MIN_VALUE: 0,
  MAX_VALUE: 4,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ResolveHostParameters_CacheUsageSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ResolveHostParameters_CacheUsage = {
  
  ALLOWED: 0,
  STALE_ALLOWED: 1,
  DISALLOWED: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ResolveHostParameters_PurposeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ResolveHostParameters_Purpose = {
  
  kUnspecified: 0,
  kPreconnect: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};


mojo.internal.Struct(
    ResolveHostParametersSpec.$,
    'ResolveHostParameters',
    [
      mojo.internal.StructField(
        'dnsQueryType', 0,
        0,
        DnsQueryTypeSpec.$,
        DnsQueryType.UNSPECIFIED,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'initialPriority', 4,
        0,
        network_mojom_RequestPrioritySpec.$,
        network_mojom_RequestPriority.kLowest,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'source', 8,
        0,
        ResolveHostParameters_SourceSpec.$,
        ResolveHostParameters_Source.ANY,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'cacheUsage', 12,
        0,
        ResolveHostParameters_CacheUsageSpec.$,
        ResolveHostParameters_CacheUsage.ALLOWED,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'controlHandle', 16,
        0,
        mojo.internal.InterfaceRequest(ResolveHostHandlePendingReceiver),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'includeCanonicalName', 20,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'loopbackOnly', 20,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isSpeculative', 20,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'secureDnsPolicy', 24,
        0,
        SecureDnsPolicySpec.$,
        SecureDnsPolicy.ALLOW,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'purpose', 28,
        0,
        ResolveHostParameters_PurposeSpec.$,
        ResolveHostParameters_Purpose.kUnspecified,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ResolveHostParameters {
  constructor() {
    /** @type { !DnsQueryType } */
    this.dnsQueryType;
    /** @type { !network_mojom_RequestPriority } */
    this.initialPriority;
    /** @type { !ResolveHostParameters_Source } */
    this.source;
    /** @type { !ResolveHostParameters_CacheUsage } */
    this.cacheUsage;
    /** @type { (ResolveHostHandlePendingReceiver|undefined) } */
    this.controlHandle;
    /** @type { !boolean } */
    this.includeCanonicalName;
    /** @type { !boolean } */
    this.loopbackOnly;
    /** @type { !boolean } */
    this.isSpeculative;
    /** @type { !SecureDnsPolicy } */
    this.secureDnsPolicy;
    /** @type { !ResolveHostParameters_Purpose } */
    this.purpose;
  }
}



mojo.internal.Struct(
    ResolveHostHandle_Cancel_ParamsSpec.$,
    'ResolveHostHandle_Cancel_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ResolveHostHandle_Cancel_Params {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    ResolveHostClient_OnComplete_ParamsSpec.$,
    'ResolveHostClient_OnComplete_Params',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resolveErrorInfo', 8,
        0,
        network_mojom_ResolveErrorInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'resolvedAddresses', 16,
        0,
        network_mojom_AddressListSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'alternativeEndpoints', 24,
        0,
        mojo.internal.Array(network_mojom_HostResolverEndpointResultSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 40],]);



/**
 * @record
 */
export class ResolveHostClient_OnComplete_Params {
  constructor() {
    /** @type { !number } */
    this.result;
    /** @type { !network_mojom_ResolveErrorInfo } */
    this.resolveErrorInfo;
    /** @type { !network_mojom_AddressList } */
    this.resolvedAddresses;
    /** @type { !Array<!network_mojom_HostResolverEndpointResult> } */
    this.alternativeEndpoints;
  }
}



mojo.internal.Struct(
    ResolveHostClient_OnTextResults_ParamsSpec.$,
    'ResolveHostClient_OnTextResults_Params',
    [
      mojo.internal.StructField(
        'textResults', 0,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ResolveHostClient_OnTextResults_Params {
  constructor() {
    /** @type { !Array<!string> } */
    this.textResults;
  }
}



mojo.internal.Struct(
    ResolveHostClient_OnHostnameResults_ParamsSpec.$,
    'ResolveHostClient_OnHostnameResults_Params',
    [
      mojo.internal.StructField(
        'hosts', 0,
        0,
        mojo.internal.Array(network_mojom_HostPortPairSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class ResolveHostClient_OnHostnameResults_Params {
  constructor() {
    /** @type { !Array<!network_mojom_HostPortPair> } */
    this.hosts;
  }
}



mojo.internal.Struct(
    MdnsListenClient_OnAddressResult_ParamsSpec.$,
    'MdnsListenClient_OnAddressResult_Params',
    [
      mojo.internal.StructField(
        'updateType', 0,
        0,
        MdnsListenClient_UpdateTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'queryType', 4,
        0,
        DnsQueryTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'endpoint', 8,
        0,
        network_mojom_IPEndPointSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MdnsListenClient_OnAddressResult_Params {
  constructor() {
    /** @type { !MdnsListenClient_UpdateType } */
    this.updateType;
    /** @type { !DnsQueryType } */
    this.queryType;
    /** @type { !network_mojom_IPEndPoint } */
    this.endpoint;
  }
}



mojo.internal.Struct(
    MdnsListenClient_OnTextResult_ParamsSpec.$,
    'MdnsListenClient_OnTextResult_Params',
    [
      mojo.internal.StructField(
        'updateType', 0,
        0,
        MdnsListenClient_UpdateTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'queryType', 4,
        0,
        DnsQueryTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'textRecords', 8,
        0,
        mojo.internal.Array(mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MdnsListenClient_OnTextResult_Params {
  constructor() {
    /** @type { !MdnsListenClient_UpdateType } */
    this.updateType;
    /** @type { !DnsQueryType } */
    this.queryType;
    /** @type { !Array<!string> } */
    this.textRecords;
  }
}



mojo.internal.Struct(
    MdnsListenClient_OnHostnameResult_ParamsSpec.$,
    'MdnsListenClient_OnHostnameResult_Params',
    [
      mojo.internal.StructField(
        'updateType', 0,
        0,
        MdnsListenClient_UpdateTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'queryType', 4,
        0,
        DnsQueryTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'host', 8,
        0,
        network_mojom_HostPortPairSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class MdnsListenClient_OnHostnameResult_Params {
  constructor() {
    /** @type { !MdnsListenClient_UpdateType } */
    this.updateType;
    /** @type { !DnsQueryType } */
    this.queryType;
    /** @type { !network_mojom_HostPortPair } */
    this.host;
  }
}



mojo.internal.Struct(
    MdnsListenClient_OnUnhandledResult_ParamsSpec.$,
    'MdnsListenClient_OnUnhandledResult_Params',
    [
      mojo.internal.StructField(
        'updateType', 0,
        0,
        MdnsListenClient_UpdateTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'queryType', 4,
        0,
        DnsQueryTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class MdnsListenClient_OnUnhandledResult_Params {
  constructor() {
    /** @type { !MdnsListenClient_UpdateType } */
    this.updateType;
    /** @type { !DnsQueryType } */
    this.queryType;
  }
}



mojo.internal.Struct(
    HostResolver_ResolveHost_ParamsSpec.$,
    'HostResolver_ResolveHost_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        HostResolverHostSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'networkAnonymizationKey', 16,
        0,
        network_mojom_NetworkAnonymizationKeySpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'optionalParameters', 32,
        0,
        ResolveHostParametersSpec.$,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseClient', 40,
        0,
        mojo.internal.InterfaceProxy(ResolveHostClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 56],]);



/**
 * @record
 */
export class HostResolver_ResolveHost_Params {
  constructor() {
    /** @type { !HostResolverHost } */
    this.host;
    /** @type { !network_mojom_NetworkAnonymizationKey } */
    this.networkAnonymizationKey;
    /** @type { (ResolveHostParameters|undefined) } */
    this.optionalParameters;
    /** @type { !ResolveHostClientRemote } */
    this.responseClient;
  }
}



mojo.internal.Struct(
    HostResolver_MdnsListen_ParamsSpec.$,
    'HostResolver_MdnsListen_Params',
    [
      mojo.internal.StructField(
        'host', 0,
        0,
        network_mojom_HostPortPairSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'queryType', 8,
        0,
        DnsQueryTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'responseClient', 12,
        0,
        mojo.internal.InterfaceProxy(MdnsListenClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class HostResolver_MdnsListen_Params {
  constructor() {
    /** @type { !network_mojom_HostPortPair } */
    this.host;
    /** @type { !DnsQueryType } */
    this.queryType;
    /** @type { !MdnsListenClientRemote } */
    this.responseClient;
  }
}



mojo.internal.Struct(
    HostResolver_MdnsListen_ResponseParamsSpec.$,
    'HostResolver_MdnsListen_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HostResolver_MdnsListen_ResponseParams {
  constructor() {
    /** @type { !number } */
    this.result;
  }
}



mojo.internal.Struct(
    DnsConfigChangeManagerClient_OnDnsConfigChanged_ParamsSpec.$,
    'DnsConfigChangeManagerClient_OnDnsConfigChanged_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class DnsConfigChangeManagerClient_OnDnsConfigChanged_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    DnsConfigChangeManager_RequestNotifications_ParamsSpec.$,
    'DnsConfigChangeManager_RequestNotifications_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.InterfaceProxy(DnsConfigChangeManagerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class DnsConfigChangeManager_RequestNotifications_Params {
  constructor() {
    /** @type { !DnsConfigChangeManagerClientRemote } */
    this.client;
  }
}

mojo.internal.Union(
    HostResolverHostSpec.$, 'HostResolverHost',
    {
      'schemeHostPort': {
        'ordinal': 0,
        'type': url_mojom_SchemeHostPortSpec.$,
      },
      'hostPortPair': {
        'ordinal': 1,
        'type': network_mojom_HostPortPairSpec.$,
      },
    });

/**
 * @typedef { {
 *   schemeHostPort: (!url_mojom_SchemeHostPort|undefined),
 *   hostPortPair: (!network_mojom_HostPortPair|undefined),
 * } }
 */
export const HostResolverHost = {};
