// services/network/public/mojom/first_party_sets_access_delegate.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/first_party_sets_access_delegate.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var first_party_sets$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/first_party_sets.mojom', 'first_party_sets.mojom.js');
  }
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', 'schemeful_site.mojom.js');
  }



  function FirstPartySetsAccessDelegateParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FirstPartySetsAccessDelegateParams.prototype.initDefaults_ = function() {
    this.enabled = false;
  };
  FirstPartySetsAccessDelegateParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FirstPartySetsAccessDelegateParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FirstPartySetsAccessDelegateParams.encodedSize = codec.kStructHeaderSize + 8;

  FirstPartySetsAccessDelegateParams.decode = function(decoder) {
    var packed;
    var val = new FirstPartySetsAccessDelegateParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FirstPartySetsAccessDelegateParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FirstPartySetsAccessDelegateParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function FirstPartySetsReadyEvent(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FirstPartySetsReadyEvent.prototype.initDefaults_ = function() {
    this.config = null;
    this.cacheFilter = null;
  };
  FirstPartySetsReadyEvent.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FirstPartySetsReadyEvent.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetsReadyEvent.config
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, first_party_sets$.FirstPartySetsContextConfig, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetsReadyEvent.cacheFilter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, first_party_sets$.FirstPartySetsCacheFilter, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FirstPartySetsReadyEvent.encodedSize = codec.kStructHeaderSize + 16;

  FirstPartySetsReadyEvent.decode = function(decoder) {
    var packed;
    var val = new FirstPartySetsReadyEvent();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.config =
        decoder.decodeStructPointer(first_party_sets$.FirstPartySetsContextConfig);
    val.cacheFilter =
        decoder.decodeStructPointer(first_party_sets$.FirstPartySetsCacheFilter);
    return val;
  };

  FirstPartySetsReadyEvent.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FirstPartySetsReadyEvent.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(first_party_sets$.FirstPartySetsContextConfig, val.config);
    encoder.encodeStructPointer(first_party_sets$.FirstPartySetsCacheFilter, val.cacheFilter);
  };
  function FirstPartySetsAccessDelegate_NotifyReady_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FirstPartySetsAccessDelegate_NotifyReady_Params.prototype.initDefaults_ = function() {
    this.readyEvent = null;
  };
  FirstPartySetsAccessDelegate_NotifyReady_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FirstPartySetsAccessDelegate_NotifyReady_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate FirstPartySetsAccessDelegate_NotifyReady_Params.readyEvent
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, FirstPartySetsReadyEvent, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  FirstPartySetsAccessDelegate_NotifyReady_Params.encodedSize = codec.kStructHeaderSize + 8;

  FirstPartySetsAccessDelegate_NotifyReady_Params.decode = function(decoder) {
    var packed;
    var val = new FirstPartySetsAccessDelegate_NotifyReady_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.readyEvent =
        decoder.decodeStructPointer(FirstPartySetsReadyEvent);
    return val;
  };

  FirstPartySetsAccessDelegate_NotifyReady_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FirstPartySetsAccessDelegate_NotifyReady_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(FirstPartySetsReadyEvent, val.readyEvent);
  };
  function FirstPartySetsAccessDelegate_SetEnabled_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  FirstPartySetsAccessDelegate_SetEnabled_Params.prototype.initDefaults_ = function() {
    this.enabled = false;
  };
  FirstPartySetsAccessDelegate_SetEnabled_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  FirstPartySetsAccessDelegate_SetEnabled_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  FirstPartySetsAccessDelegate_SetEnabled_Params.encodedSize = codec.kStructHeaderSize + 8;

  FirstPartySetsAccessDelegate_SetEnabled_Params.decode = function(decoder) {
    var packed;
    var val = new FirstPartySetsAccessDelegate_SetEnabled_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.enabled = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  FirstPartySetsAccessDelegate_SetEnabled_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(FirstPartySetsAccessDelegate_SetEnabled_Params.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.enabled & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kFirstPartySetsAccessDelegate_NotifyReady_Name = 0;
  var kFirstPartySetsAccessDelegate_SetEnabled_Name = 1;

  function FirstPartySetsAccessDelegatePtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(FirstPartySetsAccessDelegate,
                                                   handleOrPtrInfo);
  }

  function FirstPartySetsAccessDelegateAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        FirstPartySetsAccessDelegate, associatedInterfacePtrInfo);
  }

  FirstPartySetsAccessDelegateAssociatedPtr.prototype =
      Object.create(FirstPartySetsAccessDelegatePtr.prototype);
  FirstPartySetsAccessDelegateAssociatedPtr.prototype.constructor =
      FirstPartySetsAccessDelegateAssociatedPtr;

  function FirstPartySetsAccessDelegateProxy(receiver) {
    this.receiver_ = receiver;
  }
  FirstPartySetsAccessDelegatePtr.prototype.notifyReady = function() {
    return FirstPartySetsAccessDelegateProxy.prototype.notifyReady
        .apply(this.ptr.getProxy(), arguments);
  };

  FirstPartySetsAccessDelegateProxy.prototype.notifyReady = function(readyEvent) {
    var params_ = new FirstPartySetsAccessDelegate_NotifyReady_Params();
    params_.readyEvent = readyEvent;
    var builder = new codec.MessageV0Builder(
        kFirstPartySetsAccessDelegate_NotifyReady_Name,
        codec.align(FirstPartySetsAccessDelegate_NotifyReady_Params.encodedSize));
    builder.encodeStruct(FirstPartySetsAccessDelegate_NotifyReady_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  FirstPartySetsAccessDelegatePtr.prototype.setEnabled = function() {
    return FirstPartySetsAccessDelegateProxy.prototype.setEnabled
        .apply(this.ptr.getProxy(), arguments);
  };

  FirstPartySetsAccessDelegateProxy.prototype.setEnabled = function(enabled) {
    var params_ = new FirstPartySetsAccessDelegate_SetEnabled_Params();
    params_.enabled = enabled;
    var builder = new codec.MessageV0Builder(
        kFirstPartySetsAccessDelegate_SetEnabled_Name,
        codec.align(FirstPartySetsAccessDelegate_SetEnabled_Params.encodedSize));
    builder.encodeStruct(FirstPartySetsAccessDelegate_SetEnabled_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function FirstPartySetsAccessDelegateStub(delegate) {
    this.delegate_ = delegate;
  }
  FirstPartySetsAccessDelegateStub.prototype.notifyReady = function(readyEvent) {
    return this.delegate_ && this.delegate_.notifyReady && this.delegate_.notifyReady(readyEvent);
  }
  FirstPartySetsAccessDelegateStub.prototype.setEnabled = function(enabled) {
    return this.delegate_ && this.delegate_.setEnabled && this.delegate_.setEnabled(enabled);
  }

  FirstPartySetsAccessDelegateStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kFirstPartySetsAccessDelegate_NotifyReady_Name:
      var params = reader.decodeStruct(FirstPartySetsAccessDelegate_NotifyReady_Params);
      this.notifyReady(params.readyEvent);
      return true;
    case kFirstPartySetsAccessDelegate_SetEnabled_Name:
      var params = reader.decodeStruct(FirstPartySetsAccessDelegate_SetEnabled_Params);
      this.setEnabled(params.enabled);
      return true;
    default:
      return false;
    }
  };

  FirstPartySetsAccessDelegateStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateFirstPartySetsAccessDelegateRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kFirstPartySetsAccessDelegate_NotifyReady_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FirstPartySetsAccessDelegate_NotifyReady_Params;
      break;
      case kFirstPartySetsAccessDelegate_SetEnabled_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = FirstPartySetsAccessDelegate_SetEnabled_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateFirstPartySetsAccessDelegateResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var FirstPartySetsAccessDelegate = {
    name: 'network.mojom.FirstPartySetsAccessDelegate',
    kVersion: 0,
    ptrClass: FirstPartySetsAccessDelegatePtr,
    proxyClass: FirstPartySetsAccessDelegateProxy,
    stubClass: FirstPartySetsAccessDelegateStub,
    validateRequest: validateFirstPartySetsAccessDelegateRequest,
    validateResponse: null,
  };
  FirstPartySetsAccessDelegateStub.prototype.validator = validateFirstPartySetsAccessDelegateRequest;
  FirstPartySetsAccessDelegateProxy.prototype.validator = null;
  exports.FirstPartySetsAccessDelegateParams = FirstPartySetsAccessDelegateParams;
  exports.FirstPartySetsReadyEvent = FirstPartySetsReadyEvent;
  exports.FirstPartySetsAccessDelegate = FirstPartySetsAccessDelegate;
  exports.FirstPartySetsAccessDelegatePtr = FirstPartySetsAccessDelegatePtr;
  exports.FirstPartySetsAccessDelegateAssociatedPtr = FirstPartySetsAccessDelegateAssociatedPtr;
})();