// services/network/public/mojom/devtools_observer.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "services/network/public/mojom/devtools_observer.mojom-shared.h"

// Used to support stream output operator for enums.
// TODO(dcheng): Consider omitting this somehow if not needed.
#include <ostream>
#include <utility>
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/devtools_observer.mojom-params-data.h"
namespace network {
namespace mojom {

namespace internal {


// static
bool URLRequestDevToolsInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLRequestDevToolsInfo_Data* object =
      static_cast<const URLRequestDevToolsInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->method, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& method_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->method, validation_context,
                                         &method_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::network::mojom::internal::RequestPriority_Data
        ::Validate(object->priority, validation_context))
    return false;


  if (!::network::mojom::internal::URLRequestReferrerPolicy_Data
        ::Validate(object->referrer_policy, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->trust_token_params, validation_context))
    return false;

  return true;
}

URLRequestDevToolsInfo_Data::URLRequestDevToolsInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool URLResponseHeadDevToolsInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 112, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const URLResponseHeadDevToolsInfo_Data* object =
      static_cast<const URLResponseHeadDevToolsInfo_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->response_time, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->response_time, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->headers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mime_type, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& mime_type_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->mime_type, validation_context,
                                         &mime_type_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->charset, 4, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& charset_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->charset, validation_context,
                                         &charset_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->load_timing, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->load_timing, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cache_storage_cache_name, 10, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cache_storage_cache_name_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cache_storage_cache_name, validation_context,
                                         &cache_storage_cache_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->alpn_negotiated_protocol, 11, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& alpn_negotiated_protocol_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->alpn_negotiated_protocol, validation_context,
                                         &alpn_negotiated_protocol_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::AlternateProtocolUsage_Data
        ::Validate(object->alternate_protocol_usage, validation_context))
    return false;


  if (!::network::mojom::internal::FetchResponseSource_Data
        ::Validate(object->service_worker_response_source, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->service_worker_router_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->ssl_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->remote_endpoint, 17, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->remote_endpoint, validation_context))
    return false;

  return true;
}

URLResponseHeadDevToolsInfo_Data::URLResponseHeadDevToolsInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool OtherPartitionInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const OtherPartitionInfo_Data* object =
      static_cast<const OtherPartitionInfo_Data*>(data);

  return true;
}

OtherPartitionInfo_Data::OtherPartitionInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnRawRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 64, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnRawRequest_Params_Data* object =
      static_cast<const DevToolsObserver_OnRawRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devtool_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies_with_access_result, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_with_access_result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookies_with_access_result, validation_context,
                                         &cookies_with_access_result_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->timestamp, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->timestamp, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->client_security_state, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->other_partition_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->applied_network_conditions_id, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnRawRequest_Params_Data::DevToolsObserver_OnRawRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnRawResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnRawResponse_Params_Data* object =
      static_cast<const DevToolsObserver_OnRawResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devtool_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cookies_with_access_result, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& cookies_with_access_result_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->cookies_with_access_result, validation_context,
                                         &cookies_with_access_result_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  constexpr const mojo::internal::ContainerValidateParams& raw_response_headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->raw_response_headers, validation_context,
                                         &raw_response_headers_validate_params)) {
    return false;
  }


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->resource_address_space, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->cookie_partition_key, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnRawResponse_Params_Data::DevToolsObserver_OnRawResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnEarlyHintsResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnEarlyHintsResponse_Params_Data* object =
      static_cast<const DevToolsObserver_OnEarlyHintsResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devtool_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->headers, 2, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& headers_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->headers, validation_context,
                                         &headers_validate_params)) {
    return false;
  }

  return true;
}

DevToolsObserver_OnEarlyHintsResponse_Params_Data::DevToolsObserver_OnEarlyHintsResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnPrivateNetworkRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 40, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnPrivateNetworkRequest_Params_Data* object =
      static_cast<const DevToolsObserver_OnPrivateNetworkRequest_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& devtool_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::network::mojom::internal::IPAddressSpace_Data
        ::Validate(object->resource_address_space, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->client_security_state, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->client_security_state, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnPrivateNetworkRequest_Params_Data::DevToolsObserver_OnPrivateNetworkRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnCorsPreflightRequest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 48, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnCorsPreflightRequest_Params_Data* object =
      static_cast<const DevToolsObserver_OnCorsPreflightRequest_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtool_request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_headers, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_headers, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->request_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->request_info, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->initiator_url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->initiator_devtool_request_id, 5, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& initiator_devtool_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->initiator_devtool_request_id, validation_context,
                                         &initiator_devtool_request_id_validate_params)) {
    return false;
  }

  return true;
}

DevToolsObserver_OnCorsPreflightRequest_Params_Data::DevToolsObserver_OnCorsPreflightRequest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnCorsPreflightResponse_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnCorsPreflightResponse_Params_Data* object =
      static_cast<const DevToolsObserver_OnCorsPreflightResponse_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtool_request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->head, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->head, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnCorsPreflightResponse_Params_Data::DevToolsObserver_OnCorsPreflightResponse_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data* object =
      static_cast<const DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->devtool_request_id, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data::DevToolsObserver_OnCorsPreflightRequestCompleted_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnTrustTokenOperationDone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnTrustTokenOperationDone_Params_Data* object =
      static_cast<const DevToolsObserver_OnTrustTokenOperationDone_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devtool_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->result, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->result, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnTrustTokenOperationDone_Params_Data::DevToolsObserver_OnTrustTokenOperationDone_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnCorsError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 56, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnCorsError_Params_Data* object =
      static_cast<const DevToolsObserver_OnCorsError_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& devtool_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->initiator_origin, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->client_security_state, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->status, 5, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->status, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnCorsError_Params_Data::DevToolsObserver_OnCorsError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnOrbError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 24, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnOrbError_Params_Data* object =
      static_cast<const DevToolsObserver_OnOrbError_Params_Data*>(data);

  constexpr const mojo::internal::ContainerValidateParams& devtools_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtools_request_id, validation_context,
                                         &devtools_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnOrbError_Params_Data::DevToolsObserver_OnOrbError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnSharedDictionaryError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnSharedDictionaryError_Params_Data* object =
      static_cast<const DevToolsObserver_OnSharedDictionaryError_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devtool_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::network::mojom::internal::SharedDictionaryError_Data
        ::Validate(object->error, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnSharedDictionaryError_Params_Data::DevToolsObserver_OnSharedDictionaryError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data* object =
      static_cast<const DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devtool_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->issues, 3, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& issues_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->issues, validation_context,
                                         &issues_validate_params)) {
    return false;
  }

  return true;
}

DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data::DevToolsObserver_OnSRIMessageSignatureIssue_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_OnUnencodedDigestError_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 32, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_OnUnencodedDigestError_Params_Data* object =
      static_cast<const DevToolsObserver_OnUnencodedDigestError_Params_Data*>(data);

  if (!mojo::internal::ValidatePointerNonNullable(
          object->devtool_request_id, 1, validation_context)) {
    return false;
  }
  constexpr const mojo::internal::ContainerValidateParams& devtool_request_id_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  if (!mojo::internal::ValidateContainer(object->devtool_request_id, validation_context,
                                         &devtool_request_id_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->url, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->url, validation_context))
    return false;


  if (!::network::mojom::internal::UnencodedDigestIssue_Data
        ::Validate(object->issue, validation_context))
    return false;

  return true;
}

DevToolsObserver_OnUnencodedDigestError_Params_Data::DevToolsObserver_OnUnencodedDigestError_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool DevToolsObserver_Clone_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;
  if (!ValidateUnversionedStructHeaderAndSizeAndClaimMemory(
          data, 16, validation_context)) {
    return false;
  }

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  [[maybe_unused]] const DevToolsObserver_Clone_Params_Data* object =
      static_cast<const DevToolsObserver_Clone_Params_Data*>(data);

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->listener, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

DevToolsObserver_Clone_Params_Data::DevToolsObserver_Clone_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace network