// services/network/public/mojom/device_bound_sessions.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/network/public/mojom/device_bound_sessions.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('network.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }
  var context$ =
      mojo.internal.exposeNamespace('sandbox.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'sandbox/policy/mojom/context.mojom', '../../../../sandbox/policy/mojom/context.mojom.js');
  }
  var clear_data_filter$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/clear_data_filter.mojom', 'clear_data_filter.mojom.js');
  }
  var cookie_manager$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/cookie_manager.mojom', 'cookie_manager.mojom.js');
  }
  var schemeful_site$ =
      mojo.internal.exposeNamespace('network.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/network/public/mojom/schemeful_site.mojom', 'schemeful_site.mojom.js');
  }
  var url$ =
      mojo.internal.exposeNamespace('url.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'url/mojom/url.mojom', '../../../../url/mojom/url.mojom.js');
  }


  var DeviceBoundSessionAccessType = {};
  DeviceBoundSessionAccessType.kCreation = 0;
  DeviceBoundSessionAccessType.kUpdate = 1;
  DeviceBoundSessionAccessType.kTermination = 2;
  DeviceBoundSessionAccessType.MIN_VALUE = 0;
  DeviceBoundSessionAccessType.MAX_VALUE = 2;

  DeviceBoundSessionAccessType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
      return true;
    }
    return false;
  };

  DeviceBoundSessionAccessType.toKnownEnumValue = function(value) {
    return value;
  };

  DeviceBoundSessionAccessType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DeviceBoundSessionUsage = {};
  DeviceBoundSessionUsage.kUnknown = 0;
  DeviceBoundSessionUsage.kNoUsage = 1;
  DeviceBoundSessionUsage.kInScopeNotDeferred = 2;
  DeviceBoundSessionUsage.kDeferred = 3;
  DeviceBoundSessionUsage.MIN_VALUE = 0;
  DeviceBoundSessionUsage.MAX_VALUE = 3;

  DeviceBoundSessionUsage.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  DeviceBoundSessionUsage.toKnownEnumValue = function(value) {
    return value;
  };

  DeviceBoundSessionUsage.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DeviceBoundSessionDeletionReason = {};
  DeviceBoundSessionDeletionReason.kExpired = 0;
  DeviceBoundSessionDeletionReason.kFailedToRestoreKey = 1;
  DeviceBoundSessionDeletionReason.kFailedToUnwrapKey = 2;
  DeviceBoundSessionDeletionReason.kStoragePartitionCleared = 3;
  DeviceBoundSessionDeletionReason.kClearBrowsingData = 4;
  DeviceBoundSessionDeletionReason.kServerRequested = 5;
  DeviceBoundSessionDeletionReason.kInvalidSessionParams = 6;
  DeviceBoundSessionDeletionReason.kRefreshFatalError = 7;
  DeviceBoundSessionDeletionReason.MIN_VALUE = 0;
  DeviceBoundSessionDeletionReason.MAX_VALUE = 7;

  DeviceBoundSessionDeletionReason.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
    case 4:
    case 5:
    case 6:
    case 7:
      return true;
    }
    return false;
  };

  DeviceBoundSessionDeletionReason.toKnownEnumValue = function(value) {
    return value;
  };

  DeviceBoundSessionDeletionReason.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var DeviceBoundSessionScopeSpecificationType = {};
  DeviceBoundSessionScopeSpecificationType.kExclude = 0;
  DeviceBoundSessionScopeSpecificationType.kInclude = 1;
  DeviceBoundSessionScopeSpecificationType.MIN_VALUE = 0;
  DeviceBoundSessionScopeSpecificationType.MAX_VALUE = 1;

  DeviceBoundSessionScopeSpecificationType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
      return true;
    }
    return false;
  };

  DeviceBoundSessionScopeSpecificationType.toKnownEnumValue = function(value) {
    return value;
  };

  DeviceBoundSessionScopeSpecificationType.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function DeviceBoundSessionKey(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionKey.prototype.initDefaults_ = function() {
    this.site = null;
    this.id = null;
  };
  DeviceBoundSessionKey.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionKey.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionKey.site
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, schemeful_site$.SchemefulSite, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionKey.id
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionKey.encodedSize = codec.kStructHeaderSize + 16;

  DeviceBoundSessionKey.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionKey();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.site =
        decoder.decodeStructPointer(schemeful_site$.SchemefulSite);
    val.id =
        decoder.decodeStruct(codec.String);
    return val;
  };

  DeviceBoundSessionKey.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionKey.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(schemeful_site$.SchemefulSite, val.site);
    encoder.encodeStruct(codec.String, val.id);
  };
  function DeviceBoundSessionAccess(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionAccess.prototype.initDefaults_ = function() {
    this.accessType = 0;
    this.sessionKey = null;
    this.cookies = null;
  };
  DeviceBoundSessionAccess.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionAccess.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionAccess.accessType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DeviceBoundSessionAccessType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionAccess.sessionKey
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, DeviceBoundSessionKey, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionAccess.cookies
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionAccess.encodedSize = codec.kStructHeaderSize + 24;

  DeviceBoundSessionAccess.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionAccess();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.accessType =
        decoder.decodeStruct(new codec.Enum(DeviceBoundSessionAccessType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.sessionKey =
        decoder.decodeStructPointer(DeviceBoundSessionKey);
    val.cookies =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  DeviceBoundSessionAccess.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionAccess.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.accessType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(DeviceBoundSessionKey, val.sessionKey);
    encoder.encodeArrayPointer(codec.String, val.cookies);
  };
  function DeviceBoundSessionScopeSpecification(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionScopeSpecification.prototype.initDefaults_ = function() {
    this.type = 0;
    this.domain = null;
    this.path = null;
  };
  DeviceBoundSessionScopeSpecification.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionScopeSpecification.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionScopeSpecification.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DeviceBoundSessionScopeSpecificationType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionScopeSpecification.domain
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionScopeSpecification.path
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionScopeSpecification.encodedSize = codec.kStructHeaderSize + 24;

  DeviceBoundSessionScopeSpecification.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionScopeSpecification();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.type =
        decoder.decodeStruct(new codec.Enum(DeviceBoundSessionScopeSpecificationType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.domain =
        decoder.decodeStruct(codec.String);
    val.path =
        decoder.decodeStruct(codec.String);
    return val;
  };

  DeviceBoundSessionScopeSpecification.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionScopeSpecification.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.domain);
    encoder.encodeStruct(codec.String, val.path);
  };
  function DeviceBoundSessionScope(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionScope.prototype.initDefaults_ = function() {
    this.includeSite = false;
    this.specifications = null;
    this.origin = null;
  };
  DeviceBoundSessionScope.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionScope.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    // validate DeviceBoundSessionScope.specifications
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 8, new codec.PointerTo(DeviceBoundSessionScopeSpecification), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionScope.origin
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionScope.encodedSize = codec.kStructHeaderSize + 24;

  DeviceBoundSessionScope.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionScope();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.includeSite = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.specifications =
        decoder.decodeArrayPointer(new codec.PointerTo(DeviceBoundSessionScopeSpecification));
    val.origin =
        decoder.decodeStruct(codec.String);
    return val;
  };

  DeviceBoundSessionScope.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionScope.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.includeSite & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeArrayPointer(new codec.PointerTo(DeviceBoundSessionScopeSpecification), val.specifications);
    encoder.encodeStruct(codec.String, val.origin);
  };
  function DeviceBoundSessionCredential(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionCredential.prototype.initDefaults_ = function() {
    this.name = null;
    this.attributes = null;
  };
  DeviceBoundSessionCredential.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionCredential.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionCredential.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionCredential.attributes
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionCredential.encodedSize = codec.kStructHeaderSize + 16;

  DeviceBoundSessionCredential.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionCredential();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.name =
        decoder.decodeStruct(codec.String);
    val.attributes =
        decoder.decodeStruct(codec.String);
    return val;
  };

  DeviceBoundSessionCredential.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionCredential.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.name);
    encoder.encodeStruct(codec.String, val.attributes);
  };
  function DeviceBoundSessionParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionParams.prototype.initDefaults_ = function() {
    this.sessionId = null;
    this.fetcherUrl = null;
    this.refreshUrl = null;
    this.scope = null;
    this.credentials = null;
    this.allowedRefreshInitiators = null;
  };
  DeviceBoundSessionParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 56}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionParams.sessionId
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionParams.fetcherUrl
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionParams.refreshUrl
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionParams.scope
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, DeviceBoundSessionScope, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionParams.credentials
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 32, 8, new codec.PointerTo(DeviceBoundSessionCredential), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionParams.allowedRefreshInitiators
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 40, 8, codec.String, false, [0, 0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionParams.encodedSize = codec.kStructHeaderSize + 48;

  DeviceBoundSessionParams.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionId =
        decoder.decodeStruct(codec.String);
    val.fetcherUrl =
        decoder.decodeStructPointer(url$.Url);
    val.refreshUrl =
        decoder.decodeStruct(codec.String);
    val.scope =
        decoder.decodeStructPointer(DeviceBoundSessionScope);
    val.credentials =
        decoder.decodeArrayPointer(new codec.PointerTo(DeviceBoundSessionCredential));
    val.allowedRefreshInitiators =
        decoder.decodeArrayPointer(codec.String);
    return val;
  };

  DeviceBoundSessionParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.String, val.sessionId);
    encoder.encodeStructPointer(url$.Url, val.fetcherUrl);
    encoder.encodeStruct(codec.String, val.refreshUrl);
    encoder.encodeStructPointer(DeviceBoundSessionScope, val.scope);
    encoder.encodeArrayPointer(new codec.PointerTo(DeviceBoundSessionCredential), val.credentials);
    encoder.encodeArrayPointer(codec.String, val.allowedRefreshInitiators);
  };
  function DeviceBoundSessionManager_GetAllSessions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionManager_GetAllSessions_Params.prototype.initDefaults_ = function() {
  };
  DeviceBoundSessionManager_GetAllSessions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionManager_GetAllSessions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionManager_GetAllSessions_Params.encodedSize = codec.kStructHeaderSize + 0;

  DeviceBoundSessionManager_GetAllSessions_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionManager_GetAllSessions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DeviceBoundSessionManager_GetAllSessions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionManager_GetAllSessions_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function DeviceBoundSessionManager_GetAllSessions_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionManager_GetAllSessions_ResponseParams.prototype.initDefaults_ = function() {
    this.sessions = null;
  };
  DeviceBoundSessionManager_GetAllSessions_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionManager_GetAllSessions_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_GetAllSessions_ResponseParams.sessions
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(DeviceBoundSessionKey), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionManager_GetAllSessions_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  DeviceBoundSessionManager_GetAllSessions_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionManager_GetAllSessions_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessions =
        decoder.decodeArrayPointer(new codec.PointerTo(DeviceBoundSessionKey));
    return val;
  };

  DeviceBoundSessionManager_GetAllSessions_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionManager_GetAllSessions_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(DeviceBoundSessionKey), val.sessions);
  };
  function DeviceBoundSessionManager_DeleteSession_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionManager_DeleteSession_Params.prototype.initDefaults_ = function() {
    this.reason = 0;
    this.session = null;
  };
  DeviceBoundSessionManager_DeleteSession_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionManager_DeleteSession_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_DeleteSession_Params.reason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DeviceBoundSessionDeletionReason);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_DeleteSession_Params.session
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, DeviceBoundSessionKey, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionManager_DeleteSession_Params.encodedSize = codec.kStructHeaderSize + 16;

  DeviceBoundSessionManager_DeleteSession_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionManager_DeleteSession_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reason =
        decoder.decodeStruct(new codec.Enum(DeviceBoundSessionDeletionReason));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.session =
        decoder.decodeStructPointer(DeviceBoundSessionKey);
    return val;
  };

  DeviceBoundSessionManager_DeleteSession_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionManager_DeleteSession_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.reason);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(DeviceBoundSessionKey, val.session);
  };
  function DeviceBoundSessionManager_DeleteAllSessions_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionManager_DeleteAllSessions_Params.prototype.initDefaults_ = function() {
    this.reason = 0;
    this.createdAfterTime = null;
    this.createdBeforeTime = null;
    this.filter = null;
  };
  DeviceBoundSessionManager_DeleteAllSessions_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionManager_DeleteAllSessions_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_DeleteAllSessions_Params.reason
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, DeviceBoundSessionDeletionReason);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_DeleteAllSessions_Params.createdAfterTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_DeleteAllSessions_Params.createdBeforeTime
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.Time, true);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_DeleteAllSessions_Params.filter
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, clear_data_filter$.ClearDataFilter, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionManager_DeleteAllSessions_Params.encodedSize = codec.kStructHeaderSize + 32;

  DeviceBoundSessionManager_DeleteAllSessions_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionManager_DeleteAllSessions_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.reason =
        decoder.decodeStruct(new codec.Enum(DeviceBoundSessionDeletionReason));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.createdAfterTime =
        decoder.decodeStructPointer(time$.Time);
    val.createdBeforeTime =
        decoder.decodeStructPointer(time$.Time);
    val.filter =
        decoder.decodeStructPointer(clear_data_filter$.ClearDataFilter);
    return val;
  };

  DeviceBoundSessionManager_DeleteAllSessions_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionManager_DeleteAllSessions_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.reason);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(time$.Time, val.createdAfterTime);
    encoder.encodeStructPointer(time$.Time, val.createdBeforeTime);
    encoder.encodeStructPointer(clear_data_filter$.ClearDataFilter, val.filter);
  };
  function DeviceBoundSessionManager_DeleteAllSessions_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionManager_DeleteAllSessions_ResponseParams.prototype.initDefaults_ = function() {
  };
  DeviceBoundSessionManager_DeleteAllSessions_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionManager_DeleteAllSessions_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionManager_DeleteAllSessions_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  DeviceBoundSessionManager_DeleteAllSessions_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionManager_DeleteAllSessions_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  DeviceBoundSessionManager_DeleteAllSessions_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionManager_DeleteAllSessions_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function DeviceBoundSessionManager_AddObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionManager_AddObserver_Params.prototype.initDefaults_ = function() {
    this.url = null;
    this.observer = new DeviceBoundSessionAccessObserverPtr();
  };
  DeviceBoundSessionManager_AddObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionManager_AddObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_AddObserver_Params.url
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, url$.Url, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_AddObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionManager_AddObserver_Params.encodedSize = codec.kStructHeaderSize + 16;

  DeviceBoundSessionManager_AddObserver_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionManager_AddObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.url =
        decoder.decodeStructPointer(url$.Url);
    val.observer =
        decoder.decodeStruct(new codec.Interface(DeviceBoundSessionAccessObserverPtr));
    return val;
  };

  DeviceBoundSessionManager_AddObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionManager_AddObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(url$.Url, val.url);
    encoder.encodeStruct(new codec.Interface(DeviceBoundSessionAccessObserverPtr), val.observer);
  };
  function DeviceBoundSessionManager_CreateBoundSession_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionManager_CreateBoundSession_Params.prototype.initDefaults_ = function() {
    this.params = null;
    this.wrappedKey = null;
    this.cookiesToSet = null;
    this.cookieOptions = null;
  };
  DeviceBoundSessionManager_CreateBoundSession_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionManager_CreateBoundSession_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 40}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_CreateBoundSession_Params.params
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DeviceBoundSessionParams, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_CreateBoundSession_Params.wrappedKey
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 8, 1, codec.Uint8, false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_CreateBoundSession_Params.cookiesToSet
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 16, 8, new codec.PointerTo(cookie_manager$.CanonicalCookie), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionManager_CreateBoundSession_Params.cookieOptions
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, cookie_manager$.CookieOptions, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionManager_CreateBoundSession_Params.encodedSize = codec.kStructHeaderSize + 32;

  DeviceBoundSessionManager_CreateBoundSession_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionManager_CreateBoundSession_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.params =
        decoder.decodeStructPointer(DeviceBoundSessionParams);
    val.wrappedKey =
        decoder.decodeArrayPointer(codec.Uint8);
    val.cookiesToSet =
        decoder.decodeArrayPointer(new codec.PointerTo(cookie_manager$.CanonicalCookie));
    val.cookieOptions =
        decoder.decodeStructPointer(cookie_manager$.CookieOptions);
    return val;
  };

  DeviceBoundSessionManager_CreateBoundSession_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionManager_CreateBoundSession_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DeviceBoundSessionParams, val.params);
    encoder.encodeArrayPointer(codec.Uint8, val.wrappedKey);
    encoder.encodeArrayPointer(new codec.PointerTo(cookie_manager$.CanonicalCookie), val.cookiesToSet);
    encoder.encodeStructPointer(cookie_manager$.CookieOptions, val.cookieOptions);
  };
  function DeviceBoundSessionManager_CreateBoundSession_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionManager_CreateBoundSession_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  DeviceBoundSessionManager_CreateBoundSession_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionManager_CreateBoundSession_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  DeviceBoundSessionManager_CreateBoundSession_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  DeviceBoundSessionManager_CreateBoundSession_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionManager_CreateBoundSession_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DeviceBoundSessionManager_CreateBoundSession_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionManager_CreateBoundSession_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params.prototype.initDefaults_ = function() {
    this.access = null;
  };
  DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params.access
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, DeviceBoundSessionAccess, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params.encodedSize = codec.kStructHeaderSize + 8;

  DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.access =
        decoder.decodeStructPointer(DeviceBoundSessionAccess);
    return val;
  };

  DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(DeviceBoundSessionAccess, val.access);
  };
  function DeviceBoundSessionAccessObserver_Clone_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  DeviceBoundSessionAccessObserver_Clone_Params.prototype.initDefaults_ = function() {
    this.observer = new bindings.InterfaceRequest();
  };
  DeviceBoundSessionAccessObserver_Clone_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  DeviceBoundSessionAccessObserver_Clone_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate DeviceBoundSessionAccessObserver_Clone_Params.observer
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  DeviceBoundSessionAccessObserver_Clone_Params.encodedSize = codec.kStructHeaderSize + 8;

  DeviceBoundSessionAccessObserver_Clone_Params.decode = function(decoder) {
    var packed;
    var val = new DeviceBoundSessionAccessObserver_Clone_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(codec.InterfaceRequest);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  DeviceBoundSessionAccessObserver_Clone_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(DeviceBoundSessionAccessObserver_Clone_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.observer);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  var kDeviceBoundSessionManager_GetAllSessions_Name = 0;
  var kDeviceBoundSessionManager_DeleteSession_Name = 1;
  var kDeviceBoundSessionManager_DeleteAllSessions_Name = 2;
  var kDeviceBoundSessionManager_AddObserver_Name = 3;
  var kDeviceBoundSessionManager_CreateBoundSession_Name = 4;

  function DeviceBoundSessionManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DeviceBoundSessionManager,
                                                   handleOrPtrInfo);
  }

  function DeviceBoundSessionManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DeviceBoundSessionManager, associatedInterfacePtrInfo);
  }

  DeviceBoundSessionManagerAssociatedPtr.prototype =
      Object.create(DeviceBoundSessionManagerPtr.prototype);
  DeviceBoundSessionManagerAssociatedPtr.prototype.constructor =
      DeviceBoundSessionManagerAssociatedPtr;

  function DeviceBoundSessionManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  DeviceBoundSessionManagerPtr.prototype.getAllSessions = function() {
    return DeviceBoundSessionManagerProxy.prototype.getAllSessions
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceBoundSessionManagerProxy.prototype.getAllSessions = function() {
    var params_ = new DeviceBoundSessionManager_GetAllSessions_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDeviceBoundSessionManager_GetAllSessions_Name,
          codec.align(DeviceBoundSessionManager_GetAllSessions_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DeviceBoundSessionManager_GetAllSessions_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DeviceBoundSessionManager_GetAllSessions_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DeviceBoundSessionManagerPtr.prototype.deleteSession = function() {
    return DeviceBoundSessionManagerProxy.prototype.deleteSession
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceBoundSessionManagerProxy.prototype.deleteSession = function(reason, session) {
    var params_ = new DeviceBoundSessionManager_DeleteSession_Params();
    params_.reason = reason;
    params_.session = session;
    var builder = new codec.MessageV0Builder(
        kDeviceBoundSessionManager_DeleteSession_Name,
        codec.align(DeviceBoundSessionManager_DeleteSession_Params.encodedSize));
    builder.encodeStruct(DeviceBoundSessionManager_DeleteSession_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DeviceBoundSessionManagerPtr.prototype.deleteAllSessions = function() {
    return DeviceBoundSessionManagerProxy.prototype.deleteAllSessions
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceBoundSessionManagerProxy.prototype.deleteAllSessions = function(reason, createdAfterTime, createdBeforeTime, filter) {
    var params_ = new DeviceBoundSessionManager_DeleteAllSessions_Params();
    params_.reason = reason;
    params_.createdAfterTime = createdAfterTime;
    params_.createdBeforeTime = createdBeforeTime;
    params_.filter = filter;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDeviceBoundSessionManager_DeleteAllSessions_Name,
          codec.align(DeviceBoundSessionManager_DeleteAllSessions_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DeviceBoundSessionManager_DeleteAllSessions_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DeviceBoundSessionManager_DeleteAllSessions_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  DeviceBoundSessionManagerPtr.prototype.addObserver = function() {
    return DeviceBoundSessionManagerProxy.prototype.addObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceBoundSessionManagerProxy.prototype.addObserver = function(url, observer) {
    var params_ = new DeviceBoundSessionManager_AddObserver_Params();
    params_.url = url;
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kDeviceBoundSessionManager_AddObserver_Name,
        codec.align(DeviceBoundSessionManager_AddObserver_Params.encodedSize));
    builder.encodeStruct(DeviceBoundSessionManager_AddObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DeviceBoundSessionManagerPtr.prototype.createBoundSession = function() {
    return DeviceBoundSessionManagerProxy.prototype.createBoundSession
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceBoundSessionManagerProxy.prototype.createBoundSession = function(params, wrappedKey, cookiesToSet, cookieOptions) {
    var params_ = new DeviceBoundSessionManager_CreateBoundSession_Params();
    params_.params = params;
    params_.wrappedKey = wrappedKey;
    params_.cookiesToSet = cookiesToSet;
    params_.cookieOptions = cookieOptions;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kDeviceBoundSessionManager_CreateBoundSession_Name,
          codec.align(DeviceBoundSessionManager_CreateBoundSession_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(DeviceBoundSessionManager_CreateBoundSession_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(DeviceBoundSessionManager_CreateBoundSession_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function DeviceBoundSessionManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  DeviceBoundSessionManagerStub.prototype.getAllSessions = function() {
    return this.delegate_ && this.delegate_.getAllSessions && this.delegate_.getAllSessions();
  }
  DeviceBoundSessionManagerStub.prototype.deleteSession = function(reason, session) {
    return this.delegate_ && this.delegate_.deleteSession && this.delegate_.deleteSession(reason, session);
  }
  DeviceBoundSessionManagerStub.prototype.deleteAllSessions = function(reason, createdAfterTime, createdBeforeTime, filter) {
    return this.delegate_ && this.delegate_.deleteAllSessions && this.delegate_.deleteAllSessions(reason, createdAfterTime, createdBeforeTime, filter);
  }
  DeviceBoundSessionManagerStub.prototype.addObserver = function(url, observer) {
    return this.delegate_ && this.delegate_.addObserver && this.delegate_.addObserver(url, observer);
  }
  DeviceBoundSessionManagerStub.prototype.createBoundSession = function(params, wrappedKey, cookiesToSet, cookieOptions) {
    return this.delegate_ && this.delegate_.createBoundSession && this.delegate_.createBoundSession(params, wrappedKey, cookiesToSet, cookieOptions);
  }

  DeviceBoundSessionManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDeviceBoundSessionManager_DeleteSession_Name:
      var params = reader.decodeStruct(DeviceBoundSessionManager_DeleteSession_Params);
      this.deleteSession(params.reason, params.session);
      return true;
    case kDeviceBoundSessionManager_AddObserver_Name:
      var params = reader.decodeStruct(DeviceBoundSessionManager_AddObserver_Params);
      this.addObserver(params.url, params.observer);
      return true;
    default:
      return false;
    }
  };

  DeviceBoundSessionManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDeviceBoundSessionManager_GetAllSessions_Name:
      var params = reader.decodeStruct(DeviceBoundSessionManager_GetAllSessions_Params);
      this.getAllSessions().then(function(response) {
        var responseParams =
            new DeviceBoundSessionManager_GetAllSessions_ResponseParams();
        responseParams.sessions = response.sessions;
        var builder = new codec.MessageV1Builder(
            kDeviceBoundSessionManager_GetAllSessions_Name,
            codec.align(DeviceBoundSessionManager_GetAllSessions_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DeviceBoundSessionManager_GetAllSessions_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDeviceBoundSessionManager_DeleteAllSessions_Name:
      var params = reader.decodeStruct(DeviceBoundSessionManager_DeleteAllSessions_Params);
      this.deleteAllSessions(params.reason, params.createdAfterTime, params.createdBeforeTime, params.filter).then(function(response) {
        var responseParams =
            new DeviceBoundSessionManager_DeleteAllSessions_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kDeviceBoundSessionManager_DeleteAllSessions_Name,
            codec.align(DeviceBoundSessionManager_DeleteAllSessions_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DeviceBoundSessionManager_DeleteAllSessions_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kDeviceBoundSessionManager_CreateBoundSession_Name:
      var params = reader.decodeStruct(DeviceBoundSessionManager_CreateBoundSession_Params);
      this.createBoundSession(params.params, params.wrappedKey, params.cookiesToSet, params.cookieOptions).then(function(response) {
        var responseParams =
            new DeviceBoundSessionManager_CreateBoundSession_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kDeviceBoundSessionManager_CreateBoundSession_Name,
            codec.align(DeviceBoundSessionManager_CreateBoundSession_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(DeviceBoundSessionManager_CreateBoundSession_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateDeviceBoundSessionManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDeviceBoundSessionManager_GetAllSessions_Name:
        if (message.expectsResponse())
          paramsClass = DeviceBoundSessionManager_GetAllSessions_Params;
      break;
      case kDeviceBoundSessionManager_DeleteSession_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DeviceBoundSessionManager_DeleteSession_Params;
      break;
      case kDeviceBoundSessionManager_DeleteAllSessions_Name:
        if (message.expectsResponse())
          paramsClass = DeviceBoundSessionManager_DeleteAllSessions_Params;
      break;
      case kDeviceBoundSessionManager_AddObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DeviceBoundSessionManager_AddObserver_Params;
      break;
      case kDeviceBoundSessionManager_CreateBoundSession_Name:
        if (message.expectsResponse())
          paramsClass = DeviceBoundSessionManager_CreateBoundSession_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDeviceBoundSessionManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kDeviceBoundSessionManager_GetAllSessions_Name:
        if (message.isResponse())
          paramsClass = DeviceBoundSessionManager_GetAllSessions_ResponseParams;
        break;
      case kDeviceBoundSessionManager_DeleteAllSessions_Name:
        if (message.isResponse())
          paramsClass = DeviceBoundSessionManager_DeleteAllSessions_ResponseParams;
        break;
      case kDeviceBoundSessionManager_CreateBoundSession_Name:
        if (message.isResponse())
          paramsClass = DeviceBoundSessionManager_CreateBoundSession_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var DeviceBoundSessionManager = {
    name: 'network.mojom.DeviceBoundSessionManager',
    kVersion: 0,
    ptrClass: DeviceBoundSessionManagerPtr,
    proxyClass: DeviceBoundSessionManagerProxy,
    stubClass: DeviceBoundSessionManagerStub,
    validateRequest: validateDeviceBoundSessionManagerRequest,
    validateResponse: validateDeviceBoundSessionManagerResponse,
  };
  DeviceBoundSessionManagerStub.prototype.validator = validateDeviceBoundSessionManagerRequest;
  DeviceBoundSessionManagerProxy.prototype.validator = validateDeviceBoundSessionManagerResponse;
  var kDeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Name = 0;
  var kDeviceBoundSessionAccessObserver_Clone_Name = 1;

  function DeviceBoundSessionAccessObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(DeviceBoundSessionAccessObserver,
                                                   handleOrPtrInfo);
  }

  function DeviceBoundSessionAccessObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        DeviceBoundSessionAccessObserver, associatedInterfacePtrInfo);
  }

  DeviceBoundSessionAccessObserverAssociatedPtr.prototype =
      Object.create(DeviceBoundSessionAccessObserverPtr.prototype);
  DeviceBoundSessionAccessObserverAssociatedPtr.prototype.constructor =
      DeviceBoundSessionAccessObserverAssociatedPtr;

  function DeviceBoundSessionAccessObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  DeviceBoundSessionAccessObserverPtr.prototype.onDeviceBoundSessionAccessed = function() {
    return DeviceBoundSessionAccessObserverProxy.prototype.onDeviceBoundSessionAccessed
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceBoundSessionAccessObserverProxy.prototype.onDeviceBoundSessionAccessed = function(access) {
    var params_ = new DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params();
    params_.access = access;
    var builder = new codec.MessageV0Builder(
        kDeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Name,
        codec.align(DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params.encodedSize));
    builder.encodeStruct(DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  DeviceBoundSessionAccessObserverPtr.prototype.clone = function() {
    return DeviceBoundSessionAccessObserverProxy.prototype.clone
        .apply(this.ptr.getProxy(), arguments);
  };

  DeviceBoundSessionAccessObserverProxy.prototype.clone = function(observer) {
    var params_ = new DeviceBoundSessionAccessObserver_Clone_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kDeviceBoundSessionAccessObserver_Clone_Name,
        codec.align(DeviceBoundSessionAccessObserver_Clone_Params.encodedSize));
    builder.encodeStruct(DeviceBoundSessionAccessObserver_Clone_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function DeviceBoundSessionAccessObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  DeviceBoundSessionAccessObserverStub.prototype.onDeviceBoundSessionAccessed = function(access) {
    return this.delegate_ && this.delegate_.onDeviceBoundSessionAccessed && this.delegate_.onDeviceBoundSessionAccessed(access);
  }
  DeviceBoundSessionAccessObserverStub.prototype.clone = function(observer) {
    return this.delegate_ && this.delegate_.clone && this.delegate_.clone(observer);
  }

  DeviceBoundSessionAccessObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kDeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Name:
      var params = reader.decodeStruct(DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params);
      this.onDeviceBoundSessionAccessed(params.access);
      return true;
    case kDeviceBoundSessionAccessObserver_Clone_Name:
      var params = reader.decodeStruct(DeviceBoundSessionAccessObserver_Clone_Params);
      this.clone(params.observer);
      return true;
    default:
      return false;
    }
  };

  DeviceBoundSessionAccessObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateDeviceBoundSessionAccessObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kDeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DeviceBoundSessionAccessObserver_OnDeviceBoundSessionAccessed_Params;
      break;
      case kDeviceBoundSessionAccessObserver_Clone_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = DeviceBoundSessionAccessObserver_Clone_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateDeviceBoundSessionAccessObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var DeviceBoundSessionAccessObserver = {
    name: 'network.mojom.DeviceBoundSessionAccessObserver',
    kVersion: 0,
    ptrClass: DeviceBoundSessionAccessObserverPtr,
    proxyClass: DeviceBoundSessionAccessObserverProxy,
    stubClass: DeviceBoundSessionAccessObserverStub,
    validateRequest: validateDeviceBoundSessionAccessObserverRequest,
    validateResponse: null,
  };
  DeviceBoundSessionAccessObserverStub.prototype.validator = validateDeviceBoundSessionAccessObserverRequest;
  DeviceBoundSessionAccessObserverProxy.prototype.validator = null;
  exports.DeviceBoundSessionAccessType = DeviceBoundSessionAccessType;
  exports.DeviceBoundSessionUsage = DeviceBoundSessionUsage;
  exports.DeviceBoundSessionDeletionReason = DeviceBoundSessionDeletionReason;
  exports.DeviceBoundSessionScopeSpecificationType = DeviceBoundSessionScopeSpecificationType;
  exports.DeviceBoundSessionKey = DeviceBoundSessionKey;
  exports.DeviceBoundSessionAccess = DeviceBoundSessionAccess;
  exports.DeviceBoundSessionScopeSpecification = DeviceBoundSessionScopeSpecification;
  exports.DeviceBoundSessionScope = DeviceBoundSessionScope;
  exports.DeviceBoundSessionCredential = DeviceBoundSessionCredential;
  exports.DeviceBoundSessionParams = DeviceBoundSessionParams;
  exports.DeviceBoundSessionManager = DeviceBoundSessionManager;
  exports.DeviceBoundSessionManagerPtr = DeviceBoundSessionManagerPtr;
  exports.DeviceBoundSessionManagerAssociatedPtr = DeviceBoundSessionManagerAssociatedPtr;
  exports.DeviceBoundSessionAccessObserver = DeviceBoundSessionAccessObserver;
  exports.DeviceBoundSessionAccessObserverPtr = DeviceBoundSessionAccessObserverPtr;
  exports.DeviceBoundSessionAccessObserverAssociatedPtr = DeviceBoundSessionAccessObserverAssociatedPtr;
})();