// services/network/public/mojom/cross_origin_embedder_policy.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  Url as url_mojom_Url,
  UrlSpec as url_mojom_UrlSpec
} from '../../../../url/mojom/url.mojom.m.js';

import {
  RequestDestination as network_mojom_RequestDestination,
  RequestDestinationSpec as network_mojom_RequestDestinationSpec
} from './fetch_api.mojom.m.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const CrossOriginEmbedderPolicyValueSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const CrossOriginEmbedderPolicyValue = {
  
  kNone: 0,
  kRequireCorp: 1,
  kCredentialless: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class CrossOriginEmbedderPolicyReporterPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'network.mojom.CrossOriginEmbedderPolicyReporter', scope);
  }
}

/** @interface */
export class CrossOriginEmbedderPolicyReporterInterface {
  
  /**
   * @param { !url_mojom_Url } blockedUrl
   * @param { !network_mojom_RequestDestination } destination
   * @param { !boolean } reportOnly
   */

  queueCorpViolationReport(blockedUrl, destination, reportOnly) {}
  
  /**
   * @param { !CrossOriginEmbedderPolicyReporterPendingReceiver } receiver
   */

  clone(receiver) {}
}

/**
 * @implements { CrossOriginEmbedderPolicyReporterInterface }
 */
export class CrossOriginEmbedderPolicyReporterRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!CrossOriginEmbedderPolicyReporterPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          CrossOriginEmbedderPolicyReporterPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!CrossOriginEmbedderPolicyReporterPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !url_mojom_Url } blockedUrl
   * @param { !network_mojom_RequestDestination } destination
   * @param { !boolean } reportOnly
   */

  queueCorpViolationReport(
      blockedUrl,
      destination,
      reportOnly) {
    this.proxy.sendMessage(
        0,
        CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec.$,
        null,
        [
          blockedUrl,
          destination,
          reportOnly
        ],
        false);
  }

  
  /**
   * @param { !CrossOriginEmbedderPolicyReporterPendingReceiver } receiver
   */

  clone(
      receiver) {
    this.proxy.sendMessage(
        1,
        CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the CrossOriginEmbedderPolicyReporter
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class CrossOriginEmbedderPolicyReporterReceiver {
  /**
   * @param {!CrossOriginEmbedderPolicyReporterInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!CrossOriginEmbedderPolicyReporterRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        CrossOriginEmbedderPolicyReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CrossOriginEmbedderPolicyReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec.$,
        null,
        impl.queueCorpViolationReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec.$,
        null,
        impl.clone.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class CrossOriginEmbedderPolicyReporter {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "network.mojom.CrossOriginEmbedderPolicyReporter";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!CrossOriginEmbedderPolicyReporterRemote}
   */
  static getRemote() {
    let remote = new CrossOriginEmbedderPolicyReporterRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the CrossOriginEmbedderPolicyReporter
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class CrossOriginEmbedderPolicyReporterCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      CrossOriginEmbedderPolicyReporterRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!CrossOriginEmbedderPolicyReporterRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.queueCorpViolationReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec.$,
        null,
        this.queueCorpViolationReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec.$,
        null,
        this.clone.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CrossOriginEmbedderPolicySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    CrossOriginEmbedderPolicySpec.$,
    'CrossOriginEmbedderPolicy',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        CrossOriginEmbedderPolicyValueSpec.$,
        CrossOriginEmbedderPolicyValue.kNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportingEndpoint', 8,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportOnlyValue', 4,
        0,
        CrossOriginEmbedderPolicyValueSpec.$,
        CrossOriginEmbedderPolicyValue.kNone,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportOnlyReportingEndpoint', 16,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class CrossOriginEmbedderPolicy {
  constructor() {
    /** @type { !CrossOriginEmbedderPolicyValue } */
    this.value;
    /** @type { (string|undefined) } */
    this.reportingEndpoint;
    /** @type { !CrossOriginEmbedderPolicyValue } */
    this.reportOnlyValue;
    /** @type { (string|undefined) } */
    this.reportOnlyReportingEndpoint;
  }
}



mojo.internal.Struct(
    CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_ParamsSpec.$,
    'CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params',
    [
      mojo.internal.StructField(
        'blockedUrl', 0,
        0,
        url_mojom_UrlSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'destination', 8,
        0,
        network_mojom_RequestDestinationSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportOnly', 12,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class CrossOriginEmbedderPolicyReporter_QueueCorpViolationReport_Params {
  constructor() {
    /** @type { !url_mojom_Url } */
    this.blockedUrl;
    /** @type { !network_mojom_RequestDestination } */
    this.destination;
    /** @type { !boolean } */
    this.reportOnly;
  }
}



mojo.internal.Struct(
    CrossOriginEmbedderPolicyReporter_Clone_ParamsSpec.$,
    'CrossOriginEmbedderPolicyReporter_Clone_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(CrossOriginEmbedderPolicyReporterPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class CrossOriginEmbedderPolicyReporter_Clone_Params {
  constructor() {
    /** @type { !CrossOriginEmbedderPolicyReporterPendingReceiver } */
    this.receiver;
  }
}

