// services/network/public/mojom/cors_origin_pattern.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/cors_origin_pattern.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"

#include "services/network/public/mojom/cors_origin_pattern.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CorsPortMatchMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CorsDomainMatchMode, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::CorsOriginAccessMatchPriority, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CorsOriginPatternDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CorsOriginPatternDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CorsOriginPattern_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::protocol(input)) in_protocol = Traits::protocol(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->protocol)::BaseType> protocol_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_protocol,
        protocol_fragment);

      fragment->protocol.Set(
          protocol_fragment.is_null() ? nullptr : protocol_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->protocol.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null protocol in CorsOriginPattern struct");

      decltype(Traits::domain(input)) in_domain = Traits::domain(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->domain)::BaseType> domain_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_domain,
        domain_fragment);

      fragment->domain.Set(
          domain_fragment.is_null() ? nullptr : domain_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->domain.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null domain in CorsOriginPattern struct");

      fragment->port = Traits::port(input);

      
      mojo::internal::Serialize<::network::mojom::CorsDomainMatchMode>(
        Traits::domain_match_mode(input),
        &fragment->domain_match_mode);

      
      mojo::internal::Serialize<::network::mojom::CorsPortMatchMode>(
        Traits::port_match_mode(input),
        &fragment->port_match_mode);

      
      mojo::internal::Serialize<::network::mojom::CorsOriginAccessMatchPriority>(
        Traits::priority(input),
        &fragment->priority);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::CorsOriginAccessPatternsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::CorsOriginAccessPatternsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::CorsOriginAccessPatterns_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::source_origin(input)) in_source_origin = Traits::source_origin(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->source_origin)::BaseType> source_origin_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::url::mojom::OriginDataView, send_validation>(
        in_source_origin,
        source_origin_fragment);

      fragment->source_origin.Set(
          source_origin_fragment.is_null() ? nullptr : source_origin_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->source_origin.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null source_origin in CorsOriginAccessPatterns struct");

      decltype(Traits::allow_patterns(input)) in_allow_patterns = Traits::allow_patterns(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->allow_patterns)::BaseType>
          allow_patterns_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& allow_patterns_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CorsOriginPatternDataView>, send_validation>(
        in_allow_patterns,
        allow_patterns_fragment,
        &allow_patterns_validate_params);

      fragment->allow_patterns.Set(
          allow_patterns_fragment.is_null() ? nullptr : allow_patterns_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->allow_patterns.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null allow_patterns in CorsOriginAccessPatterns struct");

      decltype(Traits::block_patterns(input)) in_block_patterns = Traits::block_patterns(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->block_patterns)::BaseType>
          block_patterns_fragment(fragment.message());
      constexpr const mojo::internal::ContainerValidateParams& block_patterns_validate_params =
          mojo::internal::GetArrayValidator<0, false, nullptr>();
      
      mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CorsOriginPatternDataView>, send_validation>(
        in_block_patterns,
        block_patterns_fragment,
        &block_patterns_validate_params);

      fragment->block_patterns.Set(
          block_patterns_fragment.is_null() ? nullptr : block_patterns_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->block_patterns.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null block_patterns in CorsOriginAccessPatterns struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CORS_ORIGIN_PATTERN_MOJOM_SEND_VALIDATION_H_