// services/network/public/mojom/cors_origin_pattern.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/cors_origin_pattern.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/network/public/mojom/cors_origin_pattern.mojom-params-data.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom-shared-message-ids.h"

#include "services/network/public/mojom/cors_origin_pattern.mojom-blink-import-headers.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace network::mojom::blink {
CorsOriginPattern::CorsOriginPattern()
    : protocol(),
      domain(),
      port(),
      domain_match_mode(),
      port_match_mode(),
      priority() {}

CorsOriginPattern::CorsOriginPattern(
    const ::blink::String& protocol_in,
    const ::blink::String& domain_in,
    uint16_t port_in,
    CorsDomainMatchMode domain_match_mode_in,
    CorsPortMatchMode port_match_mode_in,
    CorsOriginAccessMatchPriority priority_in)
    : protocol(std::move(protocol_in)),
      domain(std::move(domain_in)),
      port(std::move(port_in)),
      domain_match_mode(std::move(domain_match_mode_in)),
      port_match_mode(std::move(port_match_mode_in)),
      priority(std::move(priority_in)) {}

CorsOriginPattern::~CorsOriginPattern() = default;
size_t CorsOriginPattern::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->protocol);
  seed = mojo::internal::WTFHash(seed, this->domain);
  seed = mojo::internal::WTFHash(seed, this->port);
  seed = mojo::internal::WTFHash(seed, this->domain_match_mode);
  seed = mojo::internal::WTFHash(seed, this->port_match_mode);
  seed = mojo::internal::WTFHash(seed, this->priority);
  return seed;
}

void CorsOriginPattern::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protocol"), this->protocol,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain"), this->domain,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port"), this->port,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "domain_match_mode"), this->domain_match_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CorsDomainMatchMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "port_match_mode"), this->port_match_mode,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CorsPortMatchMode>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "priority"), this->priority,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type CorsOriginAccessMatchPriority>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CorsOriginPattern::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CorsOriginAccessPatterns::CorsOriginAccessPatterns()
    : source_origin(),
      allow_patterns(),
      block_patterns() {}

CorsOriginAccessPatterns::CorsOriginAccessPatterns(
    const ::scoped_refptr<const ::blink::SecurityOrigin>& source_origin_in,
    ::blink::Vector<CorsOriginPatternPtr> allow_patterns_in,
    ::blink::Vector<CorsOriginPatternPtr> block_patterns_in)
    : source_origin(std::move(source_origin_in)),
      allow_patterns(std::move(allow_patterns_in)),
      block_patterns(std::move(block_patterns_in)) {}

CorsOriginAccessPatterns::~CorsOriginAccessPatterns() = default;

void CorsOriginAccessPatterns::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "source_origin"), this->source_origin,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::scoped_refptr<const ::blink::SecurityOrigin>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "allow_patterns"), this->allow_patterns,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<CorsOriginPatternPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "block_patterns"), this->block_patterns,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<CorsOriginPatternPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool CorsOriginAccessPatterns::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}


}  // network::mojom::blink


namespace mojo {


// static
bool StructTraits<::network::mojom::blink::CorsOriginPattern::DataView, ::network::mojom::blink::CorsOriginPatternPtr>::Read(
    ::network::mojom::blink::CorsOriginPattern::DataView input,
    ::network::mojom::blink::CorsOriginPatternPtr* output) {
  bool success = true;
  ::network::mojom::blink::CorsOriginPatternPtr result(::network::mojom::blink::CorsOriginPattern::New());
  
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadDomain(&result->domain))
        success = false;
      if (success)
        result->port = input.port();
      if (success && !input.ReadDomainMatchMode(&result->domain_match_mode))
        success = false;
      if (success && !input.ReadPortMatchMode(&result->port_match_mode))
        success = false;
      if (success && !input.ReadPriority(&result->priority))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::blink::CorsOriginAccessPatterns::DataView, ::network::mojom::blink::CorsOriginAccessPatternsPtr>::Read(
    ::network::mojom::blink::CorsOriginAccessPatterns::DataView input,
    ::network::mojom::blink::CorsOriginAccessPatternsPtr* output) {
  bool success = true;
  ::network::mojom::blink::CorsOriginAccessPatternsPtr result(::network::mojom::blink::CorsOriginAccessPatterns::New());
  
      if (success && !input.ReadSourceOrigin(&result->source_origin))
        success = false;
      if (success && !input.ReadAllowPatterns(&result->allow_patterns))
        success = false;
      if (success && !input.ReadBlockPatterns(&result->block_patterns))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace network::mojom::blink {




}  // network::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif