// services/network/public/mojom/cookie_manager.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_PARAMS_DATA_H_

#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

namespace mojo::internal {
class ValidationContext;
}


namespace network::mojom {
namespace internal {
class  CookieChangeListener_OnCookieChange_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CookieChangeInfo_Data> change;

 private:
  friend class mojo::internal::MessageFragment<CookieChangeListener_OnCookieChange_Params_Data>;

  CookieChangeListener_OnCookieChange_Params_Data();
  ~CookieChangeListener_OnCookieChange_Params_Data() = delete;
};
static_assert(sizeof(CookieChangeListener_OnCookieChange_Params_Data) == 16,
              "Bad sizeof(CookieChangeListener_OnCookieChange_Params_Data)");
class  CookieManager_GetAllCookies_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_GetAllCookies_Params_Data>;

  CookieManager_GetAllCookies_Params_Data();
  ~CookieManager_GetAllCookies_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_GetAllCookies_Params_Data) == 8,
              "Bad sizeof(CookieManager_GetAllCookies_Params_Data)");
class  CookieManager_GetAllCookies_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::CanonicalCookie_Data>>> cookies;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_GetAllCookies_ResponseParams_Data>;

  CookieManager_GetAllCookies_ResponseParams_Data();
  ~CookieManager_GetAllCookies_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_GetAllCookies_ResponseParams_Data) == 16,
              "Bad sizeof(CookieManager_GetAllCookies_ResponseParams_Data)");
class  CookieManager_GetAllCookiesWithAccessSemantics_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_GetAllCookiesWithAccessSemantics_Params_Data>;

  CookieManager_GetAllCookiesWithAccessSemantics_Params_Data();
  ~CookieManager_GetAllCookiesWithAccessSemantics_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_GetAllCookiesWithAccessSemantics_Params_Data) == 8,
              "Bad sizeof(CookieManager_GetAllCookiesWithAccessSemantics_Params_Data)");
class  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::CanonicalCookie_Data>>> cookies;
  mojo::internal::Pointer<mojo::internal::Array_Data<int32_t>> access_semantics_list;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data>;

  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data();
  ~CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data) == 24,
              "Bad sizeof(CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data)");
class  CookieManager_GetCookieList_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<internal::CookieOptions_Data> cookie_options;
  mojo::internal::Pointer<::network::mojom::internal::CookiePartitionKeyCollection_Data> cookie_partition_key_collection;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_GetCookieList_Params_Data>;

  CookieManager_GetCookieList_Params_Data();
  ~CookieManager_GetCookieList_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_GetCookieList_Params_Data) == 32,
              "Bad sizeof(CookieManager_GetCookieList_Params_Data)");
class  CookieManager_GetCookieList_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::CookieWithAccessResult_Data>>> cookies;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::CookieWithAccessResult_Data>>> excluded_cookies;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_GetCookieList_ResponseParams_Data>;

  CookieManager_GetCookieList_ResponseParams_Data();
  ~CookieManager_GetCookieList_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_GetCookieList_ResponseParams_Data) == 24,
              "Bad sizeof(CookieManager_GetCookieList_ResponseParams_Data)");
class  CookieManager_SetCanonicalCookie_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CanonicalCookie_Data> cookie;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> source_url;
  mojo::internal::Pointer<internal::CookieOptions_Data> cookie_options;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_SetCanonicalCookie_Params_Data>;

  CookieManager_SetCanonicalCookie_Params_Data();
  ~CookieManager_SetCanonicalCookie_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_SetCanonicalCookie_Params_Data) == 32,
              "Bad sizeof(CookieManager_SetCanonicalCookie_Params_Data)");
class  CookieManager_SetCanonicalCookie_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CookieAccessResult_Data> access_result;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_SetCanonicalCookie_ResponseParams_Data>;

  CookieManager_SetCanonicalCookie_ResponseParams_Data();
  ~CookieManager_SetCanonicalCookie_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_SetCanonicalCookie_ResponseParams_Data) == 16,
              "Bad sizeof(CookieManager_SetCanonicalCookie_ResponseParams_Data)");
class  CookieManager_DeleteCanonicalCookie_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CanonicalCookie_Data> cookie;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_DeleteCanonicalCookie_Params_Data>;

  CookieManager_DeleteCanonicalCookie_Params_Data();
  ~CookieManager_DeleteCanonicalCookie_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_DeleteCanonicalCookie_Params_Data) == 16,
              "Bad sizeof(CookieManager_DeleteCanonicalCookie_Params_Data)");
class  CookieManager_DeleteCanonicalCookie_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<CookieManager_DeleteCanonicalCookie_ResponseParams_Data>;

  CookieManager_DeleteCanonicalCookie_ResponseParams_Data();
  ~CookieManager_DeleteCanonicalCookie_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_DeleteCanonicalCookie_ResponseParams_Data) == 16,
              "Bad sizeof(CookieManager_DeleteCanonicalCookie_ResponseParams_Data)");
class  CookieManager_DeleteCookies_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::CookieDeletionFilter_Data> filter;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_DeleteCookies_Params_Data>;

  CookieManager_DeleteCookies_Params_Data();
  ~CookieManager_DeleteCookies_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_DeleteCookies_Params_Data) == 16,
              "Bad sizeof(CookieManager_DeleteCookies_Params_Data)");
class  CookieManager_DeleteCookies_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t num_deleted;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CookieManager_DeleteCookies_ResponseParams_Data>;

  CookieManager_DeleteCookies_ResponseParams_Data();
  ~CookieManager_DeleteCookies_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_DeleteCookies_ResponseParams_Data) == 16,
              "Bad sizeof(CookieManager_DeleteCookies_ResponseParams_Data)");
class  CookieManager_DeleteSessionOnlyCookies_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_DeleteSessionOnlyCookies_Params_Data>;

  CookieManager_DeleteSessionOnlyCookies_Params_Data();
  ~CookieManager_DeleteSessionOnlyCookies_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_DeleteSessionOnlyCookies_Params_Data) == 8,
              "Bad sizeof(CookieManager_DeleteSessionOnlyCookies_Params_Data)");
class  CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t num_deleted;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data>;

  CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data();
  ~CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data) == 16,
              "Bad sizeof(CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data)");
class  CookieManager_DeleteStaleSessionOnlyCookies_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_DeleteStaleSessionOnlyCookies_Params_Data>;

  CookieManager_DeleteStaleSessionOnlyCookies_Params_Data();
  ~CookieManager_DeleteStaleSessionOnlyCookies_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_DeleteStaleSessionOnlyCookies_Params_Data) == 8,
              "Bad sizeof(CookieManager_DeleteStaleSessionOnlyCookies_Params_Data)");
class  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t num_deleted;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data>;

  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data();
  ~CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data) == 16,
              "Bad sizeof(CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data)");
class  CookieManager_AddCookieChangeListener_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::url::mojom::internal::Url_Data> url;
  mojo::internal::Pointer<mojo::internal::String_Data> name;
  mojo::internal::Interface_Data listener;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_AddCookieChangeListener_Params_Data>;

  CookieManager_AddCookieChangeListener_Params_Data();
  ~CookieManager_AddCookieChangeListener_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_AddCookieChangeListener_Params_Data) == 32,
              "Bad sizeof(CookieManager_AddCookieChangeListener_Params_Data)");
class  CookieManager_AddGlobalChangeListener_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Interface_Data notification_pointer;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_AddGlobalChangeListener_Params_Data>;

  CookieManager_AddGlobalChangeListener_Params_Data();
  ~CookieManager_AddGlobalChangeListener_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_AddGlobalChangeListener_Params_Data) == 16,
              "Bad sizeof(CookieManager_AddGlobalChangeListener_Params_Data)");
class  CookieManager_CloneInterface_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Handle_Data new_interface;
  uint8_t padfinal_[4];

 private:
  friend class mojo::internal::MessageFragment<CookieManager_CloneInterface_Params_Data>;

  CookieManager_CloneInterface_Params_Data();
  ~CookieManager_CloneInterface_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_CloneInterface_Params_Data) == 16,
              "Bad sizeof(CookieManager_CloneInterface_Params_Data)");
class  CookieManager_FlushCookieStore_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_FlushCookieStore_Params_Data>;

  CookieManager_FlushCookieStore_Params_Data();
  ~CookieManager_FlushCookieStore_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_FlushCookieStore_Params_Data) == 8,
              "Bad sizeof(CookieManager_FlushCookieStore_Params_Data)");
class  CookieManager_FlushCookieStore_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_FlushCookieStore_ResponseParams_Data>;

  CookieManager_FlushCookieStore_ResponseParams_Data();
  ~CookieManager_FlushCookieStore_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_FlushCookieStore_ResponseParams_Data) == 8,
              "Bad sizeof(CookieManager_FlushCookieStore_ResponseParams_Data)");
class  CookieManager_AllowFileSchemeCookies_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t allow : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<CookieManager_AllowFileSchemeCookies_Params_Data>;

  CookieManager_AllowFileSchemeCookies_Params_Data();
  ~CookieManager_AllowFileSchemeCookies_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_AllowFileSchemeCookies_Params_Data) == 16,
              "Bad sizeof(CookieManager_AllowFileSchemeCookies_Params_Data)");
class  CookieManager_AllowFileSchemeCookies_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t success : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<CookieManager_AllowFileSchemeCookies_ResponseParams_Data>;

  CookieManager_AllowFileSchemeCookies_ResponseParams_Data();
  ~CookieManager_AllowFileSchemeCookies_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_AllowFileSchemeCookies_ResponseParams_Data) == 16,
              "Bad sizeof(CookieManager_AllowFileSchemeCookies_ResponseParams_Data)");
class  CookieManager_SetContentSettings_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t content_settings_type;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<::content_settings::mojom::internal::ContentSettingPatternSource_Data>>> settings;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_SetContentSettings_Params_Data>;

  CookieManager_SetContentSettings_Params_Data();
  ~CookieManager_SetContentSettings_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_SetContentSettings_Params_Data) == 24,
              "Bad sizeof(CookieManager_SetContentSettings_Params_Data)");
class  CookieManager_SetContentSettings_ResponseParams_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_SetContentSettings_ResponseParams_Data>;

  CookieManager_SetContentSettings_ResponseParams_Data();
  ~CookieManager_SetContentSettings_ResponseParams_Data() = delete;
};
static_assert(sizeof(CookieManager_SetContentSettings_ResponseParams_Data) == 8,
              "Bad sizeof(CookieManager_SetContentSettings_ResponseParams_Data)");
class  CookieManager_SetForceKeepSessionState_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_SetForceKeepSessionState_Params_Data>;

  CookieManager_SetForceKeepSessionState_Params_Data();
  ~CookieManager_SetForceKeepSessionState_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_SetForceKeepSessionState_Params_Data) == 8,
              "Bad sizeof(CookieManager_SetForceKeepSessionState_Params_Data)");
class  CookieManager_BlockThirdPartyCookies_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t block : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<CookieManager_BlockThirdPartyCookies_Params_Data>;

  CookieManager_BlockThirdPartyCookies_Params_Data();
  ~CookieManager_BlockThirdPartyCookies_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_BlockThirdPartyCookies_Params_Data) == 16,
              "Bad sizeof(CookieManager_BlockThirdPartyCookies_Params_Data)");
class  CookieManager_SetMitigationsEnabledFor3pcd_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enable : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<CookieManager_SetMitigationsEnabledFor3pcd_Params_Data>;

  CookieManager_SetMitigationsEnabledFor3pcd_Params_Data();
  ~CookieManager_SetMitigationsEnabledFor3pcd_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_SetMitigationsEnabledFor3pcd_Params_Data) == 16,
              "Bad sizeof(CookieManager_SetMitigationsEnabledFor3pcd_Params_Data)");
class  CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint8_t enable : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data>;

  CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data();
  ~CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data) == 16,
              "Bad sizeof(CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data)");
class  CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> delay;

 private:
  friend class mojo::internal::MessageFragment<CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data>;

  CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data();
  ~CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data() = delete;
};
static_assert(sizeof(CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data) == 16,
              "Bad sizeof(CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data)");

}  // namespace internal


class CookieChangeListener_OnCookieChange_ParamsDataView {
 public:
  CookieChangeListener_OnCookieChange_ParamsDataView() = default;

  CookieChangeListener_OnCookieChange_ParamsDataView(
      internal::CookieChangeListener_OnCookieChange_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetChangeDataView(
      CookieChangeInfoDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadChange(UserType* output) {
    
    auto* pointer = data_->change.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieChangeInfoDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieChangeListener_OnCookieChange_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_GetAllCookies_ParamsDataView {
 public:
  CookieManager_GetAllCookies_ParamsDataView() = default;

  CookieManager_GetAllCookies_ParamsDataView(
      internal::CookieManager_GetAllCookies_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::CookieManager_GetAllCookies_Params_Data* data_ = nullptr;
};


class CookieManager_GetAllCookies_ResponseParamsDataView {
 public:
  CookieManager_GetAllCookies_ResponseParamsDataView() = default;

  CookieManager_GetAllCookies_ResponseParamsDataView(
      internal::CookieManager_GetAllCookies_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookiesDataView(
      mojo::ArrayDataView<CanonicalCookieDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookies(UserType* output) {
    
    auto* pointer = data_->cookies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CanonicalCookieDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CookieManager_GetAllCookies_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_GetAllCookiesWithAccessSemantics_ParamsDataView {
 public:
  CookieManager_GetAllCookiesWithAccessSemantics_ParamsDataView() = default;

  CookieManager_GetAllCookiesWithAccessSemantics_ParamsDataView(
      internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::CookieManager_GetAllCookiesWithAccessSemantics_Params_Data* data_ = nullptr;
};


class CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsDataView {
 public:
  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsDataView() = default;

  CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsDataView(
      internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookiesDataView(
      mojo::ArrayDataView<CanonicalCookieDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookies(UserType* output) {
    
    auto* pointer = data_->cookies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CanonicalCookieDataView>>(
        pointer, output, message_);
  }
  inline void GetAccessSemanticsListDataView(
      mojo::ArrayDataView<CookieAccessSemantics>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessSemanticsList(UserType* output) {
    
    auto* pointer = data_->access_semantics_list.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CookieAccessSemantics>>(
        pointer, output, message_);
  }
 private:
  internal::CookieManager_GetAllCookiesWithAccessSemantics_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_GetCookieList_ParamsDataView {
 public:
  CookieManager_GetCookieList_ParamsDataView() = default;

  CookieManager_GetCookieList_ParamsDataView(
      internal::CookieManager_GetCookieList_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetCookieOptionsDataView(
      CookieOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieOptions(UserType* output) {
    
    auto* pointer = data_->cookie_options.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieOptionsDataView>(
        pointer, output, message_);
  }
  inline void GetCookiePartitionKeyCollectionDataView(
      ::network::mojom::CookiePartitionKeyCollectionDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookiePartitionKeyCollection(UserType* output) {
    
    auto* pointer = data_->cookie_partition_key_collection.Get();
    return mojo::internal::Deserialize<::network::mojom::CookiePartitionKeyCollectionDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieManager_GetCookieList_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_GetCookieList_ResponseParamsDataView {
 public:
  CookieManager_GetCookieList_ResponseParamsDataView() = default;

  CookieManager_GetCookieList_ResponseParamsDataView(
      internal::CookieManager_GetCookieList_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookiesDataView(
      mojo::ArrayDataView<CookieWithAccessResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookies(UserType* output) {
    
    auto* pointer = data_->cookies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
        pointer, output, message_);
  }
  inline void GetExcludedCookiesDataView(
      mojo::ArrayDataView<CookieWithAccessResultDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadExcludedCookies(UserType* output) {
    
    auto* pointer = data_->excluded_cookies.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::CookieWithAccessResultDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CookieManager_GetCookieList_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_SetCanonicalCookie_ParamsDataView {
 public:
  CookieManager_SetCanonicalCookie_ParamsDataView() = default;

  CookieManager_SetCanonicalCookie_ParamsDataView(
      internal::CookieManager_SetCanonicalCookie_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      CanonicalCookieDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookie(UserType* output) {
    
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::network::mojom::CanonicalCookieDataView>(
        pointer, output, message_);
  }
  inline void GetSourceUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSourceUrl(UserType* output) {
    
    auto* pointer = data_->source_url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetCookieOptionsDataView(
      CookieOptionsDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookieOptions(UserType* output) {
    
    auto* pointer = data_->cookie_options.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieOptionsDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieManager_SetCanonicalCookie_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_SetCanonicalCookie_ResponseParamsDataView {
 public:
  CookieManager_SetCanonicalCookie_ResponseParamsDataView() = default;

  CookieManager_SetCanonicalCookie_ResponseParamsDataView(
      internal::CookieManager_SetCanonicalCookie_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetAccessResultDataView(
      CookieAccessResultDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadAccessResult(UserType* output) {
    
    auto* pointer = data_->access_result.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieAccessResultDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieManager_SetCanonicalCookie_ResponseParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_DeleteCanonicalCookie_ParamsDataView {
 public:
  CookieManager_DeleteCanonicalCookie_ParamsDataView() = default;

  CookieManager_DeleteCanonicalCookie_ParamsDataView(
      internal::CookieManager_DeleteCanonicalCookie_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCookieDataView(
      CanonicalCookieDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCookie(UserType* output) {
    
    auto* pointer = data_->cookie.Get();
    return mojo::internal::Deserialize<::network::mojom::CanonicalCookieDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieManager_DeleteCanonicalCookie_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_DeleteCanonicalCookie_ResponseParamsDataView {
 public:
  CookieManager_DeleteCanonicalCookie_ResponseParamsDataView() = default;

  CookieManager_DeleteCanonicalCookie_ResponseParamsDataView(
      internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::CookieManager_DeleteCanonicalCookie_ResponseParams_Data* data_ = nullptr;
};


class CookieManager_DeleteCookies_ParamsDataView {
 public:
  CookieManager_DeleteCookies_ParamsDataView() = default;

  CookieManager_DeleteCookies_ParamsDataView(
      internal::CookieManager_DeleteCookies_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetFilterDataView(
      CookieDeletionFilterDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadFilter(UserType* output) {
    
    auto* pointer = data_->filter.Get();
    return mojo::internal::Deserialize<::network::mojom::CookieDeletionFilterDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieManager_DeleteCookies_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_DeleteCookies_ResponseParamsDataView {
 public:
  CookieManager_DeleteCookies_ResponseParamsDataView() = default;

  CookieManager_DeleteCookies_ResponseParamsDataView(
      internal::CookieManager_DeleteCookies_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t num_deleted() const {
    return data_->num_deleted;
  }
 private:
  internal::CookieManager_DeleteCookies_ResponseParams_Data* data_ = nullptr;
};


class CookieManager_DeleteSessionOnlyCookies_ParamsDataView {
 public:
  CookieManager_DeleteSessionOnlyCookies_ParamsDataView() = default;

  CookieManager_DeleteSessionOnlyCookies_ParamsDataView(
      internal::CookieManager_DeleteSessionOnlyCookies_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::CookieManager_DeleteSessionOnlyCookies_Params_Data* data_ = nullptr;
};


class CookieManager_DeleteSessionOnlyCookies_ResponseParamsDataView {
 public:
  CookieManager_DeleteSessionOnlyCookies_ResponseParamsDataView() = default;

  CookieManager_DeleteSessionOnlyCookies_ResponseParamsDataView(
      internal::CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t num_deleted() const {
    return data_->num_deleted;
  }
 private:
  internal::CookieManager_DeleteSessionOnlyCookies_ResponseParams_Data* data_ = nullptr;
};


class CookieManager_DeleteStaleSessionOnlyCookies_ParamsDataView {
 public:
  CookieManager_DeleteStaleSessionOnlyCookies_ParamsDataView() = default;

  CookieManager_DeleteStaleSessionOnlyCookies_ParamsDataView(
      internal::CookieManager_DeleteStaleSessionOnlyCookies_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::CookieManager_DeleteStaleSessionOnlyCookies_Params_Data* data_ = nullptr;
};


class CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsDataView {
 public:
  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsDataView() = default;

  CookieManager_DeleteStaleSessionOnlyCookies_ResponseParamsDataView(
      internal::CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t num_deleted() const {
    return data_->num_deleted;
  }
 private:
  internal::CookieManager_DeleteStaleSessionOnlyCookies_ResponseParams_Data* data_ = nullptr;
};


class CookieManager_AddCookieChangeListener_ParamsDataView {
 public:
  CookieManager_AddCookieChangeListener_ParamsDataView() = default;

  CookieManager_AddCookieChangeListener_ParamsDataView(
      internal::CookieManager_AddCookieChangeListener_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetUrlDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadUrl(UserType* output) {
    
    auto* pointer = data_->url.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, message_);
  }
  inline void GetNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadName(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `name` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadName` instead "
    "of `ReadName if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  template <typename UserType>
  UserType TakeListener() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
            &data_->listener, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CookieManager_AddCookieChangeListener_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_AddGlobalChangeListener_ParamsDataView {
 public:
  CookieManager_AddGlobalChangeListener_ParamsDataView() = default;

  CookieManager_AddGlobalChangeListener_ParamsDataView(
      internal::CookieManager_AddGlobalChangeListener_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeNotificationPointer() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfacePtrDataView<::network::mojom::CookieChangeListenerInterfaceBase>>(
            &data_->notification_pointer, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CookieManager_AddGlobalChangeListener_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_CloneInterface_ParamsDataView {
 public:
  CookieManager_CloneInterface_ParamsDataView() = default;

  CookieManager_CloneInterface_ParamsDataView(
      internal::CookieManager_CloneInterface_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  UserType TakeNewInterface() {
    UserType result;
    bool ret =
        mojo::internal::Deserialize<mojo::InterfaceRequestDataView<::network::mojom::CookieManagerInterfaceBase>>(
            &data_->new_interface, &result, message_);
    DCHECK(ret);
    return result;
  }
 private:
  internal::CookieManager_CloneInterface_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_FlushCookieStore_ParamsDataView {
 public:
  CookieManager_FlushCookieStore_ParamsDataView() = default;

  CookieManager_FlushCookieStore_ParamsDataView(
      internal::CookieManager_FlushCookieStore_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::CookieManager_FlushCookieStore_Params_Data* data_ = nullptr;
};


class CookieManager_FlushCookieStore_ResponseParamsDataView {
 public:
  CookieManager_FlushCookieStore_ResponseParamsDataView() = default;

  CookieManager_FlushCookieStore_ResponseParamsDataView(
      internal::CookieManager_FlushCookieStore_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::CookieManager_FlushCookieStore_ResponseParams_Data* data_ = nullptr;
};


class CookieManager_AllowFileSchemeCookies_ParamsDataView {
 public:
  CookieManager_AllowFileSchemeCookies_ParamsDataView() = default;

  CookieManager_AllowFileSchemeCookies_ParamsDataView(
      internal::CookieManager_AllowFileSchemeCookies_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool allow() const {
    return data_->allow;
  }
 private:
  internal::CookieManager_AllowFileSchemeCookies_Params_Data* data_ = nullptr;
};


class CookieManager_AllowFileSchemeCookies_ResponseParamsDataView {
 public:
  CookieManager_AllowFileSchemeCookies_ResponseParamsDataView() = default;

  CookieManager_AllowFileSchemeCookies_ResponseParamsDataView(
      internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool success() const {
    return data_->success;
  }
 private:
  internal::CookieManager_AllowFileSchemeCookies_ResponseParams_Data* data_ = nullptr;
};


class CookieManager_SetContentSettings_ParamsDataView {
 public:
  CookieManager_SetContentSettings_ParamsDataView() = default;

  CookieManager_SetContentSettings_ParamsDataView(
      internal::CookieManager_SetContentSettings_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadContentSettingsType(UserType* output) const {
    auto data_value = data_->content_settings_type;
    return mojo::internal::Deserialize<::content_settings::mojom::ContentSettingsType>(
        data_value, output);
  }
  ::content_settings::mojom::ContentSettingsType content_settings_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::content_settings::mojom::ContentSettingsType>(data_->content_settings_type));
  }
  inline void GetSettingsDataView(
      mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSettings(UserType* output) {
    
    auto* pointer = data_->settings.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>>(
        pointer, output, message_);
  }
 private:
  internal::CookieManager_SetContentSettings_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CookieManager_SetContentSettings_ResponseParamsDataView {
 public:
  CookieManager_SetContentSettings_ResponseParamsDataView() = default;

  CookieManager_SetContentSettings_ResponseParamsDataView(
      internal::CookieManager_SetContentSettings_ResponseParams_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::CookieManager_SetContentSettings_ResponseParams_Data* data_ = nullptr;
};


class CookieManager_SetForceKeepSessionState_ParamsDataView {
 public:
  CookieManager_SetForceKeepSessionState_ParamsDataView() = default;

  CookieManager_SetForceKeepSessionState_ParamsDataView(
      internal::CookieManager_SetForceKeepSessionState_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
 private:
  internal::CookieManager_SetForceKeepSessionState_Params_Data* data_ = nullptr;
};


class CookieManager_BlockThirdPartyCookies_ParamsDataView {
 public:
  CookieManager_BlockThirdPartyCookies_ParamsDataView() = default;

  CookieManager_BlockThirdPartyCookies_ParamsDataView(
      internal::CookieManager_BlockThirdPartyCookies_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool block() const {
    return data_->block;
  }
 private:
  internal::CookieManager_BlockThirdPartyCookies_Params_Data* data_ = nullptr;
};


class CookieManager_SetMitigationsEnabledFor3pcd_ParamsDataView {
 public:
  CookieManager_SetMitigationsEnabledFor3pcd_ParamsDataView() = default;

  CookieManager_SetMitigationsEnabledFor3pcd_ParamsDataView(
      internal::CookieManager_SetMitigationsEnabledFor3pcd_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enable() const {
    return data_->enable;
  }
 private:
  internal::CookieManager_SetMitigationsEnabledFor3pcd_Params_Data* data_ = nullptr;
};


class CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsDataView {
 public:
  CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsDataView() = default;

  CookieManager_SetTrackingProtectionEnabledFor3pcd_ParamsDataView(
      internal::CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enable() const {
    return data_->enable;
  }
 private:
  internal::CookieManager_SetTrackingProtectionEnabledFor3pcd_Params_Data* data_ = nullptr;
};


class CookieManager_SetPreCommitCallbackDelayForTesting_ParamsDataView {
 public:
  CookieManager_SetPreCommitCallbackDelayForTesting_ParamsDataView() = default;

  CookieManager_SetPreCommitCallbackDelayForTesting_ParamsDataView(
      internal::CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDelayDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadDelay(UserType* output) {
    
    auto* pointer = data_->delay.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, message_);
  }
 private:
  internal::CookieManager_SetPreCommitCallbackDelayForTesting_Params_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};

inline void CookieChangeListener_OnCookieChange_ParamsDataView::GetChangeDataView(
    CookieChangeInfoDataView* output) {
  auto pointer = data_->change.Get();
  *output = CookieChangeInfoDataView(pointer, message_);
}




inline void CookieManager_GetAllCookies_ResponseParamsDataView::GetCookiesDataView(
    mojo::ArrayDataView<CanonicalCookieDataView>* output) {
  auto pointer = data_->cookies.Get();
  *output = mojo::ArrayDataView<CanonicalCookieDataView>(pointer, message_);
}




inline void CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsDataView::GetCookiesDataView(
    mojo::ArrayDataView<CanonicalCookieDataView>* output) {
  auto pointer = data_->cookies.Get();
  *output = mojo::ArrayDataView<CanonicalCookieDataView>(pointer, message_);
}
inline void CookieManager_GetAllCookiesWithAccessSemantics_ResponseParamsDataView::GetAccessSemanticsListDataView(
    mojo::ArrayDataView<CookieAccessSemantics>* output) {
  auto pointer = data_->access_semantics_list.Get();
  *output = mojo::ArrayDataView<CookieAccessSemantics>(pointer, message_);
}


inline void CookieManager_GetCookieList_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CookieManager_GetCookieList_ParamsDataView::GetCookieOptionsDataView(
    CookieOptionsDataView* output) {
  auto pointer = data_->cookie_options.Get();
  *output = CookieOptionsDataView(pointer, message_);
}
inline void CookieManager_GetCookieList_ParamsDataView::GetCookiePartitionKeyCollectionDataView(
    ::network::mojom::CookiePartitionKeyCollectionDataView* output) {
  auto pointer = data_->cookie_partition_key_collection.Get();
  *output = ::network::mojom::CookiePartitionKeyCollectionDataView(pointer, message_);
}


inline void CookieManager_GetCookieList_ResponseParamsDataView::GetCookiesDataView(
    mojo::ArrayDataView<CookieWithAccessResultDataView>* output) {
  auto pointer = data_->cookies.Get();
  *output = mojo::ArrayDataView<CookieWithAccessResultDataView>(pointer, message_);
}
inline void CookieManager_GetCookieList_ResponseParamsDataView::GetExcludedCookiesDataView(
    mojo::ArrayDataView<CookieWithAccessResultDataView>* output) {
  auto pointer = data_->excluded_cookies.Get();
  *output = mojo::ArrayDataView<CookieWithAccessResultDataView>(pointer, message_);
}


inline void CookieManager_SetCanonicalCookie_ParamsDataView::GetCookieDataView(
    CanonicalCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = CanonicalCookieDataView(pointer, message_);
}
inline void CookieManager_SetCanonicalCookie_ParamsDataView::GetSourceUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->source_url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CookieManager_SetCanonicalCookie_ParamsDataView::GetCookieOptionsDataView(
    CookieOptionsDataView* output) {
  auto pointer = data_->cookie_options.Get();
  *output = CookieOptionsDataView(pointer, message_);
}


inline void CookieManager_SetCanonicalCookie_ResponseParamsDataView::GetAccessResultDataView(
    CookieAccessResultDataView* output) {
  auto pointer = data_->access_result.Get();
  *output = CookieAccessResultDataView(pointer, message_);
}


inline void CookieManager_DeleteCanonicalCookie_ParamsDataView::GetCookieDataView(
    CanonicalCookieDataView* output) {
  auto pointer = data_->cookie.Get();
  *output = CanonicalCookieDataView(pointer, message_);
}




inline void CookieManager_DeleteCookies_ParamsDataView::GetFilterDataView(
    CookieDeletionFilterDataView* output) {
  auto pointer = data_->filter.Get();
  *output = CookieDeletionFilterDataView(pointer, message_);
}












inline void CookieManager_AddCookieChangeListener_ParamsDataView::GetUrlDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->url.Get();
  *output = ::url::mojom::UrlDataView(pointer, message_);
}
inline void CookieManager_AddCookieChangeListener_ParamsDataView::GetNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->name.Get();
  *output = mojo::StringDataView(pointer, message_);
}














inline void CookieManager_SetContentSettings_ParamsDataView::GetSettingsDataView(
    mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>* output) {
  auto pointer = data_->settings.Get();
  *output = mojo::ArrayDataView<::content_settings::mojom::ContentSettingPatternSourceDataView>(pointer, message_);
}












inline void CookieManager_SetPreCommitCallbackDelayForTesting_ParamsDataView::GetDelayDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->delay.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, message_);
}



}  // network::mojom

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_PARAMS_DATA_H_