// services/network/public/mojom/cookie_manager.mojom-blink-test-utils.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_TEST_UTILS_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_TEST_UTILS_H_

#include "services/network/public/mojom/cookie_manager.mojom-blink.h"
#include "third_party/blink/public/platform/web_common.h"


namespace network::mojom::blink {


class BLINK_PLATFORM_EXPORT CookieChangeListenerInterceptorForTesting : public CookieChangeListener {
  virtual CookieChangeListener* GetForwardingInterface() = 0;
  void OnCookieChange(CookieChangeInfoPtr change) override;
};
class BLINK_PLATFORM_EXPORT CookieChangeListenerAsyncWaiter {
 public:
  explicit CookieChangeListenerAsyncWaiter(CookieChangeListener* proxy);

  CookieChangeListenerAsyncWaiter(const CookieChangeListenerAsyncWaiter&) = delete;
  CookieChangeListenerAsyncWaiter& operator=(const CookieChangeListenerAsyncWaiter&) = delete;

  ~CookieChangeListenerAsyncWaiter();

 private:
  CookieChangeListener* const proxy_;
};


class BLINK_PLATFORM_EXPORT CookieManagerInterceptorForTesting : public CookieManager {
  virtual CookieManager* GetForwardingInterface() = 0;
  void GetAllCookies(GetAllCookiesCallback callback) override;
  void GetAllCookiesWithAccessSemantics(GetAllCookiesWithAccessSemanticsCallback callback) override;
  void GetCookieList(const ::blink::KURL& url, CookieOptionsPtr cookie_options, ::network::mojom::blink::CookiePartitionKeyCollectionPtr cookie_partition_key_collection, GetCookieListCallback callback) override;
  void SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::blink::KURL& source_url, CookieOptionsPtr cookie_options, SetCanonicalCookieCallback callback) override;
  void DeleteCanonicalCookie(const ::net::CanonicalCookie& cookie, DeleteCanonicalCookieCallback callback) override;
  void DeleteCookies(CookieDeletionFilterPtr filter, DeleteCookiesCallback callback) override;
  void DeleteSessionOnlyCookies(DeleteSessionOnlyCookiesCallback callback) override;
  void DeleteStaleSessionOnlyCookies(DeleteStaleSessionOnlyCookiesCallback callback) override;
  void AddCookieChangeListener(const ::blink::KURL& url, const ::blink::String& name, ::mojo::PendingRemote<CookieChangeListener> listener) override;
  void AddGlobalChangeListener(::mojo::PendingRemote<CookieChangeListener> notification_pointer) override;
  void CloneInterface(::mojo::PendingReceiver<CookieManager> new_interface) override;
  void FlushCookieStore(FlushCookieStoreCallback callback) override;
  void AllowFileSchemeCookies(bool allow, AllowFileSchemeCookiesCallback callback) override;
  void SetContentSettings(::content_settings::mojom::blink::ContentSettingsType content_settings_type, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings, SetContentSettingsCallback callback) override;
  void SetForceKeepSessionState() override;
  void BlockThirdPartyCookies(bool block) override;
  void SetMitigationsEnabledFor3pcd(bool enable) override;
  void SetTrackingProtectionEnabledFor3pcd(bool enable) override;
  void SetPreCommitCallbackDelayForTesting(::base::TimeDelta delay) override;
};
class BLINK_PLATFORM_EXPORT CookieManagerAsyncWaiter {
 public:
  explicit CookieManagerAsyncWaiter(CookieManager* proxy);

  CookieManagerAsyncWaiter(const CookieManagerAsyncWaiter&) = delete;
  CookieManagerAsyncWaiter& operator=(const CookieManagerAsyncWaiter&) = delete;

  ~CookieManagerAsyncWaiter();
  void GetAllCookies(
      ::blink::Vector<::net::CanonicalCookie>* out_cookies);
  ::blink::Vector<::net::CanonicalCookie> GetAllCookies();
  void GetAllCookiesWithAccessSemantics(
      ::blink::Vector<::net::CanonicalCookie>* out_cookies, ::blink::Vector<CookieAccessSemantics>* out_access_semantics_list);
  
  void GetCookieList(
      const ::blink::KURL& url, CookieOptionsPtr cookie_options, ::network::mojom::blink::CookiePartitionKeyCollectionPtr cookie_partition_key_collection, ::blink::Vector<CookieWithAccessResultPtr>* out_cookies, ::blink::Vector<CookieWithAccessResultPtr>* out_excluded_cookies);
  
  void SetCanonicalCookie(
      const ::net::CanonicalCookie& cookie, const ::blink::KURL& source_url, CookieOptionsPtr cookie_options, CookieAccessResultPtr* out_access_result);
  CookieAccessResultPtr SetCanonicalCookie(const ::net::CanonicalCookie& cookie, const ::blink::KURL& source_url, CookieOptionsPtr cookie_options);
  void DeleteCanonicalCookie(
      const ::net::CanonicalCookie& cookie, bool* out_success);
  bool DeleteCanonicalCookie(const ::net::CanonicalCookie& cookie);
  void DeleteCookies(
      CookieDeletionFilterPtr filter, uint32_t* out_num_deleted);
  uint32_t DeleteCookies(CookieDeletionFilterPtr filter);
  void DeleteSessionOnlyCookies(
      uint32_t* out_num_deleted);
  uint32_t DeleteSessionOnlyCookies();
  void DeleteStaleSessionOnlyCookies(
      uint32_t* out_num_deleted);
  uint32_t DeleteStaleSessionOnlyCookies();
  void FlushCookieStore(
      );
  
  void AllowFileSchemeCookies(
      bool allow, bool* out_success);
  bool AllowFileSchemeCookies(bool allow);
  void SetContentSettings(
      ::content_settings::mojom::blink::ContentSettingsType content_settings_type, ::blink::Vector<::content_settings::mojom::blink::ContentSettingPatternSourcePtr> settings);
  

 private:
  CookieManager* const proxy_;
};




}  // network::mojom::blink

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_COOKIE_MANAGER_MOJOM_BLINK_TEST_UTILS_H_