// services/network/public/mojom/connection_endpoint_metadata.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ENDPOINT_METADATA_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ENDPOINT_METADATA_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/network/public/mojom/connection_endpoint_metadata.mojom-features.h"  // IWYU pragma: export
#include "services/network/public/mojom/connection_endpoint_metadata.mojom-shared.h"  // IWYU pragma: export
#include "services/network/public/mojom/connection_endpoint_metadata.mojom-forward.h"  // IWYU pragma: export
#include <string>
#include <vector>




#include "services/network/public/cpp/connection_endpoint_metadata_mojom_traits.h"




namespace network::mojom {








class  ConnectionEndpointMetadata {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ConnectionEndpointMetadata, T>::value>;
  using DataView = ConnectionEndpointMetadataDataView;
  using Data_ = internal::ConnectionEndpointMetadata_Data;

  template <typename... Args>
  static ConnectionEndpointMetadataPtr New(Args&&... args) {
    return ConnectionEndpointMetadataPtr(
        std::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ConnectionEndpointMetadataPtr From(const U& u) {
    return mojo::TypeConverter<ConnectionEndpointMetadataPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ConnectionEndpointMetadata>::Convert(*this);
  }


  ConnectionEndpointMetadata();

  ConnectionEndpointMetadata(
      std::vector<std::string> supported_protocol_alpns,
      std::vector<uint8_t> ech_config_list,
      const std::string& target_name,
      std::vector<std::vector<uint8_t>> trust_anchor_ids);


  ~ConnectionEndpointMetadata();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ConnectionEndpointMetadataPtr>
  ConnectionEndpointMetadataPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ConnectionEndpointMetadata::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename T, ConnectionEndpointMetadata::EnableIfSame<T>* = nullptr>
  bool operator==(const T& rhs) const { return Equals(rhs); }

  template <typename T, ConnectionEndpointMetadata::EnableIfSame<T>* = nullptr>
  bool operator!=(const T& rhs) const { return !operator==(rhs); }

  template <mojo::internal::SendValidation send_validation, typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConnectionEndpointMetadata::DataView, std::vector<uint8_t>, send_validation>(input);
  }

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ConnectionEndpointMetadata::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ConnectionEndpointMetadata::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ConnectionEndpointMetadata_UnserializedMessageContext<
            UserType, ConnectionEndpointMetadata::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    mojo::Message message;
    return mojo::internal::DeserializeImpl<ConnectionEndpointMetadata::DataView>(
        message, data, data_num_bytes, output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(base::span<const uint8_t> input,
                          UserType* output) {
    return ConnectionEndpointMetadata::Deserialize(
        input.empty() ? nullptr : input.data(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ConnectionEndpointMetadata_UnserializedMessageContext<
            UserType, ConnectionEndpointMetadata::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ConnectionEndpointMetadata::DataView>(
        input, input.payload(), input.payload_num_bytes(), output, Validate);
  }

  
  std::vector<std::string> supported_protocol_alpns;
  
  std::vector<uint8_t> ech_config_list;
  
  std::string target_name;
  
  std::vector<std::vector<uint8_t>> trust_anchor_ids;

  // Serialise this struct into a trace.
  void WriteIntoTrace(perfetto::TracedValue traced_context) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ConnectionEndpointMetadata::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ConnectionEndpointMetadata::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ConnectionEndpointMetadata::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ConnectionEndpointMetadata::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
ConnectionEndpointMetadataPtr ConnectionEndpointMetadata::Clone() const {
  return New(
      mojo::Clone(supported_protocol_alpns),
      mojo::Clone(ech_config_list),
      mojo::Clone(target_name),
      mojo::Clone(trust_anchor_ids)
  );
}

template <typename T, ConnectionEndpointMetadata::EnableIfSame<T>*>
bool ConnectionEndpointMetadata::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->supported_protocol_alpns, other_struct.supported_protocol_alpns))
    return false;
  if (!mojo::Equals(this->ech_config_list, other_struct.ech_config_list))
    return false;
  if (!mojo::Equals(this->target_name, other_struct.target_name))
    return false;
  if (!mojo::Equals(this->trust_anchor_ids, other_struct.trust_anchor_ids))
    return false;
  return true;
}

template <typename T, ConnectionEndpointMetadata::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (lhs.supported_protocol_alpns < rhs.supported_protocol_alpns)
    return true;
  if (rhs.supported_protocol_alpns < lhs.supported_protocol_alpns)
    return false;
  if (lhs.ech_config_list < rhs.ech_config_list)
    return true;
  if (rhs.ech_config_list < lhs.ech_config_list)
    return false;
  if (lhs.target_name < rhs.target_name)
    return true;
  if (rhs.target_name < lhs.target_name)
    return false;
  if (lhs.trust_anchor_ids < rhs.trust_anchor_ids)
    return true;
  if (rhs.trust_anchor_ids < lhs.trust_anchor_ids)
    return false;
  return false;
}


}  // network::mojom

namespace mojo {


template <>
struct  StructTraits<::network::mojom::ConnectionEndpointMetadata::DataView,
                                         ::network::mojom::ConnectionEndpointMetadataPtr> {
  static bool IsNull(const ::network::mojom::ConnectionEndpointMetadataPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ConnectionEndpointMetadataPtr* output) { output->reset(); }

  static const decltype(::network::mojom::ConnectionEndpointMetadata::supported_protocol_alpns)& supported_protocol_alpns(
      const ::network::mojom::ConnectionEndpointMetadataPtr& input) {
    return input->supported_protocol_alpns;
  }

  static const decltype(::network::mojom::ConnectionEndpointMetadata::ech_config_list)& ech_config_list(
      const ::network::mojom::ConnectionEndpointMetadataPtr& input) {
    return input->ech_config_list;
  }

  static const decltype(::network::mojom::ConnectionEndpointMetadata::target_name)& target_name(
      const ::network::mojom::ConnectionEndpointMetadataPtr& input) {
    return input->target_name;
  }

  static const decltype(::network::mojom::ConnectionEndpointMetadata::trust_anchor_ids)& trust_anchor_ids(
      const ::network::mojom::ConnectionEndpointMetadataPtr& input) {
    return input->trust_anchor_ids;
  }

  static bool Read(::network::mojom::ConnectionEndpointMetadata::DataView input, ::network::mojom::ConnectionEndpointMetadataPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_ENDPOINT_METADATA_MOJOM_H_