// services/network/public/mojom/connection_change_observer_client.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_SEND_VALIDATION_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_SEND_VALIDATION_H_

#include "services/network/public/mojom/connection_change_observer_client.mojom-shared-internal.h"

#include "services/network/public/mojom/connection_change_observer_client.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::network::mojom::NetworkChangeEvent, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::network::mojom::ConnectionKeepAliveConfigDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::ConnectionKeepAliveConfigDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::network::mojom::internal::ConnectionKeepAliveConfig_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->idle_timeout_in_seconds = Traits::idle_timeout_in_seconds(input);

      fragment->ping_interval_in_seconds = Traits::ping_interval_in_seconds(input);

      fragment->enable_connection_keep_alive = Traits::enable_connection_keep_alive(input);

      decltype(Traits::quic_connection_options(input)) in_quic_connection_options = Traits::quic_connection_options(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->quic_connection_options)::BaseType> quic_connection_options_fragment(
              fragment.message());
      
      mojo::internal::Serialize<mojo::StringDataView, send_validation>(
        in_quic_connection_options,
        quic_connection_options_fragment);

      fragment->quic_connection_options.Set(
          quic_connection_options_fragment.is_null() ? nullptr : quic_connection_options_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->quic_connection_options.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null quic_connection_options in ConnectionKeepAliveConfig struct");
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CONNECTION_CHANGE_OBSERVER_CLIENT_MOJOM_SEND_VALIDATION_H_