// services/network/public/mojom/cert_verifier_service.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_DATA_VIEW_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/network/public/mojom/cert_verifier_service.mojom-shared-internal.h"
#include "mojo/public/mojom/base/byte_string.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "services/network/public/mojom/network_param.mojom-shared.h"
#include "services/network/public/mojom/url_loader_factory.mojom-shared.h"


namespace cert_verifier::mojom {
class RequestParamsDataView;

class CertVerifierConfigDataView;



}  // cert_verifier::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::cert_verifier::mojom::RequestParamsDataView> {
  using Data = ::cert_verifier::mojom::internal::RequestParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::cert_verifier::mojom::CertVerifierConfigDataView> {
  using Data = ::cert_verifier::mojom::internal::CertVerifierConfig_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace cert_verifier::mojom {
// Interface base classes. They are used for type safety check.
class URLLoaderFactoryConnectorInterfaceBase {};

using URLLoaderFactoryConnectorPtrDataView =
    mojo::InterfacePtrDataView<URLLoaderFactoryConnectorInterfaceBase>;
using URLLoaderFactoryConnectorRequestDataView =
    mojo::InterfaceRequestDataView<URLLoaderFactoryConnectorInterfaceBase>;
using URLLoaderFactoryConnectorAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<URLLoaderFactoryConnectorInterfaceBase>;
using URLLoaderFactoryConnectorAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<URLLoaderFactoryConnectorInterfaceBase>;
class CertVerifierServiceInterfaceBase {};

using CertVerifierServicePtrDataView =
    mojo::InterfacePtrDataView<CertVerifierServiceInterfaceBase>;
using CertVerifierServiceRequestDataView =
    mojo::InterfaceRequestDataView<CertVerifierServiceInterfaceBase>;
using CertVerifierServiceAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertVerifierServiceInterfaceBase>;
using CertVerifierServiceAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertVerifierServiceInterfaceBase>;
class CertVerifierServiceClientInterfaceBase {};

using CertVerifierServiceClientPtrDataView =
    mojo::InterfacePtrDataView<CertVerifierServiceClientInterfaceBase>;
using CertVerifierServiceClientRequestDataView =
    mojo::InterfaceRequestDataView<CertVerifierServiceClientInterfaceBase>;
using CertVerifierServiceClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertVerifierServiceClientInterfaceBase>;
using CertVerifierServiceClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertVerifierServiceClientInterfaceBase>;
class CertVerifierRequestInterfaceBase {};

using CertVerifierRequestPtrDataView =
    mojo::InterfacePtrDataView<CertVerifierRequestInterfaceBase>;
using CertVerifierRequestRequestDataView =
    mojo::InterfaceRequestDataView<CertVerifierRequestInterfaceBase>;
using CertVerifierRequestAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<CertVerifierRequestInterfaceBase>;
using CertVerifierRequestAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<CertVerifierRequestInterfaceBase>;


class RequestParamsDataView {
 public:
  RequestParamsDataView() = default;

  RequestParamsDataView(
      internal::RequestParams_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetCertificateDataView(
      ::network::mojom::X509CertificateDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadCertificate(UserType* output) {
    
    auto* pointer = data_->certificate.Get();
    return mojo::internal::Deserialize<::network::mojom::X509CertificateDataView>(
        pointer, output, message_);
  }
  inline void GetHostnameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadHostname(UserType* output) {
    
    auto* pointer = data_->hostname.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  int32_t flags() const {
    return data_->flags;
  }
  inline void GetOcspResponseDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadOcspResponse(UserType* output) {
    
    auto* pointer = data_->ocsp_response.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
  inline void GetSctListDataView(
      ::mojo_base::mojom::ByteStringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadSctList(UserType* output) {
    
    auto* pointer = data_->sct_list.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::ByteStringDataView>(
        pointer, output, message_);
  }
 private:
  internal::RequestParams_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class CertVerifierConfigDataView {
 public:
  CertVerifierConfigDataView() = default;

  CertVerifierConfigDataView(
      internal::CertVerifierConfig_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool enable_rev_checking() const {
    return data_->enable_rev_checking;
  }
  bool require_rev_checking_local_anchors() const {
    return data_->require_rev_checking_local_anchors;
  }
  bool enable_sha1_local_anchors() const {
    return data_->enable_sha1_local_anchors;
  }
 private:
  internal::CertVerifierConfig_Data* data_ = nullptr;
};


}  // cert_verifier::mojom

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CERT_VERIFIER_SERVICE_MOJOM_DATA_VIEW_H_