// services/metrics/public/mojom/ukm_interface.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class SingularUkmInterfacePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ukm.mojom.SingularUkmInterface', scope);
  }
}

/** @interface */
export class SingularUkmInterfaceInterface {
  
  /**
   * @param { !UkmEntry } entry
   */

  submit(entry) {}
}

/**
 * @implements { SingularUkmInterfaceInterface }
 */
export class SingularUkmInterfaceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!SingularUkmInterfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          SingularUkmInterfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!SingularUkmInterfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !UkmEntry } entry
   */

  submit(
      entry) {
    this.proxy.sendMessage(
        0,
        SingularUkmInterface_Submit_ParamsSpec.$,
        null,
        [
          entry
        ],
        false);
  }
}

/**
 * An object which receives request messages for the SingularUkmInterface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class SingularUkmInterfaceReceiver {
  /**
   * @param {!SingularUkmInterfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!SingularUkmInterfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        SingularUkmInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SingularUkmInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        SingularUkmInterface_Submit_ParamsSpec.$,
        null,
        impl.submit.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class SingularUkmInterface {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ukm.mojom.SingularUkmInterface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!SingularUkmInterfaceRemote}
   */
  static getRemote() {
    let remote = new SingularUkmInterfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the SingularUkmInterface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class SingularUkmInterfaceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      SingularUkmInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!SingularUkmInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.submit =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        SingularUkmInterface_Submit_ParamsSpec.$,
        null,
        this.submit.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UkmRecorderClientInterfacePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ukm.mojom.UkmRecorderClientInterface', scope);
  }
}

/** @interface */
export class UkmRecorderClientInterfaceInterface {
  
  /**
   * @param { !UkmRecorderParameters } params
   */

  setParameters(params) {}
}

/**
 * @implements { UkmRecorderClientInterfaceInterface }
 */
export class UkmRecorderClientInterfaceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UkmRecorderClientInterfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UkmRecorderClientInterfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UkmRecorderClientInterfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !UkmRecorderParameters } params
   */

  setParameters(
      params) {
    this.proxy.sendMessage(
        0,
        UkmRecorderClientInterface_SetParameters_ParamsSpec.$,
        null,
        [
          params
        ],
        false);
  }
}

/**
 * An object which receives request messages for the UkmRecorderClientInterface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UkmRecorderClientInterfaceReceiver {
  /**
   * @param {!UkmRecorderClientInterfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UkmRecorderClientInterfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UkmRecorderClientInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UkmRecorderClientInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UkmRecorderClientInterface_SetParameters_ParamsSpec.$,
        null,
        impl.setParameters.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UkmRecorderClientInterface {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ukm.mojom.UkmRecorderClientInterface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UkmRecorderClientInterfaceRemote}
   */
  static getRemote() {
    let remote = new UkmRecorderClientInterfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UkmRecorderClientInterface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UkmRecorderClientInterfaceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UkmRecorderClientInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UkmRecorderClientInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setParameters =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UkmRecorderClientInterface_SetParameters_ParamsSpec.$,
        null,
        this.setParameters.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UkmRecorderInterfacePendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ukm.mojom.UkmRecorderInterface', scope);
  }
}

/** @interface */
export class UkmRecorderInterfaceInterface {
  
  /**
   * @param { !UkmEntry } entry
   */

  addEntry(entry) {}
  
  /**
   * @param { !bigint } sourceId
   * @param { !string } url
   */

  updateSourceURL(sourceId, url) {}
}

/**
 * @implements { UkmRecorderInterfaceInterface }
 */
export class UkmRecorderInterfaceRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UkmRecorderInterfacePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UkmRecorderInterfacePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UkmRecorderInterfacePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !UkmEntry } entry
   */

  addEntry(
      entry) {
    this.proxy.sendMessage(
        0,
        UkmRecorderInterface_AddEntry_ParamsSpec.$,
        null,
        [
          entry
        ],
        false);
  }

  
  /**
   * @param { !bigint } sourceId
   * @param { !string } url
   */

  updateSourceURL(
      sourceId,
      url) {
    this.proxy.sendMessage(
        1,
        UkmRecorderInterface_UpdateSourceURL_ParamsSpec.$,
        null,
        [
          sourceId,
          url
        ],
        false);
  }
}

/**
 * An object which receives request messages for the UkmRecorderInterface
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UkmRecorderInterfaceReceiver {
  /**
   * @param {!UkmRecorderInterfaceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UkmRecorderInterfaceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UkmRecorderInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UkmRecorderInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UkmRecorderInterface_AddEntry_ParamsSpec.$,
        null,
        impl.addEntry.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        UkmRecorderInterface_UpdateSourceURL_ParamsSpec.$,
        null,
        impl.updateSourceURL.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UkmRecorderInterface {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ukm.mojom.UkmRecorderInterface";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UkmRecorderInterfaceRemote}
   */
  static getRemote() {
    let remote = new UkmRecorderInterfaceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UkmRecorderInterface
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UkmRecorderInterfaceCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UkmRecorderInterfaceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UkmRecorderInterfaceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addEntry =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UkmRecorderInterface_AddEntry_ParamsSpec.$,
        null,
        this.addEntry.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.updateSourceURL =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        UkmRecorderInterface_UpdateSourceURL_ParamsSpec.$,
        null,
        this.updateSourceURL.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class UkmRecorderFactoryPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'ukm.mojom.UkmRecorderFactory', scope);
  }
}

/** @interface */
export class UkmRecorderFactoryInterface {
  
  /**
   * @param { !UkmRecorderInterfacePendingReceiver } receiver
   * @param { ?UkmRecorderClientInterfaceRemote } clientRemote
   */

  createUkmRecorder(receiver, clientRemote) {}
}

/**
 * @implements { UkmRecorderFactoryInterface }
 */
export class UkmRecorderFactoryRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!UkmRecorderFactoryPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          UkmRecorderFactoryPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!UkmRecorderFactoryPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !UkmRecorderInterfacePendingReceiver } receiver
   * @param { ?UkmRecorderClientInterfaceRemote } clientRemote
   */

  createUkmRecorder(
      receiver,
      clientRemote) {
    this.proxy.sendMessage(
        0,
        UkmRecorderFactory_CreateUkmRecorder_ParamsSpec.$,
        null,
        [
          receiver,
          clientRemote
        ],
        false);
  }
}

/**
 * An object which receives request messages for the UkmRecorderFactory
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class UkmRecorderFactoryReceiver {
  /**
   * @param {!UkmRecorderFactoryInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!UkmRecorderFactoryRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        UkmRecorderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UkmRecorderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        UkmRecorderFactory_CreateUkmRecorder_ParamsSpec.$,
        null,
        impl.createUkmRecorder.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class UkmRecorderFactory {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "ukm.mojom.UkmRecorderFactory";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!UkmRecorderFactoryRemote}
   */
  static getRemote() {
    let remote = new UkmRecorderFactoryRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the UkmRecorderFactory
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class UkmRecorderFactoryCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      UkmRecorderFactoryRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!UkmRecorderFactoryRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.createUkmRecorder =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        UkmRecorderFactory_CreateUkmRecorder_ParamsSpec.$,
        null,
        this.createUkmRecorder.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UkmEntrySpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UkmRecorderParametersSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const SingularUkmInterface_Submit_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UkmRecorderClientInterface_SetParameters_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UkmRecorderInterface_AddEntry_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UkmRecorderInterface_UpdateSourceURL_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const UkmRecorderFactory_CreateUkmRecorder_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    UkmEntrySpec.$,
    'UkmEntry',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventHash', 8,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'metrics', 16,
        0,
        mojo.internal.Map(mojo.internal.Uint64, mojo.internal.Int64, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class UkmEntry {
  constructor() {
    /** @type { !bigint } */
    this.sourceId;
    /** @type { !bigint } */
    this.eventHash;
    /** @type { !Map<!bigint, !bigint> } */
    this.metrics;
  }
}



mojo.internal.Struct(
    UkmRecorderParametersSpec.$,
    'UkmRecorderParameters',
    [
      mojo.internal.StructField(
        'isEnabled', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'eventHashBypassList', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint64, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UkmRecorderParameters {
  constructor() {
    /** @type { !boolean } */
    this.isEnabled;
    /** @type { !Array<!bigint> } */
    this.eventHashBypassList;
  }
}



mojo.internal.Struct(
    SingularUkmInterface_Submit_ParamsSpec.$,
    'SingularUkmInterface_Submit_Params',
    [
      mojo.internal.StructField(
        'entry', 0,
        0,
        UkmEntrySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class SingularUkmInterface_Submit_Params {
  constructor() {
    /** @type { !UkmEntry } */
    this.entry;
  }
}



mojo.internal.Struct(
    UkmRecorderClientInterface_SetParameters_ParamsSpec.$,
    'UkmRecorderClientInterface_SetParameters_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        UkmRecorderParametersSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UkmRecorderClientInterface_SetParameters_Params {
  constructor() {
    /** @type { !UkmRecorderParameters } */
    this.params;
  }
}



mojo.internal.Struct(
    UkmRecorderInterface_AddEntry_ParamsSpec.$,
    'UkmRecorderInterface_AddEntry_Params',
    [
      mojo.internal.StructField(
        'entry', 0,
        0,
        UkmEntrySpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class UkmRecorderInterface_AddEntry_Params {
  constructor() {
    /** @type { !UkmEntry } */
    this.entry;
  }
}



mojo.internal.Struct(
    UkmRecorderInterface_UpdateSourceURL_ParamsSpec.$,
    'UkmRecorderInterface_UpdateSourceURL_Params',
    [
      mojo.internal.StructField(
        'sourceId', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'url', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UkmRecorderInterface_UpdateSourceURL_Params {
  constructor() {
    /** @type { !bigint } */
    this.sourceId;
    /** @type { !string } */
    this.url;
  }
}



mojo.internal.Struct(
    UkmRecorderFactory_CreateUkmRecorder_ParamsSpec.$,
    'UkmRecorderFactory_CreateUkmRecorder_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(UkmRecorderInterfacePendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'clientRemote', 4,
        0,
        mojo.internal.InterfaceProxy(UkmRecorderClientInterfaceRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class UkmRecorderFactory_CreateUkmRecorder_Params {
  constructor() {
    /** @type { !UkmRecorderInterfacePendingReceiver } */
    this.receiver;
    /** @type { (UkmRecorderClientInterfaceRemote|undefined) } */
    this.clientRemote;
  }
}

