// services/media_session/public/mojom/media_controller.mojom-webui.ts is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '//resources/mojo/mojo/public/js/bindings.js';

import {
  MediaSessionActionSpec as mediaSession_mojom_MediaSessionActionSpec,
  MediaSessionAction as mediaSession_mojom_MediaSessionAction,
  MediaSessionImageTypeSpec as mediaSession_mojom_MediaSessionImageTypeSpec,
  MediaSessionImageType as mediaSession_mojom_MediaSessionImageType,
  MediaImageBitmapSpec as mediaSession_mojom_MediaImageBitmapSpec,
  MediaImageBitmap as mediaSession_mojom_MediaImageBitmap,
  MediaMetadataSpec as mediaSession_mojom_MediaMetadataSpec,
  MediaMetadata as mediaSession_mojom_MediaMetadata,
  MediaPositionSpec as mediaSession_mojom_MediaPositionSpec,
  MediaPosition as mediaSession_mojom_MediaPosition,
  MediaSessionInfoSpec as mediaSession_mojom_MediaSessionInfoSpec,
  MediaSessionInfo as mediaSession_mojom_MediaSessionInfo
} from './media_session.mojom-webui.js';
import {
  TimeDeltaSpec as mojoBase_mojom_TimeDeltaSpec,
  TimeDelta as mojoBase_mojom_TimeDelta
} from '//resources/mojo/mojo/public/mojom/base/time.mojom-webui.js';
import {
  UnguessableTokenSpec as mojoBase_mojom_UnguessableTokenSpec,
  UnguessableToken as mojoBase_mojom_UnguessableToken
} from '//resources/mojo/mojo/public/mojom/base/unguessable_token.mojom-webui.js';







export type MediaControllerManagerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<MediaControllerManagerPendingReceiver>;

export class MediaControllerManagerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<MediaControllerManager> {

  handle: mojo.internal.interfaceSupport.Endpoint<MediaControllerManagerPendingReceiver>;
  constructor(handle: MojoHandle|MediaControllerManagerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media_session.mojom.MediaControllerManager',
        scope);
  }
}

export interface MediaControllerManagerInterface {
  createMediaControllerForSession(receiver: MediaControllerPendingReceiver, requestId: mojoBase_mojom_UnguessableToken): void;
  createActiveMediaController(receiver: MediaControllerPendingReceiver): void;
  suspendAllSessions(): void;
}

export class MediaControllerManagerRemote implements MediaControllerManagerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<MediaControllerManagerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<MediaControllerManagerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|MediaControllerManagerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaControllerManagerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  createMediaControllerForSession(
      receiver: MediaControllerPendingReceiver,
      requestId: mojoBase_mojom_UnguessableToken): void {
    this.proxy.sendMessage(
        0,
        MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
        null,
        [
          receiver,
          requestId
        ],
        false);
  }

  createActiveMediaController(
      receiver: MediaControllerPendingReceiver): void {
    this.proxy.sendMessage(
        1,
        MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }

  suspendAllSessions(): void {
    this.proxy.sendMessage(
        2,
        MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaControllerManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaControllerManagerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaControllerManagerRemote, MediaControllerManagerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaControllerManagerRemote, MediaControllerManagerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: MediaControllerManagerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaControllerManagerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
        null,
        impl.createMediaControllerForSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
        null,
        impl.createActiveMediaController.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
        null,
        impl.suspendAllSessions.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaControllerManager {
  static get $interfaceName(): string {
    return "media_session.mojom.MediaControllerManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): MediaControllerManagerRemote {
    let remote = new MediaControllerManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the MediaControllerManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaControllerManagerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaControllerManagerRemote, MediaControllerManagerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaControllerManagerRemote, MediaControllerManagerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  createMediaControllerForSession: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  createActiveMediaController: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  suspendAllSessions: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaControllerManagerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.createMediaControllerForSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
        null,
        this.createMediaControllerForSession.createReceiverHandler(false /* expectsResponse */),
        false);
    this.createActiveMediaController =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
        null,
        this.createActiveMediaController.createReceiverHandler(false /* expectsResponse */),
        false);
    this.suspendAllSessions =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
        null,
        this.suspendAllSessions.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type MediaControllerPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<MediaControllerPendingReceiver>;

export class MediaControllerPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<MediaController> {

  handle: mojo.internal.interfaceSupport.Endpoint<MediaControllerPendingReceiver>;
  constructor(handle: MojoHandle|MediaControllerPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media_session.mojom.MediaController',
        scope);
  }
}

export interface MediaControllerInterface {
  suspend(): void;
  resume(): void;
  stop(): void;
  toggleSuspendResume(): void;
  addObserver(observer: MediaControllerObserverRemote): void;
  previousTrack(): void;
  nextTrack(): void;
  seek(seekTime: mojoBase_mojom_TimeDelta): void;
  observeImages(type: mediaSession_mojom_MediaSessionImageType, minimumSizePx: number, desiredSizePx: number, observer: MediaControllerImageObserverRemote): void;
  seekTo(seekTime: mojoBase_mojom_TimeDelta): void;
  scrubTo(seekTime: mojoBase_mojom_TimeDelta): void;
  enterPictureInPicture(): void;
  exitPictureInPicture(): void;
  setAudioSinkId(id: (string | null)): void;
  toggleMicrophone(): void;
  toggleCamera(): void;
  hangUp(): void;
  raise(): void;
  setMute(mute: boolean): void;
  requestMediaRemoting(): void;
  enterAutoPictureInPicture(): void;
  skipAd(): void;
}

export class MediaControllerRemote implements MediaControllerInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<MediaControllerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<MediaControllerPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|MediaControllerPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaControllerPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  suspend(): void {
    this.proxy.sendMessage(
        0,
        MediaController_Suspend_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  resume(): void {
    this.proxy.sendMessage(
        1,
        MediaController_Resume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  stop(): void {
    this.proxy.sendMessage(
        2,
        MediaController_Stop_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  toggleSuspendResume(): void {
    this.proxy.sendMessage(
        3,
        MediaController_ToggleSuspendResume_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  addObserver(
      observer: MediaControllerObserverRemote): void {
    this.proxy.sendMessage(
        4,
        MediaController_AddObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  previousTrack(): void {
    this.proxy.sendMessage(
        5,
        MediaController_PreviousTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  nextTrack(): void {
    this.proxy.sendMessage(
        6,
        MediaController_NextTrack_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  seek(
      seekTime: mojoBase_mojom_TimeDelta): void {
    this.proxy.sendMessage(
        7,
        MediaController_Seek_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  observeImages(
      type: mediaSession_mojom_MediaSessionImageType,
      minimumSizePx: number,
      desiredSizePx: number,
      observer: MediaControllerImageObserverRemote): void {
    this.proxy.sendMessage(
        8,
        MediaController_ObserveImages_ParamsSpec.$,
        null,
        [
          type,
          minimumSizePx,
          desiredSizePx,
          observer
        ],
        false);
  }

  seekTo(
      seekTime: mojoBase_mojom_TimeDelta): void {
    this.proxy.sendMessage(
        9,
        MediaController_SeekTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  scrubTo(
      seekTime: mojoBase_mojom_TimeDelta): void {
    this.proxy.sendMessage(
        10,
        MediaController_ScrubTo_ParamsSpec.$,
        null,
        [
          seekTime
        ],
        false);
  }

  enterPictureInPicture(): void {
    this.proxy.sendMessage(
        11,
        MediaController_EnterPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  exitPictureInPicture(): void {
    this.proxy.sendMessage(
        12,
        MediaController_ExitPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setAudioSinkId(
      id: (string | null)): void {
    this.proxy.sendMessage(
        13,
        MediaController_SetAudioSinkId_ParamsSpec.$,
        null,
        [
          id
        ],
        false);
  }

  toggleMicrophone(): void {
    this.proxy.sendMessage(
        14,
        MediaController_ToggleMicrophone_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  toggleCamera(): void {
    this.proxy.sendMessage(
        15,
        MediaController_ToggleCamera_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  hangUp(): void {
    this.proxy.sendMessage(
        16,
        MediaController_HangUp_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  raise(): void {
    this.proxy.sendMessage(
        17,
        MediaController_Raise_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  setMute(
      mute: boolean): void {
    this.proxy.sendMessage(
        18,
        MediaController_SetMute_ParamsSpec.$,
        null,
        [
          mute
        ],
        false);
  }

  requestMediaRemoting(): void {
    this.proxy.sendMessage(
        19,
        MediaController_RequestMediaRemoting_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  enterAutoPictureInPicture(): void {
    this.proxy.sendMessage(
        20,
        MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  skipAd(): void {
    this.proxy.sendMessage(
        21,
        MediaController_SkipAd_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaController
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaControllerReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaControllerRemote, MediaControllerPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaControllerRemote, MediaControllerPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: MediaControllerInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaControllerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaController_Suspend_ParamsSpec.$,
        null,
        impl.suspend.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaController_Resume_ParamsSpec.$,
        null,
        impl.resume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaController_Stop_ParamsSpec.$,
        null,
        impl.stop.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaController_ToggleSuspendResume_ParamsSpec.$,
        null,
        impl.toggleSuspendResume.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaController_AddObserver_ParamsSpec.$,
        null,
        impl.addObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        MediaController_PreviousTrack_ParamsSpec.$,
        null,
        impl.previousTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        MediaController_NextTrack_ParamsSpec.$,
        null,
        impl.nextTrack.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        MediaController_Seek_ParamsSpec.$,
        null,
        impl.seek.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        MediaController_ObserveImages_ParamsSpec.$,
        null,
        impl.observeImages.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        MediaController_SeekTo_ParamsSpec.$,
        null,
        impl.seekTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        MediaController_ScrubTo_ParamsSpec.$,
        null,
        impl.scrubTo.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        MediaController_EnterPictureInPicture_ParamsSpec.$,
        null,
        impl.enterPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        MediaController_ExitPictureInPicture_ParamsSpec.$,
        null,
        impl.exitPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        MediaController_SetAudioSinkId_ParamsSpec.$,
        null,
        impl.setAudioSinkId.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        14,
        MediaController_ToggleMicrophone_ParamsSpec.$,
        null,
        impl.toggleMicrophone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        15,
        MediaController_ToggleCamera_ParamsSpec.$,
        null,
        impl.toggleCamera.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        16,
        MediaController_HangUp_ParamsSpec.$,
        null,
        impl.hangUp.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        17,
        MediaController_Raise_ParamsSpec.$,
        null,
        impl.raise.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        18,
        MediaController_SetMute_ParamsSpec.$,
        null,
        impl.setMute.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        19,
        MediaController_RequestMediaRemoting_ParamsSpec.$,
        null,
        impl.requestMediaRemoting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        20,
        MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        impl.enterAutoPictureInPicture.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        21,
        MediaController_SkipAd_ParamsSpec.$,
        null,
        impl.skipAd.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaController {
  static get $interfaceName(): string {
    return "media_session.mojom.MediaController";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): MediaControllerRemote {
    let remote = new MediaControllerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the MediaController
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaControllerCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaControllerRemote, MediaControllerPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaControllerRemote, MediaControllerPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  suspend: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  resume: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  stop: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  toggleSuspendResume: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  addObserver: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  previousTrack: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  nextTrack: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  seek: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  observeImages: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  seekTo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  scrubTo: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  enterPictureInPicture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  exitPictureInPicture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setAudioSinkId: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  toggleMicrophone: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  toggleCamera: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  hangUp: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  raise: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  setMute: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  requestMediaRemoting: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  enterAutoPictureInPicture: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  skipAd: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaControllerRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.suspend =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaController_Suspend_ParamsSpec.$,
        null,
        this.suspend.createReceiverHandler(false /* expectsResponse */),
        false);
    this.resume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaController_Resume_ParamsSpec.$,
        null,
        this.resume.createReceiverHandler(false /* expectsResponse */),
        false);
    this.stop =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaController_Stop_ParamsSpec.$,
        null,
        this.stop.createReceiverHandler(false /* expectsResponse */),
        false);
    this.toggleSuspendResume =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaController_ToggleSuspendResume_ParamsSpec.$,
        null,
        this.toggleSuspendResume.createReceiverHandler(false /* expectsResponse */),
        false);
    this.addObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaController_AddObserver_ParamsSpec.$,
        null,
        this.addObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    this.previousTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        MediaController_PreviousTrack_ParamsSpec.$,
        null,
        this.previousTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    this.nextTrack =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        MediaController_NextTrack_ParamsSpec.$,
        null,
        this.nextTrack.createReceiverHandler(false /* expectsResponse */),
        false);
    this.seek =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        MediaController_Seek_ParamsSpec.$,
        null,
        this.seek.createReceiverHandler(false /* expectsResponse */),
        false);
    this.observeImages =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        MediaController_ObserveImages_ParamsSpec.$,
        null,
        this.observeImages.createReceiverHandler(false /* expectsResponse */),
        false);
    this.seekTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        MediaController_SeekTo_ParamsSpec.$,
        null,
        this.seekTo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.scrubTo =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        MediaController_ScrubTo_ParamsSpec.$,
        null,
        this.scrubTo.createReceiverHandler(false /* expectsResponse */),
        false);
    this.enterPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        MediaController_EnterPictureInPicture_ParamsSpec.$,
        null,
        this.enterPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.exitPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        MediaController_ExitPictureInPicture_ParamsSpec.$,
        null,
        this.exitPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setAudioSinkId =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        MediaController_SetAudioSinkId_ParamsSpec.$,
        null,
        this.setAudioSinkId.createReceiverHandler(false /* expectsResponse */),
        false);
    this.toggleMicrophone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        14,
        MediaController_ToggleMicrophone_ParamsSpec.$,
        null,
        this.toggleMicrophone.createReceiverHandler(false /* expectsResponse */),
        false);
    this.toggleCamera =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        15,
        MediaController_ToggleCamera_ParamsSpec.$,
        null,
        this.toggleCamera.createReceiverHandler(false /* expectsResponse */),
        false);
    this.hangUp =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        16,
        MediaController_HangUp_ParamsSpec.$,
        null,
        this.hangUp.createReceiverHandler(false /* expectsResponse */),
        false);
    this.raise =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        17,
        MediaController_Raise_ParamsSpec.$,
        null,
        this.raise.createReceiverHandler(false /* expectsResponse */),
        false);
    this.setMute =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        18,
        MediaController_SetMute_ParamsSpec.$,
        null,
        this.setMute.createReceiverHandler(false /* expectsResponse */),
        false);
    this.requestMediaRemoting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        19,
        MediaController_RequestMediaRemoting_ParamsSpec.$,
        null,
        this.requestMediaRemoting.createReceiverHandler(false /* expectsResponse */),
        false);
    this.enterAutoPictureInPicture =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        20,
        MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
        null,
        this.enterAutoPictureInPicture.createReceiverHandler(false /* expectsResponse */),
        false);
    this.skipAd =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        21,
        MediaController_SkipAd_ParamsSpec.$,
        null,
        this.skipAd.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type MediaControllerObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<MediaControllerObserverPendingReceiver>;

export class MediaControllerObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<MediaControllerObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<MediaControllerObserverPendingReceiver>;
  constructor(handle: MojoHandle|MediaControllerObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media_session.mojom.MediaControllerObserver',
        scope);
  }
}

export interface MediaControllerObserverInterface {
  mediaSessionInfoChanged(info: (mediaSession_mojom_MediaSessionInfo | null)): void;
  mediaSessionMetadataChanged(metadata: (mediaSession_mojom_MediaMetadata | null)): void;
  mediaSessionActionsChanged(action: mediaSession_mojom_MediaSessionAction[]): void;
  mediaSessionChanged(requestId: (mojoBase_mojom_UnguessableToken | null)): void;
  mediaSessionPositionChanged(position: (mediaSession_mojom_MediaPosition | null)): void;
}

export class MediaControllerObserverRemote implements MediaControllerObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<MediaControllerObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<MediaControllerObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|MediaControllerObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaControllerObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  mediaSessionInfoChanged(
      info: (mediaSession_mojom_MediaSessionInfo | null)): void {
    this.proxy.sendMessage(
        0,
        MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        [
          info
        ],
        false);
  }

  mediaSessionMetadataChanged(
      metadata: (mediaSession_mojom_MediaMetadata | null)): void {
    this.proxy.sendMessage(
        1,
        MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        [
          metadata
        ],
        false);
  }

  mediaSessionActionsChanged(
      action: mediaSession_mojom_MediaSessionAction[]): void {
    this.proxy.sendMessage(
        2,
        MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        [
          action
        ],
        false);
  }

  mediaSessionChanged(
      requestId: (mojoBase_mojom_UnguessableToken | null)): void {
    this.proxy.sendMessage(
        3,
        MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
        null,
        [
          requestId
        ],
        false);
  }

  mediaSessionPositionChanged(
      position: (mediaSession_mojom_MediaPosition | null)): void {
    this.proxy.sendMessage(
        4,
        MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        [
          position
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaControllerObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaControllerObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaControllerObserverRemote, MediaControllerObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaControllerObserverRemote, MediaControllerObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: MediaControllerObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaControllerObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        impl.mediaSessionInfoChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        impl.mediaSessionMetadataChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        impl.mediaSessionActionsChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
        null,
        impl.mediaSessionChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        impl.mediaSessionPositionChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaControllerObserver {
  static get $interfaceName(): string {
    return "media_session.mojom.MediaControllerObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): MediaControllerObserverRemote {
    let remote = new MediaControllerObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the MediaControllerObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaControllerObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaControllerObserverRemote, MediaControllerObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaControllerObserverRemote, MediaControllerObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  mediaSessionInfoChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  mediaSessionMetadataChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  mediaSessionActionsChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  mediaSessionChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  mediaSessionPositionChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaControllerObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.mediaSessionInfoChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
        null,
        this.mediaSessionInfoChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.mediaSessionMetadataChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
        null,
        this.mediaSessionMetadataChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.mediaSessionActionsChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
        null,
        this.mediaSessionActionsChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.mediaSessionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
        null,
        this.mediaSessionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.mediaSessionPositionChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
        null,
        this.mediaSessionPositionChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}


export type MediaControllerImageObserverPendingReceiverEndpoint =
  mojo.internal.interfaceSupport.Endpoint<MediaControllerImageObserverPendingReceiver>;

export class MediaControllerImageObserverPendingReceiver implements
    mojo.internal.interfaceSupport.PendingReceiver<MediaControllerImageObserver> {

  handle: mojo.internal.interfaceSupport.Endpoint<MediaControllerImageObserverPendingReceiver>;
  constructor(handle: MojoHandle|MediaControllerImageObserverPendingReceiverEndpoint) {
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  bindInBrowser(scope: string = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        'media_session.mojom.MediaControllerImageObserver',
        scope);
  }
}

export interface MediaControllerImageObserverInterface {
  mediaControllerImageChanged(type: mediaSession_mojom_MediaSessionImageType, bitmap: (mediaSession_mojom_MediaImageBitmap | null)): void;
  mediaControllerChapterImageChanged(index: number, bitmap: (mediaSession_mojom_MediaImageBitmap | null)): void;
}

export class MediaControllerImageObserverRemote implements MediaControllerImageObserverInterface {
  private proxy: mojo.internal.interfaceSupport.InterfaceRemoteBase<MediaControllerImageObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<MediaControllerImageObserverPendingReceiver>;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor(
      handle?: MojoHandle|MediaControllerImageObserverPendingReceiverEndpoint) {
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          MediaControllerImageObserverPendingReceiver, handle);

    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  mediaControllerImageChanged(
      type: mediaSession_mojom_MediaSessionImageType,
      bitmap: (mediaSession_mojom_MediaImageBitmap | null)): void {
    this.proxy.sendMessage(
        0,
        MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
        null,
        [
          type,
          bitmap
        ],
        false);
  }

  mediaControllerChapterImageChanged(
      index: number,
      bitmap: (mediaSession_mojom_MediaImageBitmap | null)): void {
    this.proxy.sendMessage(
        1,
        MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
        null,
        [
          index,
          bitmap
        ],
        false);
  }
};

/**
 * An object which receives request messages for the MediaControllerImageObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class MediaControllerImageObserverReceiver {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaControllerImageObserverRemote, MediaControllerImageObserverPendingReceiver>;

  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaControllerImageObserverRemote, MediaControllerImageObserverPendingReceiver>;

  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;


  constructor(impl: MediaControllerImageObserverInterface) {

    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        MediaControllerImageObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
        null,
        impl.mediaControllerImageChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
        null,
        impl.mediaControllerChapterImageChanged.bind(impl),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class MediaControllerImageObserver {
  static get $interfaceName(): string {
    return "media_session.mojom.MediaControllerImageObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   */
  static getRemote(): MediaControllerImageObserverRemote {
    let remote = new MediaControllerImageObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}

/**
 * An object which receives request messages for the MediaControllerImageObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class MediaControllerImageObserverCallbackRouter {
  private helper_internal_: mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<
    MediaControllerImageObserverRemote, MediaControllerImageObserverPendingReceiver>;
  $: mojo.internal.interfaceSupport.InterfaceReceiverHelper<
    MediaControllerImageObserverRemote, MediaControllerImageObserverPendingReceiver>;
  router_: mojo.internal.interfaceSupport.CallbackRouter;

  mediaControllerImageChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  mediaControllerChapterImageChanged: mojo.internal.interfaceSupport.InterfaceCallbackReceiver;
  onConnectionError: mojo.internal.interfaceSupport.ConnectionErrorEventRouter;

  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      MediaControllerImageObserverRemote);

    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    this.mediaControllerImageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
        null,
        this.mediaControllerImageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.mediaControllerChapterImageChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
        null,
        this.mediaControllerChapterImageChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param id An ID returned by a prior call to addListener.
   * @return True iff the identified listener was found and removed.
   */
  removeListener(id: number): boolean {
    return this.router_.removeListener(id);
  }
}

export const MediaControllerManager_CreateMediaControllerForSession_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaControllerManager_CreateActiveMediaController_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaControllerManager_SuspendAllSessions_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_Suspend_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_Resume_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_Stop_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_ToggleSuspendResume_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_AddObserver_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_PreviousTrack_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_NextTrack_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_Seek_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_ObserveImages_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_SeekTo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_ScrubTo_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_EnterPictureInPicture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_ExitPictureInPicture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_SetAudioSinkId_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_ToggleMicrophone_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_ToggleCamera_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_HangUp_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_Raise_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_SetMute_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_RequestMediaRemoting_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_EnterAutoPictureInPicture_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaController_SkipAd_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaControllerObserver_MediaSessionChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };

export const MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec: { $: mojo.internal.MojomType } =
    { $: {} as unknown as mojo.internal.MojomType };




export interface MediaControllerManager_CreateMediaControllerForSession_ParamsMojoType {
  receiver: MediaControllerPendingReceiver;
  requestId: mojoBase_mojom_UnguessableToken;
}


export type MediaControllerManager_CreateMediaControllerForSession_Params = MediaControllerManager_CreateMediaControllerForSession_ParamsMojoType;
mojo.internal.Struct<MediaControllerManager_CreateMediaControllerForSession_ParamsMojoType>(
    MediaControllerManager_CreateMediaControllerForSession_ParamsSpec.$,
    'MediaControllerManager_CreateMediaControllerForSession_Params',
    [
      mojo.internal.StructField<MediaControllerManager_CreateMediaControllerForSession_ParamsMojoType, MediaControllerPendingReceiver>(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(MediaControllerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaControllerManager_CreateMediaControllerForSession_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'requestId', 8,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface MediaControllerManager_CreateActiveMediaController_ParamsMojoType {
  receiver: MediaControllerPendingReceiver;
}


export type MediaControllerManager_CreateActiveMediaController_Params = MediaControllerManager_CreateActiveMediaController_ParamsMojoType;
mojo.internal.Struct<MediaControllerManager_CreateActiveMediaController_ParamsMojoType>(
    MediaControllerManager_CreateActiveMediaController_ParamsSpec.$,
    'MediaControllerManager_CreateActiveMediaController_Params',
    [
      mojo.internal.StructField<MediaControllerManager_CreateActiveMediaController_ParamsMojoType, MediaControllerPendingReceiver>(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(MediaControllerPendingReceiver),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaControllerManager_SuspendAllSessions_ParamsMojoType {
}


export type MediaControllerManager_SuspendAllSessions_Params = MediaControllerManager_SuspendAllSessions_ParamsMojoType;
mojo.internal.Struct<MediaControllerManager_SuspendAllSessions_ParamsMojoType>(
    MediaControllerManager_SuspendAllSessions_ParamsSpec.$,
    'MediaControllerManager_SuspendAllSessions_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_Suspend_ParamsMojoType {
}


export type MediaController_Suspend_Params = MediaController_Suspend_ParamsMojoType;
mojo.internal.Struct<MediaController_Suspend_ParamsMojoType>(
    MediaController_Suspend_ParamsSpec.$,
    'MediaController_Suspend_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_Resume_ParamsMojoType {
}


export type MediaController_Resume_Params = MediaController_Resume_ParamsMojoType;
mojo.internal.Struct<MediaController_Resume_ParamsMojoType>(
    MediaController_Resume_ParamsSpec.$,
    'MediaController_Resume_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_Stop_ParamsMojoType {
}


export type MediaController_Stop_Params = MediaController_Stop_ParamsMojoType;
mojo.internal.Struct<MediaController_Stop_ParamsMojoType>(
    MediaController_Stop_ParamsSpec.$,
    'MediaController_Stop_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_ToggleSuspendResume_ParamsMojoType {
}


export type MediaController_ToggleSuspendResume_Params = MediaController_ToggleSuspendResume_ParamsMojoType;
mojo.internal.Struct<MediaController_ToggleSuspendResume_ParamsMojoType>(
    MediaController_ToggleSuspendResume_ParamsSpec.$,
    'MediaController_ToggleSuspendResume_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_AddObserver_ParamsMojoType {
  observer: MediaControllerObserverRemote;
}


export type MediaController_AddObserver_Params = MediaController_AddObserver_ParamsMojoType;
mojo.internal.Struct<MediaController_AddObserver_ParamsMojoType>(
    MediaController_AddObserver_ParamsSpec.$,
    'MediaController_AddObserver_Params',
    [
      mojo.internal.StructField<MediaController_AddObserver_ParamsMojoType, MediaControllerObserverRemote>(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(MediaControllerObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaController_PreviousTrack_ParamsMojoType {
}


export type MediaController_PreviousTrack_Params = MediaController_PreviousTrack_ParamsMojoType;
mojo.internal.Struct<MediaController_PreviousTrack_ParamsMojoType>(
    MediaController_PreviousTrack_ParamsSpec.$,
    'MediaController_PreviousTrack_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_NextTrack_ParamsMojoType {
}


export type MediaController_NextTrack_Params = MediaController_NextTrack_ParamsMojoType;
mojo.internal.Struct<MediaController_NextTrack_ParamsMojoType>(
    MediaController_NextTrack_ParamsSpec.$,
    'MediaController_NextTrack_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_Seek_ParamsMojoType {
  seekTime: mojoBase_mojom_TimeDelta;
}


export type MediaController_Seek_Params = MediaController_Seek_ParamsMojoType;
mojo.internal.Struct<MediaController_Seek_ParamsMojoType>(
    MediaController_Seek_ParamsSpec.$,
    'MediaController_Seek_Params',
    [
      mojo.internal.StructField<MediaController_Seek_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaController_ObserveImages_ParamsMojoType {
  type: mediaSession_mojom_MediaSessionImageType;
  minimumSizePx: number;
  desiredSizePx: number;
  observer: MediaControllerImageObserverRemote;
}


export type MediaController_ObserveImages_Params = MediaController_ObserveImages_ParamsMojoType;
mojo.internal.Struct<MediaController_ObserveImages_ParamsMojoType>(
    MediaController_ObserveImages_ParamsSpec.$,
    'MediaController_ObserveImages_Params',
    [
      mojo.internal.StructField<MediaController_ObserveImages_ParamsMojoType, mediaSession_mojom_MediaSessionImageType>(
        'type', 0,
        0,
        mediaSession_mojom_MediaSessionImageTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaController_ObserveImages_ParamsMojoType, number>(
        'minimumSizePx', 4,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaController_ObserveImages_ParamsMojoType, number>(
        'desiredSizePx', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaController_ObserveImages_ParamsMojoType, MediaControllerImageObserverRemote>(
        'observer', 12,
        0,
        mojo.internal.InterfaceProxy(MediaControllerImageObserverRemote),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 32],]);





export interface MediaController_SeekTo_ParamsMojoType {
  seekTime: mojoBase_mojom_TimeDelta;
}


export type MediaController_SeekTo_Params = MediaController_SeekTo_ParamsMojoType;
mojo.internal.Struct<MediaController_SeekTo_ParamsMojoType>(
    MediaController_SeekTo_ParamsSpec.$,
    'MediaController_SeekTo_Params',
    [
      mojo.internal.StructField<MediaController_SeekTo_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaController_ScrubTo_ParamsMojoType {
  seekTime: mojoBase_mojom_TimeDelta;
}


export type MediaController_ScrubTo_Params = MediaController_ScrubTo_ParamsMojoType;
mojo.internal.Struct<MediaController_ScrubTo_ParamsMojoType>(
    MediaController_ScrubTo_ParamsSpec.$,
    'MediaController_ScrubTo_Params',
    [
      mojo.internal.StructField<MediaController_ScrubTo_ParamsMojoType, mojoBase_mojom_TimeDelta>(
        'seekTime', 0,
        0,
        mojoBase_mojom_TimeDeltaSpec.$,
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaController_EnterPictureInPicture_ParamsMojoType {
}


export type MediaController_EnterPictureInPicture_Params = MediaController_EnterPictureInPicture_ParamsMojoType;
mojo.internal.Struct<MediaController_EnterPictureInPicture_ParamsMojoType>(
    MediaController_EnterPictureInPicture_ParamsSpec.$,
    'MediaController_EnterPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_ExitPictureInPicture_ParamsMojoType {
}


export type MediaController_ExitPictureInPicture_Params = MediaController_ExitPictureInPicture_ParamsMojoType;
mojo.internal.Struct<MediaController_ExitPictureInPicture_ParamsMojoType>(
    MediaController_ExitPictureInPicture_ParamsSpec.$,
    'MediaController_ExitPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_SetAudioSinkId_ParamsMojoType {
  id: (string | null);
}


export type MediaController_SetAudioSinkId_Params = MediaController_SetAudioSinkId_ParamsMojoType;
mojo.internal.Struct<MediaController_SetAudioSinkId_ParamsMojoType>(
    MediaController_SetAudioSinkId_ParamsSpec.$,
    'MediaController_SetAudioSinkId_Params',
    [
      mojo.internal.StructField<MediaController_SetAudioSinkId_ParamsMojoType, string>(
        'id', 0,
        0,
        mojo.internal.String,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaController_ToggleMicrophone_ParamsMojoType {
}


export type MediaController_ToggleMicrophone_Params = MediaController_ToggleMicrophone_ParamsMojoType;
mojo.internal.Struct<MediaController_ToggleMicrophone_ParamsMojoType>(
    MediaController_ToggleMicrophone_ParamsSpec.$,
    'MediaController_ToggleMicrophone_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_ToggleCamera_ParamsMojoType {
}


export type MediaController_ToggleCamera_Params = MediaController_ToggleCamera_ParamsMojoType;
mojo.internal.Struct<MediaController_ToggleCamera_ParamsMojoType>(
    MediaController_ToggleCamera_ParamsSpec.$,
    'MediaController_ToggleCamera_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_HangUp_ParamsMojoType {
}


export type MediaController_HangUp_Params = MediaController_HangUp_ParamsMojoType;
mojo.internal.Struct<MediaController_HangUp_ParamsMojoType>(
    MediaController_HangUp_ParamsSpec.$,
    'MediaController_HangUp_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_Raise_ParamsMojoType {
}


export type MediaController_Raise_Params = MediaController_Raise_ParamsMojoType;
mojo.internal.Struct<MediaController_Raise_ParamsMojoType>(
    MediaController_Raise_ParamsSpec.$,
    'MediaController_Raise_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_SetMute_ParamsMojoType {
  mute: boolean;
}


export type MediaController_SetMute_Params = MediaController_SetMute_ParamsMojoType;
mojo.internal.Struct<MediaController_SetMute_ParamsMojoType>(
    MediaController_SetMute_ParamsSpec.$,
    'MediaController_SetMute_Params',
    [
      mojo.internal.StructField<MediaController_SetMute_ParamsMojoType, boolean>(
        'mute', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaController_RequestMediaRemoting_ParamsMojoType {
}


export type MediaController_RequestMediaRemoting_Params = MediaController_RequestMediaRemoting_ParamsMojoType;
mojo.internal.Struct<MediaController_RequestMediaRemoting_ParamsMojoType>(
    MediaController_RequestMediaRemoting_ParamsSpec.$,
    'MediaController_RequestMediaRemoting_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_EnterAutoPictureInPicture_ParamsMojoType {
}


export type MediaController_EnterAutoPictureInPicture_Params = MediaController_EnterAutoPictureInPicture_ParamsMojoType;
mojo.internal.Struct<MediaController_EnterAutoPictureInPicture_ParamsMojoType>(
    MediaController_EnterAutoPictureInPicture_ParamsSpec.$,
    'MediaController_EnterAutoPictureInPicture_Params',
    [
    ],
    [[0, 8],]);





export interface MediaController_SkipAd_ParamsMojoType {
}


export type MediaController_SkipAd_Params = MediaController_SkipAd_ParamsMojoType;
mojo.internal.Struct<MediaController_SkipAd_ParamsMojoType>(
    MediaController_SkipAd_ParamsSpec.$,
    'MediaController_SkipAd_Params',
    [
    ],
    [[0, 8],]);





export interface MediaControllerObserver_MediaSessionInfoChanged_ParamsMojoType {
  info: (mediaSession_mojom_MediaSessionInfo | null);
}


export type MediaControllerObserver_MediaSessionInfoChanged_Params = MediaControllerObserver_MediaSessionInfoChanged_ParamsMojoType;
mojo.internal.Struct<MediaControllerObserver_MediaSessionInfoChanged_ParamsMojoType>(
    MediaControllerObserver_MediaSessionInfoChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionInfoChanged_Params',
    [
      mojo.internal.StructField<MediaControllerObserver_MediaSessionInfoChanged_ParamsMojoType, mediaSession_mojom_MediaSessionInfo>(
        'info', 0,
        0,
        mediaSession_mojom_MediaSessionInfoSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaControllerObserver_MediaSessionMetadataChanged_ParamsMojoType {
  metadata: (mediaSession_mojom_MediaMetadata | null);
}


export type MediaControllerObserver_MediaSessionMetadataChanged_Params = MediaControllerObserver_MediaSessionMetadataChanged_ParamsMojoType;
mojo.internal.Struct<MediaControllerObserver_MediaSessionMetadataChanged_ParamsMojoType>(
    MediaControllerObserver_MediaSessionMetadataChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionMetadataChanged_Params',
    [
      mojo.internal.StructField<MediaControllerObserver_MediaSessionMetadataChanged_ParamsMojoType, mediaSession_mojom_MediaMetadata>(
        'metadata', 0,
        0,
        mediaSession_mojom_MediaMetadataSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaControllerObserver_MediaSessionActionsChanged_ParamsMojoType {
  action: mediaSession_mojom_MediaSessionAction[];
}


export type MediaControllerObserver_MediaSessionActionsChanged_Params = MediaControllerObserver_MediaSessionActionsChanged_ParamsMojoType;
mojo.internal.Struct<MediaControllerObserver_MediaSessionActionsChanged_ParamsMojoType>(
    MediaControllerObserver_MediaSessionActionsChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionActionsChanged_Params',
    [
      mojo.internal.StructField<MediaControllerObserver_MediaSessionActionsChanged_ParamsMojoType, mediaSession_mojom_MediaSessionAction[]>(
        'action', 0,
        0,
        mojo.internal.Array(mediaSession_mojom_MediaSessionActionSpec.$, false),
        null,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaControllerObserver_MediaSessionChanged_ParamsMojoType {
  requestId: (mojoBase_mojom_UnguessableToken | null);
}


export type MediaControllerObserver_MediaSessionChanged_Params = MediaControllerObserver_MediaSessionChanged_ParamsMojoType;
mojo.internal.Struct<MediaControllerObserver_MediaSessionChanged_ParamsMojoType>(
    MediaControllerObserver_MediaSessionChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionChanged_Params',
    [
      mojo.internal.StructField<MediaControllerObserver_MediaSessionChanged_ParamsMojoType, mojoBase_mojom_UnguessableToken>(
        'requestId', 0,
        0,
        mojoBase_mojom_UnguessableTokenSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaControllerObserver_MediaSessionPositionChanged_ParamsMojoType {
  position: (mediaSession_mojom_MediaPosition | null);
}


export type MediaControllerObserver_MediaSessionPositionChanged_Params = MediaControllerObserver_MediaSessionPositionChanged_ParamsMojoType;
mojo.internal.Struct<MediaControllerObserver_MediaSessionPositionChanged_ParamsMojoType>(
    MediaControllerObserver_MediaSessionPositionChanged_ParamsSpec.$,
    'MediaControllerObserver_MediaSessionPositionChanged_Params',
    [
      mojo.internal.StructField<MediaControllerObserver_MediaSessionPositionChanged_ParamsMojoType, mediaSession_mojom_MediaPosition>(
        'position', 0,
        0,
        mediaSession_mojom_MediaPositionSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 16],]);





export interface MediaControllerImageObserver_MediaControllerImageChanged_ParamsMojoType {
  type: mediaSession_mojom_MediaSessionImageType;
  bitmap: (mediaSession_mojom_MediaImageBitmap | null);
}


export type MediaControllerImageObserver_MediaControllerImageChanged_Params = MediaControllerImageObserver_MediaControllerImageChanged_ParamsMojoType;
mojo.internal.Struct<MediaControllerImageObserver_MediaControllerImageChanged_ParamsMojoType>(
    MediaControllerImageObserver_MediaControllerImageChanged_ParamsSpec.$,
    'MediaControllerImageObserver_MediaControllerImageChanged_Params',
    [
      mojo.internal.StructField<MediaControllerImageObserver_MediaControllerImageChanged_ParamsMojoType, mediaSession_mojom_MediaSessionImageType>(
        'type', 0,
        0,
        mediaSession_mojom_MediaSessionImageTypeSpec.$,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaControllerImageObserver_MediaControllerImageChanged_ParamsMojoType, mediaSession_mojom_MediaImageBitmap>(
        'bitmap', 8,
        0,
        mediaSession_mojom_MediaImageBitmapSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);





export interface MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsMojoType {
  index: number;
  bitmap: (mediaSession_mojom_MediaImageBitmap | null);
}


export type MediaControllerImageObserver_MediaControllerChapterImageChanged_Params = MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsMojoType;
mojo.internal.Struct<MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsMojoType>(
    MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsSpec.$,
    'MediaControllerImageObserver_MediaControllerChapterImageChanged_Params',
    [
      mojo.internal.StructField<MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsMojoType, number>(
        'index', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
        undefined,
        undefined,
    ),
      mojo.internal.StructField<MediaControllerImageObserver_MediaControllerChapterImageChanged_ParamsMojoType, mediaSession_mojom_MediaImageBitmap>(
        'bitmap', 8,
        0,
        mediaSession_mojom_MediaImageBitmapSpec.$,
        null,
        true /* nullable */,
        0,
        undefined,
        undefined,
    ),
    ],
    [[0, 24],]);



