// services/media_session/public/mojom/audio_focus.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/media_session/public/mojom/audio_focus.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('mediaSession.mojom');
  var unguessable_token$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/unguessable_token.mojom', '../../../../mojo/public/mojom/base/unguessable_token.mojom.js');
  }
  var media_session$ =
      mojo.internal.exposeNamespace('mediaSession.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'services/media_session/public/mojom/media_session.mojom', 'media_session.mojom.js');
  }


  var EnforcementMode = {};
  EnforcementMode.kDefault = 0;
  EnforcementMode.kNone = 1;
  EnforcementMode.kSingleGroup = 2;
  EnforcementMode.kSingleSession = 3;
  EnforcementMode.MIN_VALUE = 0;
  EnforcementMode.MAX_VALUE = 3;

  EnforcementMode.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  EnforcementMode.toKnownEnumValue = function(value) {
    return value;
  };

  EnforcementMode.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var AudioFocusType = {};
  AudioFocusType.kGain = 0;
  AudioFocusType.kGainTransientMayDuck = 1;
  AudioFocusType.kGainTransient = 2;
  AudioFocusType.kAmbient = 3;
  AudioFocusType.MIN_VALUE = 0;
  AudioFocusType.MAX_VALUE = 3;

  AudioFocusType.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  AudioFocusType.toKnownEnumValue = function(value) {
    return value;
  };

  AudioFocusType.validate = function(enumValue) {
    const isExtensible = true;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function AudioFocusRequestState(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusRequestState.prototype.initDefaults_ = function() {
    this.sessionInfo = null;
    this.audioFocusType = 0;
    this.sourceName = null;
    this.requestId = null;
    this.sourceId = null;
  };
  AudioFocusRequestState.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusRequestState.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24},
      {version: 2, numBytes: 32},
      {version: 3, numBytes: 40},
      {version: 9, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusRequestState.sessionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_session$.MediaSessionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusRequestState.audioFocusType
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, AudioFocusType);
    if (err !== validator.validationError.NONE)
        return err;



    // version check AudioFocusRequestState.sourceName
    if (!messageValidator.isFieldInStructVersion(offset, 2))
      return validator.validationError.NONE;
    // validate AudioFocusRequestState.sourceName
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 16, true)
    if (err !== validator.validationError.NONE)
        return err;



    // version check AudioFocusRequestState.requestId
    if (!messageValidator.isFieldInStructVersion(offset, 3))
      return validator.validationError.NONE;
    // validate AudioFocusRequestState.requestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;



    // version check AudioFocusRequestState.sourceId
    if (!messageValidator.isFieldInStructVersion(offset, 9))
      return validator.validationError.NONE;
    // validate AudioFocusRequestState.sourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusRequestState.encodedSize = codec.kStructHeaderSize + 40;

  AudioFocusRequestState.decode = function(decoder) {
    var packed;
    var val = new AudioFocusRequestState();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionInfo =
        decoder.decodeStructPointer(media_session$.MediaSessionInfo);
    val.audioFocusType =
        decoder.decodeStruct(new codec.Enum(AudioFocusType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    if (version >= 2) {
      val.sourceName =
          decoder.decodeStruct(codec.String);
    } else {
      val.sourceName = null;
    }
    if (version >= 3) {
      val.requestId =
          decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    } else {
      val.requestId = null;
    }
    if (version >= 9) {
      val.sourceId =
          decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    } else {
      val.sourceId = null;
    }
    return val;
  };

  AudioFocusRequestState.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusRequestState.encodedSize);
    encoder.writeUint32(9);
    encoder.encodeStructPointer(media_session$.MediaSessionInfo, val.sessionInfo);
    encoder.encodeStruct(codec.Int32, val.audioFocusType);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStruct(codec.String, val.sourceName);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.requestId);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sourceId);
  };
  function AudioFocusObserver_OnFocusGained_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusObserver_OnFocusGained_Params.prototype.initDefaults_ = function() {
    this.state = null;
  };
  AudioFocusObserver_OnFocusGained_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusObserver_OnFocusGained_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusObserver_OnFocusGained_Params.state
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AudioFocusRequestState, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusObserver_OnFocusGained_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusObserver_OnFocusGained_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusObserver_OnFocusGained_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStructPointer(AudioFocusRequestState);
    return val;
  };

  AudioFocusObserver_OnFocusGained_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusObserver_OnFocusGained_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AudioFocusRequestState, val.state);
  };
  function AudioFocusObserver_OnFocusLost_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusObserver_OnFocusLost_Params.prototype.initDefaults_ = function() {
    this.state = null;
  };
  AudioFocusObserver_OnFocusLost_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusObserver_OnFocusLost_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusObserver_OnFocusLost_Params.state
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, AudioFocusRequestState, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusObserver_OnFocusLost_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusObserver_OnFocusLost_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusObserver_OnFocusLost_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.state =
        decoder.decodeStructPointer(AudioFocusRequestState);
    return val;
  };

  AudioFocusObserver_OnFocusLost_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusObserver_OnFocusLost_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(AudioFocusRequestState, val.state);
  };
  function AudioFocusObserver_OnRequestIdReleased_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusObserver_OnRequestIdReleased_Params.prototype.initDefaults_ = function() {
    this.requestId = null;
  };
  AudioFocusObserver_OnRequestIdReleased_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusObserver_OnRequestIdReleased_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusObserver_OnRequestIdReleased_Params.requestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusObserver_OnRequestIdReleased_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusObserver_OnRequestIdReleased_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusObserver_OnRequestIdReleased_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioFocusObserver_OnRequestIdReleased_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusObserver_OnRequestIdReleased_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.requestId);
  };
  function AudioFocusRequestClient_RequestAudioFocus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusRequestClient_RequestAudioFocus_Params.prototype.initDefaults_ = function() {
    this.sessionInfo = null;
    this.type = 0;
  };
  AudioFocusRequestClient_RequestAudioFocus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusRequestClient_RequestAudioFocus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusRequestClient_RequestAudioFocus_Params.sessionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_session$.MediaSessionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusRequestClient_RequestAudioFocus_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 8, AudioFocusType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusRequestClient_RequestAudioFocus_Params.encodedSize = codec.kStructHeaderSize + 16;

  AudioFocusRequestClient_RequestAudioFocus_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusRequestClient_RequestAudioFocus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionInfo =
        decoder.decodeStructPointer(media_session$.MediaSessionInfo);
    val.type =
        decoder.decodeStruct(new codec.Enum(AudioFocusType));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AudioFocusRequestClient_RequestAudioFocus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusRequestClient_RequestAudioFocus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_session$.MediaSessionInfo, val.sessionInfo);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AudioFocusRequestClient_RequestAudioFocus_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusRequestClient_RequestAudioFocus_ResponseParams.prototype.initDefaults_ = function() {
  };
  AudioFocusRequestClient_RequestAudioFocus_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusRequestClient_RequestAudioFocus_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusRequestClient_RequestAudioFocus_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  AudioFocusRequestClient_RequestAudioFocus_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioFocusRequestClient_RequestAudioFocus_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AudioFocusRequestClient_RequestAudioFocus_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusRequestClient_RequestAudioFocus_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function AudioFocusRequestClient_AbandonAudioFocus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusRequestClient_AbandonAudioFocus_Params.prototype.initDefaults_ = function() {
  };
  AudioFocusRequestClient_AbandonAudioFocus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusRequestClient_AbandonAudioFocus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusRequestClient_AbandonAudioFocus_Params.encodedSize = codec.kStructHeaderSize + 0;

  AudioFocusRequestClient_AbandonAudioFocus_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusRequestClient_AbandonAudioFocus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AudioFocusRequestClient_AbandonAudioFocus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusRequestClient_AbandonAudioFocus_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function AudioFocusRequestClient_MediaSessionInfoChanged_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusRequestClient_MediaSessionInfoChanged_Params.prototype.initDefaults_ = function() {
    this.sessionInfo = null;
  };
  AudioFocusRequestClient_MediaSessionInfoChanged_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusRequestClient_MediaSessionInfoChanged_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusRequestClient_MediaSessionInfoChanged_Params.sessionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_session$.MediaSessionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusRequestClient_MediaSessionInfoChanged_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusRequestClient_MediaSessionInfoChanged_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusRequestClient_MediaSessionInfoChanged_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sessionInfo =
        decoder.decodeStructPointer(media_session$.MediaSessionInfo);
    return val;
  };

  AudioFocusRequestClient_MediaSessionInfoChanged_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusRequestClient_MediaSessionInfoChanged_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_session$.MediaSessionInfo, val.sessionInfo);
  };
  function AudioFocusManager_RequestAudioFocus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_RequestAudioFocus_Params.prototype.initDefaults_ = function() {
    this.client = new bindings.InterfaceRequest();
    this.session = new media_session$.MediaSessionPtr();
    this.type = 0;
    this.sessionInfo = null;
  };
  AudioFocusManager_RequestAudioFocus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_RequestAudioFocus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestAudioFocus_Params.client
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 0, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestAudioFocus_Params.session
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 4, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestAudioFocus_Params.sessionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, media_session$.MediaSessionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestAudioFocus_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 12, AudioFocusType);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_RequestAudioFocus_Params.encodedSize = codec.kStructHeaderSize + 24;

  AudioFocusManager_RequestAudioFocus_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_RequestAudioFocus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.client =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.session =
        decoder.decodeStruct(new codec.Interface(media_session$.MediaSessionPtr));
    val.type =
        decoder.decodeStruct(new codec.Enum(AudioFocusType));
    val.sessionInfo =
        decoder.decodeStructPointer(media_session$.MediaSessionInfo);
    return val;
  };

  AudioFocusManager_RequestAudioFocus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_RequestAudioFocus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.InterfaceRequest, val.client);
    encoder.encodeStruct(new codec.Interface(media_session$.MediaSessionPtr), val.session);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStructPointer(media_session$.MediaSessionInfo, val.sessionInfo);
  };
  function AudioFocusManager_RequestAudioFocus_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_RequestAudioFocus_ResponseParams.prototype.initDefaults_ = function() {
    this.requestId = null;
  };
  AudioFocusManager_RequestAudioFocus_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_RequestAudioFocus_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestAudioFocus_ResponseParams.requestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_RequestAudioFocus_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManager_RequestAudioFocus_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_RequestAudioFocus_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioFocusManager_RequestAudioFocus_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_RequestAudioFocus_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.requestId);
  };
  function AudioFocusManager_RequestGroupedAudioFocus_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_RequestGroupedAudioFocus_Params.prototype.initDefaults_ = function() {
    this.requestId = null;
    this.client = new bindings.InterfaceRequest();
    this.session = new media_session$.MediaSessionPtr();
    this.type = 0;
    this.sessionInfo = null;
    this.groupId = null;
  };
  AudioFocusManager_RequestGroupedAudioFocus_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_RequestGroupedAudioFocus_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 48}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestGroupedAudioFocus_Params.requestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestGroupedAudioFocus_Params.client
    err = messageValidator.validateInterfaceRequest(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestGroupedAudioFocus_Params.session
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 12, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestGroupedAudioFocus_Params.sessionInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 24, media_session$.MediaSessionInfo, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestGroupedAudioFocus_Params.type
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 20, AudioFocusType);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestGroupedAudioFocus_Params.groupId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 32, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_RequestGroupedAudioFocus_Params.encodedSize = codec.kStructHeaderSize + 40;

  AudioFocusManager_RequestGroupedAudioFocus_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_RequestGroupedAudioFocus_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.client =
        decoder.decodeStruct(codec.InterfaceRequest);
    val.session =
        decoder.decodeStruct(new codec.Interface(media_session$.MediaSessionPtr));
    val.type =
        decoder.decodeStruct(new codec.Enum(AudioFocusType));
    val.sessionInfo =
        decoder.decodeStructPointer(media_session$.MediaSessionInfo);
    val.groupId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioFocusManager_RequestGroupedAudioFocus_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_RequestGroupedAudioFocus_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.requestId);
    encoder.encodeStruct(codec.InterfaceRequest, val.client);
    encoder.encodeStruct(new codec.Interface(media_session$.MediaSessionPtr), val.session);
    encoder.encodeStruct(codec.Int32, val.type);
    encoder.encodeStructPointer(media_session$.MediaSessionInfo, val.sessionInfo);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.groupId);
  };
  function AudioFocusManager_RequestGroupedAudioFocus_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_RequestGroupedAudioFocus_ResponseParams.prototype.initDefaults_ = function() {
    this.success = false;
  };
  AudioFocusManager_RequestGroupedAudioFocus_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_RequestGroupedAudioFocus_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    return validator.validationError.NONE;
  };

  AudioFocusManager_RequestGroupedAudioFocus_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManager_RequestGroupedAudioFocus_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_RequestGroupedAudioFocus_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    packed = decoder.readUint8();
    val.success = (packed >> 0) & 1 ? true : false;
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AudioFocusManager_RequestGroupedAudioFocus_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_RequestGroupedAudioFocus_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    packed = 0;
    packed |= (val.success & 1) << 0
    encoder.writeUint8(packed);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AudioFocusManager_GetFocusRequests_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_GetFocusRequests_Params.prototype.initDefaults_ = function() {
  };
  AudioFocusManager_GetFocusRequests_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_GetFocusRequests_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_GetFocusRequests_Params.encodedSize = codec.kStructHeaderSize + 0;

  AudioFocusManager_GetFocusRequests_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_GetFocusRequests_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AudioFocusManager_GetFocusRequests_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_GetFocusRequests_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function AudioFocusManager_GetFocusRequests_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_GetFocusRequests_ResponseParams.prototype.initDefaults_ = function() {
    this.requests = null;
  };
  AudioFocusManager_GetFocusRequests_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_GetFocusRequests_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_GetFocusRequests_ResponseParams.requests
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AudioFocusRequestState), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_GetFocusRequests_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManager_GetFocusRequests_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_GetFocusRequests_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requests =
        decoder.decodeArrayPointer(new codec.PointerTo(AudioFocusRequestState));
    return val;
  };

  AudioFocusManager_GetFocusRequests_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_GetFocusRequests_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AudioFocusRequestState), val.requests);
  };
  function AudioFocusManager_AddObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_AddObserver_Params.prototype.initDefaults_ = function() {
    this.observer = new AudioFocusObserverPtr();
  };
  AudioFocusManager_AddObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_AddObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_AddObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 0, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_AddObserver_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManager_AddObserver_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_AddObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.observer =
        decoder.decodeStruct(new codec.Interface(AudioFocusObserverPtr));
    return val;
  };

  AudioFocusManager_AddObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_AddObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(new codec.Interface(AudioFocusObserverPtr), val.observer);
  };
  function AudioFocusManager_SetSource_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_SetSource_Params.prototype.initDefaults_ = function() {
    this.identity = null;
    this.name = null;
  };
  AudioFocusManager_SetSource_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_SetSource_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_SetSource_Params.identity
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_SetSource_Params.name
    err = messageValidator.validateStringPointer(offset + codec.kStructHeaderSize + 8, false)
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_SetSource_Params.encodedSize = codec.kStructHeaderSize + 16;

  AudioFocusManager_SetSource_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_SetSource_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.identity =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.name =
        decoder.decodeStruct(codec.String);
    return val;
  };

  AudioFocusManager_SetSource_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_SetSource_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.identity);
    encoder.encodeStruct(codec.String, val.name);
  };
  function AudioFocusManager_SetEnforcementMode_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_SetEnforcementMode_Params.prototype.initDefaults_ = function() {
    this.mode = 0;
  };
  AudioFocusManager_SetEnforcementMode_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_SetEnforcementMode_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_SetEnforcementMode_Params.mode
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, EnforcementMode);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_SetEnforcementMode_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManager_SetEnforcementMode_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_SetEnforcementMode_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.mode =
        decoder.decodeStruct(new codec.Enum(EnforcementMode));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    return val;
  };

  AudioFocusManager_SetEnforcementMode_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_SetEnforcementMode_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.mode);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
  };
  function AudioFocusManager_AddSourceObserver_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_AddSourceObserver_Params.prototype.initDefaults_ = function() {
    this.sourceId = null;
    this.observer = new AudioFocusObserverPtr();
  };
  AudioFocusManager_AddSourceObserver_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_AddSourceObserver_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_AddSourceObserver_Params.sourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_AddSourceObserver_Params.observer
    err = messageValidator.validateInterface(offset + codec.kStructHeaderSize + 8, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_AddSourceObserver_Params.encodedSize = codec.kStructHeaderSize + 16;

  AudioFocusManager_AddSourceObserver_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_AddSourceObserver_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    val.observer =
        decoder.decodeStruct(new codec.Interface(AudioFocusObserverPtr));
    return val;
  };

  AudioFocusManager_AddSourceObserver_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_AddSourceObserver_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sourceId);
    encoder.encodeStruct(new codec.Interface(AudioFocusObserverPtr), val.observer);
  };
  function AudioFocusManager_GetSourceFocusRequests_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_GetSourceFocusRequests_Params.prototype.initDefaults_ = function() {
    this.sourceId = null;
  };
  AudioFocusManager_GetSourceFocusRequests_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_GetSourceFocusRequests_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_GetSourceFocusRequests_Params.sourceId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_GetSourceFocusRequests_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManager_GetSourceFocusRequests_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_GetSourceFocusRequests_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.sourceId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioFocusManager_GetSourceFocusRequests_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_GetSourceFocusRequests_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.sourceId);
  };
  function AudioFocusManager_GetSourceFocusRequests_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_GetSourceFocusRequests_ResponseParams.prototype.initDefaults_ = function() {
    this.requests = null;
  };
  AudioFocusManager_GetSourceFocusRequests_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_GetSourceFocusRequests_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_GetSourceFocusRequests_ResponseParams.requests
    err = messageValidator.validateArrayPointer(offset + codec.kStructHeaderSize + 0, 8, new codec.PointerTo(AudioFocusRequestState), false, [0], 0);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_GetSourceFocusRequests_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManager_GetSourceFocusRequests_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_GetSourceFocusRequests_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requests =
        decoder.decodeArrayPointer(new codec.PointerTo(AudioFocusRequestState));
    return val;
  };

  AudioFocusManager_GetSourceFocusRequests_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_GetSourceFocusRequests_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeArrayPointer(new codec.PointerTo(AudioFocusRequestState), val.requests);
  };
  function AudioFocusManager_RequestIdReleased_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_RequestIdReleased_Params.prototype.initDefaults_ = function() {
    this.requestId = null;
  };
  AudioFocusManager_RequestIdReleased_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_RequestIdReleased_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_RequestIdReleased_Params.requestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_RequestIdReleased_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManager_RequestIdReleased_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_RequestIdReleased_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioFocusManager_RequestIdReleased_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_RequestIdReleased_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.requestId);
  };
  function AudioFocusManager_StartDuckingAllAudio_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_StartDuckingAllAudio_Params.prototype.initDefaults_ = function() {
    this.exemptedRequestId = null;
  };
  AudioFocusManager_StartDuckingAllAudio_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_StartDuckingAllAudio_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManager_StartDuckingAllAudio_Params.exemptedRequestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, true);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_StartDuckingAllAudio_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManager_StartDuckingAllAudio_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_StartDuckingAllAudio_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.exemptedRequestId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioFocusManager_StartDuckingAllAudio_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_StartDuckingAllAudio_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.exemptedRequestId);
  };
  function AudioFocusManager_StopDuckingAllAudio_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_StopDuckingAllAudio_Params.prototype.initDefaults_ = function() {
  };
  AudioFocusManager_StopDuckingAllAudio_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_StopDuckingAllAudio_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_StopDuckingAllAudio_Params.encodedSize = codec.kStructHeaderSize + 0;

  AudioFocusManager_StopDuckingAllAudio_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_StopDuckingAllAudio_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AudioFocusManager_StopDuckingAllAudio_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_StopDuckingAllAudio_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function AudioFocusManager_FlushForTesting_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_FlushForTesting_Params.prototype.initDefaults_ = function() {
  };
  AudioFocusManager_FlushForTesting_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_FlushForTesting_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_FlushForTesting_Params.encodedSize = codec.kStructHeaderSize + 0;

  AudioFocusManager_FlushForTesting_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_FlushForTesting_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AudioFocusManager_FlushForTesting_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_FlushForTesting_Params.encodedSize);
    encoder.writeUint32(0);
  };
  function AudioFocusManager_FlushForTesting_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManager_FlushForTesting_ResponseParams.prototype.initDefaults_ = function() {
  };
  AudioFocusManager_FlushForTesting_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManager_FlushForTesting_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 8}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManager_FlushForTesting_ResponseParams.encodedSize = codec.kStructHeaderSize + 0;

  AudioFocusManager_FlushForTesting_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManager_FlushForTesting_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    return val;
  };

  AudioFocusManager_FlushForTesting_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManager_FlushForTesting_ResponseParams.encodedSize);
    encoder.writeUint32(0);
  };
  function AudioFocusManagerDebug_GetDebugInfoForRequest_Params(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManagerDebug_GetDebugInfoForRequest_Params.prototype.initDefaults_ = function() {
    this.requestId = null;
  };
  AudioFocusManagerDebug_GetDebugInfoForRequest_Params.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManagerDebug_GetDebugInfoForRequest_Params.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManagerDebug_GetDebugInfoForRequest_Params.requestId
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, unguessable_token$.UnguessableToken, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManagerDebug_GetDebugInfoForRequest_Params.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManagerDebug_GetDebugInfoForRequest_Params.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManagerDebug_GetDebugInfoForRequest_Params();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.requestId =
        decoder.decodeStructPointer(unguessable_token$.UnguessableToken);
    return val;
  };

  AudioFocusManagerDebug_GetDebugInfoForRequest_Params.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManagerDebug_GetDebugInfoForRequest_Params.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(unguessable_token$.UnguessableToken, val.requestId);
  };
  function AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams.prototype.initDefaults_ = function() {
    this.debugInfo = null;
  };
  AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 16}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams.debugInfo
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 0, media_session$.MediaSessionDebugInfo, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams.encodedSize = codec.kStructHeaderSize + 8;

  AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams.decode = function(decoder) {
    var packed;
    var val = new AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.debugInfo =
        decoder.decodeStructPointer(media_session$.MediaSessionDebugInfo);
    return val;
  };

  AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStructPointer(media_session$.MediaSessionDebugInfo, val.debugInfo);
  };
  var kAudioFocusObserver_OnFocusGained_Name = 0;
  var kAudioFocusObserver_OnFocusLost_Name = 1;
  var kAudioFocusObserver_OnRequestIdReleased_Name = 2;

  function AudioFocusObserverPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AudioFocusObserver,
                                                   handleOrPtrInfo);
  }

  function AudioFocusObserverAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AudioFocusObserver, associatedInterfacePtrInfo);
  }

  AudioFocusObserverAssociatedPtr.prototype =
      Object.create(AudioFocusObserverPtr.prototype);
  AudioFocusObserverAssociatedPtr.prototype.constructor =
      AudioFocusObserverAssociatedPtr;

  function AudioFocusObserverProxy(receiver) {
    this.receiver_ = receiver;
  }
  AudioFocusObserverPtr.prototype.onFocusGained = function() {
    return AudioFocusObserverProxy.prototype.onFocusGained
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusObserverProxy.prototype.onFocusGained = function(state) {
    var params_ = new AudioFocusObserver_OnFocusGained_Params();
    params_.state = state;
    var builder = new codec.MessageV0Builder(
        kAudioFocusObserver_OnFocusGained_Name,
        codec.align(AudioFocusObserver_OnFocusGained_Params.encodedSize));
    builder.encodeStruct(AudioFocusObserver_OnFocusGained_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioFocusObserverPtr.prototype.onFocusLost = function() {
    return AudioFocusObserverProxy.prototype.onFocusLost
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusObserverProxy.prototype.onFocusLost = function(state) {
    var params_ = new AudioFocusObserver_OnFocusLost_Params();
    params_.state = state;
    var builder = new codec.MessageV0Builder(
        kAudioFocusObserver_OnFocusLost_Name,
        codec.align(AudioFocusObserver_OnFocusLost_Params.encodedSize));
    builder.encodeStruct(AudioFocusObserver_OnFocusLost_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioFocusObserverPtr.prototype.onRequestIdReleased = function() {
    return AudioFocusObserverProxy.prototype.onRequestIdReleased
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusObserverProxy.prototype.onRequestIdReleased = function(requestId) {
    var params_ = new AudioFocusObserver_OnRequestIdReleased_Params();
    params_.requestId = requestId;
    var builder = new codec.MessageV0Builder(
        kAudioFocusObserver_OnRequestIdReleased_Name,
        codec.align(AudioFocusObserver_OnRequestIdReleased_Params.encodedSize));
    builder.encodeStruct(AudioFocusObserver_OnRequestIdReleased_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AudioFocusObserverStub(delegate) {
    this.delegate_ = delegate;
  }
  AudioFocusObserverStub.prototype.onFocusGained = function(state) {
    return this.delegate_ && this.delegate_.onFocusGained && this.delegate_.onFocusGained(state);
  }
  AudioFocusObserverStub.prototype.onFocusLost = function(state) {
    return this.delegate_ && this.delegate_.onFocusLost && this.delegate_.onFocusLost(state);
  }
  AudioFocusObserverStub.prototype.onRequestIdReleased = function(requestId) {
    return this.delegate_ && this.delegate_.onRequestIdReleased && this.delegate_.onRequestIdReleased(requestId);
  }

  AudioFocusObserverStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioFocusObserver_OnFocusGained_Name:
      var params = reader.decodeStruct(AudioFocusObserver_OnFocusGained_Params);
      this.onFocusGained(params.state);
      return true;
    case kAudioFocusObserver_OnFocusLost_Name:
      var params = reader.decodeStruct(AudioFocusObserver_OnFocusLost_Params);
      this.onFocusLost(params.state);
      return true;
    case kAudioFocusObserver_OnRequestIdReleased_Name:
      var params = reader.decodeStruct(AudioFocusObserver_OnRequestIdReleased_Params);
      this.onRequestIdReleased(params.requestId);
      return true;
    default:
      return false;
    }
  };

  AudioFocusObserverStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  function validateAudioFocusObserverRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAudioFocusObserver_OnFocusGained_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusObserver_OnFocusGained_Params;
      break;
      case kAudioFocusObserver_OnFocusLost_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusObserver_OnFocusLost_Params;
      break;
      case kAudioFocusObserver_OnRequestIdReleased_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusObserver_OnRequestIdReleased_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAudioFocusObserverResponse(messageValidator) {
    return validator.validationError.NONE;
  }

  var AudioFocusObserver = {
    name: 'media_session.mojom.AudioFocusObserver',
    kVersion: 8,
    ptrClass: AudioFocusObserverPtr,
    proxyClass: AudioFocusObserverProxy,
    stubClass: AudioFocusObserverStub,
    validateRequest: validateAudioFocusObserverRequest,
    validateResponse: null,
  };
  AudioFocusObserverStub.prototype.validator = validateAudioFocusObserverRequest;
  AudioFocusObserverProxy.prototype.validator = null;
  var kAudioFocusRequestClient_RequestAudioFocus_Name = 0;
  var kAudioFocusRequestClient_AbandonAudioFocus_Name = 1;
  var kAudioFocusRequestClient_MediaSessionInfoChanged_Name = 2;

  function AudioFocusRequestClientPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AudioFocusRequestClient,
                                                   handleOrPtrInfo);
  }

  function AudioFocusRequestClientAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AudioFocusRequestClient, associatedInterfacePtrInfo);
  }

  AudioFocusRequestClientAssociatedPtr.prototype =
      Object.create(AudioFocusRequestClientPtr.prototype);
  AudioFocusRequestClientAssociatedPtr.prototype.constructor =
      AudioFocusRequestClientAssociatedPtr;

  function AudioFocusRequestClientProxy(receiver) {
    this.receiver_ = receiver;
  }
  AudioFocusRequestClientPtr.prototype.requestAudioFocus = function() {
    return AudioFocusRequestClientProxy.prototype.requestAudioFocus
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusRequestClientProxy.prototype.requestAudioFocus = function(sessionInfo, type) {
    var params_ = new AudioFocusRequestClient_RequestAudioFocus_Params();
    params_.sessionInfo = sessionInfo;
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioFocusRequestClient_RequestAudioFocus_Name,
          codec.align(AudioFocusRequestClient_RequestAudioFocus_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioFocusRequestClient_RequestAudioFocus_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioFocusRequestClient_RequestAudioFocus_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AudioFocusRequestClientPtr.prototype.abandonAudioFocus = function() {
    return AudioFocusRequestClientProxy.prototype.abandonAudioFocus
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusRequestClientProxy.prototype.abandonAudioFocus = function() {
    var params_ = new AudioFocusRequestClient_AbandonAudioFocus_Params();
    var builder = new codec.MessageV0Builder(
        kAudioFocusRequestClient_AbandonAudioFocus_Name,
        codec.align(AudioFocusRequestClient_AbandonAudioFocus_Params.encodedSize));
    builder.encodeStruct(AudioFocusRequestClient_AbandonAudioFocus_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioFocusRequestClientPtr.prototype.mediaSessionInfoChanged = function() {
    return AudioFocusRequestClientProxy.prototype.mediaSessionInfoChanged
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusRequestClientProxy.prototype.mediaSessionInfoChanged = function(sessionInfo) {
    var params_ = new AudioFocusRequestClient_MediaSessionInfoChanged_Params();
    params_.sessionInfo = sessionInfo;
    var builder = new codec.MessageV0Builder(
        kAudioFocusRequestClient_MediaSessionInfoChanged_Name,
        codec.align(AudioFocusRequestClient_MediaSessionInfoChanged_Params.encodedSize));
    builder.encodeStruct(AudioFocusRequestClient_MediaSessionInfoChanged_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };

  function AudioFocusRequestClientStub(delegate) {
    this.delegate_ = delegate;
  }
  AudioFocusRequestClientStub.prototype.requestAudioFocus = function(sessionInfo, type) {
    return this.delegate_ && this.delegate_.requestAudioFocus && this.delegate_.requestAudioFocus(sessionInfo, type);
  }
  AudioFocusRequestClientStub.prototype.abandonAudioFocus = function() {
    return this.delegate_ && this.delegate_.abandonAudioFocus && this.delegate_.abandonAudioFocus();
  }
  AudioFocusRequestClientStub.prototype.mediaSessionInfoChanged = function(sessionInfo) {
    return this.delegate_ && this.delegate_.mediaSessionInfoChanged && this.delegate_.mediaSessionInfoChanged(sessionInfo);
  }

  AudioFocusRequestClientStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioFocusRequestClient_AbandonAudioFocus_Name:
      var params = reader.decodeStruct(AudioFocusRequestClient_AbandonAudioFocus_Params);
      this.abandonAudioFocus();
      return true;
    case kAudioFocusRequestClient_MediaSessionInfoChanged_Name:
      var params = reader.decodeStruct(AudioFocusRequestClient_MediaSessionInfoChanged_Params);
      this.mediaSessionInfoChanged(params.sessionInfo);
      return true;
    default:
      return false;
    }
  };

  AudioFocusRequestClientStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioFocusRequestClient_RequestAudioFocus_Name:
      var params = reader.decodeStruct(AudioFocusRequestClient_RequestAudioFocus_Params);
      this.requestAudioFocus(params.sessionInfo, params.type).then(function(response) {
        var responseParams =
            new AudioFocusRequestClient_RequestAudioFocus_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kAudioFocusRequestClient_RequestAudioFocus_Name,
            codec.align(AudioFocusRequestClient_RequestAudioFocus_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioFocusRequestClient_RequestAudioFocus_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAudioFocusRequestClientRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAudioFocusRequestClient_RequestAudioFocus_Name:
        if (message.expectsResponse())
          paramsClass = AudioFocusRequestClient_RequestAudioFocus_Params;
      break;
      case kAudioFocusRequestClient_AbandonAudioFocus_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusRequestClient_AbandonAudioFocus_Params;
      break;
      case kAudioFocusRequestClient_MediaSessionInfoChanged_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusRequestClient_MediaSessionInfoChanged_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAudioFocusRequestClientResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAudioFocusRequestClient_RequestAudioFocus_Name:
        if (message.isResponse())
          paramsClass = AudioFocusRequestClient_RequestAudioFocus_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AudioFocusRequestClient = {
    name: 'media_session.mojom.AudioFocusRequestClient',
    kVersion: 0,
    ptrClass: AudioFocusRequestClientPtr,
    proxyClass: AudioFocusRequestClientProxy,
    stubClass: AudioFocusRequestClientStub,
    validateRequest: validateAudioFocusRequestClientRequest,
    validateResponse: validateAudioFocusRequestClientResponse,
  };
  AudioFocusRequestClientStub.prototype.validator = validateAudioFocusRequestClientRequest;
  AudioFocusRequestClientProxy.prototype.validator = validateAudioFocusRequestClientResponse;
  var kAudioFocusManager_RequestAudioFocus_Name = 0;
  var kAudioFocusManager_RequestGroupedAudioFocus_Name = 4;
  var kAudioFocusManager_GetFocusRequests_Name = 1;
  var kAudioFocusManager_AddObserver_Name = 2;
  var kAudioFocusManager_SetSource_Name = 6;
  var kAudioFocusManager_SetEnforcementMode_Name = 5;
  var kAudioFocusManager_AddSourceObserver_Name = 7;
  var kAudioFocusManager_GetSourceFocusRequests_Name = 8;
  var kAudioFocusManager_RequestIdReleased_Name = 9;
  var kAudioFocusManager_StartDuckingAllAudio_Name = 10;
  var kAudioFocusManager_StopDuckingAllAudio_Name = 11;
  var kAudioFocusManager_FlushForTesting_Name = 12;

  function AudioFocusManagerPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AudioFocusManager,
                                                   handleOrPtrInfo);
  }

  function AudioFocusManagerAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AudioFocusManager, associatedInterfacePtrInfo);
  }

  AudioFocusManagerAssociatedPtr.prototype =
      Object.create(AudioFocusManagerPtr.prototype);
  AudioFocusManagerAssociatedPtr.prototype.constructor =
      AudioFocusManagerAssociatedPtr;

  function AudioFocusManagerProxy(receiver) {
    this.receiver_ = receiver;
  }
  AudioFocusManagerPtr.prototype.requestAudioFocus = function() {
    return AudioFocusManagerProxy.prototype.requestAudioFocus
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.requestAudioFocus = function(client, session, sessionInfo, type) {
    var params_ = new AudioFocusManager_RequestAudioFocus_Params();
    params_.client = client;
    params_.session = session;
    params_.sessionInfo = sessionInfo;
    params_.type = type;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioFocusManager_RequestAudioFocus_Name,
          codec.align(AudioFocusManager_RequestAudioFocus_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioFocusManager_RequestAudioFocus_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioFocusManager_RequestAudioFocus_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AudioFocusManagerPtr.prototype.requestGroupedAudioFocus = function() {
    return AudioFocusManagerProxy.prototype.requestGroupedAudioFocus
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.requestGroupedAudioFocus = function(requestId, client, session, sessionInfo, type, groupId) {
    var params_ = new AudioFocusManager_RequestGroupedAudioFocus_Params();
    params_.requestId = requestId;
    params_.client = client;
    params_.session = session;
    params_.sessionInfo = sessionInfo;
    params_.type = type;
    params_.groupId = groupId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioFocusManager_RequestGroupedAudioFocus_Name,
          codec.align(AudioFocusManager_RequestGroupedAudioFocus_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioFocusManager_RequestGroupedAudioFocus_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioFocusManager_RequestGroupedAudioFocus_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AudioFocusManagerPtr.prototype.getFocusRequests = function() {
    return AudioFocusManagerProxy.prototype.getFocusRequests
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.getFocusRequests = function() {
    var params_ = new AudioFocusManager_GetFocusRequests_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioFocusManager_GetFocusRequests_Name,
          codec.align(AudioFocusManager_GetFocusRequests_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioFocusManager_GetFocusRequests_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioFocusManager_GetFocusRequests_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AudioFocusManagerPtr.prototype.addObserver = function() {
    return AudioFocusManagerProxy.prototype.addObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.addObserver = function(observer) {
    var params_ = new AudioFocusManager_AddObserver_Params();
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kAudioFocusManager_AddObserver_Name,
        codec.align(AudioFocusManager_AddObserver_Params.encodedSize));
    builder.encodeStruct(AudioFocusManager_AddObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioFocusManagerPtr.prototype.setSource = function() {
    return AudioFocusManagerProxy.prototype.setSource
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.setSource = function(identity, name) {
    var params_ = new AudioFocusManager_SetSource_Params();
    params_.identity = identity;
    params_.name = name;
    var builder = new codec.MessageV0Builder(
        kAudioFocusManager_SetSource_Name,
        codec.align(AudioFocusManager_SetSource_Params.encodedSize));
    builder.encodeStruct(AudioFocusManager_SetSource_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioFocusManagerPtr.prototype.setEnforcementMode = function() {
    return AudioFocusManagerProxy.prototype.setEnforcementMode
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.setEnforcementMode = function(mode) {
    var params_ = new AudioFocusManager_SetEnforcementMode_Params();
    params_.mode = mode;
    var builder = new codec.MessageV0Builder(
        kAudioFocusManager_SetEnforcementMode_Name,
        codec.align(AudioFocusManager_SetEnforcementMode_Params.encodedSize));
    builder.encodeStruct(AudioFocusManager_SetEnforcementMode_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioFocusManagerPtr.prototype.addSourceObserver = function() {
    return AudioFocusManagerProxy.prototype.addSourceObserver
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.addSourceObserver = function(sourceId, observer) {
    var params_ = new AudioFocusManager_AddSourceObserver_Params();
    params_.sourceId = sourceId;
    params_.observer = observer;
    var builder = new codec.MessageV0Builder(
        kAudioFocusManager_AddSourceObserver_Name,
        codec.align(AudioFocusManager_AddSourceObserver_Params.encodedSize));
    builder.encodeStruct(AudioFocusManager_AddSourceObserver_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioFocusManagerPtr.prototype.getSourceFocusRequests = function() {
    return AudioFocusManagerProxy.prototype.getSourceFocusRequests
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.getSourceFocusRequests = function(sourceId) {
    var params_ = new AudioFocusManager_GetSourceFocusRequests_Params();
    params_.sourceId = sourceId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioFocusManager_GetSourceFocusRequests_Name,
          codec.align(AudioFocusManager_GetSourceFocusRequests_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioFocusManager_GetSourceFocusRequests_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioFocusManager_GetSourceFocusRequests_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };
  AudioFocusManagerPtr.prototype.requestIdReleased = function() {
    return AudioFocusManagerProxy.prototype.requestIdReleased
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.requestIdReleased = function(requestId) {
    var params_ = new AudioFocusManager_RequestIdReleased_Params();
    params_.requestId = requestId;
    var builder = new codec.MessageV0Builder(
        kAudioFocusManager_RequestIdReleased_Name,
        codec.align(AudioFocusManager_RequestIdReleased_Params.encodedSize));
    builder.encodeStruct(AudioFocusManager_RequestIdReleased_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioFocusManagerPtr.prototype.startDuckingAllAudio = function() {
    return AudioFocusManagerProxy.prototype.startDuckingAllAudio
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.startDuckingAllAudio = function(exemptedRequestId) {
    var params_ = new AudioFocusManager_StartDuckingAllAudio_Params();
    params_.exemptedRequestId = exemptedRequestId;
    var builder = new codec.MessageV0Builder(
        kAudioFocusManager_StartDuckingAllAudio_Name,
        codec.align(AudioFocusManager_StartDuckingAllAudio_Params.encodedSize));
    builder.encodeStruct(AudioFocusManager_StartDuckingAllAudio_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioFocusManagerPtr.prototype.stopDuckingAllAudio = function() {
    return AudioFocusManagerProxy.prototype.stopDuckingAllAudio
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.stopDuckingAllAudio = function() {
    var params_ = new AudioFocusManager_StopDuckingAllAudio_Params();
    var builder = new codec.MessageV0Builder(
        kAudioFocusManager_StopDuckingAllAudio_Name,
        codec.align(AudioFocusManager_StopDuckingAllAudio_Params.encodedSize));
    builder.encodeStruct(AudioFocusManager_StopDuckingAllAudio_Params, params_);
    var message = builder.finish();
    this.receiver_.accept(message);
  };
  AudioFocusManagerPtr.prototype.flushForTesting = function() {
    return AudioFocusManagerProxy.prototype.flushForTesting
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerProxy.prototype.flushForTesting = function() {
    var params_ = new AudioFocusManager_FlushForTesting_Params();
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioFocusManager_FlushForTesting_Name,
          codec.align(AudioFocusManager_FlushForTesting_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioFocusManager_FlushForTesting_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioFocusManager_FlushForTesting_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AudioFocusManagerStub(delegate) {
    this.delegate_ = delegate;
  }
  AudioFocusManagerStub.prototype.requestAudioFocus = function(client, session, sessionInfo, type) {
    return this.delegate_ && this.delegate_.requestAudioFocus && this.delegate_.requestAudioFocus(client, session, sessionInfo, type);
  }
  AudioFocusManagerStub.prototype.requestGroupedAudioFocus = function(requestId, client, session, sessionInfo, type, groupId) {
    return this.delegate_ && this.delegate_.requestGroupedAudioFocus && this.delegate_.requestGroupedAudioFocus(requestId, client, session, sessionInfo, type, groupId);
  }
  AudioFocusManagerStub.prototype.getFocusRequests = function() {
    return this.delegate_ && this.delegate_.getFocusRequests && this.delegate_.getFocusRequests();
  }
  AudioFocusManagerStub.prototype.addObserver = function(observer) {
    return this.delegate_ && this.delegate_.addObserver && this.delegate_.addObserver(observer);
  }
  AudioFocusManagerStub.prototype.setSource = function(identity, name) {
    return this.delegate_ && this.delegate_.setSource && this.delegate_.setSource(identity, name);
  }
  AudioFocusManagerStub.prototype.setEnforcementMode = function(mode) {
    return this.delegate_ && this.delegate_.setEnforcementMode && this.delegate_.setEnforcementMode(mode);
  }
  AudioFocusManagerStub.prototype.addSourceObserver = function(sourceId, observer) {
    return this.delegate_ && this.delegate_.addSourceObserver && this.delegate_.addSourceObserver(sourceId, observer);
  }
  AudioFocusManagerStub.prototype.getSourceFocusRequests = function(sourceId) {
    return this.delegate_ && this.delegate_.getSourceFocusRequests && this.delegate_.getSourceFocusRequests(sourceId);
  }
  AudioFocusManagerStub.prototype.requestIdReleased = function(requestId) {
    return this.delegate_ && this.delegate_.requestIdReleased && this.delegate_.requestIdReleased(requestId);
  }
  AudioFocusManagerStub.prototype.startDuckingAllAudio = function(exemptedRequestId) {
    return this.delegate_ && this.delegate_.startDuckingAllAudio && this.delegate_.startDuckingAllAudio(exemptedRequestId);
  }
  AudioFocusManagerStub.prototype.stopDuckingAllAudio = function() {
    return this.delegate_ && this.delegate_.stopDuckingAllAudio && this.delegate_.stopDuckingAllAudio();
  }
  AudioFocusManagerStub.prototype.flushForTesting = function() {
    return this.delegate_ && this.delegate_.flushForTesting && this.delegate_.flushForTesting();
  }

  AudioFocusManagerStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioFocusManager_AddObserver_Name:
      var params = reader.decodeStruct(AudioFocusManager_AddObserver_Params);
      this.addObserver(params.observer);
      return true;
    case kAudioFocusManager_SetSource_Name:
      var params = reader.decodeStruct(AudioFocusManager_SetSource_Params);
      this.setSource(params.identity, params.name);
      return true;
    case kAudioFocusManager_SetEnforcementMode_Name:
      var params = reader.decodeStruct(AudioFocusManager_SetEnforcementMode_Params);
      this.setEnforcementMode(params.mode);
      return true;
    case kAudioFocusManager_AddSourceObserver_Name:
      var params = reader.decodeStruct(AudioFocusManager_AddSourceObserver_Params);
      this.addSourceObserver(params.sourceId, params.observer);
      return true;
    case kAudioFocusManager_RequestIdReleased_Name:
      var params = reader.decodeStruct(AudioFocusManager_RequestIdReleased_Params);
      this.requestIdReleased(params.requestId);
      return true;
    case kAudioFocusManager_StartDuckingAllAudio_Name:
      var params = reader.decodeStruct(AudioFocusManager_StartDuckingAllAudio_Params);
      this.startDuckingAllAudio(params.exemptedRequestId);
      return true;
    case kAudioFocusManager_StopDuckingAllAudio_Name:
      var params = reader.decodeStruct(AudioFocusManager_StopDuckingAllAudio_Params);
      this.stopDuckingAllAudio();
      return true;
    default:
      return false;
    }
  };

  AudioFocusManagerStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioFocusManager_RequestAudioFocus_Name:
      var params = reader.decodeStruct(AudioFocusManager_RequestAudioFocus_Params);
      this.requestAudioFocus(params.client, params.session, params.sessionInfo, params.type).then(function(response) {
        var responseParams =
            new AudioFocusManager_RequestAudioFocus_ResponseParams();
        responseParams.requestId = response.requestId;
        var builder = new codec.MessageV1Builder(
            kAudioFocusManager_RequestAudioFocus_Name,
            codec.align(AudioFocusManager_RequestAudioFocus_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioFocusManager_RequestAudioFocus_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAudioFocusManager_RequestGroupedAudioFocus_Name:
      var params = reader.decodeStruct(AudioFocusManager_RequestGroupedAudioFocus_Params);
      this.requestGroupedAudioFocus(params.requestId, params.client, params.session, params.sessionInfo, params.type, params.groupId).then(function(response) {
        var responseParams =
            new AudioFocusManager_RequestGroupedAudioFocus_ResponseParams();
        responseParams.success = response.success;
        var builder = new codec.MessageV1Builder(
            kAudioFocusManager_RequestGroupedAudioFocus_Name,
            codec.align(AudioFocusManager_RequestGroupedAudioFocus_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioFocusManager_RequestGroupedAudioFocus_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAudioFocusManager_GetFocusRequests_Name:
      var params = reader.decodeStruct(AudioFocusManager_GetFocusRequests_Params);
      this.getFocusRequests().then(function(response) {
        var responseParams =
            new AudioFocusManager_GetFocusRequests_ResponseParams();
        responseParams.requests = response.requests;
        var builder = new codec.MessageV1Builder(
            kAudioFocusManager_GetFocusRequests_Name,
            codec.align(AudioFocusManager_GetFocusRequests_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioFocusManager_GetFocusRequests_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAudioFocusManager_GetSourceFocusRequests_Name:
      var params = reader.decodeStruct(AudioFocusManager_GetSourceFocusRequests_Params);
      this.getSourceFocusRequests(params.sourceId).then(function(response) {
        var responseParams =
            new AudioFocusManager_GetSourceFocusRequests_ResponseParams();
        responseParams.requests = response.requests;
        var builder = new codec.MessageV1Builder(
            kAudioFocusManager_GetSourceFocusRequests_Name,
            codec.align(AudioFocusManager_GetSourceFocusRequests_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioFocusManager_GetSourceFocusRequests_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    case kAudioFocusManager_FlushForTesting_Name:
      var params = reader.decodeStruct(AudioFocusManager_FlushForTesting_Params);
      this.flushForTesting().then(function(response) {
        var responseParams =
            new AudioFocusManager_FlushForTesting_ResponseParams();
        var builder = new codec.MessageV1Builder(
            kAudioFocusManager_FlushForTesting_Name,
            codec.align(AudioFocusManager_FlushForTesting_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioFocusManager_FlushForTesting_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAudioFocusManagerRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAudioFocusManager_RequestAudioFocus_Name:
        if (message.expectsResponse())
          paramsClass = AudioFocusManager_RequestAudioFocus_Params;
      break;
      case kAudioFocusManager_RequestGroupedAudioFocus_Name:
        if (message.expectsResponse())
          paramsClass = AudioFocusManager_RequestGroupedAudioFocus_Params;
      break;
      case kAudioFocusManager_GetFocusRequests_Name:
        if (message.expectsResponse())
          paramsClass = AudioFocusManager_GetFocusRequests_Params;
      break;
      case kAudioFocusManager_AddObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusManager_AddObserver_Params;
      break;
      case kAudioFocusManager_SetSource_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusManager_SetSource_Params;
      break;
      case kAudioFocusManager_SetEnforcementMode_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusManager_SetEnforcementMode_Params;
      break;
      case kAudioFocusManager_AddSourceObserver_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusManager_AddSourceObserver_Params;
      break;
      case kAudioFocusManager_GetSourceFocusRequests_Name:
        if (message.expectsResponse())
          paramsClass = AudioFocusManager_GetSourceFocusRequests_Params;
      break;
      case kAudioFocusManager_RequestIdReleased_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusManager_RequestIdReleased_Params;
      break;
      case kAudioFocusManager_StartDuckingAllAudio_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusManager_StartDuckingAllAudio_Params;
      break;
      case kAudioFocusManager_StopDuckingAllAudio_Name:
        if (!message.expectsResponse() && !message.isResponse())
          paramsClass = AudioFocusManager_StopDuckingAllAudio_Params;
      break;
      case kAudioFocusManager_FlushForTesting_Name:
        if (message.expectsResponse())
          paramsClass = AudioFocusManager_FlushForTesting_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAudioFocusManagerResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAudioFocusManager_RequestAudioFocus_Name:
        if (message.isResponse())
          paramsClass = AudioFocusManager_RequestAudioFocus_ResponseParams;
        break;
      case kAudioFocusManager_RequestGroupedAudioFocus_Name:
        if (message.isResponse())
          paramsClass = AudioFocusManager_RequestGroupedAudioFocus_ResponseParams;
        break;
      case kAudioFocusManager_GetFocusRequests_Name:
        if (message.isResponse())
          paramsClass = AudioFocusManager_GetFocusRequests_ResponseParams;
        break;
      case kAudioFocusManager_GetSourceFocusRequests_Name:
        if (message.isResponse())
          paramsClass = AudioFocusManager_GetSourceFocusRequests_ResponseParams;
        break;
      case kAudioFocusManager_FlushForTesting_Name:
        if (message.isResponse())
          paramsClass = AudioFocusManager_FlushForTesting_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AudioFocusManager = {
    name: 'media_session.mojom.AudioFocusManager',
    kVersion: 10,
    ptrClass: AudioFocusManagerPtr,
    proxyClass: AudioFocusManagerProxy,
    stubClass: AudioFocusManagerStub,
    validateRequest: validateAudioFocusManagerRequest,
    validateResponse: validateAudioFocusManagerResponse,
  };
  AudioFocusManagerStub.prototype.validator = validateAudioFocusManagerRequest;
  AudioFocusManagerProxy.prototype.validator = validateAudioFocusManagerResponse;
  var kAudioFocusManagerDebug_GetDebugInfoForRequest_Name = 0;

  function AudioFocusManagerDebugPtr(handleOrPtrInfo) {
    this.ptr = new bindings.InterfacePtrController(AudioFocusManagerDebug,
                                                   handleOrPtrInfo);
  }

  function AudioFocusManagerDebugAssociatedPtr(associatedInterfacePtrInfo) {
    this.ptr = new associatedBindings.AssociatedInterfacePtrController(
        AudioFocusManagerDebug, associatedInterfacePtrInfo);
  }

  AudioFocusManagerDebugAssociatedPtr.prototype =
      Object.create(AudioFocusManagerDebugPtr.prototype);
  AudioFocusManagerDebugAssociatedPtr.prototype.constructor =
      AudioFocusManagerDebugAssociatedPtr;

  function AudioFocusManagerDebugProxy(receiver) {
    this.receiver_ = receiver;
  }
  AudioFocusManagerDebugPtr.prototype.getDebugInfoForRequest = function() {
    return AudioFocusManagerDebugProxy.prototype.getDebugInfoForRequest
        .apply(this.ptr.getProxy(), arguments);
  };

  AudioFocusManagerDebugProxy.prototype.getDebugInfoForRequest = function(requestId) {
    var params_ = new AudioFocusManagerDebug_GetDebugInfoForRequest_Params();
    params_.requestId = requestId;
    return new Promise(function(resolve, reject) {
      var builder = new codec.MessageV1Builder(
          kAudioFocusManagerDebug_GetDebugInfoForRequest_Name,
          codec.align(AudioFocusManagerDebug_GetDebugInfoForRequest_Params.encodedSize),
          codec.kMessageExpectsResponse, 0);
      builder.encodeStruct(AudioFocusManagerDebug_GetDebugInfoForRequest_Params, params_);
      var message = builder.finish();
      this.receiver_.acceptAndExpectResponse(message).then(function(message) {
        var reader = new codec.MessageReader(message);
        var responseParams =
            reader.decodeStruct(AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams);
        resolve(responseParams);
      }).catch(function(result) {
        reject(Error("Connection error: " + result));
      });
    }.bind(this));
  };

  function AudioFocusManagerDebugStub(delegate) {
    this.delegate_ = delegate;
  }
  AudioFocusManagerDebugStub.prototype.getDebugInfoForRequest = function(requestId) {
    return this.delegate_ && this.delegate_.getDebugInfoForRequest && this.delegate_.getDebugInfoForRequest(requestId);
  }

  AudioFocusManagerDebugStub.prototype.accept = function(message) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    default:
      return false;
    }
  };

  AudioFocusManagerDebugStub.prototype.acceptWithResponder =
      function(message, responder) {
    var reader = new codec.MessageReader(message);
    switch (reader.messageName) {
    case kAudioFocusManagerDebug_GetDebugInfoForRequest_Name:
      var params = reader.decodeStruct(AudioFocusManagerDebug_GetDebugInfoForRequest_Params);
      this.getDebugInfoForRequest(params.requestId).then(function(response) {
        var responseParams =
            new AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams();
        responseParams.debugInfo = response.debugInfo;
        var builder = new codec.MessageV1Builder(
            kAudioFocusManagerDebug_GetDebugInfoForRequest_Name,
            codec.align(AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams.encodedSize),
            codec.kMessageIsResponse, reader.requestID);
        builder.encodeStruct(AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams,
                             responseParams);
        var message = builder.finish();
        responder.accept(message);
      });
      return true;
    default:
      return false;
    }
  };

  function validateAudioFocusManagerDebugRequest(messageValidator) {
    var message = messageValidator.message;
    var paramsClass = null;
    switch (message.getName()) {
      case kAudioFocusManagerDebug_GetDebugInfoForRequest_Name:
        if (message.expectsResponse())
          paramsClass = AudioFocusManagerDebug_GetDebugInfoForRequest_Params;
      break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  function validateAudioFocusManagerDebugResponse(messageValidator) {
   var message = messageValidator.message;
   var paramsClass = null;
   switch (message.getName()) {
      case kAudioFocusManagerDebug_GetDebugInfoForRequest_Name:
        if (message.isResponse())
          paramsClass = AudioFocusManagerDebug_GetDebugInfoForRequest_ResponseParams;
        break;
    }
    if (paramsClass === null)
      return validator.validationError.NONE;
    return paramsClass.validate(messageValidator, messageValidator.message.getHeaderNumBytes());
  }

  var AudioFocusManagerDebug = {
    name: 'media_session.mojom.AudioFocusManagerDebug',
    kVersion: 0,
    ptrClass: AudioFocusManagerDebugPtr,
    proxyClass: AudioFocusManagerDebugProxy,
    stubClass: AudioFocusManagerDebugStub,
    validateRequest: validateAudioFocusManagerDebugRequest,
    validateResponse: validateAudioFocusManagerDebugResponse,
  };
  AudioFocusManagerDebugStub.prototype.validator = validateAudioFocusManagerDebugRequest;
  AudioFocusManagerDebugProxy.prototype.validator = validateAudioFocusManagerDebugResponse;
  exports.EnforcementMode = EnforcementMode;
  exports.AudioFocusType = AudioFocusType;
  exports.AudioFocusRequestState = AudioFocusRequestState;
  exports.AudioFocusObserver = AudioFocusObserver;
  exports.AudioFocusObserverPtr = AudioFocusObserverPtr;
  exports.AudioFocusObserverAssociatedPtr = AudioFocusObserverAssociatedPtr;
  exports.AudioFocusRequestClient = AudioFocusRequestClient;
  exports.AudioFocusRequestClientPtr = AudioFocusRequestClientPtr;
  exports.AudioFocusRequestClientAssociatedPtr = AudioFocusRequestClientAssociatedPtr;
  exports.AudioFocusManager = AudioFocusManager;
  exports.AudioFocusManagerPtr = AudioFocusManagerPtr;
  exports.AudioFocusManagerAssociatedPtr = AudioFocusManagerAssociatedPtr;
  exports.AudioFocusManagerDebug = AudioFocusManagerDebug;
  exports.AudioFocusManagerDebugPtr = AudioFocusManagerDebugPtr;
  exports.AudioFocusManagerDebugAssociatedPtr = AudioFocusManagerDebugAssociatedPtr;
})();