// services/device/public/mojom/wake_lock_provider.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('device.mojom.WakeLockReason');
goog.require('device.mojom.WakeLockType');
goog.require('device.mojom.WakeLock');
goog.require('device.mojom.WakeLockContext');






goog.provide('device.mojom.WakeLockProvider');
goog.provide('device.mojom.WakeLockProviderReceiver');
goog.provide('device.mojom.WakeLockProviderCallbackRouter');
goog.provide('device.mojom.WakeLockProviderInterface');
goog.provide('device.mojom.WakeLockProviderRemote');
goog.provide('device.mojom.WakeLockProviderPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.WakeLockProviderPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.WakeLockProvider.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.WakeLockProviderInterface = class {
  
  /**
   * @param { !number } contextId
   * @param { !device.mojom.WakeLockContextPendingReceiver } context
   */

  getWakeLockContextForID(contextId, context) {}
  
  /**
   * @param { !device.mojom.WakeLockType } type
   * @param { !device.mojom.WakeLockReason } reason
   * @param { !string } description
   * @param { !device.mojom.WakeLockPendingReceiver } wakeLock
   */

  getWakeLockWithoutContext(type, reason, description, wakeLock) {}
  
  /**
   * @param { !device.mojom.WakeLockType } type
   * @param { !device.mojom.WakeLockObserverRemote } observer
   */

  notifyOnWakeLockDeactivation(type, observer) {}
  
  /**
   * @param { !device.mojom.WakeLockType } type
   * @return {!Promise<{
        count: !number,
   *  }>}
   */

  getActiveWakeLocksForTests(type) {}
};

/**
 * @export
 * @implements { device.mojom.WakeLockProviderInterface }
 */
device.mojom.WakeLockProviderRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.WakeLockProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.WakeLockProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.WakeLockProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } contextId
   * @param { !device.mojom.WakeLockContextPendingReceiver } context
   */

  getWakeLockContextForID(
      contextId,
      context) {
    this.proxy.sendMessage(
        0,
        device.mojom.WakeLockProvider_GetWakeLockContextForID_ParamsSpec.$,
        null,
        [
          contextId,
          context
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.WakeLockType } type
   * @param { !device.mojom.WakeLockReason } reason
   * @param { !string } description
   * @param { !device.mojom.WakeLockPendingReceiver } wakeLock
   */

  getWakeLockWithoutContext(
      type,
      reason,
      description,
      wakeLock) {
    this.proxy.sendMessage(
        1,
        device.mojom.WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec.$,
        null,
        [
          type,
          reason,
          description,
          wakeLock
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.WakeLockType } type
   * @param { !device.mojom.WakeLockObserverRemote } observer
   */

  notifyOnWakeLockDeactivation(
      type,
      observer) {
    this.proxy.sendMessage(
        2,
        device.mojom.WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec.$,
        null,
        [
          type,
          observer
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.WakeLockType } type
   * @return {!Promise<{
        count: !number,
   *  }>}
   */

  getActiveWakeLocksForTests(
      type) {
    return this.proxy.sendMessage(
        3,
        device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec.$,
        device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec.$,
        [
          type
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WakeLockProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.WakeLockProviderReceiver = class {
  /**
   * @param {!device.mojom.WakeLockProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.WakeLockProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.WakeLockProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.WakeLockProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.WakeLockProvider_GetWakeLockContextForID_ParamsSpec.$,
        null,
        impl.getWakeLockContextForID.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec.$,
        null,
        impl.getWakeLockWithoutContext.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec.$,
        null,
        impl.notifyOnWakeLockDeactivation.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec.$,
        device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec.$,
        impl.getActiveWakeLocksForTests.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.WakeLockProvider = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.WakeLockProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.WakeLockProviderRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.WakeLockProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WakeLockProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.WakeLockProviderCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.WakeLockProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.WakeLockProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWakeLockContextForID =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.WakeLockProvider_GetWakeLockContextForID_ParamsSpec.$,
        null,
        this.getWakeLockContextForID.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getWakeLockWithoutContext =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec.$,
        null,
        this.getWakeLockWithoutContext.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.notifyOnWakeLockDeactivation =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec.$,
        null,
        this.notifyOnWakeLockDeactivation.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getActiveWakeLocksForTests =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec.$,
        device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec.$,
        this.getActiveWakeLocksForTests.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.WakeLockObserver');
goog.provide('device.mojom.WakeLockObserverReceiver');
goog.provide('device.mojom.WakeLockObserverCallbackRouter');
goog.provide('device.mojom.WakeLockObserverInterface');
goog.provide('device.mojom.WakeLockObserverRemote');
goog.provide('device.mojom.WakeLockObserverPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.WakeLockObserverPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.WakeLockObserver.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.WakeLockObserverInterface = class {
  
  /**
   * @param { !device.mojom.WakeLockType } type
   */

  onWakeLockDeactivated(type) {}
};

/**
 * @export
 * @implements { device.mojom.WakeLockObserverInterface }
 */
device.mojom.WakeLockObserverRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.WakeLockObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.WakeLockObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.WakeLockObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !device.mojom.WakeLockType } type
   */

  onWakeLockDeactivated(
      type) {
    this.proxy.sendMessage(
        0,
        device.mojom.WakeLockObserver_OnWakeLockDeactivated_ParamsSpec.$,
        null,
        [
          type
        ],
        false);
  }
};

/**
 * An object which receives request messages for the WakeLockObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.WakeLockObserverReceiver = class {
  /**
   * @param {!device.mojom.WakeLockObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.WakeLockObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.WakeLockObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.WakeLockObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.WakeLockObserver_OnWakeLockDeactivated_ParamsSpec.$,
        null,
        impl.onWakeLockDeactivated.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.WakeLockObserver = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.WakeLockObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.WakeLockObserverRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.WakeLockObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the WakeLockObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.WakeLockObserverCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.WakeLockObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.WakeLockObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onWakeLockDeactivated =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.WakeLockObserver_OnWakeLockDeactivated_ParamsSpec.$,
        null,
        this.onWakeLockDeactivated.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.WakeLockProvider_GetWakeLockContextForID_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLockProvider_GetWakeLockContextForID_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.WakeLockObserver_OnWakeLockDeactivated_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.WakeLockObserver_OnWakeLockDeactivated_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.WakeLockProvider_GetWakeLockContextForID_ParamsSpec.$,
    'WakeLockProvider_GetWakeLockContextForID_Params',
    [
      mojo.internal.StructField(
        'contextId', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'context', 4,
        0,
        mojo.internal.InterfaceRequest(device.mojom.WakeLockContextPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.WakeLockProvider_GetWakeLockContextForID_Params');

/** @record */
device.mojom.WakeLockProvider_GetWakeLockContextForID_Params = class {
  constructor() {
    /** @export { !number } */
    this.contextId;
    /** @export { !device.mojom.WakeLockContextPendingReceiver } */
    this.context;
  }
};



mojo.internal.Struct(
    device.mojom.WakeLockProvider_GetWakeLockWithoutContext_ParamsSpec.$,
    'WakeLockProvider_GetWakeLockWithoutContext_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.WakeLockTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'reason', 4,
        0,
        device.mojom.WakeLockReasonSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'description', 8,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'wakeLock', 16,
        0,
        mojo.internal.InterfaceRequest(device.mojom.WakeLockPendingReceiver),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.WakeLockProvider_GetWakeLockWithoutContext_Params');

/** @record */
device.mojom.WakeLockProvider_GetWakeLockWithoutContext_Params = class {
  constructor() {
    /** @export { !device.mojom.WakeLockType } */
    this.type;
    /** @export { !device.mojom.WakeLockReason } */
    this.reason;
    /** @export { !string } */
    this.description;
    /** @export { !device.mojom.WakeLockPendingReceiver } */
    this.wakeLock;
  }
};



mojo.internal.Struct(
    device.mojom.WakeLockProvider_NotifyOnWakeLockDeactivation_ParamsSpec.$,
    'WakeLockProvider_NotifyOnWakeLockDeactivation_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.WakeLockTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'observer', 4,
        0,
        mojo.internal.InterfaceProxy(device.mojom.WakeLockObserverRemote),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.WakeLockProvider_NotifyOnWakeLockDeactivation_Params');

/** @record */
device.mojom.WakeLockProvider_NotifyOnWakeLockDeactivation_Params = class {
  constructor() {
    /** @export { !device.mojom.WakeLockType } */
    this.type;
    /** @export { !device.mojom.WakeLockObserverRemote } */
    this.observer;
  }
};



mojo.internal.Struct(
    device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ParamsSpec.$,
    'WakeLockProvider_GetActiveWakeLocksForTests_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.WakeLockTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_Params');

/** @record */
device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_Params = class {
  constructor() {
    /** @export { !device.mojom.WakeLockType } */
    this.type;
  }
};



mojo.internal.Struct(
    device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ResponseParamsSpec.$,
    'WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams',
    [
      mojo.internal.StructField(
        'count', 0,
        0,
        mojo.internal.Int32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams');

/** @record */
device.mojom.WakeLockProvider_GetActiveWakeLocksForTests_ResponseParams = class {
  constructor() {
    /** @export { !number } */
    this.count;
  }
};



mojo.internal.Struct(
    device.mojom.WakeLockObserver_OnWakeLockDeactivated_ParamsSpec.$,
    'WakeLockObserver_OnWakeLockDeactivated_Params',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.WakeLockTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.WakeLockObserver_OnWakeLockDeactivated_Params');

/** @record */
device.mojom.WakeLockObserver_OnWakeLockDeactivated_Params = class {
  constructor() {
    /** @export { !device.mojom.WakeLockType } */
    this.type;
  }
};

