// services/device/public/mojom/vibration_manager.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');







goog.provide('device.mojom.VibrationManager');
goog.provide('device.mojom.VibrationManagerReceiver');
goog.provide('device.mojom.VibrationManagerCallbackRouter');
goog.provide('device.mojom.VibrationManagerInterface');
goog.provide('device.mojom.VibrationManagerRemote');
goog.provide('device.mojom.VibrationManagerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.VibrationManagerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.VibrationManager.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.VibrationManagerInterface = class {
  
  /**
   * @param { !bigint } milliseconds
   * @return {!Promise}
   */

  vibrate(milliseconds) {}
  
  /**
   * @return {!Promise}
   */

  cancel() {}
};

/**
 * @export
 * @implements { device.mojom.VibrationManagerInterface }
 */
device.mojom.VibrationManagerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.VibrationManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.VibrationManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.VibrationManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !bigint } milliseconds
   * @return {!Promise}
   */

  vibrate(
      milliseconds) {
    return this.proxy.sendMessage(
        0,
        device.mojom.VibrationManager_Vibrate_ParamsSpec.$,
        device.mojom.VibrationManager_Vibrate_ResponseParamsSpec.$,
        [
          milliseconds
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  cancel() {
    return this.proxy.sendMessage(
        1,
        device.mojom.VibrationManager_Cancel_ParamsSpec.$,
        device.mojom.VibrationManager_Cancel_ResponseParamsSpec.$,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VibrationManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.VibrationManagerReceiver = class {
  /**
   * @param {!device.mojom.VibrationManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.VibrationManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.VibrationManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.VibrationManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.VibrationManager_Vibrate_ParamsSpec.$,
        device.mojom.VibrationManager_Vibrate_ResponseParamsSpec.$,
        impl.vibrate.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.VibrationManager_Cancel_ParamsSpec.$,
        device.mojom.VibrationManager_Cancel_ResponseParamsSpec.$,
        impl.cancel.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.VibrationManager = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.VibrationManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.VibrationManagerRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.VibrationManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VibrationManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.VibrationManagerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.VibrationManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.VibrationManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.vibrate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.VibrationManager_Vibrate_ParamsSpec.$,
        device.mojom.VibrationManager_Vibrate_ResponseParamsSpec.$,
        this.vibrate.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.VibrationManager_Cancel_ParamsSpec.$,
        device.mojom.VibrationManager_Cancel_ResponseParamsSpec.$,
        this.cancel.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.VibrationManagerListener');
goog.provide('device.mojom.VibrationManagerListenerReceiver');
goog.provide('device.mojom.VibrationManagerListenerCallbackRouter');
goog.provide('device.mojom.VibrationManagerListenerInterface');
goog.provide('device.mojom.VibrationManagerListenerRemote');
goog.provide('device.mojom.VibrationManagerListenerPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.VibrationManagerListenerPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.VibrationManagerListener.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.VibrationManagerListenerInterface = class {
  
  /**
   */

  onVibrate() {}
};

/**
 * @export
 * @implements { device.mojom.VibrationManagerListenerInterface }
 */
device.mojom.VibrationManagerListenerRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.VibrationManagerListenerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.VibrationManagerListenerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.VibrationManagerListenerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onVibrate() {
    this.proxy.sendMessage(
        0,
        device.mojom.VibrationManagerListener_OnVibrate_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the VibrationManagerListener
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.VibrationManagerListenerReceiver = class {
  /**
   * @param {!device.mojom.VibrationManagerListenerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.VibrationManagerListenerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.VibrationManagerListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.VibrationManagerListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.VibrationManagerListener_OnVibrate_ParamsSpec.$,
        null,
        impl.onVibrate.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.VibrationManagerListener = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.VibrationManagerListener";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.VibrationManagerListenerRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.VibrationManagerListenerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the VibrationManagerListener
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.VibrationManagerListenerCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.VibrationManagerListenerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.VibrationManagerListenerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onVibrate =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.VibrationManagerListener_OnVibrate_ParamsSpec.$,
        null,
        this.onVibrate.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.VibrationManager_Vibrate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.VibrationManager_Vibrate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.VibrationManager_Vibrate_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.VibrationManager_Vibrate_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.VibrationManager_Cancel_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.VibrationManager_Cancel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.VibrationManager_Cancel_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.VibrationManager_Cancel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.VibrationManagerListener_OnVibrate_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.VibrationManagerListener_OnVibrate_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.VibrationManager_Vibrate_ParamsSpec.$,
    'VibrationManager_Vibrate_Params',
    [
      mojo.internal.StructField(
        'milliseconds', 0,
        0,
        mojo.internal.Int64,
        BigInt(0),
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.VibrationManager_Vibrate_Params');

/** @record */
device.mojom.VibrationManager_Vibrate_Params = class {
  constructor() {
    /** @export { !bigint } */
    this.milliseconds;
  }
};



mojo.internal.Struct(
    device.mojom.VibrationManager_Vibrate_ResponseParamsSpec.$,
    'VibrationManager_Vibrate_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.VibrationManager_Vibrate_ResponseParams');

/** @record */
device.mojom.VibrationManager_Vibrate_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.VibrationManager_Cancel_ParamsSpec.$,
    'VibrationManager_Cancel_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.VibrationManager_Cancel_Params');

/** @record */
device.mojom.VibrationManager_Cancel_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.VibrationManager_Cancel_ResponseParamsSpec.$,
    'VibrationManager_Cancel_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.VibrationManager_Cancel_ResponseParams');

/** @record */
device.mojom.VibrationManager_Cancel_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.VibrationManagerListener_OnVibrate_ParamsSpec.$,
    'VibrationManagerListener_OnVibrate_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.VibrationManagerListener_OnVibrate_Params');

/** @record */
device.mojom.VibrationManagerListener_OnVibrate_Params = class {
  constructor() {
  }
};

