// services/device/public/mojom/usb_device.mojom-lite-for-compile.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2018 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
/**
 * @fileoverview
 * @suppress {missingRequire}
 */
'use strict';

goog.require('mojo.internal');
goog.require('mojo.internal.interfaceSupport');

goog.require('mojoBase.mojom.ReadOnlyBuffer');
goog.require('mojoBase.mojom.String16');
goog.require('url.mojom.Url');



goog.provide('device.mojom.USB_AUDIO_CLASS');
/**
 * @const { !number }
 * @export
 */
device.mojom.USB_AUDIO_CLASS = 0x01;
goog.provide('device.mojom.USB_COMM_CLASS');
/**
 * @const { !number }
 * @export
 */
device.mojom.USB_COMM_CLASS = 0x02;
goog.provide('device.mojom.USB_HID_CLASS');
/**
 * @const { !number }
 * @export
 */
device.mojom.USB_HID_CLASS = 0x03;
goog.provide('device.mojom.USB_MASS_STORAGE_CLASS');
/**
 * @const { !number }
 * @export
 */
device.mojom.USB_MASS_STORAGE_CLASS = 0x08;
goog.provide('device.mojom.USB_SMART_CARD_CLASS');
/**
 * @const { !number }
 * @export
 */
device.mojom.USB_SMART_CARD_CLASS = 0x0B;
goog.provide('device.mojom.USB_VIDEO_CLASS');
/**
 * @const { !number }
 * @export
 */
device.mojom.USB_VIDEO_CLASS = 0x0E;
goog.provide('device.mojom.USB_AUDIO_VIDEO_CLASS');
/**
 * @const { !number }
 * @export
 */
device.mojom.USB_AUDIO_VIDEO_CLASS = 0x10;
goog.provide('device.mojom.USB_WIRELESS_CLASS');
/**
 * @const { !number }
 * @export
 */
device.mojom.USB_WIRELESS_CLASS = 0xE0;

goog.provide('device.mojom.UsbOpenDeviceSuccess');
goog.provide('device.mojom.UsbOpenDeviceSuccessSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbOpenDeviceSuccessSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UsbOpenDeviceSuccess = {
  
  OK: 0,
  MIN_VALUE: 0,
  MAX_VALUE: 0,
};

goog.provide('device.mojom.UsbOpenDeviceError');
goog.provide('device.mojom.UsbOpenDeviceErrorSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbOpenDeviceErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UsbOpenDeviceError = {
  
  ACCESS_DENIED: 0,
  ALREADY_OPEN: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('device.mojom.UsbClaimInterfaceResult');
goog.provide('device.mojom.UsbClaimInterfaceResultSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbClaimInterfaceResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UsbClaimInterfaceResult = {
  
  kSuccess: 0,
  kProtectedClass: 1,
  kFailure: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};

goog.provide('device.mojom.UsbTransferDirection');
goog.provide('device.mojom.UsbTransferDirectionSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbTransferDirectionSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UsbTransferDirection = {
  
  INBOUND: 0,
  OUTBOUND: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

goog.provide('device.mojom.UsbControlTransferType');
goog.provide('device.mojom.UsbControlTransferTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbControlTransferTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UsbControlTransferType = {
  
  STANDARD: 0,
  CLASS: 1,
  VENDOR: 2,
  RESERVED: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('device.mojom.UsbControlTransferRecipient');
goog.provide('device.mojom.UsbControlTransferRecipientSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbControlTransferRecipientSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UsbControlTransferRecipient = {
  
  DEVICE: 0,
  INTERFACE: 1,
  ENDPOINT: 2,
  OTHER: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('device.mojom.UsbTransferType');
goog.provide('device.mojom.UsbTransferTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbTransferTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UsbTransferType = {
  
  CONTROL: 0,
  ISOCHRONOUS: 1,
  BULK: 2,
  INTERRUPT: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('device.mojom.UsbSynchronizationType');
goog.provide('device.mojom.UsbSynchronizationTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbSynchronizationTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UsbSynchronizationType = {
  
  NONE: 0,
  ASYNCHRONOUS: 1,
  ADAPTIVE: 2,
  SYNCHRONOUS: 3,
  MIN_VALUE: 0,
  MAX_VALUE: 3,
};

goog.provide('device.mojom.UsbUsageType');
goog.provide('device.mojom.UsbUsageTypeSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbUsageTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UsbUsageType = {
  
  DATA: 0,
  FEEDBACK: 1,
  EXPLICIT_FEEDBACK: 2,
  PERIODIC: 3,
  NOTIFICATION: 4,
  RESERVED: 5,
  MIN_VALUE: 0,
  MAX_VALUE: 5,
};

goog.provide('device.mojom.UsbTransferStatus');
goog.provide('device.mojom.UsbTransferStatusSpec');
/**
 * @const { {$: !mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbTransferStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 * @export
 */
device.mojom.UsbTransferStatus = {
  
  COMPLETED: 0,
  TRANSFER_ERROR: 1,
  TIMEOUT: 2,
  CANCELLED: 3,
  STALLED: 4,
  DISCONNECT: 5,
  BABBLE: 6,
  SHORT_PACKET: 7,
  PERMISSION_DENIED: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};



goog.provide('device.mojom.UsbDevice');
goog.provide('device.mojom.UsbDeviceReceiver');
goog.provide('device.mojom.UsbDeviceCallbackRouter');
goog.provide('device.mojom.UsbDeviceInterface');
goog.provide('device.mojom.UsbDeviceRemote');
goog.provide('device.mojom.UsbDevicePendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.UsbDevicePendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.UsbDevice.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.UsbDeviceInterface = class {
  
  /**
   * @return {!Promise<{
        result: !device.mojom.UsbOpenDeviceResult,
   *  }>}
   */

  open() {}
  
  /**
   * @return {!Promise}
   */

  close() {}
  
  /**
   * @param { !number } value
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setConfiguration(value) {}
  
  /**
   * @param { !number } interfaceNumber
   * @return {!Promise<{
        result: !device.mojom.UsbClaimInterfaceResult,
   *  }>}
   */

  claimInterface(interfaceNumber) {}
  
  /**
   * @param { !number } interfaceNumber
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  releaseInterface(interfaceNumber) {}
  
  /**
   * @param { !number } interfaceNumber
   * @param { !number } alternateSetting
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setInterfaceAlternateSetting(interfaceNumber, alternateSetting) {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  reset() {}
  
  /**
   * @param { !device.mojom.UsbTransferDirection } direction
   * @param { !number } endpointNumber
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  clearHalt(direction, endpointNumber) {}
  
  /**
   * @param { !device.mojom.UsbControlTransferParams } params
   * @param { !number } length
   * @param { !number } timeout
   * @return {!Promise<{
        status: !device.mojom.UsbTransferStatus,
        data: !mojoBase.mojom.ReadOnlyBuffer,
   *  }>}
   */

  controlTransferIn(params, length, timeout) {}
  
  /**
   * @param { !device.mojom.UsbControlTransferParams } params
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !number } timeout
   * @return {!Promise<{
        status: !device.mojom.UsbTransferStatus,
   *  }>}
   */

  controlTransferOut(params, data, timeout) {}
  
  /**
   * @param { !number } endpointNumber
   * @param { !number } length
   * @param { !number } timeout
   * @return {!Promise<{
        status: !device.mojom.UsbTransferStatus,
        data: !mojoBase.mojom.ReadOnlyBuffer,
   *  }>}
   */

  genericTransferIn(endpointNumber, length, timeout) {}
  
  /**
   * @param { !number } endpointNumber
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !number } timeout
   * @return {!Promise<{
        status: !device.mojom.UsbTransferStatus,
   *  }>}
   */

  genericTransferOut(endpointNumber, data, timeout) {}
  
  /**
   * @param { !number } endpointNumber
   * @param { !Array<!number> } packetLengths
   * @param { !number } timeout
   * @return {!Promise<{
        data: !mojoBase.mojom.ReadOnlyBuffer,
        packets: !Array<!device.mojom.UsbIsochronousPacket>,
   *  }>}
   */

  isochronousTransferIn(endpointNumber, packetLengths, timeout) {}
  
  /**
   * @param { !number } endpointNumber
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !Array<!number> } packetLengths
   * @param { !number } timeout
   * @return {!Promise<{
        packets: !Array<!device.mojom.UsbIsochronousPacket>,
   *  }>}
   */

  isochronousTransferOut(endpointNumber, data, packetLengths, timeout) {}
};

/**
 * @export
 * @implements { device.mojom.UsbDeviceInterface }
 */
device.mojom.UsbDeviceRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.UsbDevicePendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.UsbDevicePendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.UsbDevicePendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        result: !device.mojom.UsbOpenDeviceResult,
   *  }>}
   */

  open() {
    return this.proxy.sendMessage(
        0,
        device.mojom.UsbDevice_Open_ParamsSpec.$,
        device.mojom.UsbDevice_Open_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise}
   */

  close() {
    return this.proxy.sendMessage(
        1,
        device.mojom.UsbDevice_Close_ParamsSpec.$,
        device.mojom.UsbDevice_Close_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } value
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setConfiguration(
      value) {
    return this.proxy.sendMessage(
        2,
        device.mojom.UsbDevice_SetConfiguration_ParamsSpec.$,
        device.mojom.UsbDevice_SetConfiguration_ResponseParamsSpec.$,
        [
          value
        ],
        false);
  }

  
  /**
   * @param { !number } interfaceNumber
   * @return {!Promise<{
        result: !device.mojom.UsbClaimInterfaceResult,
   *  }>}
   */

  claimInterface(
      interfaceNumber) {
    return this.proxy.sendMessage(
        3,
        device.mojom.UsbDevice_ClaimInterface_ParamsSpec.$,
        device.mojom.UsbDevice_ClaimInterface_ResponseParamsSpec.$,
        [
          interfaceNumber
        ],
        false);
  }

  
  /**
   * @param { !number } interfaceNumber
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  releaseInterface(
      interfaceNumber) {
    return this.proxy.sendMessage(
        4,
        device.mojom.UsbDevice_ReleaseInterface_ParamsSpec.$,
        device.mojom.UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
        [
          interfaceNumber
        ],
        false);
  }

  
  /**
   * @param { !number } interfaceNumber
   * @param { !number } alternateSetting
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setInterfaceAlternateSetting(
      interfaceNumber,
      alternateSetting) {
    return this.proxy.sendMessage(
        5,
        device.mojom.UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
        device.mojom.UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
        [
          interfaceNumber,
          alternateSetting
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  reset() {
    return this.proxy.sendMessage(
        6,
        device.mojom.UsbDevice_Reset_ParamsSpec.$,
        device.mojom.UsbDevice_Reset_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.UsbTransferDirection } direction
   * @param { !number } endpointNumber
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  clearHalt(
      direction,
      endpointNumber) {
    return this.proxy.sendMessage(
        7,
        device.mojom.UsbDevice_ClearHalt_ParamsSpec.$,
        device.mojom.UsbDevice_ClearHalt_ResponseParamsSpec.$,
        [
          direction,
          endpointNumber
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.UsbControlTransferParams } params
   * @param { !number } length
   * @param { !number } timeout
   * @return {!Promise<{
        status: !device.mojom.UsbTransferStatus,
        data: !mojoBase.mojom.ReadOnlyBuffer,
   *  }>}
   */

  controlTransferIn(
      params,
      length,
      timeout) {
    return this.proxy.sendMessage(
        8,
        device.mojom.UsbDevice_ControlTransferIn_ParamsSpec.$,
        device.mojom.UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
        [
          params,
          length,
          timeout
        ],
        false);
  }

  
  /**
   * @param { !device.mojom.UsbControlTransferParams } params
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !number } timeout
   * @return {!Promise<{
        status: !device.mojom.UsbTransferStatus,
   *  }>}
   */

  controlTransferOut(
      params,
      data,
      timeout) {
    return this.proxy.sendMessage(
        9,
        device.mojom.UsbDevice_ControlTransferOut_ParamsSpec.$,
        device.mojom.UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
        [
          params,
          data,
          timeout
        ],
        false);
  }

  
  /**
   * @param { !number } endpointNumber
   * @param { !number } length
   * @param { !number } timeout
   * @return {!Promise<{
        status: !device.mojom.UsbTransferStatus,
        data: !mojoBase.mojom.ReadOnlyBuffer,
   *  }>}
   */

  genericTransferIn(
      endpointNumber,
      length,
      timeout) {
    return this.proxy.sendMessage(
        10,
        device.mojom.UsbDevice_GenericTransferIn_ParamsSpec.$,
        device.mojom.UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
        [
          endpointNumber,
          length,
          timeout
        ],
        false);
  }

  
  /**
   * @param { !number } endpointNumber
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !number } timeout
   * @return {!Promise<{
        status: !device.mojom.UsbTransferStatus,
   *  }>}
   */

  genericTransferOut(
      endpointNumber,
      data,
      timeout) {
    return this.proxy.sendMessage(
        11,
        device.mojom.UsbDevice_GenericTransferOut_ParamsSpec.$,
        device.mojom.UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
        [
          endpointNumber,
          data,
          timeout
        ],
        false);
  }

  
  /**
   * @param { !number } endpointNumber
   * @param { !Array<!number> } packetLengths
   * @param { !number } timeout
   * @return {!Promise<{
        data: !mojoBase.mojom.ReadOnlyBuffer,
        packets: !Array<!device.mojom.UsbIsochronousPacket>,
   *  }>}
   */

  isochronousTransferIn(
      endpointNumber,
      packetLengths,
      timeout) {
    return this.proxy.sendMessage(
        12,
        device.mojom.UsbDevice_IsochronousTransferIn_ParamsSpec.$,
        device.mojom.UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
        [
          endpointNumber,
          packetLengths,
          timeout
        ],
        false);
  }

  
  /**
   * @param { !number } endpointNumber
   * @param { !mojoBase.mojom.ReadOnlyBuffer } data
   * @param { !Array<!number> } packetLengths
   * @param { !number } timeout
   * @return {!Promise<{
        packets: !Array<!device.mojom.UsbIsochronousPacket>,
   *  }>}
   */

  isochronousTransferOut(
      endpointNumber,
      data,
      packetLengths,
      timeout) {
    return this.proxy.sendMessage(
        13,
        device.mojom.UsbDevice_IsochronousTransferOut_ParamsSpec.$,
        device.mojom.UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
        [
          endpointNumber,
          data,
          packetLengths,
          timeout
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UsbDevice
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.UsbDeviceReceiver = class {
  /**
   * @param {!device.mojom.UsbDeviceInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.UsbDeviceRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.UsbDeviceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.UsbDeviceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.UsbDevice_Open_ParamsSpec.$,
        device.mojom.UsbDevice_Open_ResponseParamsSpec.$,
        impl.open.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.UsbDevice_Close_ParamsSpec.$,
        device.mojom.UsbDevice_Close_ResponseParamsSpec.$,
        impl.close.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        device.mojom.UsbDevice_SetConfiguration_ParamsSpec.$,
        device.mojom.UsbDevice_SetConfiguration_ResponseParamsSpec.$,
        impl.setConfiguration.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        device.mojom.UsbDevice_ClaimInterface_ParamsSpec.$,
        device.mojom.UsbDevice_ClaimInterface_ResponseParamsSpec.$,
        impl.claimInterface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        device.mojom.UsbDevice_ReleaseInterface_ParamsSpec.$,
        device.mojom.UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
        impl.releaseInterface.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        device.mojom.UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
        device.mojom.UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
        impl.setInterfaceAlternateSetting.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        device.mojom.UsbDevice_Reset_ParamsSpec.$,
        device.mojom.UsbDevice_Reset_ResponseParamsSpec.$,
        impl.reset.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        device.mojom.UsbDevice_ClearHalt_ParamsSpec.$,
        device.mojom.UsbDevice_ClearHalt_ResponseParamsSpec.$,
        impl.clearHalt.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        device.mojom.UsbDevice_ControlTransferIn_ParamsSpec.$,
        device.mojom.UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
        impl.controlTransferIn.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        device.mojom.UsbDevice_ControlTransferOut_ParamsSpec.$,
        device.mojom.UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
        impl.controlTransferOut.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        device.mojom.UsbDevice_GenericTransferIn_ParamsSpec.$,
        device.mojom.UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
        impl.genericTransferIn.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        11,
        device.mojom.UsbDevice_GenericTransferOut_ParamsSpec.$,
        device.mojom.UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
        impl.genericTransferOut.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        12,
        device.mojom.UsbDevice_IsochronousTransferIn_ParamsSpec.$,
        device.mojom.UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
        impl.isochronousTransferIn.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        13,
        device.mojom.UsbDevice_IsochronousTransferOut_ParamsSpec.$,
        device.mojom.UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
        impl.isochronousTransferOut.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.UsbDevice = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.UsbDevice";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.UsbDeviceRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.UsbDeviceRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UsbDevice
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.UsbDeviceCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.UsbDeviceRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.UsbDeviceRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.open =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.UsbDevice_Open_ParamsSpec.$,
        device.mojom.UsbDevice_Open_ResponseParamsSpec.$,
        this.open.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.close =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.UsbDevice_Close_ParamsSpec.$,
        device.mojom.UsbDevice_Close_ResponseParamsSpec.$,
        this.close.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setConfiguration =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        device.mojom.UsbDevice_SetConfiguration_ParamsSpec.$,
        device.mojom.UsbDevice_SetConfiguration_ResponseParamsSpec.$,
        this.setConfiguration.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.claimInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        device.mojom.UsbDevice_ClaimInterface_ParamsSpec.$,
        device.mojom.UsbDevice_ClaimInterface_ResponseParamsSpec.$,
        this.claimInterface.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.releaseInterface =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        device.mojom.UsbDevice_ReleaseInterface_ParamsSpec.$,
        device.mojom.UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
        this.releaseInterface.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setInterfaceAlternateSetting =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        device.mojom.UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
        device.mojom.UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
        this.setInterfaceAlternateSetting.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.reset =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        device.mojom.UsbDevice_Reset_ParamsSpec.$,
        device.mojom.UsbDevice_Reset_ResponseParamsSpec.$,
        this.reset.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.clearHalt =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        device.mojom.UsbDevice_ClearHalt_ParamsSpec.$,
        device.mojom.UsbDevice_ClearHalt_ResponseParamsSpec.$,
        this.clearHalt.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.controlTransferIn =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        device.mojom.UsbDevice_ControlTransferIn_ParamsSpec.$,
        device.mojom.UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
        this.controlTransferIn.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.controlTransferOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        device.mojom.UsbDevice_ControlTransferOut_ParamsSpec.$,
        device.mojom.UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
        this.controlTransferOut.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.genericTransferIn =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        device.mojom.UsbDevice_GenericTransferIn_ParamsSpec.$,
        device.mojom.UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
        this.genericTransferIn.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.genericTransferOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        11,
        device.mojom.UsbDevice_GenericTransferOut_ParamsSpec.$,
        device.mojom.UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
        this.genericTransferOut.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isochronousTransferIn =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        12,
        device.mojom.UsbDevice_IsochronousTransferIn_ParamsSpec.$,
        device.mojom.UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
        this.isochronousTransferIn.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.isochronousTransferOut =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        13,
        device.mojom.UsbDevice_IsochronousTransferOut_ParamsSpec.$,
        device.mojom.UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
        this.isochronousTransferOut.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.UsbDeviceClient');
goog.provide('device.mojom.UsbDeviceClientReceiver');
goog.provide('device.mojom.UsbDeviceClientCallbackRouter');
goog.provide('device.mojom.UsbDeviceClientInterface');
goog.provide('device.mojom.UsbDeviceClientRemote');
goog.provide('device.mojom.UsbDeviceClientPendingReceiver');


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 * @export
 */
device.mojom.UsbDeviceClientPendingReceiver = class {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle,
        device.mojom.UsbDeviceClient.$interfaceName,
        scope);
  }
};

/** @interface */
device.mojom.UsbDeviceClientInterface = class {
  
  /**
   */

  onDeviceOpened() {}
  
  /**
   */

  onDeviceClosed() {}
};

/**
 * @export
 * @implements { device.mojom.UsbDeviceClientInterface }
 */
device.mojom.UsbDeviceClientRemote = class {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!device.mojom.UsbDeviceClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          device.mojom.UsbDeviceClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!device.mojom.UsbDeviceClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onDeviceOpened() {
    this.proxy.sendMessage(
        0,
        device.mojom.UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  onDeviceClosed() {
    this.proxy.sendMessage(
        1,
        device.mojom.UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
};

/**
 * An object which receives request messages for the UsbDeviceClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 *
 * @export
 */
device.mojom.UsbDeviceClientReceiver = class {
  /**
   * @param {!device.mojom.UsbDeviceClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!device.mojom.UsbDeviceClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        device.mojom.UsbDeviceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.UsbDeviceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        device.mojom.UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
        null,
        impl.onDeviceOpened.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        device.mojom.UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
        null,
        impl.onDeviceClosed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
};

/**
 *  @export
 */
device.mojom.UsbDeviceClient = class {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.UsbDeviceClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!device.mojom.UsbDeviceClientRemote}
   * @export
   */
  static getRemote() {
    let remote = new device.mojom.UsbDeviceClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
};


/**
 * An object which receives request messages for the UsbDeviceClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 *
 * @export
 */
device.mojom.UsbDeviceClientCallbackRouter = class {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      device.mojom.UsbDeviceClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!device.mojom.UsbDeviceClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceOpened =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        device.mojom.UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
        null,
        this.onDeviceOpened.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onDeviceClosed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        device.mojom.UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
        null,
        this.onDeviceClosed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   * @export
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
};


goog.provide('device.mojom.UsbEndpointInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbEndpointInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbAlternateInterfaceInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbAlternateInterfaceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbInterfaceInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbInterfaceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbConfigurationInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbConfigurationInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDeviceInfoSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbControlTransferParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbControlTransferParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbIsochronousPacketSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbIsochronousPacketSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_Open_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_Open_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_Open_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_Open_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_Close_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_Close_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_Close_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_Close_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_SetConfiguration_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_SetConfiguration_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_SetConfiguration_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_SetConfiguration_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_ClaimInterface_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_ClaimInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_ClaimInterface_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_ClaimInterface_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_ReleaseInterface_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_ReleaseInterface_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_ReleaseInterface_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_ReleaseInterface_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_SetInterfaceAlternateSetting_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_SetInterfaceAlternateSetting_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_Reset_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_Reset_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_Reset_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_Reset_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_ClearHalt_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_ClearHalt_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_ClearHalt_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_ClearHalt_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_ControlTransferIn_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_ControlTransferIn_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_ControlTransferIn_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_ControlTransferIn_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_ControlTransferOut_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_ControlTransferOut_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_ControlTransferOut_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_ControlTransferOut_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_GenericTransferIn_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_GenericTransferIn_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_GenericTransferIn_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_GenericTransferIn_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_GenericTransferOut_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_GenericTransferOut_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_GenericTransferOut_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_GenericTransferOut_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_IsochronousTransferIn_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_IsochronousTransferIn_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_IsochronousTransferIn_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_IsochronousTransferIn_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_IsochronousTransferOut_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_IsochronousTransferOut_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDevice_IsochronousTransferOut_ResponseParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDevice_IsochronousTransferOut_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDeviceClient_OnDeviceOpened_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDeviceClient_OnDeviceOpened_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbDeviceClient_OnDeviceClosed_ParamsSpec');
/**
 * @const { {$:!mojo.internal.MojomType}}
 * @export
 */
device.mojom.UsbDeviceClient_OnDeviceClosed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

goog.provide('device.mojom.UsbOpenDeviceResultSpec');
/**
 * @const { {$:!mojo.internal.MojomType} }
 * @export
 */
device.mojom.UsbOpenDeviceResultSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    device.mojom.UsbEndpointInfoSpec.$,
    'UsbEndpointInfo',
    [
      mojo.internal.StructField(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'direction', 4,
        0,
        device.mojom.UsbTransferDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'type', 8,
        0,
        device.mojom.UsbTransferTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'packetSize', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'synchronizationType', 16,
        0,
        device.mojom.UsbSynchronizationTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usageType', 20,
        0,
        device.mojom.UsbUsageTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'pollingInterval', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extraData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('device.mojom.UsbEndpointInfo');

/** @record */
device.mojom.UsbEndpointInfo = class {
  constructor() {
    /** @export { !number } */
    this.endpointNumber;
    /** @export { !device.mojom.UsbTransferDirection } */
    this.direction;
    /** @export { !device.mojom.UsbTransferType } */
    this.type;
    /** @export { !number } */
    this.packetSize;
    /** @export { !device.mojom.UsbSynchronizationType } */
    this.synchronizationType;
    /** @export { !device.mojom.UsbUsageType } */
    this.usageType;
    /** @export { !number } */
    this.pollingInterval;
    /** @export { !Array<!number> } */
    this.extraData;
  }
};



mojo.internal.Struct(
    device.mojom.UsbAlternateInterfaceInfoSpec.$,
    'UsbAlternateInterfaceInfo',
    [
      mojo.internal.StructField(
        'alternateSetting', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'classCode', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subclassCode', 2,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protocolCode', 3,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interfaceName', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpoints', 16,
        0,
        mojo.internal.Array(device.mojom.UsbEndpointInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extraData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('device.mojom.UsbAlternateInterfaceInfo');

/** @record */
device.mojom.UsbAlternateInterfaceInfo = class {
  constructor() {
    /** @export { !number } */
    this.alternateSetting;
    /** @export { !number } */
    this.classCode;
    /** @export { !number } */
    this.subclassCode;
    /** @export { !number } */
    this.protocolCode;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.interfaceName;
    /** @export { !Array<!device.mojom.UsbEndpointInfo> } */
    this.endpoints;
    /** @export { !Array<!number> } */
    this.extraData;
  }
};



mojo.internal.Struct(
    device.mojom.UsbInterfaceInfoSpec.$,
    'UsbInterfaceInfo',
    [
      mojo.internal.StructField(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'firstInterface', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alternates', 8,
        0,
        mojo.internal.Array(device.mojom.UsbAlternateInterfaceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbInterfaceInfo');

/** @record */
device.mojom.UsbInterfaceInfo = class {
  constructor() {
    /** @export { !number } */
    this.interfaceNumber;
    /** @export { !number } */
    this.firstInterface;
    /** @export { !Array<!device.mojom.UsbAlternateInterfaceInfo> } */
    this.alternates;
  }
};



mojo.internal.Struct(
    device.mojom.UsbConfigurationInfoSpec.$,
    'UsbConfigurationInfo',
    [
      mojo.internal.StructField(
        'configurationValue', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'configurationName', 8,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'selfPowered', 1,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'remoteWakeup', 1,
        1,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'maximumPower', 2,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'interfaces', 16,
        0,
        mojo.internal.Array(device.mojom.UsbInterfaceInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'extraData', 24,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 40],]);



goog.provide('device.mojom.UsbConfigurationInfo');

/** @record */
device.mojom.UsbConfigurationInfo = class {
  constructor() {
    /** @export { !number } */
    this.configurationValue;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.configurationName;
    /** @export { !boolean } */
    this.selfPowered;
    /** @export { !boolean } */
    this.remoteWakeup;
    /** @export { !number } */
    this.maximumPower;
    /** @export { !Array<!device.mojom.UsbInterfaceInfo> } */
    this.interfaces;
    /** @export { !Array<!number> } */
    this.extraData;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDeviceInfoSpec.$,
    'UsbDeviceInfo',
    [
      mojo.internal.StructField(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usbVersionMajor', 8,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usbVersionMinor', 9,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'usbVersionSubminor', 10,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'classCode', 11,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'subclassCode', 12,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'protocolCode', 13,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'busNumber', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'portNumber', 20,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'vendorId', 14,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'productId', 24,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceVersionMajor', 26,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceVersionMinor', 27,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'deviceVersionSubminor', 28,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'manufacturerName', 32,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'productName', 40,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'serialNumber', 48,
        0,
        mojoBase.mojom.String16Spec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'webusbLandingPage', 56,
        0,
        url.mojom.UrlSpec.$,
        null,
        true, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'activeConfiguration', 29,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'configurations', 64,
        0,
        mojo.internal.Array(device.mojom.UsbConfigurationInfoSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 80],]);



goog.provide('device.mojom.UsbDeviceInfo');

/** @record */
device.mojom.UsbDeviceInfo = class {
  constructor() {
    /** @export { !string } */
    this.guid;
    /** @export { !number } */
    this.usbVersionMajor;
    /** @export { !number } */
    this.usbVersionMinor;
    /** @export { !number } */
    this.usbVersionSubminor;
    /** @export { !number } */
    this.classCode;
    /** @export { !number } */
    this.subclassCode;
    /** @export { !number } */
    this.protocolCode;
    /** @export { !number } */
    this.busNumber;
    /** @export { !number } */
    this.portNumber;
    /** @export { !number } */
    this.vendorId;
    /** @export { !number } */
    this.productId;
    /** @export { !number } */
    this.deviceVersionMajor;
    /** @export { !number } */
    this.deviceVersionMinor;
    /** @export { !number } */
    this.deviceVersionSubminor;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.manufacturerName;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.productName;
    /** @export { (mojoBase.mojom.String16|undefined) } */
    this.serialNumber;
    /** @export { (url.mojom.Url|undefined) } */
    this.webusbLandingPage;
    /** @export { !number } */
    this.activeConfiguration;
    /** @export { !Array<!device.mojom.UsbConfigurationInfo> } */
    this.configurations;
  }
};

/**
 * @const { !string }
 * @export
 */
device.mojom.UsbControlTransferParams_SECURITY_KEY_AOA_MODEL =
    "12eba9f901039b36";



mojo.internal.Struct(
    device.mojom.UsbControlTransferParamsSpec.$,
    'UsbControlTransferParams',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        device.mojom.UsbControlTransferTypeSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'recipient', 4,
        0,
        device.mojom.UsbControlTransferRecipientSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'request', 8,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'value', 10,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'index', 12,
        0,
        mojo.internal.Uint16,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbControlTransferParams');

/** @record */
device.mojom.UsbControlTransferParams = class {
  constructor() {
    /** @export { !device.mojom.UsbControlTransferType } */
    this.type;
    /** @export { !device.mojom.UsbControlTransferRecipient } */
    this.recipient;
    /** @export { !number } */
    this.request;
    /** @export { !number } */
    this.value;
    /** @export { !number } */
    this.index;
  }
};



mojo.internal.Struct(
    device.mojom.UsbIsochronousPacketSpec.$,
    'UsbIsochronousPacket',
    [
      mojo.internal.StructField(
        'length', 0,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'transferredLength', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'status', 8,
        0,
        device.mojom.UsbTransferStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbIsochronousPacket');

/** @record */
device.mojom.UsbIsochronousPacket = class {
  constructor() {
    /** @export { !number } */
    this.length;
    /** @export { !number } */
    this.transferredLength;
    /** @export { !device.mojom.UsbTransferStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_Open_ParamsSpec.$,
    'UsbDevice_Open_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.UsbDevice_Open_Params');

/** @record */
device.mojom.UsbDevice_Open_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_Open_ResponseParamsSpec.$,
    'UsbDevice_Open_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.UsbOpenDeviceResultSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbDevice_Open_ResponseParams');

/** @record */
device.mojom.UsbDevice_Open_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.UsbOpenDeviceResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_Close_ParamsSpec.$,
    'UsbDevice_Close_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.UsbDevice_Close_Params');

/** @record */
device.mojom.UsbDevice_Close_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_Close_ResponseParamsSpec.$,
    'UsbDevice_Close_ResponseParams',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.UsbDevice_Close_ResponseParams');

/** @record */
device.mojom.UsbDevice_Close_ResponseParams = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_SetConfiguration_ParamsSpec.$,
    'UsbDevice_SetConfiguration_Params',
    [
      mojo.internal.StructField(
        'value', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_SetConfiguration_Params');

/** @record */
device.mojom.UsbDevice_SetConfiguration_Params = class {
  constructor() {
    /** @export { !number } */
    this.value;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_SetConfiguration_ResponseParamsSpec.$,
    'UsbDevice_SetConfiguration_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_SetConfiguration_ResponseParams');

/** @record */
device.mojom.UsbDevice_SetConfiguration_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_ClaimInterface_ParamsSpec.$,
    'UsbDevice_ClaimInterface_Params',
    [
      mojo.internal.StructField(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_ClaimInterface_Params');

/** @record */
device.mojom.UsbDevice_ClaimInterface_Params = class {
  constructor() {
    /** @export { !number } */
    this.interfaceNumber;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_ClaimInterface_ResponseParamsSpec.$,
    'UsbDevice_ClaimInterface_ResponseParams',
    [
      mojo.internal.StructField(
        'result', 0,
        0,
        device.mojom.UsbClaimInterfaceResultSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_ClaimInterface_ResponseParams');

/** @record */
device.mojom.UsbDevice_ClaimInterface_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.UsbClaimInterfaceResult } */
    this.result;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_ReleaseInterface_ParamsSpec.$,
    'UsbDevice_ReleaseInterface_Params',
    [
      mojo.internal.StructField(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_ReleaseInterface_Params');

/** @record */
device.mojom.UsbDevice_ReleaseInterface_Params = class {
  constructor() {
    /** @export { !number } */
    this.interfaceNumber;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_ReleaseInterface_ResponseParamsSpec.$,
    'UsbDevice_ReleaseInterface_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_ReleaseInterface_ResponseParams');

/** @record */
device.mojom.UsbDevice_ReleaseInterface_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_SetInterfaceAlternateSetting_ParamsSpec.$,
    'UsbDevice_SetInterfaceAlternateSetting_Params',
    [
      mojo.internal.StructField(
        'interfaceNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'alternateSetting', 1,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_SetInterfaceAlternateSetting_Params');

/** @record */
device.mojom.UsbDevice_SetInterfaceAlternateSetting_Params = class {
  constructor() {
    /** @export { !number } */
    this.interfaceNumber;
    /** @export { !number } */
    this.alternateSetting;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_SetInterfaceAlternateSetting_ResponseParamsSpec.$,
    'UsbDevice_SetInterfaceAlternateSetting_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_SetInterfaceAlternateSetting_ResponseParams');

/** @record */
device.mojom.UsbDevice_SetInterfaceAlternateSetting_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_Reset_ParamsSpec.$,
    'UsbDevice_Reset_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.UsbDevice_Reset_Params');

/** @record */
device.mojom.UsbDevice_Reset_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_Reset_ResponseParamsSpec.$,
    'UsbDevice_Reset_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_Reset_ResponseParams');

/** @record */
device.mojom.UsbDevice_Reset_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_ClearHalt_ParamsSpec.$,
    'UsbDevice_ClearHalt_Params',
    [
      mojo.internal.StructField(
        'direction', 0,
        0,
        device.mojom.UsbTransferDirectionSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'endpointNumber', 4,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_ClearHalt_Params');

/** @record */
device.mojom.UsbDevice_ClearHalt_Params = class {
  constructor() {
    /** @export { !device.mojom.UsbTransferDirection } */
    this.direction;
    /** @export { !number } */
    this.endpointNumber;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_ClearHalt_ResponseParamsSpec.$,
    'UsbDevice_ClearHalt_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_ClearHalt_ResponseParams');

/** @record */
device.mojom.UsbDevice_ClearHalt_ResponseParams = class {
  constructor() {
    /** @export { !boolean } */
    this.success;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_ControlTransferIn_ParamsSpec.$,
    'UsbDevice_ControlTransferIn_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        device.mojom.UsbControlTransferParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 12,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbDevice_ControlTransferIn_Params');

/** @record */
device.mojom.UsbDevice_ControlTransferIn_Params = class {
  constructor() {
    /** @export { !device.mojom.UsbControlTransferParams } */
    this.params;
    /** @export { !number } */
    this.length;
    /** @export { !number } */
    this.timeout;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_ControlTransferIn_ResponseParamsSpec.$,
    'UsbDevice_ControlTransferIn_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        device.mojom.UsbTransferStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbDevice_ControlTransferIn_ResponseParams');

/** @record */
device.mojom.UsbDevice_ControlTransferIn_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.UsbTransferStatus } */
    this.status;
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_ControlTransferOut_ParamsSpec.$,
    'UsbDevice_ControlTransferOut_Params',
    [
      mojo.internal.StructField(
        'params', 0,
        0,
        device.mojom.UsbControlTransferParamsSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 16,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.UsbDevice_ControlTransferOut_Params');

/** @record */
device.mojom.UsbDevice_ControlTransferOut_Params = class {
  constructor() {
    /** @export { !device.mojom.UsbControlTransferParams } */
    this.params;
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
    /** @export { !number } */
    this.timeout;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_ControlTransferOut_ResponseParamsSpec.$,
    'UsbDevice_ControlTransferOut_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        device.mojom.UsbTransferStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_ControlTransferOut_ResponseParams');

/** @record */
device.mojom.UsbDevice_ControlTransferOut_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.UsbTransferStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_GenericTransferIn_ParamsSpec.$,
    'UsbDevice_GenericTransferIn_Params',
    [
      mojo.internal.StructField(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'length', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 8,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbDevice_GenericTransferIn_Params');

/** @record */
device.mojom.UsbDevice_GenericTransferIn_Params = class {
  constructor() {
    /** @export { !number } */
    this.endpointNumber;
    /** @export { !number } */
    this.length;
    /** @export { !number } */
    this.timeout;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_GenericTransferIn_ResponseParamsSpec.$,
    'UsbDevice_GenericTransferIn_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        device.mojom.UsbTransferStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbDevice_GenericTransferIn_ResponseParams');

/** @record */
device.mojom.UsbDevice_GenericTransferIn_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.UsbTransferStatus } */
    this.status;
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_GenericTransferOut_ParamsSpec.$,
    'UsbDevice_GenericTransferOut_Params',
    [
      mojo.internal.StructField(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbDevice_GenericTransferOut_Params');

/** @record */
device.mojom.UsbDevice_GenericTransferOut_Params = class {
  constructor() {
    /** @export { !number } */
    this.endpointNumber;
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
    /** @export { !number } */
    this.timeout;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_GenericTransferOut_ResponseParamsSpec.$,
    'UsbDevice_GenericTransferOut_ResponseParams',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        device.mojom.UsbTransferStatusSpec.$,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_GenericTransferOut_ResponseParams');

/** @record */
device.mojom.UsbDevice_GenericTransferOut_ResponseParams = class {
  constructor() {
    /** @export { !device.mojom.UsbTransferStatus } */
    this.status;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_IsochronousTransferIn_ParamsSpec.$,
    'UsbDevice_IsochronousTransferIn_Params',
    [
      mojo.internal.StructField(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'packetLengths', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbDevice_IsochronousTransferIn_Params');

/** @record */
device.mojom.UsbDevice_IsochronousTransferIn_Params = class {
  constructor() {
    /** @export { !number } */
    this.endpointNumber;
    /** @export { !Array<!number> } */
    this.packetLengths;
    /** @export { !number } */
    this.timeout;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_IsochronousTransferIn_ResponseParamsSpec.$,
    'UsbDevice_IsochronousTransferIn_ResponseParams',
    [
      mojo.internal.StructField(
        'data', 0,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'packets', 8,
        0,
        mojo.internal.Array(device.mojom.UsbIsochronousPacketSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 24],]);



goog.provide('device.mojom.UsbDevice_IsochronousTransferIn_ResponseParams');

/** @record */
device.mojom.UsbDevice_IsochronousTransferIn_ResponseParams = class {
  constructor() {
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
    /** @export { !Array<!device.mojom.UsbIsochronousPacket> } */
    this.packets;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_IsochronousTransferOut_ParamsSpec.$,
    'UsbDevice_IsochronousTransferOut_Params',
    [
      mojo.internal.StructField(
        'endpointNumber', 0,
        0,
        mojo.internal.Uint8,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'data', 8,
        0,
        mojoBase.mojom.ReadOnlyBufferSpec.$,
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'packetLengths', 16,
        0,
        mojo.internal.Array(mojo.internal.Uint32, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
      mojo.internal.StructField(
        'timeout', 4,
        0,
        mojo.internal.Uint32,
        0,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 32],]);



goog.provide('device.mojom.UsbDevice_IsochronousTransferOut_Params');

/** @record */
device.mojom.UsbDevice_IsochronousTransferOut_Params = class {
  constructor() {
    /** @export { !number } */
    this.endpointNumber;
    /** @export { !mojoBase.mojom.ReadOnlyBuffer } */
    this.data;
    /** @export { !Array<!number> } */
    this.packetLengths;
    /** @export { !number } */
    this.timeout;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDevice_IsochronousTransferOut_ResponseParamsSpec.$,
    'UsbDevice_IsochronousTransferOut_ResponseParams',
    [
      mojo.internal.StructField(
        'packets', 0,
        0,
        mojo.internal.Array(device.mojom.UsbIsochronousPacketSpec.$, false),
        null,
        false, /* nullable */
        0 /* minVersion */,
      ),
    ],
    [[0, 16],]);



goog.provide('device.mojom.UsbDevice_IsochronousTransferOut_ResponseParams');

/** @record */
device.mojom.UsbDevice_IsochronousTransferOut_ResponseParams = class {
  constructor() {
    /** @export { !Array<!device.mojom.UsbIsochronousPacket> } */
    this.packets;
  }
};



mojo.internal.Struct(
    device.mojom.UsbDeviceClient_OnDeviceOpened_ParamsSpec.$,
    'UsbDeviceClient_OnDeviceOpened_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.UsbDeviceClient_OnDeviceOpened_Params');

/** @record */
device.mojom.UsbDeviceClient_OnDeviceOpened_Params = class {
  constructor() {
  }
};



mojo.internal.Struct(
    device.mojom.UsbDeviceClient_OnDeviceClosed_ParamsSpec.$,
    'UsbDeviceClient_OnDeviceClosed_Params',
    [
    ],
    [[0, 8],]);



goog.provide('device.mojom.UsbDeviceClient_OnDeviceClosed_Params');

/** @record */
device.mojom.UsbDeviceClient_OnDeviceClosed_Params = class {
  constructor() {
  }
};

goog.provide('device.mojom.UsbOpenDeviceResult');


mojo.internal.Union(
    device.mojom.UsbOpenDeviceResultSpec.$, 'UsbOpenDeviceResult',
    {
      'success': {
        'ordinal': 0,
        'type': device.mojom.UsbOpenDeviceSuccessSpec.$,
      },
      'error': {
        'ordinal': 1,
        'type': device.mojom.UsbOpenDeviceErrorSpec.$,
      },
    });

/**
 * @typedef { {
 *   success: (!device.mojom.UsbOpenDeviceSuccess|undefined),
 *   error: (!device.mojom.UsbOpenDeviceError|undefined),
 * } }
 */
device.mojom.UsbOpenDeviceResult;
