// services/device/public/mojom/sensor_provider.mojom-send-validation.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_SEND_VALIDATION_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_SEND_VALIDATION_H_

#include "services/device/public/mojom/sensor_provider.mojom-shared-internal.h"
#include "mojo/public/mojom/base/shared_memory.mojom-shared.h"
#include "services/device/public/mojom/sensor.mojom-shared.h"

#include "services/device/public/mojom/sensor_provider.mojom-data-view.h"

#include "mojo/public/cpp/bindings/lib/send_validation_type.h"
#include "mojo/public/cpp/bindings/lib/send_validation.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization_send_validation.h"
#include "mojo/public/cpp/bindings/lib/has_send_validation_helper.h"

namespace mojo::internal {
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::SensorCreationResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::CreateVirtualSensorResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::UpdateVirtualSensorResult, MaybeConstUserType>
    : std::false_type {};
template <typename MaybeConstUserType>
struct HasSendValidationSerialize<::device::mojom::GetVirtualSensorInformationError, MaybeConstUserType>
    : std::false_type {};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::SensorInitParamsDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::SensorInitParamsDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::SensorInitParams_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      decltype(Traits::sensor(input)) in_sensor = Traits::sensor(input);

      
      mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::SensorInterfaceBase>>(
        in_sensor,
        &fragment->sensor,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->sensor)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid sensor in SensorInitParams struct");

      decltype(Traits::client_receiver(input)) in_client_receiver = Traits::client_receiver(input);

      
      mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::SensorClientInterfaceBase>>(
        in_client_receiver,
        &fragment->client_receiver,
        &fragment.message());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(!mojo::internal::IsHandleOrInterfaceValid(fragment->client_receiver)),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
        "invalid client_receiver in SensorInitParams struct");

      decltype(Traits::memory(input)) in_memory = Traits::memory(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->memory)::BaseType> memory_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::mojo_base::mojom::ReadOnlySharedMemoryRegionDataView, send_validation>(
        in_memory,
        memory_fragment);

      fragment->memory.Set(
          memory_fragment.is_null() ? nullptr : memory_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->memory.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null memory in SensorInitParams struct");

      fragment->buffer_offset = Traits::buffer_offset(input);

      
      mojo::internal::Serialize<::device::mojom::ReportingMode>(
        Traits::mode(input),
        &fragment->mode);

      decltype(Traits::default_configuration(input)) in_default_configuration = Traits::default_configuration(input);
      mojo::internal::MessageFragment<
          typename decltype(fragment->default_configuration)::BaseType> default_configuration_fragment(
              fragment.message());
      
      mojo::internal::Serialize<::device::mojom::SensorConfigurationDataView, send_validation>(
        in_default_configuration,
        default_configuration_fragment);

      fragment->default_configuration.Set(
          default_configuration_fragment.is_null() ? nullptr : default_configuration_fragment.data());

      
      MOJO_INTERNAL_CHECK_SERIALIZATION(
        send_validation,
        !(fragment->default_configuration.is_null()),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null default_configuration in SensorInitParams struct");

      fragment->maximum_frequency = Traits::maximum_frequency(input);

      fragment->minimum_frequency = Traits::minimum_frequency(input);
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::VirtualSensorMetadataDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VirtualSensorMetadataDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VirtualSensorMetadata_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->available = Traits::available(input);
      fragment->maximum_frequency_$flag = Traits::maximum_frequency(input).has_value();
      if (Traits::maximum_frequency(input).has_value()) {
        fragment->maximum_frequency_$value = Traits::maximum_frequency(input).value();
      }
      fragment->minimum_frequency_$flag = Traits::minimum_frequency(input).has_value();
      if (Traits::minimum_frequency(input).has_value()) {
        fragment->minimum_frequency_$value = Traits::minimum_frequency(input).value();
      }
      fragment->reporting_mode_$flag = Traits::reporting_mode(input).has_value();
      if (Traits::reporting_mode(input).has_value()) {
        
        mojo::internal::Serialize<::device::mojom::ReportingMode>(
          Traits::reporting_mode(input).value(),
          &fragment->reporting_mode_$value);
      } else {
        fragment->reporting_mode_$value =
            static_cast<int32_t>(::device::mojom::ReportingMode::kMinValue);
      }
  }
};

template <typename MaybeConstUserType, mojo::internal::SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::VirtualSensorInformationDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::device::mojom::VirtualSensorInformationDataView, UserType>;
  static void Serialize(
      MaybeConstUserType& input,
      mojo::internal::MessageFragment<::device::mojom::internal::VirtualSensorInformation_Data>& fragment) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    fragment.Allocate();

      fragment->sampling_frequency = Traits::sampling_frequency(input);
  }
};
template <typename MaybeConstUserType, SendValidation send_validation>
struct SendValidationSerializer<::device::mojom::GetVirtualSensorInformationResultDataView, MaybeConstUserType, send_validation> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = UnionTraits<::device::mojom::GetVirtualSensorInformationResultDataView, UserType>;
  static void Serialize(MaybeConstUserType& input,
                        MessageFragment<::device::mojom::internal::GetVirtualSensorInformationResult_Data>& fragment,
                        bool inlined) {
    
    if (CallIsNullIfExists<Traits>(input)) {
       if (inlined)
        fragment->set_null();
      return;
    }

if (!inlined)
  fragment.Allocate();

    // TODO(azani): Handle unknown and objects.
    // Set the not-null flag.
fragment->size = kUnionDataSize;
fragment->tag = Traits::GetTag(input);
switch (fragment->tag) {
  case ::device::mojom::GetVirtualSensorInformationResultDataView::Tag::kInfo: {
    decltype(Traits::info(input))
    in_info = Traits::info(input);
    mojo::internal::MessageFragment<
      typename decltype(fragment->data.f_info)::BaseType>
    value_fragment(fragment.message());
        
mojo::internal::Serialize<::device::mojom::VirtualSensorInformationDataView, send_validation>(
  in_info,
  value_fragment);
  
MOJO_INTERNAL_CHECK_SERIALIZATION(
  send_validation,
  !(value_fragment.is_null()),
  mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
  "null info in GetVirtualSensorInformationResult union");
    fragment->data.f_info.Set(
      value_fragment.is_null() ? nullptr : value_fragment.data());
    break;
  }
  case ::device::mojom::GetVirtualSensorInformationResultDataView::Tag::kError: {
    decltype(Traits::error(input))
    in_error = Traits::error(input);
        
mojo::internal::Serialize<::device::mojom::GetVirtualSensorInformationError, send_validation>(
  in_error,
  &fragment->data.f_error);
    break;
  }
}
  }
};

}  // namespace mojo::internal

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_SENSOR_PROVIDER_MOJOM_SEND_VALIDATION_H_