// services/device/public/mojom/pressure_update.mojom.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2014 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

'use strict';

(function() {
  var mojomId = 'services/device/public/mojom/pressure_update.mojom';
  if (mojo.internal.isMojomLoaded(mojomId)) {
    console.warn('The following mojom is loaded multiple times: ' + mojomId);
    return;
  }
  mojo.internal.markMojomLoaded(mojomId);
  var bindings = mojo;
  var associatedBindings = mojo;
  var codec = mojo.internal;
  var validator = mojo.internal;

  var exports = mojo.internal.exposeNamespace('device.mojom');
  var time$ =
      mojo.internal.exposeNamespace('mojoBase.mojom');
  if (mojo.config.autoLoadMojomDeps) {
    mojo.internal.loadMojomIfNecessary(
        'mojo/public/mojom/base/time.mojom', '../../../../mojo/public/mojom/base/time.mojom.js');
  }


  var DEFAULT_OWN_CONTRIBUTION_ESTIMATE = -1.0;
  var PressureSource = {};
  PressureSource.kCpu = 0;
  PressureSource.MIN_VALUE = 0;
  PressureSource.MAX_VALUE = 0;

  PressureSource.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
      return true;
    }
    return false;
  };

  PressureSource.toKnownEnumValue = function(value) {
    return value;
  };

  PressureSource.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };
  var PressureState = {};
  PressureState.kNominal = 0;
  PressureState.kFair = 1;
  PressureState.kSerious = 2;
  PressureState.kCritical = 3;
  PressureState.MIN_VALUE = 0;
  PressureState.MAX_VALUE = 3;

  PressureState.isKnownEnumValue = function(value) {
    switch (value) {
    case 0:
    case 1:
    case 2:
    case 3:
      return true;
    }
    return false;
  };

  PressureState.toKnownEnumValue = function(value) {
    return value;
  };

  PressureState.validate = function(enumValue) {
    const isExtensible = false;
    if (isExtensible || this.isKnownEnumValue(enumValue))
      return validator.validationError.NONE;

    return validator.validationError.UNKNOWN_ENUM_VALUE;
  };

  function PressureUpdate(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureUpdate.prototype.initDefaults_ = function() {
    this.source = 0;
    this.data = null;
    this.timestamp = null;
  };
  PressureUpdate.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureUpdate.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 32}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureUpdate.source
    err = messageValidator.validateEnum(offset + codec.kStructHeaderSize + 0, PressureSource);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureUpdate.data
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 8, PressureData, false);
    if (err !== validator.validationError.NONE)
        return err;


    // validate PressureUpdate.timestamp
    err = messageValidator.validateStructPointer(offset + codec.kStructHeaderSize + 16, time$.TimeTicks, false);
    if (err !== validator.validationError.NONE)
        return err;

    return validator.validationError.NONE;
  };

  PressureUpdate.encodedSize = codec.kStructHeaderSize + 24;

  PressureUpdate.decode = function(decoder) {
    var packed;
    var val = new PressureUpdate();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.source =
        decoder.decodeStruct(new codec.Enum(PressureSource));
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    decoder.skip(1);
    val.data =
        decoder.decodeStructPointer(PressureData);
    val.timestamp =
        decoder.decodeStructPointer(time$.TimeTicks);
    return val;
  };

  PressureUpdate.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureUpdate.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Int32, val.source);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.skip(1);
    encoder.encodeStructPointer(PressureData, val.data);
    encoder.encodeStructPointer(time$.TimeTicks, val.timestamp);
  };
  function PressureData(values) {
    this.initDefaults_();
    this.initFields_(values);
  }


  PressureData.prototype.initDefaults_ = function() {
    this.cpuUtilization = 0;
    this.ownContributionEstimate = DEFAULT_OWN_CONTRIBUTION_ESTIMATE;
  };
  PressureData.prototype.initFields_ = function(fields) {
    for(var field in fields) {
        if (this.hasOwnProperty(field))
          this[field] = fields[field];
    }
  };

  PressureData.validate = function(messageValidator, offset) {
    var err;
    err = messageValidator.validateStructHeader(offset, codec.kStructHeaderSize);
    if (err !== validator.validationError.NONE)
        return err;

    var kVersionSizes = [
      {version: 0, numBytes: 24}
    ];
    err = messageValidator.validateStructVersion(offset, kVersionSizes);
    if (err !== validator.validationError.NONE)
        return err;



    return validator.validationError.NONE;
  };

  PressureData.encodedSize = codec.kStructHeaderSize + 16;

  PressureData.decode = function(decoder) {
    var packed;
    var val = new PressureData();
    var numberOfBytes = decoder.readUint32();
    var version = decoder.readUint32();
    val.cpuUtilization =
        decoder.decodeStruct(codec.Double);
    val.ownContributionEstimate =
        decoder.decodeStruct(codec.Double);
    return val;
  };

  PressureData.encode = function(encoder, val) {
    var packed;
    encoder.writeUint32(PressureData.encodedSize);
    encoder.writeUint32(0);
    encoder.encodeStruct(codec.Double, val.cpuUtilization);
    encoder.encodeStruct(codec.Double, val.ownContributionEstimate);
  };
  exports.DEFAULT_OWN_CONTRIBUTION_ESTIMATE = DEFAULT_OWN_CONTRIBUTION_ESTIMATE;
  exports.PressureSource = PressureSource;
  exports.PressureState = PressureState;
  exports.PressureUpdate = PressureUpdate;
  exports.PressureData = PressureData;
})();