// services/device/public/mojom/nfc_provider.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';

import {
  NFCRemote as device_mojom_NFCRemote,
  NFCPendingReceiver as device_mojom_NFCPendingReceiver
} from './nfc.mojom.m.js';




/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class NFCProviderPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.NFCProvider', scope);
  }
}

/** @interface */
export class NFCProviderInterface {
  
  /**
   * @param { !number } hostId
   * @param { !device_mojom_NFCPendingReceiver } receiver
   */

  getNFCForHost(hostId, receiver) {}
  
  /**
   */

  suspendNFCOperations() {}
  
  /**
   */

  resumeNFCOperations() {}
}

/**
 * @implements { NFCProviderInterface }
 */
export class NFCProviderRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!NFCProviderPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          NFCProviderPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!NFCProviderPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } hostId
   * @param { !device_mojom_NFCPendingReceiver } receiver
   */

  getNFCForHost(
      hostId,
      receiver) {
    this.proxy.sendMessage(
        0,
        NFCProvider_GetNFCForHost_ParamsSpec.$,
        null,
        [
          hostId,
          receiver
        ],
        false);
  }

  
  /**
   */

  suspendNFCOperations() {
    this.proxy.sendMessage(
        1,
        NFCProvider_SuspendNFCOperations_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   */

  resumeNFCOperations() {
    this.proxy.sendMessage(
        2,
        NFCProvider_ResumeNFCOperations_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the NFCProvider
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class NFCProviderReceiver {
  /**
   * @param {!NFCProviderInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!NFCProviderRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        NFCProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NFCProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        NFCProvider_GetNFCForHost_ParamsSpec.$,
        null,
        impl.getNFCForHost.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        NFCProvider_SuspendNFCOperations_ParamsSpec.$,
        null,
        impl.suspendNFCOperations.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        NFCProvider_ResumeNFCOperations_ParamsSpec.$,
        null,
        impl.resumeNFCOperations.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class NFCProvider {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.NFCProvider";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!NFCProviderRemote}
   */
  static getRemote() {
    let remote = new NFCProviderRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the NFCProvider
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class NFCProviderCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      NFCProviderRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!NFCProviderRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getNFCForHost =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        NFCProvider_GetNFCForHost_ParamsSpec.$,
        null,
        this.getNFCForHost.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.suspendNFCOperations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        NFCProvider_SuspendNFCOperations_ParamsSpec.$,
        null,
        this.suspendNFCOperations.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.resumeNFCOperations =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        NFCProvider_ResumeNFCOperations_ParamsSpec.$,
        null,
        this.resumeNFCOperations.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFCProvider_GetNFCForHost_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFCProvider_SuspendNFCOperations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const NFCProvider_ResumeNFCOperations_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    NFCProvider_GetNFCForHost_ParamsSpec.$,
    'NFCProvider_GetNFCForHost_Params',
    [
      mojo.internal.StructField(
        'hostId', 0,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'receiver', 4,
        0,
        mojo.internal.InterfaceRequest(device_mojom_NFCPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class NFCProvider_GetNFCForHost_Params {
  constructor() {
    /** @type { !number } */
    this.hostId;
    /** @type { !device_mojom_NFCPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    NFCProvider_SuspendNFCOperations_ParamsSpec.$,
    'NFCProvider_SuspendNFCOperations_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NFCProvider_SuspendNFCOperations_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    NFCProvider_ResumeNFCOperations_ParamsSpec.$,
    'NFCProvider_ResumeNFCOperations_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class NFCProvider_ResumeNFCOperations_Params {
  constructor() {
  }
}

