// services/device/public/mojom/nfc_provider.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/nfc_provider.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/nfc_provider.mojom-params-data.h"
#include "services/device/public/mojom/nfc_provider.mojom-shared-message-ids.h"

#include "services/device/public/mojom/nfc_provider.mojom-blink-import-headers.h"
#include "services/device/public/mojom/nfc_provider.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
// The declaration includes the definition on other builds.

NFCProvider::IPCStableHashFunction NFCProvider::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::NFCProvider>(message.name())) {
    case messages::NFCProvider::kGetNFCForHost: {
      return &NFCProvider::GetNFCForHost_Sym::IPCStableHash;
    }
    case messages::NFCProvider::kSuspendNFCOperations: {
      return &NFCProvider::SuspendNFCOperations_Sym::IPCStableHash;
    }
    case messages::NFCProvider::kResumeNFCOperations: {
      return &NFCProvider::ResumeNFCOperations_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* NFCProvider::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::NFCProvider>(message.name())) {
      case messages::NFCProvider::kGetNFCForHost:
            return "Receive device::mojom::NFCProvider::GetNFCForHost";
      case messages::NFCProvider::kSuspendNFCOperations:
            return "Receive device::mojom::NFCProvider::SuspendNFCOperations";
      case messages::NFCProvider::kResumeNFCOperations:
            return "Receive device::mojom::NFCProvider::ResumeNFCOperations";
    }
  } else {
    switch (static_cast<messages::NFCProvider>(message.name())) {
      case messages::NFCProvider::kGetNFCForHost:
            return "Receive reply device::mojom::NFCProvider::GetNFCForHost";
      case messages::NFCProvider::kSuspendNFCOperations:
            return "Receive reply device::mojom::NFCProvider::SuspendNFCOperations";
      case messages::NFCProvider::kResumeNFCOperations:
            return "Receive reply device::mojom::NFCProvider::ResumeNFCOperations";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t NFCProvider::GetNFCForHost_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa1a4fb11;  // IPCStableHash for device::mojom::NFCProvider::GetNFCForHost
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NFCProvider::SuspendNFCOperations_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x4affba0c;  // IPCStableHash for device::mojom::NFCProvider::SuspendNFCOperations
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t NFCProvider::ResumeNFCOperations_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xcd279dee;  // IPCStableHash for device::mojom::NFCProvider::ResumeNFCOperations
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

NFCProviderProxy::NFCProviderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NFCProviderProxy::GetNFCForHost(
    int32_t in_host_id, ::mojo::PendingReceiver<::device::mojom::blink::NFC> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::NFCProvider::GetNFCForHost", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("host_id"), in_host_id,
                        "<value of type int32_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<::device::mojom::blink::NFC>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFCProvider::kGetNFCForHost), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFCProvider_GetNFCForHost_Params_Data> params(
          message);
  params.Allocate();

  params->host_id = in_host_id;

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::NFCInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in NFCProvider.GetNFCForHost request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFCProvider::Name_);
  message.set_method_name("GetNFCForHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NFCProviderProxy::SuspendNFCOperations(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::NFCProvider::SuspendNFCOperations");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFCProvider::kSuspendNFCOperations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFCProvider_SuspendNFCOperations_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFCProvider::Name_);
  message.set_method_name("SuspendNFCOperations");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void NFCProviderProxy::ResumeNFCOperations(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::NFCProvider::ResumeNFCOperations");
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::NFCProvider::kResumeNFCOperations), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::NFCProvider_ResumeNFCOperations_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NFCProvider::Name_);
  message.set_method_name("ResumeNFCOperations");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool NFCProviderStubDispatch::Accept(
    NFCProvider* impl,
    mojo::Message* message) {
  switch (static_cast<messages::NFCProvider>(message->header()->name)) {
    case messages::NFCProvider::kGetNFCForHost: {
      DCHECK(message->is_serialized());
      internal::NFCProvider_GetNFCForHost_Params_Data* params =
          reinterpret_cast<internal::NFCProvider_GetNFCForHost_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NFCProvider.0
      bool success = true;
      int32_t p_host_id{};
      ::mojo::PendingReceiver<::device::mojom::blink::NFC> p_receiver{};
      NFCProvider_GetNFCForHost_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_host_id = input_data_view.host_id();
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFCProvider::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetNFCForHost(        
        std::move(p_host_id), 
        std::move(p_receiver));
      return true;
    }
    case messages::NFCProvider::kSuspendNFCOperations: {
      DCHECK(message->is_serialized());
      internal::NFCProvider_SuspendNFCOperations_Params_Data* params =
          reinterpret_cast<internal::NFCProvider_SuspendNFCOperations_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NFCProvider.1
      bool success = true;
      NFCProvider_SuspendNFCOperations_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFCProvider::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SuspendNFCOperations(        );
      return true;
    }
    case messages::NFCProvider::kResumeNFCOperations: {
      DCHECK(message->is_serialized());
      internal::NFCProvider_ResumeNFCOperations_Params_Data* params =
          reinterpret_cast<internal::NFCProvider_ResumeNFCOperations_Params_Data*>(
              message->mutable_payload());
      

      // Validation for NFCProvider.2
      bool success = true;
      NFCProvider_ResumeNFCOperations_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NFCProvider::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResumeNFCOperations(        );
      return true;
    }
  }
  return false;
}

// static
bool NFCProviderStubDispatch::AcceptWithResponder(
    NFCProvider* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::NFCProvider>(message->header()->name)) {
    case messages::NFCProvider::kGetNFCForHost: {
      break;
    }
    case messages::NFCProvider::kSuspendNFCOperations: {
      break;
    }
    case messages::NFCProvider::kResumeNFCOperations: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kNFCProviderValidationInfo[] = {
    { &internal::NFCProvider_GetNFCForHost_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NFCProvider_SuspendNFCOperations_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::NFCProvider_ResumeNFCOperations_Params_Data::Validate,
     nullptr /* no response */},
};

bool NFCProviderRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::NFCProvider::Name_,
    kNFCProviderValidationInfo);
}



}  // device::mojom::blink


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void NFCProviderInterceptorForTesting::GetNFCForHost(int32_t host_id, ::mojo::PendingReceiver<::device::mojom::blink::NFC> receiver) {
  GetForwardingInterface()->GetNFCForHost(
    std::move(host_id)
    , 
    std::move(receiver)
    );
}
void NFCProviderInterceptorForTesting::SuspendNFCOperations() {
  GetForwardingInterface()->SuspendNFCOperations();
}
void NFCProviderInterceptorForTesting::ResumeNFCOperations() {
  GetForwardingInterface()->ResumeNFCOperations();
}
NFCProviderAsyncWaiter::NFCProviderAsyncWaiter(
    NFCProvider* proxy) : proxy_(proxy) {}

NFCProviderAsyncWaiter::~NFCProviderAsyncWaiter() = default;







}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif