// services/device/public/mojom/nfc.mojom-data-view.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2025 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_DATA_VIEW_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_DATA_VIEW_H_

#include <stdint.h>

#include <functional>
#include <iosfwd>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"

#include "services/device/public/mojom/nfc.mojom-shared-internal.h"


namespace device::mojom {
class NDEFErrorDataView;

class NDEFRecordDataView;

class NDEFMessageDataView;

class NDEFWriteOptionsDataView;



}  // device::mojom


namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::device::mojom::NDEFErrorDataView> {
  using Data = ::device::mojom::internal::NDEFError_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::NDEFRecordDataView> {
  using Data = ::device::mojom::internal::NDEFRecord_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::NDEFMessageDataView> {
  using Data = ::device::mojom::internal::NDEFMessage_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::device::mojom::NDEFWriteOptionsDataView> {
  using Data = ::device::mojom::internal::NDEFWriteOptions_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace device::mojom {


enum class NDEFErrorType : int32_t {
  
  NOT_ALLOWED = 0,
  
  NOT_SUPPORTED = 1,
  
  NOT_READABLE = 2,
  
  INVALID_MESSAGE = 3,
  
  OPERATION_CANCELLED = 4,
  
  IO_ERROR = 5,
  kMinValue = 0,
  kMaxValue = 5,
};

 std::ostream& operator<<(std::ostream& os, NDEFErrorType value);
inline bool IsKnownEnumValue(NDEFErrorType value) {
  return internal::NDEFErrorType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class NDEFRecordTypeCategory : int32_t {
  
  kStandardized = 0,
  
  kExternal = 1,
  
  kLocal = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, NDEFRecordTypeCategory value);
inline bool IsKnownEnumValue(NDEFRecordTypeCategory value) {
  return internal::NDEFRecordTypeCategory_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class NFCInterfaceBase {};

using NFCPtrDataView =
    mojo::InterfacePtrDataView<NFCInterfaceBase>;
using NFCRequestDataView =
    mojo::InterfaceRequestDataView<NFCInterfaceBase>;
using NFCAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NFCInterfaceBase>;
using NFCAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NFCInterfaceBase>;
class NFCClientInterfaceBase {};

using NFCClientPtrDataView =
    mojo::InterfacePtrDataView<NFCClientInterfaceBase>;
using NFCClientRequestDataView =
    mojo::InterfaceRequestDataView<NFCClientInterfaceBase>;
using NFCClientAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<NFCClientInterfaceBase>;
using NFCClientAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<NFCClientInterfaceBase>;


class NDEFErrorDataView {
 public:
  NDEFErrorDataView() = default;

  NDEFErrorDataView(
      internal::NDEFError_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadErrorType(UserType* output) const {
    auto data_value = data_->error_type;
    return mojo::internal::Deserialize<::device::mojom::NDEFErrorType>(
        data_value, output);
  }
  NDEFErrorType error_type() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::NDEFErrorType>(data_->error_type));
  }
  inline void GetErrorMessageDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadErrorMessage(UserType* output) {
    
    auto* pointer = data_->error_message.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
 private:
  internal::NDEFError_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NDEFRecordDataView {
 public:
  NDEFRecordDataView() = default;

  NDEFRecordDataView(
      internal::NDEFRecord_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  [[nodiscard]] bool ReadCategory(UserType* output) const {
    auto data_value = data_->category;
    return mojo::internal::Deserialize<::device::mojom::NDEFRecordTypeCategory>(
        data_value, output);
  }
  NDEFRecordTypeCategory category() const {
    return ::mojo::internal::ToKnownEnumValueHelper(
          static_cast<::device::mojom::NDEFRecordTypeCategory>(data_->category));
  }
  inline void GetRecordTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadRecordType(UserType* output) {
    
    auto* pointer = data_->record_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetMediaTypeDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadMediaType(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `media_type` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadMediaType` instead "
    "of `ReadMediaType if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->media_type.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetIdDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadId(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `id` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadId` instead "
    "of `ReadId if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->id.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetEncodingDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadEncoding(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `encoding` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadEncoding` instead "
    "of `ReadEncoding if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->encoding.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetLangDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadLang(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `lang` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadLang` instead "
    "of `ReadLang if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->lang.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, message_);
  }
  inline void GetDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, message_);
  }
  inline void GetPayloadMessageDataView(
      NDEFMessageDataView* output);

  template <typename UserType>
  [[nodiscard]] bool ReadPayloadMessage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::device::mojom::NDEFMessageDataView, UserType>(),
    "Attempting to read the optional `payload_message` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with std::optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPayloadMessage` instead "
    "of `ReadPayloadMessage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->payload_message.Get();
    return mojo::internal::Deserialize<::device::mojom::NDEFMessageDataView>(
        pointer, output, message_);
  }
 private:
  internal::NDEFRecord_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NDEFMessageDataView {
 public:
  NDEFMessageDataView() = default;

  NDEFMessageDataView(
      internal::NDEFMessage_Data* data,
      mojo::Message* message)
      : data_(data), message_(message) {}

  bool is_null() const { return !data_; }
  inline void GetDataDataView(
      mojo::ArrayDataView<NDEFRecordDataView>* output);

  template <typename UserType>
  [[nodiscard]] bool ReadData(UserType* output) {
    
    auto* pointer = data_->data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::device::mojom::NDEFRecordDataView>>(
        pointer, output, message_);
  }
 private:
  internal::NDEFMessage_Data* data_ = nullptr;
  mojo::Message* message_ = nullptr;
};


class NDEFWriteOptionsDataView {
 public:
  NDEFWriteOptionsDataView() = default;

  NDEFWriteOptionsDataView(
      internal::NDEFWriteOptions_Data* data,
      mojo::Message* message)
      : data_(data) {}

  bool is_null() const { return !data_; }
  bool overwrite() const {
    return data_->overwrite;
  }
 private:
  internal::NDEFWriteOptions_Data* data_ = nullptr;
};


}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_NFC_MOJOM_DATA_VIEW_H_