// services/device/public/mojom/hid.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';


/**
 * @const { !number }
 */
export const PAGE_UNDEFINED = 0x00;


/**
 * @const { !number }
 */
export const PAGE_GENERIC_DESKTOP = 0x01;


/**
 * @const { !number }
 */
export const PAGE_SIMULATION = 0x02;


/**
 * @const { !number }
 */
export const PAGE_VIRTUAL_REALITY = 0x03;


/**
 * @const { !number }
 */
export const PAGE_SPORT = 0x04;


/**
 * @const { !number }
 */
export const PAGE_GAME = 0x05;


/**
 * @const { !number }
 */
export const PAGE_GENERIC_DEVICE = 0x06;


/**
 * @const { !number }
 */
export const PAGE_KEYBOARD = 0x07;


/**
 * @const { !number }
 */
export const PAGE_LED = 0x08;


/**
 * @const { !number }
 */
export const PAGE_BUTTON = 0x09;


/**
 * @const { !number }
 */
export const PAGE_ORDINAL = 0x0A;


/**
 * @const { !number }
 */
export const PAGE_TELEPHONY = 0x0B;


/**
 * @const { !number }
 */
export const PAGE_CONSUMER = 0x0C;


/**
 * @const { !number }
 */
export const PAGE_DIGITIZER = 0x0D;


/**
 * @const { !number }
 */
export const PAGE_PID_PAGE = 0x0F;


/**
 * @const { !number }
 */
export const PAGE_UNICODE = 0x10;


/**
 * @const { !number }
 */
export const PAGE_ALPHANUMERIC_DISPLAY = 0x14;


/**
 * @const { !number }
 */
export const PAGE_MEDICAL_INSTRUMENTS = 0x40;


/**
 * @const { !number }
 */
export const PAGE_MONITOR0 = 0x80;


/**
 * @const { !number }
 */
export const PAGE_MONITOR1 = 0x81;


/**
 * @const { !number }
 */
export const PAGE_MONITOR2 = 0x82;


/**
 * @const { !number }
 */
export const PAGE_MONITOR3 = 0x83;


/**
 * @const { !number }
 */
export const PAGE_POWER0 = 0x84;


/**
 * @const { !number }
 */
export const PAGE_POWER1 = 0x85;


/**
 * @const { !number }
 */
export const PAGE_POWER2 = 0x86;


/**
 * @const { !number }
 */
export const PAGE_POWER3 = 0x87;


/**
 * @const { !number }
 */
export const PAGE_BAR_CODE_SCANNER = 0x8C;


/**
 * @const { !number }
 */
export const PAGE_SCALE = 0x8D;


/**
 * @const { !number }
 */
export const PAGE_MAGNETIC_STRIPE_READER = 0x8E;


/**
 * @const { !number }
 */
export const PAGE_RESERVED_POINT_OF_SALE = 0x8F;


/**
 * @const { !number }
 */
export const PAGE_CAMERA_CONTROL = 0x90;


/**
 * @const { !number }
 */
export const PAGE_ARCADE = 0x91;


/**
 * @const { !number }
 */
export const PAGE_FIDO = 0xF1D0;


/**
 * @const { !number }
 */
export const PAGE_VENDOR = 0xFF00;


/**
 * @const { !number }
 */
export const PAGE_MEDIA_CENTER = 0xFFBC;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_UNDEFINED = 0x00;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_POINTER = 0x01;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_MOUSE = 0x02;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_JOYSTICK = 0x04;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_GAME_PAD = 0x05;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_KEYBOARD = 0x06;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_KEYPAD = 0x07;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_MULTI_AXIS_CONTROLLER = 0x08;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_X = 0x30;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_Y = 0x31;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_Z = 0x32;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_RX = 0x33;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_RY = 0x34;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_RZ = 0x35;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SLIDER = 0x36;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_DIAL = 0x37;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_WHEEL = 0x38;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_HAT_SWITCH = 0x39;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_COUNTED_BUFFER = 0x3a;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_BYTE_COUNT = 0x3b;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_MOTION_WAKEUP = 0x3c;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_START = 0x3d;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SELECT = 0x3e;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_VX = 0x40;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_VY = 0x41;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_VZ = 0x42;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_VBRX = 0x43;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_VBRY = 0x44;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_VBRZ = 0x45;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_VNO = 0x46;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_CONTROL = 0x80;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_POWER_DOWN = 0x81;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_SLEEP = 0x82;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_WAKE_UP = 0x83;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_CONTEXT_MENU = 0x84;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_MAIN_MENU = 0x85;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_APP_MENU = 0x86;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_MENU_HELP = 0x87;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_MENU_EXIT = 0x88;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_MENU_SELECT = 0x89;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_MENU_RIGHT = 0x8a;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_MENU_LEFT = 0x8b;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_MENU_UP = 0x8c;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_MENU_DOWN = 0x8d;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_COLD_RESTART = 0x8e;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_WARM_RESTART = 0x8f;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_D_PAD_UP = 0x90;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_D_PAD_DOWN = 0x91;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_D_PAD_LEFT = 0x92;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_D_PAD_RIGHT = 0x93;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_DOCK = 0xa0;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_UNDOCK = 0xa1;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_SETUP = 0xa2;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_BREAK = 0xa3;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_DEBUGGER_BREAK = 0xa4;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_APPLICATION_BREAK = 0xa5;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_APPLICATION_DEBUGGER_BREAK = 0xa6;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_SPEAKER_MUTE = 0xa7;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_HIBERNATE = 0xa8;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_DISPLAY_INVERT = 0xb0;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_DISPLAY_INTERNAL = 0xb1;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_DISPLAY_EXTERNAL = 0xb2;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_DISPLAY_BOTH = 0xb3;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_DISPLAY_DUAL = 0xb4;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_DISPLAY_TOGGLE = 0xb5;


/**
 * @const { !number }
 */
export const GENERIC_DESKTOP_SYSTEM_DISPLAY_SWAP = 0xb6;


/**
 * @const { !number }
 */
export const HID_COLLECTION_TYPE_PHYSICAL = 0x00;


/**
 * @const { !number }
 */
export const HID_COLLECTION_TYPE_APPLICATION = 0x01;


/**
 * @const { !number }
 */
export const HID_COLLECTION_TYPE_LOGICAL = 0x02;


/**
 * @const { !number }
 */
export const HID_COLLECTION_TYPE_REPORT = 0x03;


/**
 * @const { !number }
 */
export const HID_COLLECTION_TYPE_NAMED_ARRAY = 0x04;


/**
 * @const { !number }
 */
export const HID_COLLECTION_TYPE_USAGE_SWITCH = 0x05;


/**
 * @const { !number }
 */
export const HID_COLLECTION_TYPE_USAGE_MODIFIER = 0x06;


/**
 * @const { !number }
 */
export const HID_COLLECTION_TYPE_VENDOR_MIN = 0x80;


/**
 * @const { !number }
 */
export const HID_COLLECTION_TYPE_VENDOR_MAX = 0xff;


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const HidBusTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const HidBusType = {
  
  kHIDBusTypeUSB: 0,
  kHIDBusTypeBluetooth: 1,
  kHIDBusTypeUnknown: 2,
  MIN_VALUE: 0,
  MAX_VALUE: 2,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HidManagerClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.HidManagerClient', scope);
  }
}

/** @interface */
export class HidManagerClientInterface {
  
  /**
   * @param { !HidDeviceInfo } deviceInfo
   */

  deviceAdded(deviceInfo) {}
  
  /**
   * @param { !HidDeviceInfo } deviceInfo
   */

  deviceRemoved(deviceInfo) {}
  
  /**
   * @param { !HidDeviceInfo } deviceInfo
   */

  deviceChanged(deviceInfo) {}
}

/**
 * @implements { HidManagerClientInterface }
 */
export class HidManagerClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HidManagerClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HidManagerClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HidManagerClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !HidDeviceInfo } deviceInfo
   */

  deviceAdded(
      deviceInfo) {
    this.proxy.sendMessage(
        0,
        HidManagerClient_DeviceAdded_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }

  
  /**
   * @param { !HidDeviceInfo } deviceInfo
   */

  deviceRemoved(
      deviceInfo) {
    this.proxy.sendMessage(
        1,
        HidManagerClient_DeviceRemoved_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }

  
  /**
   * @param { !HidDeviceInfo } deviceInfo
   */

  deviceChanged(
      deviceInfo) {
    this.proxy.sendMessage(
        2,
        HidManagerClient_DeviceChanged_ParamsSpec.$,
        null,
        [
          deviceInfo
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HidManagerClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HidManagerClientReceiver {
  /**
   * @param {!HidManagerClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HidManagerClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HidManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HidManagerClient_DeviceAdded_ParamsSpec.$,
        null,
        impl.deviceAdded.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        HidManagerClient_DeviceRemoved_ParamsSpec.$,
        null,
        impl.deviceRemoved.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        HidManagerClient_DeviceChanged_ParamsSpec.$,
        null,
        impl.deviceChanged.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HidManagerClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.HidManagerClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HidManagerClientRemote}
   */
  static getRemote() {
    let remote = new HidManagerClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HidManagerClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HidManagerClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HidManagerClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidManagerClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deviceAdded =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HidManagerClient_DeviceAdded_ParamsSpec.$,
        null,
        this.deviceAdded.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deviceRemoved =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        HidManagerClient_DeviceRemoved_ParamsSpec.$,
        null,
        this.deviceRemoved.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.deviceChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        HidManagerClient_DeviceChanged_ParamsSpec.$,
        null,
        this.deviceChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HidManagerPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.HidManager', scope);
  }
}

/** @interface */
export class HidManagerInterface {
  
  /**
   * @param { !Object } client
   * @return {!Promise<{
        devices: !Array<!HidDeviceInfo>,
   *  }>}
   */

  getDevicesAndSetClient(client) {}
  
  /**
   * @return {!Promise<{
        devices: !Array<!HidDeviceInfo>,
   *  }>}
   */

  getDevices() {}
  
  /**
   * @param { !string } deviceGuid
   * @param { ?HidConnectionClientRemote } connectionClient
   * @param { ?HidConnectionWatcherRemote } watcher
   * @param { !boolean } allowProtectedReports
   * @param { !boolean } allowFidoReports
   * @return {!Promise<{
        connection: ?HidConnectionRemote,
   *  }>}
   */

  connect(deviceGuid, connectionClient, watcher, allowProtectedReports, allowFidoReports) {}
  
  /**
   * @param { !HidManagerPendingReceiver } receiver
   */

  addReceiver(receiver) {}
}

/**
 * @implements { HidManagerInterface }
 */
export class HidManagerRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HidManagerPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HidManagerPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HidManagerPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !Object } client
   * @return {!Promise<{
        devices: !Array<!HidDeviceInfo>,
   *  }>}
   */

  getDevicesAndSetClient(
      client) {
    return this.proxy.sendMessage(
        0,
        HidManager_GetDevicesAndSetClient_ParamsSpec.$,
        HidManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
        [
          client
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        devices: !Array<!HidDeviceInfo>,
   *  }>}
   */

  getDevices() {
    return this.proxy.sendMessage(
        1,
        HidManager_GetDevices_ParamsSpec.$,
        HidManager_GetDevices_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } deviceGuid
   * @param { ?HidConnectionClientRemote } connectionClient
   * @param { ?HidConnectionWatcherRemote } watcher
   * @param { !boolean } allowProtectedReports
   * @param { !boolean } allowFidoReports
   * @return {!Promise<{
        connection: ?HidConnectionRemote,
   *  }>}
   */

  connect(
      deviceGuid,
      connectionClient,
      watcher,
      allowProtectedReports,
      allowFidoReports) {
    return this.proxy.sendMessage(
        2,
        HidManager_Connect_ParamsSpec.$,
        HidManager_Connect_ResponseParamsSpec.$,
        [
          deviceGuid,
          connectionClient,
          watcher,
          allowProtectedReports,
          allowFidoReports
        ],
        false);
  }

  
  /**
   * @param { !HidManagerPendingReceiver } receiver
   */

  addReceiver(
      receiver) {
    this.proxy.sendMessage(
        3,
        HidManager_AddReceiver_ParamsSpec.$,
        null,
        [
          receiver
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HidManager
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HidManagerReceiver {
  /**
   * @param {!HidManagerInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HidManagerRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HidManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HidManager_GetDevicesAndSetClient_ParamsSpec.$,
        HidManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
        impl.getDevicesAndSetClient.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        HidManager_GetDevices_ParamsSpec.$,
        HidManager_GetDevices_ResponseParamsSpec.$,
        impl.getDevices.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        HidManager_Connect_ParamsSpec.$,
        HidManager_Connect_ResponseParamsSpec.$,
        impl.connect.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        HidManager_AddReceiver_ParamsSpec.$,
        null,
        impl.addReceiver.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HidManager {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.HidManager";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HidManagerRemote}
   */
  static getRemote() {
    let remote = new HidManagerRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HidManager
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HidManagerCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HidManagerRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidManagerRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevicesAndSetClient =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HidManager_GetDevicesAndSetClient_ParamsSpec.$,
        HidManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
        this.getDevicesAndSetClient.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getDevices =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        HidManager_GetDevices_ParamsSpec.$,
        HidManager_GetDevices_ResponseParamsSpec.$,
        this.getDevices.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.connect =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        HidManager_Connect_ParamsSpec.$,
        HidManager_Connect_ResponseParamsSpec.$,
        this.connect.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addReceiver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        HidManager_AddReceiver_ParamsSpec.$,
        null,
        this.addReceiver.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HidConnectionPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.HidConnection', scope);
  }
}

/** @interface */
export class HidConnectionInterface {
  
  /**
   * @return {!Promise<{
        success: !boolean,
        reportId: !number,
        buffer: ?Array<!number>,
   *  }>}
   */

  read() {}
  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  write(reportId, buffer) {}
  
  /**
   * @param { !number } reportId
   * @return {!Promise<{
        success: !boolean,
        buffer: ?Array<!number>,
   *  }>}
   */

  getFeatureReport(reportId) {}
  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  sendFeatureReport(reportId, buffer) {}
}

/**
 * @implements { HidConnectionInterface }
 */
export class HidConnectionRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HidConnectionPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HidConnectionPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HidConnectionPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
        reportId: !number,
        buffer: ?Array<!number>,
   *  }>}
   */

  read() {
    return this.proxy.sendMessage(
        0,
        HidConnection_Read_ParamsSpec.$,
        HidConnection_Read_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  write(
      reportId,
      buffer) {
    return this.proxy.sendMessage(
        1,
        HidConnection_Write_ParamsSpec.$,
        HidConnection_Write_ResponseParamsSpec.$,
        [
          reportId,
          buffer
        ],
        false);
  }

  
  /**
   * @param { !number } reportId
   * @return {!Promise<{
        success: !boolean,
        buffer: ?Array<!number>,
   *  }>}
   */

  getFeatureReport(
      reportId) {
    return this.proxy.sendMessage(
        2,
        HidConnection_GetFeatureReport_ParamsSpec.$,
        HidConnection_GetFeatureReport_ResponseParamsSpec.$,
        [
          reportId
        ],
        false);
  }

  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  sendFeatureReport(
      reportId,
      buffer) {
    return this.proxy.sendMessage(
        3,
        HidConnection_SendFeatureReport_ParamsSpec.$,
        HidConnection_SendFeatureReport_ResponseParamsSpec.$,
        [
          reportId,
          buffer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HidConnection
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HidConnectionReceiver {
  /**
   * @param {!HidConnectionInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HidConnectionRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HidConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HidConnection_Read_ParamsSpec.$,
        HidConnection_Read_ResponseParamsSpec.$,
        impl.read.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        HidConnection_Write_ParamsSpec.$,
        HidConnection_Write_ResponseParamsSpec.$,
        impl.write.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        HidConnection_GetFeatureReport_ParamsSpec.$,
        HidConnection_GetFeatureReport_ResponseParamsSpec.$,
        impl.getFeatureReport.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        HidConnection_SendFeatureReport_ParamsSpec.$,
        HidConnection_SendFeatureReport_ResponseParamsSpec.$,
        impl.sendFeatureReport.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HidConnection {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.HidConnection";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HidConnectionRemote}
   */
  static getRemote() {
    let remote = new HidConnectionRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HidConnection
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HidConnectionCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HidConnectionRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidConnectionRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.read =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HidConnection_Read_ParamsSpec.$,
        HidConnection_Read_ResponseParamsSpec.$,
        this.read.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.write =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        HidConnection_Write_ParamsSpec.$,
        HidConnection_Write_ResponseParamsSpec.$,
        this.write.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getFeatureReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        HidConnection_GetFeatureReport_ParamsSpec.$,
        HidConnection_GetFeatureReport_ResponseParamsSpec.$,
        this.getFeatureReport.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.sendFeatureReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        HidConnection_SendFeatureReport_ParamsSpec.$,
        HidConnection_SendFeatureReport_ResponseParamsSpec.$,
        this.sendFeatureReport.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HidConnectionClientPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.HidConnectionClient', scope);
  }
}

/** @interface */
export class HidConnectionClientInterface {
  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   */

  onInputReport(reportId, buffer) {}
}

/**
 * @implements { HidConnectionClientInterface }
 */
export class HidConnectionClientRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HidConnectionClientPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HidConnectionClientPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HidConnectionClientPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !number } reportId
   * @param { !Array<!number> } buffer
   */

  onInputReport(
      reportId,
      buffer) {
    this.proxy.sendMessage(
        0,
        HidConnectionClient_OnInputReport_ParamsSpec.$,
        null,
        [
          reportId,
          buffer
        ],
        false);
  }
}

/**
 * An object which receives request messages for the HidConnectionClient
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HidConnectionClientReceiver {
  /**
   * @param {!HidConnectionClientInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HidConnectionClientRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HidConnectionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidConnectionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        HidConnectionClient_OnInputReport_ParamsSpec.$,
        null,
        impl.onInputReport.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HidConnectionClient {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.HidConnectionClient";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HidConnectionClientRemote}
   */
  static getRemote() {
    let remote = new HidConnectionClientRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HidConnectionClient
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HidConnectionClientCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HidConnectionClientRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidConnectionClientRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onInputReport =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        HidConnectionClient_OnInputReport_ParamsSpec.$,
        null,
        this.onInputReport.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class HidConnectionWatcherPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.HidConnectionWatcher', scope);
  }
}

/** @interface */
export class HidConnectionWatcherInterface {
}

/**
 * @implements { HidConnectionWatcherInterface }
 */
export class HidConnectionWatcherRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!HidConnectionWatcherPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          HidConnectionWatcherPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!HidConnectionWatcherPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }
}

/**
 * An object which receives request messages for the HidConnectionWatcher
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class HidConnectionWatcherReceiver {
  /**
   * @param {!HidConnectionWatcherInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!HidConnectionWatcherRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        HidConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class HidConnectionWatcher {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.HidConnectionWatcher";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!HidConnectionWatcherRemote}
   */
  static getRemote() {
    let remote = new HidConnectionWatcherRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the HidConnectionWatcher
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class HidConnectionWatcherCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      HidConnectionWatcherRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!HidConnectionWatcherRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidUsageAndPageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidReportItemSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidReportDescriptionSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidCollectionInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidDeviceInfoSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidManagerClient_DeviceAdded_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidManagerClient_DeviceRemoved_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidManagerClient_DeviceChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidManager_GetDevicesAndSetClient_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidManager_GetDevicesAndSetClient_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidManager_GetDevices_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidManager_GetDevices_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidManager_Connect_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidManager_Connect_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidManager_AddReceiver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidConnection_Read_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidConnection_Read_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidConnection_Write_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidConnection_Write_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidConnection_GetFeatureReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidConnection_GetFeatureReport_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidConnection_SendFeatureReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidConnection_SendFeatureReport_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const HidConnectionClient_OnInputReport_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    HidUsageAndPageSpec.$,
    'HidUsageAndPage',
    [
      mojo.internal.StructField(
        'usage', 0,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usagePage', 2,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidUsageAndPage {
  constructor() {
    /** @type { !number } */
    this.usage;
    /** @type { !number } */
    this.usagePage;
  }
}



mojo.internal.Struct(
    HidReportItemSpec.$,
    'HidReportItem',
    [
      mojo.internal.StructField(
        'isRange', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isConstant', 0,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isVariable', 0,
        2,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isRelative', 0,
        3,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'wrap', 0,
        4,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isNonLinear', 0,
        5,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'noPreferredState', 0,
        6,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasNullPosition', 0,
        7,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isVolatile', 1,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isBufferedBytes', 1,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usages', 8,
        0,
        mojo.internal.Array(HidUsageAndPageSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usageMinimum', 16,
        0,
        HidUsageAndPageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'usageMaximum', 24,
        0,
        HidUsageAndPageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'designatorMinimum', 4,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'designatorMaximum', 32,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stringMinimum', 36,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'stringMaximum', 40,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'logicalMinimum', 44,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'logicalMaximum', 48,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'physicalMinimum', 52,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'physicalMaximum', 56,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unitExponent', 60,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'unit', 64,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportSize', 68,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportCount', 72,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 88],]);



/**
 * @record
 */
export class HidReportItem {
  constructor() {
    /** @type { !boolean } */
    this.isRange;
    /** @type { !boolean } */
    this.isConstant;
    /** @type { !boolean } */
    this.isVariable;
    /** @type { !boolean } */
    this.isRelative;
    /** @type { !boolean } */
    this.wrap;
    /** @type { !boolean } */
    this.isNonLinear;
    /** @type { !boolean } */
    this.noPreferredState;
    /** @type { !boolean } */
    this.hasNullPosition;
    /** @type { !boolean } */
    this.isVolatile;
    /** @type { !boolean } */
    this.isBufferedBytes;
    /** @type { !Array<!HidUsageAndPage> } */
    this.usages;
    /** @type { !HidUsageAndPage } */
    this.usageMinimum;
    /** @type { !HidUsageAndPage } */
    this.usageMaximum;
    /** @type { !number } */
    this.designatorMinimum;
    /** @type { !number } */
    this.designatorMaximum;
    /** @type { !number } */
    this.stringMinimum;
    /** @type { !number } */
    this.stringMaximum;
    /** @type { !number } */
    this.logicalMinimum;
    /** @type { !number } */
    this.logicalMaximum;
    /** @type { !number } */
    this.physicalMinimum;
    /** @type { !number } */
    this.physicalMaximum;
    /** @type { !number } */
    this.unitExponent;
    /** @type { !number } */
    this.unit;
    /** @type { !number } */
    this.reportSize;
    /** @type { !number } */
    this.reportCount;
  }
}



mojo.internal.Struct(
    HidReportDescriptionSpec.$,
    'HidReportDescription',
    [
      mojo.internal.StructField(
        'reportId', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'items', 8,
        0,
        mojo.internal.Array(HidReportItemSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HidReportDescription {
  constructor() {
    /** @type { !number } */
    this.reportId;
    /** @type { !Array<!HidReportItem> } */
    this.items;
  }
}



mojo.internal.Struct(
    HidCollectionInfoSpec.$,
    'HidCollectionInfo',
    [
      mojo.internal.StructField(
        'usage', 0,
        0,
        HidUsageAndPageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportIds', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'collectionType', 16,
        0,
        mojo.internal.Uint32,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'inputReports', 24,
        0,
        mojo.internal.Array(HidReportDescriptionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'outputReports', 32,
        0,
        mojo.internal.Array(HidReportDescriptionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'featureReports', 40,
        0,
        mojo.internal.Array(HidReportDescriptionSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'children', 48,
        0,
        mojo.internal.Array(HidCollectionInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 64],]);



/**
 * @record
 */
export class HidCollectionInfo {
  constructor() {
    /** @type { !HidUsageAndPage } */
    this.usage;
    /** @type { !Array<!number> } */
    this.reportIds;
    /** @type { !number } */
    this.collectionType;
    /** @type { !Array<!HidReportDescription> } */
    this.inputReports;
    /** @type { !Array<!HidReportDescription> } */
    this.outputReports;
    /** @type { !Array<!HidReportDescription> } */
    this.featureReports;
    /** @type { !Array<!HidCollectionInfo> } */
    this.children;
  }
}



mojo.internal.Struct(
    HidDeviceInfoSpec.$,
    'HidDeviceInfo',
    [
      mojo.internal.StructField(
        'guid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'physicalDeviceId', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'vendorId', 16,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'productId', 18,
        0,
        mojo.internal.Uint16,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'productName', 24,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'serialNumber', 32,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'busType', 20,
        0,
        HidBusTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportDescriptor', 40,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'collections', 48,
        0,
        mojo.internal.Array(HidCollectionInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'hasReportId', 56,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxInputReportSize', 64,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxOutputReportSize', 72,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'maxFeatureReportSize', 80,
        0,
        mojo.internal.Uint64,
        BigInt(0),
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'deviceNode', 88,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'protectedInputReportIds', 96,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'protectedOutputReportIds', 104,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'protectedFeatureReportIds', 112,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'isExcludedByBlocklist', 56,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        3,
      ),
    ],
    [[0, 104],[1, 128],[3, 128],]);



/**
 * @record
 */
export class HidDeviceInfo {
  constructor() {
    /** @type { !string } */
    this.guid;
    /** @type { !string } */
    this.physicalDeviceId;
    /** @type { !number } */
    this.vendorId;
    /** @type { !number } */
    this.productId;
    /** @type { !string } */
    this.productName;
    /** @type { !string } */
    this.serialNumber;
    /** @type { !HidBusType } */
    this.busType;
    /** @type { !Array<!number> } */
    this.reportDescriptor;
    /** @type { !Array<!HidCollectionInfo> } */
    this.collections;
    /** @type { !boolean } */
    this.hasReportId;
    /** @type { !bigint } */
    this.maxInputReportSize;
    /** @type { !bigint } */
    this.maxOutputReportSize;
    /** @type { !bigint } */
    this.maxFeatureReportSize;
    /** @type { !string } */
    this.deviceNode;
    /** @type { (Array<!number>|undefined) } */
    this.protectedInputReportIds;
    /** @type { (Array<!number>|undefined) } */
    this.protectedOutputReportIds;
    /** @type { (Array<!number>|undefined) } */
    this.protectedFeatureReportIds;
    /** @type { !boolean } */
    this.isExcludedByBlocklist;
  }
}



mojo.internal.Struct(
    HidManagerClient_DeviceAdded_ParamsSpec.$,
    'HidManagerClient_DeviceAdded_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        HidDeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidManagerClient_DeviceAdded_Params {
  constructor() {
    /** @type { !HidDeviceInfo } */
    this.deviceInfo;
  }
}



mojo.internal.Struct(
    HidManagerClient_DeviceRemoved_ParamsSpec.$,
    'HidManagerClient_DeviceRemoved_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        HidDeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidManagerClient_DeviceRemoved_Params {
  constructor() {
    /** @type { !HidDeviceInfo } */
    this.deviceInfo;
  }
}



mojo.internal.Struct(
    HidManagerClient_DeviceChanged_ParamsSpec.$,
    'HidManagerClient_DeviceChanged_Params',
    [
      mojo.internal.StructField(
        'deviceInfo', 0,
        0,
        HidDeviceInfoSpec.$,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidManagerClient_DeviceChanged_Params {
  constructor() {
    /** @type { !HidDeviceInfo } */
    this.deviceInfo;
  }
}



mojo.internal.Struct(
    HidManager_GetDevicesAndSetClient_ParamsSpec.$,
    'HidManager_GetDevicesAndSetClient_Params',
    [
      mojo.internal.StructField(
        'client', 0,
        0,
        mojo.internal.AssociatedInterfaceProxy(HidManagerClientRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidManager_GetDevicesAndSetClient_Params {
  constructor() {
    /** @type { !Object } */
    this.client;
  }
}



mojo.internal.Struct(
    HidManager_GetDevicesAndSetClient_ResponseParamsSpec.$,
    'HidManager_GetDevicesAndSetClient_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(HidDeviceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidManager_GetDevicesAndSetClient_ResponseParams {
  constructor() {
    /** @type { !Array<!HidDeviceInfo> } */
    this.devices;
  }
}



mojo.internal.Struct(
    HidManager_GetDevices_ParamsSpec.$,
    'HidManager_GetDevices_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class HidManager_GetDevices_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    HidManager_GetDevices_ResponseParamsSpec.$,
    'HidManager_GetDevices_ResponseParams',
    [
      mojo.internal.StructField(
        'devices', 0,
        0,
        mojo.internal.Array(HidDeviceInfoSpec.$, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidManager_GetDevices_ResponseParams {
  constructor() {
    /** @type { !Array<!HidDeviceInfo> } */
    this.devices;
  }
}



mojo.internal.Struct(
    HidManager_Connect_ParamsSpec.$,
    'HidManager_Connect_Params',
    [
      mojo.internal.StructField(
        'deviceGuid', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'connectionClient', 8,
        0,
        mojo.internal.InterfaceProxy(HidConnectionClientRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'watcher', 16,
        0,
        mojo.internal.InterfaceProxy(HidConnectionWatcherRemote),
        null,
        true /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'allowProtectedReports', 24,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        1,
      ),
      mojo.internal.StructField(
        'allowFidoReports', 24,
        1,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        2,
      ),
    ],
    [[0, 32],[1, 40],[2, 40],]);



/**
 * @record
 */
export class HidManager_Connect_Params {
  constructor() {
    /** @type { !string } */
    this.deviceGuid;
    /** @type { (HidConnectionClientRemote|undefined) } */
    this.connectionClient;
    /** @type { (HidConnectionWatcherRemote|undefined) } */
    this.watcher;
    /** @type { !boolean } */
    this.allowProtectedReports;
    /** @type { !boolean } */
    this.allowFidoReports;
  }
}



mojo.internal.Struct(
    HidManager_Connect_ResponseParamsSpec.$,
    'HidManager_Connect_ResponseParams',
    [
      mojo.internal.StructField(
        'connection', 0,
        0,
        mojo.internal.InterfaceProxy(HidConnectionRemote),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidManager_Connect_ResponseParams {
  constructor() {
    /** @type { (HidConnectionRemote|undefined) } */
    this.connection;
  }
}



mojo.internal.Struct(
    HidManager_AddReceiver_ParamsSpec.$,
    'HidManager_AddReceiver_Params',
    [
      mojo.internal.StructField(
        'receiver', 0,
        0,
        mojo.internal.InterfaceRequest(HidManagerPendingReceiver),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidManager_AddReceiver_Params {
  constructor() {
    /** @type { !HidManagerPendingReceiver } */
    this.receiver;
  }
}



mojo.internal.Struct(
    HidConnection_Read_ParamsSpec.$,
    'HidConnection_Read_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class HidConnection_Read_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    HidConnection_Read_ResponseParamsSpec.$,
    'HidConnection_Read_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'reportId', 1,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HidConnection_Read_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { !number } */
    this.reportId;
    /** @type { (Array<!number>|undefined) } */
    this.buffer;
  }
}



mojo.internal.Struct(
    HidConnection_Write_ParamsSpec.$,
    'HidConnection_Write_Params',
    [
      mojo.internal.StructField(
        'reportId', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HidConnection_Write_Params {
  constructor() {
    /** @type { !number } */
    this.reportId;
    /** @type { !Array<!number> } */
    this.buffer;
  }
}



mojo.internal.Struct(
    HidConnection_Write_ResponseParamsSpec.$,
    'HidConnection_Write_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidConnection_Write_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    HidConnection_GetFeatureReport_ParamsSpec.$,
    'HidConnection_GetFeatureReport_Params',
    [
      mojo.internal.StructField(
        'reportId', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidConnection_GetFeatureReport_Params {
  constructor() {
    /** @type { !number } */
    this.reportId;
  }
}



mojo.internal.Struct(
    HidConnection_GetFeatureReport_ResponseParamsSpec.$,
    'HidConnection_GetFeatureReport_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        true /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HidConnection_GetFeatureReport_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
    /** @type { (Array<!number>|undefined) } */
    this.buffer;
  }
}



mojo.internal.Struct(
    HidConnection_SendFeatureReport_ParamsSpec.$,
    'HidConnection_SendFeatureReport_Params',
    [
      mojo.internal.StructField(
        'reportId', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HidConnection_SendFeatureReport_Params {
  constructor() {
    /** @type { !number } */
    this.reportId;
    /** @type { !Array<!number> } */
    this.buffer;
  }
}



mojo.internal.Struct(
    HidConnection_SendFeatureReport_ResponseParamsSpec.$,
    'HidConnection_SendFeatureReport_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class HidConnection_SendFeatureReport_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    HidConnectionClient_OnInputReport_ParamsSpec.$,
    'HidConnectionClient_OnInputReport_Params',
    [
      mojo.internal.StructField(
        'reportId', 0,
        0,
        mojo.internal.Uint8,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'buffer', 8,
        0,
        mojo.internal.Array(mojo.internal.Uint8, false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class HidConnectionClient_OnInputReport_Params {
  constructor() {
    /** @type { !number } */
    this.reportId;
    /** @type { !Array<!number> } */
    this.buffer;
  }
}

