// services/device/public/mojom/hid.mojom-blink.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/hid.mojom-blink.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/hid.mojom-params-data.h"
#include "services/device/public/mojom/hid.mojom-shared-message-ids.h"

#include "services/device/public/mojom/hid.mojom-blink-import-headers.h"
#include "services/device/public/mojom/hid.mojom-blink-test-utils.h"
#include "mojo/public/cpp/bindings/lib/wtf_serialization.h"


namespace device::mojom::blink {
HidUsageAndPage::HidUsageAndPage()
    : usage(),
      usage_page() {}

HidUsageAndPage::HidUsageAndPage(
    uint16_t usage_in,
    uint16_t usage_page_in)
    : usage(std::move(usage_in)),
      usage_page(std::move(usage_page_in)) {}

HidUsageAndPage::~HidUsageAndPage() = default;
size_t HidUsageAndPage::Hash(size_t seed) const {
  seed = mojo::internal::WTFHash(seed, this->usage);
  seed = mojo::internal::WTFHash(seed, this->usage_page);
  return seed;
}

void HidUsageAndPage::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage_page"), this->usage_page,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HidUsageAndPage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HidReportItem::HidReportItem()
    : is_range(),
      is_constant(),
      is_variable(),
      is_relative(),
      wrap(),
      is_non_linear(),
      no_preferred_state(),
      has_null_position(),
      is_volatile(),
      is_buffered_bytes(),
      usages(),
      usage_minimum(),
      usage_maximum(),
      designator_minimum(),
      designator_maximum(),
      string_minimum(),
      string_maximum(),
      logical_minimum(),
      logical_maximum(),
      physical_minimum(),
      physical_maximum(),
      unit_exponent(),
      unit(),
      report_size(),
      report_count() {}

HidReportItem::HidReportItem(
    bool is_range_in,
    bool is_constant_in,
    bool is_variable_in,
    bool is_relative_in,
    bool wrap_in,
    bool is_non_linear_in,
    bool no_preferred_state_in,
    bool has_null_position_in,
    bool is_volatile_in,
    bool is_buffered_bytes_in,
    ::blink::Vector<HidUsageAndPagePtr> usages_in,
    HidUsageAndPagePtr usage_minimum_in,
    HidUsageAndPagePtr usage_maximum_in,
    uint32_t designator_minimum_in,
    uint32_t designator_maximum_in,
    uint32_t string_minimum_in,
    uint32_t string_maximum_in,
    int32_t logical_minimum_in,
    int32_t logical_maximum_in,
    int32_t physical_minimum_in,
    int32_t physical_maximum_in,
    uint32_t unit_exponent_in,
    uint32_t unit_in,
    uint32_t report_size_in,
    uint32_t report_count_in)
    : is_range(std::move(is_range_in)),
      is_constant(std::move(is_constant_in)),
      is_variable(std::move(is_variable_in)),
      is_relative(std::move(is_relative_in)),
      wrap(std::move(wrap_in)),
      is_non_linear(std::move(is_non_linear_in)),
      no_preferred_state(std::move(no_preferred_state_in)),
      has_null_position(std::move(has_null_position_in)),
      is_volatile(std::move(is_volatile_in)),
      is_buffered_bytes(std::move(is_buffered_bytes_in)),
      usages(std::move(usages_in)),
      usage_minimum(std::move(usage_minimum_in)),
      usage_maximum(std::move(usage_maximum_in)),
      designator_minimum(std::move(designator_minimum_in)),
      designator_maximum(std::move(designator_maximum_in)),
      string_minimum(std::move(string_minimum_in)),
      string_maximum(std::move(string_maximum_in)),
      logical_minimum(std::move(logical_minimum_in)),
      logical_maximum(std::move(logical_maximum_in)),
      physical_minimum(std::move(physical_minimum_in)),
      physical_maximum(std::move(physical_maximum_in)),
      unit_exponent(std::move(unit_exponent_in)),
      unit(std::move(unit_in)),
      report_size(std::move(report_size_in)),
      report_count(std::move(report_count_in)) {}

HidReportItem::~HidReportItem() = default;

void HidReportItem::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_range"), this->is_range,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_constant"), this->is_constant,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_variable"), this->is_variable,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_relative"), this->is_relative,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "wrap"), this->wrap,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_non_linear"), this->is_non_linear,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "no_preferred_state"), this->no_preferred_state,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_null_position"), this->has_null_position,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_volatile"), this->is_volatile,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_buffered_bytes"), this->is_buffered_bytes,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usages"), this->usages,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<HidUsageAndPagePtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage_minimum"), this->usage_minimum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HidUsageAndPagePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage_maximum"), this->usage_maximum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HidUsageAndPagePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "designator_minimum"), this->designator_minimum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "designator_maximum"), this->designator_maximum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "string_minimum"), this->string_minimum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "string_maximum"), this->string_maximum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logical_minimum"), this->logical_minimum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "logical_maximum"), this->logical_maximum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "physical_minimum"), this->physical_minimum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "physical_maximum"), this->physical_maximum,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type int32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unit_exponent"), this->unit_exponent,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "unit"), this->unit,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_size"), this->report_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_count"), this->report_count,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HidReportItem::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HidReportDescription::HidReportDescription()
    : report_id(),
      items() {}

HidReportDescription::HidReportDescription(
    uint8_t report_id_in,
    ::blink::Vector<HidReportItemPtr> items_in)
    : report_id(std::move(report_id_in)),
      items(std::move(items_in)) {}

HidReportDescription::~HidReportDescription() = default;

void HidReportDescription::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_id"), this->report_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint8_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "items"), this->items,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<HidReportItemPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HidReportDescription::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HidCollectionInfo::HidCollectionInfo()
    : usage(),
      report_ids(),
      collection_type(),
      input_reports(),
      output_reports(),
      feature_reports(),
      children() {}

HidCollectionInfo::HidCollectionInfo(
    HidUsageAndPagePtr usage_in,
    ::blink::Vector<uint8_t> report_ids_in,
    uint32_t collection_type_in,
    ::blink::Vector<HidReportDescriptionPtr> input_reports_in,
    ::blink::Vector<HidReportDescriptionPtr> output_reports_in,
    ::blink::Vector<HidReportDescriptionPtr> feature_reports_in,
    ::blink::Vector<HidCollectionInfoPtr> children_in)
    : usage(std::move(usage_in)),
      report_ids(std::move(report_ids_in)),
      collection_type(std::move(collection_type_in)),
      input_reports(std::move(input_reports_in)),
      output_reports(std::move(output_reports_in)),
      feature_reports(std::move(feature_reports_in)),
      children(std::move(children_in)) {}

HidCollectionInfo::~HidCollectionInfo() = default;

void HidCollectionInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "usage"), this->usage,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HidUsageAndPagePtr>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_ids"), this->report_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "collection_type"), this->collection_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint32_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "input_reports"), this->input_reports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<HidReportDescriptionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "output_reports"), this->output_reports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<HidReportDescriptionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "feature_reports"), this->feature_reports,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<HidReportDescriptionPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "children"), this->children,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<HidCollectionInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HidCollectionInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HidDeviceInfo::HidDeviceInfo()
    : guid(),
      physical_device_id(),
      vendor_id(),
      product_id(),
      product_name(),
      serial_number(),
      bus_type(),
      report_descriptor(),
      collections(),
      has_report_id(),
      max_input_report_size(),
      max_output_report_size(),
      max_feature_report_size(),
      device_node(),
      protected_input_report_ids(),
      protected_output_report_ids(),
      protected_feature_report_ids(),
      is_excluded_by_blocklist() {}

HidDeviceInfo::HidDeviceInfo(
    const ::blink::String& guid_in,
    const ::blink::String& physical_device_id_in,
    uint16_t vendor_id_in,
    uint16_t product_id_in,
    const ::blink::String& product_name_in,
    const ::blink::String& serial_number_in,
    HidBusType bus_type_in,
    ::blink::Vector<uint8_t> report_descriptor_in,
    ::blink::Vector<HidCollectionInfoPtr> collections_in,
    bool has_report_id_in,
    uint64_t max_input_report_size_in,
    uint64_t max_output_report_size_in,
    uint64_t max_feature_report_size_in,
    const ::blink::String& device_node_in)
    : guid(std::move(guid_in)),
      physical_device_id(std::move(physical_device_id_in)),
      vendor_id(std::move(vendor_id_in)),
      product_id(std::move(product_id_in)),
      product_name(std::move(product_name_in)),
      serial_number(std::move(serial_number_in)),
      bus_type(std::move(bus_type_in)),
      report_descriptor(std::move(report_descriptor_in)),
      collections(std::move(collections_in)),
      has_report_id(std::move(has_report_id_in)),
      max_input_report_size(std::move(max_input_report_size_in)),
      max_output_report_size(std::move(max_output_report_size_in)),
      max_feature_report_size(std::move(max_feature_report_size_in)),
      device_node(std::move(device_node_in)),
      protected_input_report_ids(),
      protected_output_report_ids(),
      protected_feature_report_ids(),
      is_excluded_by_blocklist() {}

HidDeviceInfo::HidDeviceInfo(
    const ::blink::String& guid_in,
    const ::blink::String& physical_device_id_in,
    uint16_t vendor_id_in,
    uint16_t product_id_in,
    const ::blink::String& product_name_in,
    const ::blink::String& serial_number_in,
    HidBusType bus_type_in,
    ::blink::Vector<uint8_t> report_descriptor_in,
    ::blink::Vector<HidCollectionInfoPtr> collections_in,
    bool has_report_id_in,
    uint64_t max_input_report_size_in,
    uint64_t max_output_report_size_in,
    uint64_t max_feature_report_size_in,
    const ::blink::String& device_node_in,
    std::optional<::blink::Vector<uint8_t>> protected_input_report_ids_in,
    std::optional<::blink::Vector<uint8_t>> protected_output_report_ids_in,
    std::optional<::blink::Vector<uint8_t>> protected_feature_report_ids_in)
    : guid(std::move(guid_in)),
      physical_device_id(std::move(physical_device_id_in)),
      vendor_id(std::move(vendor_id_in)),
      product_id(std::move(product_id_in)),
      product_name(std::move(product_name_in)),
      serial_number(std::move(serial_number_in)),
      bus_type(std::move(bus_type_in)),
      report_descriptor(std::move(report_descriptor_in)),
      collections(std::move(collections_in)),
      has_report_id(std::move(has_report_id_in)),
      max_input_report_size(std::move(max_input_report_size_in)),
      max_output_report_size(std::move(max_output_report_size_in)),
      max_feature_report_size(std::move(max_feature_report_size_in)),
      device_node(std::move(device_node_in)),
      protected_input_report_ids(std::move(protected_input_report_ids_in)),
      protected_output_report_ids(std::move(protected_output_report_ids_in)),
      protected_feature_report_ids(std::move(protected_feature_report_ids_in)),
      is_excluded_by_blocklist() {}

HidDeviceInfo::HidDeviceInfo(
    const ::blink::String& guid_in,
    const ::blink::String& physical_device_id_in,
    uint16_t vendor_id_in,
    uint16_t product_id_in,
    const ::blink::String& product_name_in,
    const ::blink::String& serial_number_in,
    HidBusType bus_type_in,
    ::blink::Vector<uint8_t> report_descriptor_in,
    ::blink::Vector<HidCollectionInfoPtr> collections_in,
    bool has_report_id_in,
    uint64_t max_input_report_size_in,
    uint64_t max_output_report_size_in,
    uint64_t max_feature_report_size_in,
    const ::blink::String& device_node_in,
    std::optional<::blink::Vector<uint8_t>> protected_input_report_ids_in,
    std::optional<::blink::Vector<uint8_t>> protected_output_report_ids_in,
    std::optional<::blink::Vector<uint8_t>> protected_feature_report_ids_in,
    bool is_excluded_by_blocklist_in)
    : guid(std::move(guid_in)),
      physical_device_id(std::move(physical_device_id_in)),
      vendor_id(std::move(vendor_id_in)),
      product_id(std::move(product_id_in)),
      product_name(std::move(product_name_in)),
      serial_number(std::move(serial_number_in)),
      bus_type(std::move(bus_type_in)),
      report_descriptor(std::move(report_descriptor_in)),
      collections(std::move(collections_in)),
      has_report_id(std::move(has_report_id_in)),
      max_input_report_size(std::move(max_input_report_size_in)),
      max_output_report_size(std::move(max_output_report_size_in)),
      max_feature_report_size(std::move(max_feature_report_size_in)),
      device_node(std::move(device_node_in)),
      protected_input_report_ids(std::move(protected_input_report_ids_in)),
      protected_output_report_ids(std::move(protected_output_report_ids_in)),
      protected_feature_report_ids(std::move(protected_feature_report_ids_in)),
      is_excluded_by_blocklist(std::move(is_excluded_by_blocklist_in)) {}

HidDeviceInfo::~HidDeviceInfo() = default;

void HidDeviceInfo::WriteIntoTrace(
    perfetto::TracedValue traced_context) const {
  [[maybe_unused]] auto dict = std::move(traced_context).WriteDictionary();
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "guid"), this->guid,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "physical_device_id"), this->physical_device_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "vendor_id"), this->vendor_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_id"), this->product_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint16_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "product_name"), this->product_name,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "serial_number"), this->serial_number,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "bus_type"), this->bus_type,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type HidBusType>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "report_descriptor"), this->report_descriptor,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::Vector<uint8_t>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "collections"), this->collections,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type ::blink::Vector<HidCollectionInfoPtr>>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "has_report_id"), this->has_report_id,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_input_report_size"), this->max_input_report_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_output_report_size"), this->max_output_report_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "max_feature_report_size"), this->max_feature_report_size,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type uint64_t>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "device_node"), this->device_node,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const ::blink::String&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protected_input_report_ids"), this->protected_input_report_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protected_output_report_ids"), this->protected_output_report_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "protected_feature_report_ids"), this->protected_feature_report_ids,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type const std::optional<::blink::Vector<uint8_t>>&>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
  perfetto::WriteIntoTracedValueWithFallback(
    dict.AddItem(
      "is_excluded_by_blocklist"), this->is_excluded_by_blocklist,
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      "<value of type bool>"
#else
      "<value>"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
    );
}

bool HidDeviceInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
// The declaration includes the definition on other builds.
constexpr base::Token HidManagerClient::Uuid_;

HidManagerClient::IPCStableHashFunction HidManagerClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HidManagerClient>(message.name())) {
    case messages::HidManagerClient::kDeviceAdded: {
      return &HidManagerClient::DeviceAdded_Sym::IPCStableHash;
    }
    case messages::HidManagerClient::kDeviceRemoved: {
      return &HidManagerClient::DeviceRemoved_Sym::IPCStableHash;
    }
    case messages::HidManagerClient::kDeviceChanged: {
      return &HidManagerClient::DeviceChanged_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HidManagerClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HidManagerClient>(message.name())) {
      case messages::HidManagerClient::kDeviceAdded:
            return "Receive device::mojom::HidManagerClient::DeviceAdded";
      case messages::HidManagerClient::kDeviceRemoved:
            return "Receive device::mojom::HidManagerClient::DeviceRemoved";
      case messages::HidManagerClient::kDeviceChanged:
            return "Receive device::mojom::HidManagerClient::DeviceChanged";
    }
  } else {
    switch (static_cast<messages::HidManagerClient>(message.name())) {
      case messages::HidManagerClient::kDeviceAdded:
            return "Receive reply device::mojom::HidManagerClient::DeviceAdded";
      case messages::HidManagerClient::kDeviceRemoved:
            return "Receive reply device::mojom::HidManagerClient::DeviceRemoved";
      case messages::HidManagerClient::kDeviceChanged:
            return "Receive reply device::mojom::HidManagerClient::DeviceChanged";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HidManagerClient::DeviceAdded_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xf83dd663;  // IPCStableHash for device::mojom::HidManagerClient::DeviceAdded
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidManagerClient::DeviceRemoved_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x7cf92f9b;  // IPCStableHash for device::mojom::HidManagerClient::DeviceRemoved
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidManagerClient::DeviceChanged_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x92359667;  // IPCStableHash for device::mojom::HidManagerClient::DeviceChanged
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

HidManagerClientProxy::HidManagerClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HidManagerClientProxy::DeviceAdded(
    HidDeviceInfoPtr in_device_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::HidManagerClient::DeviceAdded", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type HidDeviceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidManagerClient::kDeviceAdded), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidManagerClient_DeviceAdded_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::HidDeviceInfoDataView>(
    in_device_info,
    device_info_fragment);

  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_info in HidManagerClient.DeviceAdded request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidManagerClient::Name_);
  message.set_method_name("DeviceAdded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void HidManagerClientProxy::DeviceRemoved(
    HidDeviceInfoPtr in_device_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::HidManagerClient::DeviceRemoved", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type HidDeviceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidManagerClient::kDeviceRemoved), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidManagerClient_DeviceRemoved_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::HidDeviceInfoDataView>(
    in_device_info,
    device_info_fragment);

  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_info in HidManagerClient.DeviceRemoved request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidManagerClient::Name_);
  message.set_method_name("DeviceRemoved");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

void HidManagerClientProxy::DeviceChanged(
    HidDeviceInfoPtr in_device_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::HidManagerClient::DeviceChanged", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_info"), in_device_info,
                        "<value of type HidDeviceInfoPtr>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidManagerClient::kDeviceChanged), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidManagerClient_DeviceChanged_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_info)::BaseType> device_info_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::HidDeviceInfoDataView>(
    in_device_info,
    device_info_fragment);

  params->device_info.Set(
      device_info_fragment.is_null() ? nullptr : device_info_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_info.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_info in HidManagerClient.DeviceChanged request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidManagerClient::Name_);
  message.set_method_name("DeviceChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool HidManagerClientStubDispatch::Accept(
    HidManagerClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HidManagerClient>(message->header()->name)) {
    case messages::HidManagerClient::kDeviceAdded: {
      DCHECK(message->is_serialized());
      internal::HidManagerClient_DeviceAdded_Params_Data* params =
          reinterpret_cast<internal::HidManagerClient_DeviceAdded_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HidManagerClient.0
      bool success = true;
      HidDeviceInfoPtr p_device_info{};
      HidManagerClient_DeviceAdded_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidManagerClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeviceAdded(        
        std::move(p_device_info));
      return true;
    }
    case messages::HidManagerClient::kDeviceRemoved: {
      DCHECK(message->is_serialized());
      internal::HidManagerClient_DeviceRemoved_Params_Data* params =
          reinterpret_cast<internal::HidManagerClient_DeviceRemoved_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HidManagerClient.1
      bool success = true;
      HidDeviceInfoPtr p_device_info{};
      HidManagerClient_DeviceRemoved_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidManagerClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeviceRemoved(        
        std::move(p_device_info));
      return true;
    }
    case messages::HidManagerClient::kDeviceChanged: {
      DCHECK(message->is_serialized());
      internal::HidManagerClient_DeviceChanged_Params_Data* params =
          reinterpret_cast<internal::HidManagerClient_DeviceChanged_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HidManagerClient.2
      bool success = true;
      HidDeviceInfoPtr p_device_info{};
      HidManagerClient_DeviceChanged_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceInfo(&p_device_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidManagerClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeviceChanged(        
        std::move(p_device_info));
      return true;
    }
  }
  return false;
}

// static
bool HidManagerClientStubDispatch::AcceptWithResponder(
    HidManagerClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HidManagerClient>(message->header()->name)) {
    case messages::HidManagerClient::kDeviceAdded: {
      break;
    }
    case messages::HidManagerClient::kDeviceRemoved: {
      break;
    }
    case messages::HidManagerClient::kDeviceChanged: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHidManagerClientValidationInfo[] = {
    { &internal::HidManagerClient_DeviceAdded_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::HidManagerClient_DeviceRemoved_Params_Data::Validate,
     nullptr /* no response */},
    { &internal::HidManagerClient_DeviceChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool HidManagerClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::HidManagerClient::Name_,
    kHidManagerClientValidationInfo);
}

// The declaration includes the definition on other builds.
constexpr base::Token HidManager::Uuid_;

HidManager::IPCStableHashFunction HidManager::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HidManager>(message.name())) {
    case messages::HidManager::kGetDevicesAndSetClient: {
      return &HidManager::GetDevicesAndSetClient_Sym::IPCStableHash;
    }
    case messages::HidManager::kGetDevices: {
      return &HidManager::GetDevices_Sym::IPCStableHash;
    }
    case messages::HidManager::kConnect: {
      return &HidManager::Connect_Sym::IPCStableHash;
    }
    case messages::HidManager::kAddReceiver: {
      return &HidManager::AddReceiver_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HidManager::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HidManager>(message.name())) {
      case messages::HidManager::kGetDevicesAndSetClient:
            return "Receive device::mojom::HidManager::GetDevicesAndSetClient";
      case messages::HidManager::kGetDevices:
            return "Receive device::mojom::HidManager::GetDevices";
      case messages::HidManager::kConnect:
            return "Receive device::mojom::HidManager::Connect";
      case messages::HidManager::kAddReceiver:
            return "Receive device::mojom::HidManager::AddReceiver";
    }
  } else {
    switch (static_cast<messages::HidManager>(message.name())) {
      case messages::HidManager::kGetDevicesAndSetClient:
            return "Receive reply device::mojom::HidManager::GetDevicesAndSetClient";
      case messages::HidManager::kGetDevices:
            return "Receive reply device::mojom::HidManager::GetDevices";
      case messages::HidManager::kConnect:
            return "Receive reply device::mojom::HidManager::Connect";
      case messages::HidManager::kAddReceiver:
            return "Receive reply device::mojom::HidManager::AddReceiver";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HidManager::GetDevicesAndSetClient_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x84d178de;  // IPCStableHash for device::mojom::HidManager::GetDevicesAndSetClient
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidManager::GetDevices_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x5c3d6af1;  // IPCStableHash for device::mojom::HidManager::GetDevices
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidManager::Connect_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xd3c9caaf;  // IPCStableHash for device::mojom::HidManager::Connect
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidManager::AddReceiver_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xff39ae16;  // IPCStableHash for device::mojom::HidManager::AddReceiver
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class HidManager_GetDevicesAndSetClient_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidManager_GetDevicesAndSetClient_ForwardToCallback(
      HidManager::GetDevicesAndSetClientCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidManager_GetDevicesAndSetClient_ForwardToCallback(const HidManager_GetDevicesAndSetClient_ForwardToCallback&) = delete;
  HidManager_GetDevicesAndSetClient_ForwardToCallback& operator=(const HidManager_GetDevicesAndSetClient_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidManager::GetDevicesAndSetClientCallback callback_;
};

class HidManager_GetDevices_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidManager_GetDevices_ForwardToCallback(
      HidManager::GetDevicesCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidManager_GetDevices_ForwardToCallback(const HidManager_GetDevices_ForwardToCallback&) = delete;
  HidManager_GetDevices_ForwardToCallback& operator=(const HidManager_GetDevices_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidManager::GetDevicesCallback callback_;
};

class HidManager_Connect_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidManager_Connect_ForwardToCallback(
      HidManager::ConnectCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidManager_Connect_ForwardToCallback(const HidManager_Connect_ForwardToCallback&) = delete;
  HidManager_Connect_ForwardToCallback& operator=(const HidManager_Connect_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidManager::ConnectCallback callback_;
};

HidManagerProxy::HidManagerProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HidManagerProxy::GetDevicesAndSetClient(
    ::mojo::PendingAssociatedRemote<HidManagerClient> in_client, GetDevicesAndSetClientCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::HidManager::GetDevicesAndSetClient", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("client"), in_client,
                        "<value of type ::mojo::PendingAssociatedRemote<HidManagerClient>>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidManager::kGetDevicesAndSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidManager_GetDevicesAndSetClient_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<::device::mojom::HidManagerClientAssociatedPtrInfoDataView>(
    in_client,
    &params->client,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->client)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_INTERFACE_ID,
    "invalid client in HidManager.GetDevicesAndSetClient request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidManager::Name_);
  message.set_method_name("GetDevicesAndSetClient");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidManager_GetDevicesAndSetClient_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HidManagerProxy::GetDevices(
    GetDevicesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::HidManager::GetDevices");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidManager::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidManager_GetDevices_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidManager::Name_);
  message.set_method_name("GetDevices");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidManager_GetDevices_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HidManagerProxy::Connect(
    const ::blink::String& in_device_guid, ::mojo::PendingRemote<HidConnectionClient> in_connection_client, ::mojo::PendingRemote<HidConnectionWatcher> in_watcher, bool in_allow_protected_reports, bool in_allow_fido_reports, ConnectCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::HidManager::Connect", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("device_guid"), in_device_guid,
                        "<value of type const ::blink::String&>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection_client"), in_connection_client,
                        "<value of type ::mojo::PendingRemote<HidConnectionClient>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("watcher"), in_watcher,
                        "<value of type ::mojo::PendingRemote<HidConnectionWatcher>>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_protected_reports"), in_allow_protected_reports,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("allow_fido_reports"), in_allow_fido_reports,
                        "<value of type bool>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidManager::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidManager_Connect_Params_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->device_guid)::BaseType> device_guid_fragment(
          params.message());
  
  mojo::internal::Serialize<mojo::StringDataView>(
    in_device_guid,
    device_guid_fragment);

  params->device_guid.Set(
      device_guid_fragment.is_null() ? nullptr : device_guid_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->device_guid.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null device_guid in HidManager.Connect request");

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::HidConnectionClientInterfaceBase>>(
    in_connection_client,
    &params->connection_client,
    &params.message());

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::HidConnectionWatcherInterfaceBase>>(
    in_watcher,
    &params->watcher,
    &params.message());

  params->allow_protected_reports = in_allow_protected_reports;

  params->allow_fido_reports = in_allow_fido_reports;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidManager::Name_);
  message.set_method_name("Connect");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidManager_Connect_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HidManagerProxy::AddReceiver(
    ::mojo::PendingReceiver<HidManager> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::HidManager::AddReceiver", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("receiver"), in_receiver,
                        "<value of type ::mojo::PendingReceiver<HidManager>>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidManager::kAddReceiver), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidManager_AddReceiver_Params_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::device::mojom::HidManagerInterfaceBase>>(
    in_receiver,
    &params->receiver,
    &params.message());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(!mojo::internal::IsHandleOrInterfaceValid(params->receiver)),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
    "invalid receiver in HidManager.AddReceiver request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidManager::Name_);
  message.set_method_name("AddReceiver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}
class HidManager_GetDevicesAndSetClient_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidManager::GetDevicesAndSetClientCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidManager_GetDevicesAndSetClient_ProxyToResponder> proxy(
        new HidManager_GetDevicesAndSetClient_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidManager_GetDevicesAndSetClient_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidManager_GetDevicesAndSetClient_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidManager_GetDevicesAndSetClient_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidManager::GetDevicesAndSetClientCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<HidDeviceInfoPtr> in_devices);
};

bool HidManager_GetDevicesAndSetClient_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidManager_GetDevicesAndSetClient_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidManager_GetDevicesAndSetClient_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidManager.0
  bool success = true;
  ::blink::Vector<HidDeviceInfoPtr> p_devices{};
  HidManager_GetDevicesAndSetClient_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidManager::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_devices));
  }
  return true;
}

void HidManager_GetDevicesAndSetClient_ProxyToResponder::Run(
    ::blink::Vector<HidDeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::HidManager::GetDevicesAndSetClient", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices,
                        "<value of type ::blink::Vector<HidDeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidManager::kGetDevicesAndSetClient), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidManager_GetDevicesAndSetClient_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidDeviceInfoDataView>>(
    in_devices,
    devices_fragment,
    &devices_validate_params);

  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devices.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devices in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidManager::Name_);
  message.set_method_name("GetDevicesAndSetClient");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HidManager_GetDevices_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidManager::GetDevicesCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidManager_GetDevices_ProxyToResponder> proxy(
        new HidManager_GetDevices_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidManager_GetDevices_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidManager_GetDevices_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidManager_GetDevices_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidManager::GetDevicesCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::Vector<HidDeviceInfoPtr> in_devices);
};

bool HidManager_GetDevices_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidManager_GetDevices_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidManager_GetDevices_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidManager.1
  bool success = true;
  ::blink::Vector<HidDeviceInfoPtr> p_devices{};
  HidManager_GetDevices_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadDevices(&p_devices))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidManager::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_devices));
  }
  return true;
}

void HidManager_GetDevices_ProxyToResponder::Run(
    ::blink::Vector<HidDeviceInfoPtr> in_devices) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::HidManager::GetDevices", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("devices"), in_devices,
                        "<value of type ::blink::Vector<HidDeviceInfoPtr>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidManager::kGetDevices), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidManager_GetDevices_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->devices)::BaseType>
      devices_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& devices_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<::device::mojom::HidDeviceInfoDataView>>(
    in_devices,
    devices_fragment,
    &devices_validate_params);

  params->devices.Set(
      devices_fragment.is_null() ? nullptr : devices_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->devices.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null devices in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidManager::Name_);
  message.set_method_name("GetDevices");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HidManager_Connect_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidManager::ConnectCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidManager_Connect_ProxyToResponder> proxy(
        new HidManager_Connect_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidManager_Connect_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidManager_Connect_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidManager_Connect_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidManager::ConnectCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::mojo::PendingRemote<HidConnection> in_connection);
};

bool HidManager_Connect_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidManager_Connect_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidManager_Connect_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidManager.2
  bool success = true;
  ::mojo::PendingRemote<HidConnection> p_connection{};
  HidManager_Connect_ResponseParamsDataView input_data_view(params, message);
  
  if (success) {
    p_connection =
        input_data_view.TakeConnection<decltype(p_connection)>();
  }
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidManager::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_connection));
  }
  return true;
}

void HidManager_Connect_ProxyToResponder::Run(
    ::mojo::PendingRemote<HidConnection> in_connection) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::HidManager::Connect", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("connection"), in_connection,
                        "<value of type ::mojo::PendingRemote<HidConnection>>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidManager::kConnect), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidManager_Connect_ResponseParams_Data> params(
          message);
  params.Allocate();

  
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::device::mojom::HidConnectionInterfaceBase>>(
    in_connection,
    &params->connection,
    &params.message());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidManager::Name_);
  message.set_method_name("Connect");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HidManagerStubDispatch::Accept(
    HidManager* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HidManager>(message->header()->name)) {
    case messages::HidManager::kGetDevicesAndSetClient: {
      break;
    }
    case messages::HidManager::kGetDevices: {
      break;
    }
    case messages::HidManager::kConnect: {
      break;
    }
    case messages::HidManager::kAddReceiver: {
      DCHECK(message->is_serialized());
      internal::HidManager_AddReceiver_Params_Data* params =
          reinterpret_cast<internal::HidManager_AddReceiver_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HidManager.3
      bool success = true;
      ::mojo::PendingReceiver<HidManager> p_receiver{};
      HidManager_AddReceiver_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidManager::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddReceiver(        
        std::move(p_receiver));
      return true;
    }
  }
  return false;
}

// static
bool HidManagerStubDispatch::AcceptWithResponder(
    HidManager* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HidManager>(message->header()->name)) {
    case messages::HidManager::kGetDevicesAndSetClient: {
      internal::HidManager_GetDevicesAndSetClient_Params_Data* params =
          reinterpret_cast<
              internal::HidManager_GetDevicesAndSetClient_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidManager.0
      bool success = true;
      ::mojo::PendingAssociatedRemote<HidManagerClient> p_client{};
      HidManager_GetDevicesAndSetClient_ParamsDataView input_data_view(params, message);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidManager::Name_, 0, false);
        return false;
      }
      auto callback =
          HidManager_GetDevicesAndSetClient_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevicesAndSetClient(        
        std::move(p_client), std::move(callback));
      return true;
    }
    case messages::HidManager::kGetDevices: {
      internal::HidManager_GetDevices_Params_Data* params =
          reinterpret_cast<
              internal::HidManager_GetDevices_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidManager.1
      bool success = true;
      HidManager_GetDevices_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidManager::Name_, 1, false);
        return false;
      }
      auto callback =
          HidManager_GetDevices_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDevices(std::move(callback));
      return true;
    }
    case messages::HidManager::kConnect: {
      internal::HidManager_Connect_Params_Data* params =
          reinterpret_cast<
              internal::HidManager_Connect_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidManager.2
      bool success = true;
      ::blink::String p_device_guid{};
      ::mojo::PendingRemote<HidConnectionClient> p_connection_client{};
      ::mojo::PendingRemote<HidConnectionWatcher> p_watcher{};
      bool p_allow_protected_reports{};
      bool p_allow_fido_reports{};
      HidManager_Connect_ParamsDataView input_data_view(params, message);
      
      if (success && !input_data_view.ReadDeviceGuid(&p_device_guid))
        success = false;
      if (success) {
        p_connection_client =
            input_data_view.TakeConnectionClient<decltype(p_connection_client)>();
      }
      if (success) {
        p_watcher =
            input_data_view.TakeWatcher<decltype(p_watcher)>();
      }
      if (success)
        p_allow_protected_reports = input_data_view.allow_protected_reports();
      if (success)
        p_allow_fido_reports = input_data_view.allow_fido_reports();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidManager::Name_, 2, false);
        return false;
      }
      auto callback =
          HidManager_Connect_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Connect(        
        std::move(p_device_guid), 
        std::move(p_connection_client), 
        std::move(p_watcher), 
        std::move(p_allow_protected_reports), 
        std::move(p_allow_fido_reports), std::move(callback));
      return true;
    }
    case messages::HidManager::kAddReceiver: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHidManagerValidationInfo[] = {
    { &internal::HidManager_GetDevicesAndSetClient_Params_Data::Validate,
     &internal::HidManager_GetDevicesAndSetClient_ResponseParams_Data::Validate},
    { &internal::HidManager_GetDevices_Params_Data::Validate,
     &internal::HidManager_GetDevices_ResponseParams_Data::Validate},
    { &internal::HidManager_Connect_Params_Data::Validate,
     &internal::HidManager_Connect_ResponseParams_Data::Validate},
    { &internal::HidManager_AddReceiver_Params_Data::Validate,
     nullptr /* no response */},
};

bool HidManagerRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::HidManager::Name_,
    kHidManagerValidationInfo);
}

bool HidManagerResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::blink::HidManager::Name_,
    kHidManagerValidationInfo);
}
// The declaration includes the definition on other builds.
constexpr base::Token HidConnection::Uuid_;

HidConnection::IPCStableHashFunction HidConnection::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HidConnection>(message.name())) {
    case messages::HidConnection::kRead: {
      return &HidConnection::Read_Sym::IPCStableHash;
    }
    case messages::HidConnection::kWrite: {
      return &HidConnection::Write_Sym::IPCStableHash;
    }
    case messages::HidConnection::kGetFeatureReport: {
      return &HidConnection::GetFeatureReport_Sym::IPCStableHash;
    }
    case messages::HidConnection::kSendFeatureReport: {
      return &HidConnection::SendFeatureReport_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HidConnection::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HidConnection>(message.name())) {
      case messages::HidConnection::kRead:
            return "Receive device::mojom::HidConnection::Read";
      case messages::HidConnection::kWrite:
            return "Receive device::mojom::HidConnection::Write";
      case messages::HidConnection::kGetFeatureReport:
            return "Receive device::mojom::HidConnection::GetFeatureReport";
      case messages::HidConnection::kSendFeatureReport:
            return "Receive device::mojom::HidConnection::SendFeatureReport";
    }
  } else {
    switch (static_cast<messages::HidConnection>(message.name())) {
      case messages::HidConnection::kRead:
            return "Receive reply device::mojom::HidConnection::Read";
      case messages::HidConnection::kWrite:
            return "Receive reply device::mojom::HidConnection::Write";
      case messages::HidConnection::kGetFeatureReport:
            return "Receive reply device::mojom::HidConnection::GetFeatureReport";
      case messages::HidConnection::kSendFeatureReport:
            return "Receive reply device::mojom::HidConnection::SendFeatureReport";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HidConnection::Read_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x87e7b559;  // IPCStableHash for device::mojom::HidConnection::Read
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidConnection::Write_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xbad9ce92;  // IPCStableHash for device::mojom::HidConnection::Write
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidConnection::GetFeatureReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x2f357d63;  // IPCStableHash for device::mojom::HidConnection::GetFeatureReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
uint32_t HidConnection::SendFeatureReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xce9a4db9;  // IPCStableHash for device::mojom::HidConnection::SendFeatureReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class HidConnection_Read_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidConnection_Read_ForwardToCallback(
      HidConnection::ReadCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidConnection_Read_ForwardToCallback(const HidConnection_Read_ForwardToCallback&) = delete;
  HidConnection_Read_ForwardToCallback& operator=(const HidConnection_Read_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidConnection::ReadCallback callback_;
};

class HidConnection_Write_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidConnection_Write_ForwardToCallback(
      HidConnection::WriteCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidConnection_Write_ForwardToCallback(const HidConnection_Write_ForwardToCallback&) = delete;
  HidConnection_Write_ForwardToCallback& operator=(const HidConnection_Write_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidConnection::WriteCallback callback_;
};

class HidConnection_GetFeatureReport_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidConnection_GetFeatureReport_ForwardToCallback(
      HidConnection::GetFeatureReportCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidConnection_GetFeatureReport_ForwardToCallback(const HidConnection_GetFeatureReport_ForwardToCallback&) = delete;
  HidConnection_GetFeatureReport_ForwardToCallback& operator=(const HidConnection_GetFeatureReport_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidConnection::GetFeatureReportCallback callback_;
};

class HidConnection_SendFeatureReport_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  HidConnection_SendFeatureReport_ForwardToCallback(
      HidConnection::SendFeatureReportCallback callback
      ) : callback_(std::move(callback)) {
  }

  HidConnection_SendFeatureReport_ForwardToCallback(const HidConnection_SendFeatureReport_ForwardToCallback&) = delete;
  HidConnection_SendFeatureReport_ForwardToCallback& operator=(const HidConnection_SendFeatureReport_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  HidConnection::SendFeatureReportCallback callback_;
};

HidConnectionProxy::HidConnectionProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HidConnectionProxy::Read(
    ReadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::HidConnection::Read");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidConnection::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidConnection_Read_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidConnection::Name_);
  message.set_method_name("Read");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidConnection_Read_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HidConnectionProxy::Write(
    uint8_t in_report_id, const ::blink::Vector<uint8_t>& in_buffer, WriteCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::HidConnection::Write", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_id"), in_report_id,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type const ::blink::Vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidConnection::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidConnection_Write_Params_Data> params(
          message);
  params.Allocate();

  params->report_id = in_report_id;
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType>
      buffer_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& buffer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_buffer,
    buffer_fragment,
    &buffer_validate_params);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in HidConnection.Write request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidConnection::Name_);
  message.set_method_name("Write");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidConnection_Write_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HidConnectionProxy::GetFeatureReport(
    uint8_t in_report_id, GetFeatureReportCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::HidConnection::GetFeatureReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_id"), in_report_id,
                        "<value of type uint8_t>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidConnection::kGetFeatureReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidConnection_GetFeatureReport_Params_Data> params(
          message);
  params.Allocate();

  params->report_id = in_report_id;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidConnection::Name_);
  message.set_method_name("GetFeatureReport");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidConnection_GetFeatureReport_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}

void HidConnectionProxy::SendFeatureReport(
    uint8_t in_report_id, const ::blink::Vector<uint8_t>& in_buffer, SendFeatureReportCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::HidConnection::SendFeatureReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_id"), in_report_id,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type const ::blink::Vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidConnection::kSendFeatureReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidConnection_SendFeatureReport_Params_Data> params(
          message);
  params.Allocate();

  params->report_id = in_report_id;
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType>
      buffer_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& buffer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_buffer,
    buffer_fragment,
    &buffer_validate_params);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in HidConnection.SendFeatureReport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidConnection::Name_);
  message.set_method_name("SendFeatureReport");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new HidConnection_SendFeatureReport_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class HidConnection_Read_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidConnection::ReadCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidConnection_Read_ProxyToResponder> proxy(
        new HidConnection_Read_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidConnection_Read_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidConnection_Read_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidConnection_Read_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidConnection::ReadCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, uint8_t in_report_id, const std::optional<::blink::Vector<uint8_t>>& in_buffer);
};

bool HidConnection_Read_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidConnection_Read_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidConnection_Read_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidConnection.0
  bool success = true;
  bool p_success{};
  uint8_t p_report_id{};
  std::optional<::blink::Vector<uint8_t>> p_buffer{};
  HidConnection_Read_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success)
    p_report_id = input_data_view.report_id();
  if (success && !input_data_view.ReadBuffer(&p_buffer))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidConnection::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_report_id), 
std::move(p_buffer));
  }
  return true;
}

void HidConnection_Read_ProxyToResponder::Run(
    bool in_success, uint8_t in_report_id, const std::optional<::blink::Vector<uint8_t>>& in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::HidConnection::Read", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_id"), in_report_id,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type const std::optional<::blink::Vector<uint8_t>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidConnection::kRead), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidConnection_Read_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

  params->report_id = in_report_id;
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType>
      buffer_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& buffer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_buffer,
    buffer_fragment,
    &buffer_validate_params);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidConnection::Name_);
  message.set_method_name("Read");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HidConnection_Write_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidConnection::WriteCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidConnection_Write_ProxyToResponder> proxy(
        new HidConnection_Write_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidConnection_Write_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidConnection_Write_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidConnection_Write_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidConnection::WriteCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool HidConnection_Write_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidConnection_Write_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidConnection_Write_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidConnection.1
  bool success = true;
  bool p_success{};
  HidConnection_Write_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidConnection::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void HidConnection_Write_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::HidConnection::Write", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidConnection::kWrite), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidConnection_Write_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidConnection::Name_);
  message.set_method_name("Write");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HidConnection_GetFeatureReport_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidConnection::GetFeatureReportCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidConnection_GetFeatureReport_ProxyToResponder> proxy(
        new HidConnection_GetFeatureReport_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidConnection_GetFeatureReport_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidConnection_GetFeatureReport_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidConnection_GetFeatureReport_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidConnection::GetFeatureReportCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success, const std::optional<::blink::Vector<uint8_t>>& in_buffer);
};

bool HidConnection_GetFeatureReport_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidConnection_GetFeatureReport_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidConnection_GetFeatureReport_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidConnection.2
  bool success = true;
  bool p_success{};
  std::optional<::blink::Vector<uint8_t>> p_buffer{};
  HidConnection_GetFeatureReport_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (success && !input_data_view.ReadBuffer(&p_buffer))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidConnection::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success), 
std::move(p_buffer));
  }
  return true;
}

void HidConnection_GetFeatureReport_ProxyToResponder::Run(
    bool in_success, const std::optional<::blink::Vector<uint8_t>>& in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::HidConnection::GetFeatureReport", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type const std::optional<::blink::Vector<uint8_t>>&>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidConnection::kGetFeatureReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidConnection_GetFeatureReport_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType>
      buffer_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& buffer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_buffer,
    buffer_fragment,
    &buffer_validate_params);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidConnection::Name_);
  message.set_method_name("GetFeatureReport");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class HidConnection_SendFeatureReport_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static HidConnection::SendFeatureReportCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<HidConnection_SendFeatureReport_ProxyToResponder> proxy(
        new HidConnection_SendFeatureReport_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&HidConnection_SendFeatureReport_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~HidConnection_SendFeatureReport_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  HidConnection_SendFeatureReport_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "HidConnection::SendFeatureReportCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);
};

bool HidConnection_SendFeatureReport_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::HidConnection_SendFeatureReport_ResponseParams_Data* params =
      reinterpret_cast<
          internal::HidConnection_SendFeatureReport_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for HidConnection.3
  bool success = true;
  bool p_success{};
  HidConnection_SendFeatureReport_ResponseParamsDataView input_data_view(params, message);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        HidConnection::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_success));
  }
  return true;
}

void HidConnection_SendFeatureReport_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::HidConnection::SendFeatureReport", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("success"), in_success,
                        "<value of type bool>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidConnection::kSendFeatureReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidConnection_SendFeatureReport_ResponseParams_Data> params(
          message);
  params.Allocate();

  params->success = in_success;

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidConnection::Name_);
  message.set_method_name("SendFeatureReport");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool HidConnectionStubDispatch::Accept(
    HidConnection* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HidConnection>(message->header()->name)) {
    case messages::HidConnection::kRead: {
      break;
    }
    case messages::HidConnection::kWrite: {
      break;
    }
    case messages::HidConnection::kGetFeatureReport: {
      break;
    }
    case messages::HidConnection::kSendFeatureReport: {
      break;
    }
  }
  return false;
}

// static
bool HidConnectionStubDispatch::AcceptWithResponder(
    HidConnection* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HidConnection>(message->header()->name)) {
    case messages::HidConnection::kRead: {
      internal::HidConnection_Read_Params_Data* params =
          reinterpret_cast<
              internal::HidConnection_Read_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidConnection.0
      bool success = true;
      HidConnection_Read_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidConnection::Name_, 0, false);
        return false;
      }
      auto callback =
          HidConnection_Read_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Read(std::move(callback));
      return true;
    }
    case messages::HidConnection::kWrite: {
      internal::HidConnection_Write_Params_Data* params =
          reinterpret_cast<
              internal::HidConnection_Write_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidConnection.1
      bool success = true;
      uint8_t p_report_id{};
      ::blink::Vector<uint8_t> p_buffer{};
      HidConnection_Write_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_report_id = input_data_view.report_id();
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidConnection::Name_, 1, false);
        return false;
      }
      auto callback =
          HidConnection_Write_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Write(        
        std::move(p_report_id), 
        std::move(p_buffer), std::move(callback));
      return true;
    }
    case messages::HidConnection::kGetFeatureReport: {
      internal::HidConnection_GetFeatureReport_Params_Data* params =
          reinterpret_cast<
              internal::HidConnection_GetFeatureReport_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidConnection.2
      bool success = true;
      uint8_t p_report_id{};
      HidConnection_GetFeatureReport_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_report_id = input_data_view.report_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidConnection::Name_, 2, false);
        return false;
      }
      auto callback =
          HidConnection_GetFeatureReport_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetFeatureReport(        
        std::move(p_report_id), std::move(callback));
      return true;
    }
    case messages::HidConnection::kSendFeatureReport: {
      internal::HidConnection_SendFeatureReport_Params_Data* params =
          reinterpret_cast<
              internal::HidConnection_SendFeatureReport_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for HidConnection.3
      bool success = true;
      uint8_t p_report_id{};
      ::blink::Vector<uint8_t> p_buffer{};
      HidConnection_SendFeatureReport_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_report_id = input_data_view.report_id();
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidConnection::Name_, 3, false);
        return false;
      }
      auto callback =
          HidConnection_SendFeatureReport_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SendFeatureReport(        
        std::move(p_report_id), 
        std::move(p_buffer), std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHidConnectionValidationInfo[] = {
    { &internal::HidConnection_Read_Params_Data::Validate,
     &internal::HidConnection_Read_ResponseParams_Data::Validate},
    { &internal::HidConnection_Write_Params_Data::Validate,
     &internal::HidConnection_Write_ResponseParams_Data::Validate},
    { &internal::HidConnection_GetFeatureReport_Params_Data::Validate,
     &internal::HidConnection_GetFeatureReport_ResponseParams_Data::Validate},
    { &internal::HidConnection_SendFeatureReport_Params_Data::Validate,
     &internal::HidConnection_SendFeatureReport_ResponseParams_Data::Validate},
};

bool HidConnectionRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::HidConnection::Name_,
    kHidConnectionValidationInfo);
}

bool HidConnectionResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::blink::HidConnection::Name_,
    kHidConnectionValidationInfo);
}
// The declaration includes the definition on other builds.
constexpr base::Token HidConnectionClient::Uuid_;

HidConnectionClient::IPCStableHashFunction HidConnectionClient::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::HidConnectionClient>(message.name())) {
    case messages::HidConnectionClient::kOnInputReport: {
      return &HidConnectionClient::OnInputReport_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HidConnectionClient::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::HidConnectionClient>(message.name())) {
      case messages::HidConnectionClient::kOnInputReport:
            return "Receive device::mojom::HidConnectionClient::OnInputReport";
    }
  } else {
    switch (static_cast<messages::HidConnectionClient>(message.name())) {
      case messages::HidConnectionClient::kOnInputReport:
            return "Receive reply device::mojom::HidConnectionClient::OnInputReport";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t HidConnectionClient::OnInputReport_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0x236b93f5;  // IPCStableHash for device::mojom::HidConnectionClient::OnInputReport
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

HidConnectionClientProxy::HidConnectionClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void HidConnectionClientProxy::OnInputReport(
    uint8_t in_report_id, const ::blink::Vector<uint8_t>& in_buffer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send device::mojom::HidConnectionClient::OnInputReport", "input_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("report_id"), in_report_id,
                        "<value of type uint8_t>");
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("buffer"), in_buffer,
                        "<value of type const ::blink::Vector<uint8_t>&>");
   });
#endif

  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::HidConnectionClient::kOnInputReport), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::HidConnectionClient_OnInputReport_Params_Data> params(
          message);
  params.Allocate();

  params->report_id = in_report_id;
  mojo::internal::MessageFragment<
      typename decltype(params->buffer)::BaseType>
      buffer_fragment(params.message());
  constexpr const mojo::internal::ContainerValidateParams& buffer_validate_params =
      mojo::internal::GetArrayValidator<0, false, nullptr>();
  
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
    in_buffer,
    buffer_fragment,
    &buffer_validate_params);

  params->buffer.Set(
      buffer_fragment.is_null() ? nullptr : buffer_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->buffer.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null buffer in HidConnectionClient.OnInputReport request");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(HidConnectionClient::Name_);
  message.set_method_name("OnInputReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ::mojo::internal::SendMojoMessage(*receiver_, message);
}

// static
bool HidConnectionClientStubDispatch::Accept(
    HidConnectionClient* impl,
    mojo::Message* message) {
  switch (static_cast<messages::HidConnectionClient>(message->header()->name)) {
    case messages::HidConnectionClient::kOnInputReport: {
      DCHECK(message->is_serialized());
      internal::HidConnectionClient_OnInputReport_Params_Data* params =
          reinterpret_cast<internal::HidConnectionClient_OnInputReport_Params_Data*>(
              message->mutable_payload());
      

      // Validation for HidConnectionClient.0
      bool success = true;
      uint8_t p_report_id{};
      ::blink::Vector<uint8_t> p_buffer{};
      HidConnectionClient_OnInputReport_ParamsDataView input_data_view(params, message);
      
      if (success)
        p_report_id = input_data_view.report_id();
      if (success && !input_data_view.ReadBuffer(&p_buffer))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            HidConnectionClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnInputReport(        
        std::move(p_report_id), 
        std::move(p_buffer));
      return true;
    }
  }
  return false;
}

// static
bool HidConnectionClientStubDispatch::AcceptWithResponder(
    HidConnectionClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::HidConnectionClient>(message->header()->name)) {
    case messages::HidConnectionClient::kOnInputReport: {
      break;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kHidConnectionClientValidationInfo[] = {
    { &internal::HidConnectionClient_OnInputReport_Params_Data::Validate,
     nullptr /* no response */},
};

bool HidConnectionClientRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::blink::HidConnectionClient::Name_,
    kHidConnectionClientValidationInfo);
}

// The declaration includes the definition on other builds.
constexpr base::Token HidConnectionWatcher::Uuid_;

HidConnectionWatcher::IPCStableHashFunction HidConnectionWatcher::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* HidConnectionWatcher::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
# endif // !BUILDFLAG(IS_FUCHSIA)

HidConnectionWatcherProxy::HidConnectionWatcherProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

// static
bool HidConnectionWatcherStubDispatch::Accept(
    HidConnectionWatcher* impl,
    mojo::Message* message) {
  return false;
}

// static
bool HidConnectionWatcherStubDispatch::AcceptWithResponder(
    HidConnectionWatcher* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  return false;
}
namespace {
}  // namespace

bool HidConnectionWatcherRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGeneric(
    message,
    ::device::mojom::blink::HidConnectionWatcher::Name_,
    {});
}



}  // device::mojom::blink


namespace mojo {


// static
bool StructTraits<::device::mojom::blink::HidUsageAndPage::DataView, ::device::mojom::blink::HidUsageAndPagePtr>::Read(
    ::device::mojom::blink::HidUsageAndPage::DataView input,
    ::device::mojom::blink::HidUsageAndPagePtr* output) {
  bool success = true;
  ::device::mojom::blink::HidUsageAndPagePtr result(::device::mojom::blink::HidUsageAndPage::New());
  
      if (success)
        result->usage = input.usage();
      if (success)
        result->usage_page = input.usage_page();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::HidReportItem::DataView, ::device::mojom::blink::HidReportItemPtr>::Read(
    ::device::mojom::blink::HidReportItem::DataView input,
    ::device::mojom::blink::HidReportItemPtr* output) {
  bool success = true;
  ::device::mojom::blink::HidReportItemPtr result(::device::mojom::blink::HidReportItem::New());
  
      if (success)
        result->is_range = input.is_range();
      if (success)
        result->is_constant = input.is_constant();
      if (success)
        result->is_variable = input.is_variable();
      if (success)
        result->is_relative = input.is_relative();
      if (success)
        result->wrap = input.wrap();
      if (success)
        result->is_non_linear = input.is_non_linear();
      if (success)
        result->no_preferred_state = input.no_preferred_state();
      if (success)
        result->has_null_position = input.has_null_position();
      if (success)
        result->is_volatile = input.is_volatile();
      if (success)
        result->is_buffered_bytes = input.is_buffered_bytes();
      if (success && !input.ReadUsages(&result->usages))
        success = false;
      if (success && !input.ReadUsageMinimum(&result->usage_minimum))
        success = false;
      if (success && !input.ReadUsageMaximum(&result->usage_maximum))
        success = false;
      if (success)
        result->designator_minimum = input.designator_minimum();
      if (success)
        result->designator_maximum = input.designator_maximum();
      if (success)
        result->string_minimum = input.string_minimum();
      if (success)
        result->string_maximum = input.string_maximum();
      if (success)
        result->logical_minimum = input.logical_minimum();
      if (success)
        result->logical_maximum = input.logical_maximum();
      if (success)
        result->physical_minimum = input.physical_minimum();
      if (success)
        result->physical_maximum = input.physical_maximum();
      if (success)
        result->unit_exponent = input.unit_exponent();
      if (success)
        result->unit = input.unit();
      if (success)
        result->report_size = input.report_size();
      if (success)
        result->report_count = input.report_count();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::HidReportDescription::DataView, ::device::mojom::blink::HidReportDescriptionPtr>::Read(
    ::device::mojom::blink::HidReportDescription::DataView input,
    ::device::mojom::blink::HidReportDescriptionPtr* output) {
  bool success = true;
  ::device::mojom::blink::HidReportDescriptionPtr result(::device::mojom::blink::HidReportDescription::New());
  
      if (success)
        result->report_id = input.report_id();
      if (success && !input.ReadItems(&result->items))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::HidCollectionInfo::DataView, ::device::mojom::blink::HidCollectionInfoPtr>::Read(
    ::device::mojom::blink::HidCollectionInfo::DataView input,
    ::device::mojom::blink::HidCollectionInfoPtr* output) {
  bool success = true;
  ::device::mojom::blink::HidCollectionInfoPtr result(::device::mojom::blink::HidCollectionInfo::New());
  
      if (success && !input.ReadUsage(&result->usage))
        success = false;
      if (success && !input.ReadReportIds(&result->report_ids))
        success = false;
      if (success)
        result->collection_type = input.collection_type();
      if (success && !input.ReadInputReports(&result->input_reports))
        success = false;
      if (success && !input.ReadOutputReports(&result->output_reports))
        success = false;
      if (success && !input.ReadFeatureReports(&result->feature_reports))
        success = false;
      if (success && !input.ReadChildren(&result->children))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::device::mojom::blink::HidDeviceInfo::DataView, ::device::mojom::blink::HidDeviceInfoPtr>::Read(
    ::device::mojom::blink::HidDeviceInfo::DataView input,
    ::device::mojom::blink::HidDeviceInfoPtr* output) {
  bool success = true;
  ::device::mojom::blink::HidDeviceInfoPtr result(::device::mojom::blink::HidDeviceInfo::New());
  
      if (success && !input.ReadGuid(&result->guid))
        success = false;
      if (success && !input.ReadPhysicalDeviceId(&result->physical_device_id))
        success = false;
      if (success)
        result->vendor_id = input.vendor_id();
      if (success)
        result->product_id = input.product_id();
      if (success && !input.ReadProductName(&result->product_name))
        success = false;
      if (success && !input.ReadSerialNumber(&result->serial_number))
        success = false;
      if (success && !input.ReadBusType(&result->bus_type))
        success = false;
      if (success && !input.ReadReportDescriptor(&result->report_descriptor))
        success = false;
      if (success && !input.ReadCollections(&result->collections))
        success = false;
      if (success)
        result->has_report_id = input.has_report_id();
      if (success)
        result->max_input_report_size = input.max_input_report_size();
      if (success)
        result->max_output_report_size = input.max_output_report_size();
      if (success)
        result->max_feature_report_size = input.max_feature_report_size();
      if (success && !input.ReadDeviceNode(&result->device_node))
        success = false;
      if (success && !input.ReadProtectedInputReportIds(&result->protected_input_report_ids))
        success = false;
      if (success && !input.ReadProtectedOutputReportIds(&result->protected_output_report_ids))
        success = false;
      if (success && !input.ReadProtectedFeatureReportIds(&result->protected_feature_report_ids))
        success = false;
      if (success)
        result->is_excluded_by_blocklist = input.is_excluded_by_blocklist();
  *output = std::move(result);
  return success;
}

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom::blink {


void HidManagerClientInterceptorForTesting::DeviceAdded(HidDeviceInfoPtr device_info) {
  GetForwardingInterface()->DeviceAdded(
    std::move(device_info)
    );
}
void HidManagerClientInterceptorForTesting::DeviceRemoved(HidDeviceInfoPtr device_info) {
  GetForwardingInterface()->DeviceRemoved(
    std::move(device_info)
    );
}
void HidManagerClientInterceptorForTesting::DeviceChanged(HidDeviceInfoPtr device_info) {
  GetForwardingInterface()->DeviceChanged(
    std::move(device_info)
    );
}
HidManagerClientAsyncWaiter::HidManagerClientAsyncWaiter(
    HidManagerClient* proxy) : proxy_(proxy) {}

HidManagerClientAsyncWaiter::~HidManagerClientAsyncWaiter() = default;





void HidManagerInterceptorForTesting::GetDevicesAndSetClient(::mojo::PendingAssociatedRemote<HidManagerClient> client, GetDevicesAndSetClientCallback callback) {
  GetForwardingInterface()->GetDevicesAndSetClient(
    std::move(client)
    , std::move(callback));
}
void HidManagerInterceptorForTesting::GetDevices(GetDevicesCallback callback) {
  GetForwardingInterface()->GetDevices(std::move(callback));
}
void HidManagerInterceptorForTesting::Connect(const ::blink::String& device_guid, ::mojo::PendingRemote<HidConnectionClient> connection_client, ::mojo::PendingRemote<HidConnectionWatcher> watcher, bool allow_protected_reports, bool allow_fido_reports, ConnectCallback callback) {
  GetForwardingInterface()->Connect(
    std::move(device_guid)
    , 
    std::move(connection_client)
    , 
    std::move(watcher)
    , 
    std::move(allow_protected_reports)
    , 
    std::move(allow_fido_reports)
    , std::move(callback));
}
void HidManagerInterceptorForTesting::AddReceiver(::mojo::PendingReceiver<HidManager> receiver) {
  GetForwardingInterface()->AddReceiver(
    std::move(receiver)
    );
}
HidManagerAsyncWaiter::HidManagerAsyncWaiter(
    HidManager* proxy) : proxy_(proxy) {}

HidManagerAsyncWaiter::~HidManagerAsyncWaiter() = default;


void HidManagerAsyncWaiter::GetDevicesAndSetClient(
    ::mojo::PendingAssociatedRemote<HidManagerClient> client, ::blink::Vector<HidDeviceInfoPtr>* out_devices) {
  base::RunLoop loop;
  proxy_->GetDevicesAndSetClient(
      std::move(client),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<HidDeviceInfoPtr>* out_devices
,
             ::blink::Vector<HidDeviceInfoPtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}

::blink::Vector<HidDeviceInfoPtr> HidManagerAsyncWaiter::GetDevicesAndSetClient(
    ::mojo::PendingAssociatedRemote<HidManagerClient> client) {
  ::blink::Vector<HidDeviceInfoPtr> async_wait_result;
  GetDevicesAndSetClient(std::move(client),&async_wait_result);
  return async_wait_result;
}

void HidManagerAsyncWaiter::GetDevices(
    ::blink::Vector<HidDeviceInfoPtr>* out_devices) {
  base::RunLoop loop;
  proxy_->GetDevices(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::blink::Vector<HidDeviceInfoPtr>* out_devices
,
             ::blink::Vector<HidDeviceInfoPtr> devices) {*out_devices = std::move(devices);
            loop->Quit();
          },
          &loop,
          out_devices));
  loop.Run();
}

::blink::Vector<HidDeviceInfoPtr> HidManagerAsyncWaiter::GetDevices(
    ) {
  ::blink::Vector<HidDeviceInfoPtr> async_wait_result;
  GetDevices(&async_wait_result);
  return async_wait_result;
}

void HidManagerAsyncWaiter::Connect(
    const ::blink::String& device_guid, ::mojo::PendingRemote<HidConnectionClient> connection_client, ::mojo::PendingRemote<HidConnectionWatcher> watcher, bool allow_protected_reports, bool allow_fido_reports, ::mojo::PendingRemote<HidConnection>* out_connection) {
  base::RunLoop loop;
  proxy_->Connect(
      std::move(device_guid),
      std::move(connection_client),
      std::move(watcher),
      std::move(allow_protected_reports),
      std::move(allow_fido_reports),
      base::BindOnce(
          [](base::RunLoop* loop,
             ::mojo::PendingRemote<HidConnection>* out_connection
,
             ::mojo::PendingRemote<HidConnection> connection) {*out_connection = std::move(connection);
            loop->Quit();
          },
          &loop,
          out_connection));
  loop.Run();
}

::mojo::PendingRemote<HidConnection> HidManagerAsyncWaiter::Connect(
    const ::blink::String& device_guid, ::mojo::PendingRemote<HidConnectionClient> connection_client, ::mojo::PendingRemote<HidConnectionWatcher> watcher, bool allow_protected_reports, bool allow_fido_reports) {
  ::mojo::PendingRemote<HidConnection> async_wait_result;
  Connect(std::move(device_guid),std::move(connection_client),std::move(watcher),std::move(allow_protected_reports),std::move(allow_fido_reports),&async_wait_result);
  return async_wait_result;
}




void HidConnectionInterceptorForTesting::Read(ReadCallback callback) {
  GetForwardingInterface()->Read(std::move(callback));
}
void HidConnectionInterceptorForTesting::Write(uint8_t report_id, const ::blink::Vector<uint8_t>& buffer, WriteCallback callback) {
  GetForwardingInterface()->Write(
    std::move(report_id)
    , 
    std::move(buffer)
    , std::move(callback));
}
void HidConnectionInterceptorForTesting::GetFeatureReport(uint8_t report_id, GetFeatureReportCallback callback) {
  GetForwardingInterface()->GetFeatureReport(
    std::move(report_id)
    , std::move(callback));
}
void HidConnectionInterceptorForTesting::SendFeatureReport(uint8_t report_id, const ::blink::Vector<uint8_t>& buffer, SendFeatureReportCallback callback) {
  GetForwardingInterface()->SendFeatureReport(
    std::move(report_id)
    , 
    std::move(buffer)
    , std::move(callback));
}
HidConnectionAsyncWaiter::HidConnectionAsyncWaiter(
    HidConnection* proxy) : proxy_(proxy) {}

HidConnectionAsyncWaiter::~HidConnectionAsyncWaiter() = default;


void HidConnectionAsyncWaiter::Read(
    bool* out_success, uint8_t* out_report_id, std::optional<::blink::Vector<uint8_t>>* out_buffer) {
  base::RunLoop loop;
  proxy_->Read(
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             uint8_t* out_report_id
,
             std::optional<::blink::Vector<uint8_t>>* out_buffer
,
             bool success,
             uint8_t report_id,
             const std::optional<::blink::Vector<uint8_t>>& buffer) {*out_success = std::move(success);*out_report_id = std::move(report_id);*out_buffer = std::move(buffer);
            loop->Quit();
          },
          &loop,
          out_success,
          out_report_id,
          out_buffer));
  loop.Run();
}



void HidConnectionAsyncWaiter::Write(
    uint8_t report_id, const ::blink::Vector<uint8_t>& buffer, bool* out_success) {
  base::RunLoop loop;
  proxy_->Write(
      std::move(report_id),
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool HidConnectionAsyncWaiter::Write(
    uint8_t report_id, const ::blink::Vector<uint8_t>& buffer) {
  bool async_wait_result;
  Write(std::move(report_id),std::move(buffer),&async_wait_result);
  return async_wait_result;
}

void HidConnectionAsyncWaiter::GetFeatureReport(
    uint8_t report_id, bool* out_success, std::optional<::blink::Vector<uint8_t>>* out_buffer) {
  base::RunLoop loop;
  proxy_->GetFeatureReport(
      std::move(report_id),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             std::optional<::blink::Vector<uint8_t>>* out_buffer
,
             bool success,
             const std::optional<::blink::Vector<uint8_t>>& buffer) {*out_success = std::move(success);*out_buffer = std::move(buffer);
            loop->Quit();
          },
          &loop,
          out_success,
          out_buffer));
  loop.Run();
}



void HidConnectionAsyncWaiter::SendFeatureReport(
    uint8_t report_id, const ::blink::Vector<uint8_t>& buffer, bool* out_success) {
  base::RunLoop loop;
  proxy_->SendFeatureReport(
      std::move(report_id),
      std::move(buffer),
      base::BindOnce(
          [](base::RunLoop* loop,
             bool* out_success
,
             bool success) {*out_success = std::move(success);
            loop->Quit();
          },
          &loop,
          out_success));
  loop.Run();
}

bool HidConnectionAsyncWaiter::SendFeatureReport(
    uint8_t report_id, const ::blink::Vector<uint8_t>& buffer) {
  bool async_wait_result;
  SendFeatureReport(std::move(report_id),std::move(buffer),&async_wait_result);
  return async_wait_result;
}




void HidConnectionClientInterceptorForTesting::OnInputReport(uint8_t report_id, const ::blink::Vector<uint8_t>& buffer) {
  GetForwardingInterface()->OnInputReport(
    std::move(report_id)
    , 
    std::move(buffer)
    );
}
HidConnectionClientAsyncWaiter::HidConnectionClientAsyncWaiter(
    HidConnectionClient* proxy) : proxy_(proxy) {}

HidConnectionClientAsyncWaiter::~HidConnectionClientAsyncWaiter() = default;





HidConnectionWatcherAsyncWaiter::HidConnectionWatcherAsyncWaiter(
    HidConnectionWatcher* proxy) : proxy_(proxy) {}

HidConnectionWatcherAsyncWaiter::~HidConnectionWatcherAsyncWaiter() = default;







}  // device::mojom::blink


#if defined(__clang__)
#pragma clang diagnostic pop
#endif