// services/device/public/mojom/geoposition.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_SHARED_INTERNAL_H_
#define SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_SHARED_INTERNAL_H_
#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/mojom/base/time.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}


namespace device::mojom {
namespace internal {
class Geoposition_Data;
class GeopositionError_Data;
class GeopositionResult_Data;

struct GeopositionErrorCode_Data {
 public:
  static bool constexpr kIsExtensible = false;

  static bool IsKnownValue(int32_t value) {
    switch (value) {
      case 1:
      case 2:
      case 3:
        return true;
    }
    return false;
  }

  static bool Validate(int32_t value,
                       mojo::internal::ValidationContext* validation_context) {
    if (kIsExtensible || IsKnownValue(value))
      return true;

    ReportValidationError(validation_context,
                          mojo::internal::VALIDATION_ERROR_UNKNOWN_ENUM_VALUE);
    return false;
  }
};

#pragma pack(push, 1)


class  GeopositionResult_Data {
 public:
  // Used to identify Mojom Union Data Classes.
  typedef void MojomUnionDataType;

  GeopositionResult_Data() = default;
  // Do nothing in the destructor since it won't be called when it is a
  // non-inlined union.
  ~GeopositionResult_Data() = default;

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context,
                       bool inlined);

  bool is_null() const { return size == 0; }

  void set_null() {
    size = 0U;
    tag = static_cast<GeopositionResult_Tag>(0);
    data.unknown = 0U;
  }

  // TODO(crbug.com/40731316): SHOUTY_CASE values are being deprecated per C++ code style
  // guidelines (https://google.github.io/styleguide/cppguide.html#Enumerator_Names),
  // please use kCamelCase values instead.  Cleanup NULL_VALUE, BOOL_VALUE, INT_VALUE, etc.
  // generation once codebase is transitioned to kNullValue, kBoolValue, kIntValue, etc.
  enum class GeopositionResult_Tag : uint32_t {

    
    kPosition,
    
    kError,
  };

  // A note on layout:
  // "Each non-static data member is allocated as if it were the sole member of
  // a struct." - Section 9.5.2 ISO/IEC 14882:2011 (The C++ Spec)
  union MOJO_ALIGNAS(8) Union_ {
    Union_() : unknown(0) {}
    mojo::internal::Pointer<internal::Geoposition_Data> f_position;
    mojo::internal::Pointer<internal::GeopositionError_Data> f_error;
    uint64_t unknown;
  };

  uint32_t size;
  GeopositionResult_Tag tag;
  Union_ data;
};
static_assert(sizeof(GeopositionResult_Data) == mojo::internal::kUnionDataSize,
              "Bad sizeof(GeopositionResult_Data)");
class  Geoposition_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  double latitude;
  double longitude;
  double altitude;
  double accuracy;
  double altitude_accuracy;
  double heading;
  double speed;
  mojo::internal::Pointer<::mojo_base::mojom::internal::Time_Data> timestamp;
  uint8_t is_precise : 1;
  uint8_t padfinal_[7];

 private:
  friend class mojo::internal::MessageFragment<Geoposition_Data>;

  Geoposition_Data();
  ~Geoposition_Data() = delete;
};
static_assert(sizeof(Geoposition_Data) == 80,
              "Bad sizeof(Geoposition_Data)");
// Used by Geoposition::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct Geoposition_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  Geoposition_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~Geoposition_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<Geoposition_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    Geoposition_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class  GeopositionError_Data {
 public:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t error_code;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::String_Data> error_message;
  mojo::internal::Pointer<mojo::internal::String_Data> error_technical;

 private:
  friend class mojo::internal::MessageFragment<GeopositionError_Data>;

  GeopositionError_Data();
  ~GeopositionError_Data() = delete;
};
static_assert(sizeof(GeopositionError_Data) == 32,
              "Bad sizeof(GeopositionError_Data)");
// Used by GeopositionError::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct GeopositionError_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  GeopositionError_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~GeopositionError_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::Message& message) override {
    mojo::internal::MessageFragment<GeopositionError_Data> fragment(message);
    mojo::internal::Serialize<DataView>(user_data_, fragment);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    GeopositionError_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal

}  // device::mojom

#endif  // SERVICES_DEVICE_PUBLIC_MOJOM_GEOPOSITION_MOJOM_SHARED_INTERNAL_H_