// services/device/public/mojom/fingerprint.mojom.m.js is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2020 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

import {mojo} from '../../../../mojo/public/js/bindings.js';


/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const ScanResultSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const ScanResult = {
  
  SUCCESS: 0,
  PARTIAL: 1,
  INSUFFICIENT: 2,
  SENSOR_DIRTY: 3,
  TOO_SLOW: 4,
  TOO_FAST: 5,
  IMMOBILE: 6,
  NO_MATCH: 7,
  MIN_VALUE: 0,
  MAX_VALUE: 7,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const FingerprintErrorSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const FingerprintError = {
  
  UNKNOWN: 0,
  HW_UNAVAILABLE: 1,
  UNABLE_TO_PROCESS: 2,
  TIMEOUT: 3,
  NO_SPACE: 4,
  CANCELED: 5,
  UNABLE_TO_REMOVE: 6,
  LOCKOUT: 7,
  NO_TEMPLATES: 8,
  MIN_VALUE: 0,
  MAX_VALUE: 8,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BiometricTypeSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BiometricType = {
  
  UNKNOWN: 0,
  FINGERPRINT: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};

/**
 * @const { {$: !mojo.internal.MojomType} }
 */
export const BiometricsManagerStatusSpec = { $: mojo.internal.Enum() };

/**
 * @enum {number}
 */
export const BiometricsManagerStatus = {
  
  UNKNOWN: 0,
  INITIALIZED: 1,
  MIN_VALUE: 0,
  MAX_VALUE: 1,
};



/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FingerprintObserverPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.FingerprintObserver', scope);
  }
}

/** @interface */
export class FingerprintObserverInterface {
  
  /**
   */

  onRestarted() {}
  
  /**
   * @param { !BiometricsManagerStatus } status
   */

  onStatusChanged(status) {}
  
  /**
   * @param { !ScanResult } scanResult
   * @param { !boolean } isComplete
   * @param { !number } percentComplete
   */

  onEnrollScanDone(scanResult, isComplete, percentComplete) {}
  
  /**
   * @param { !FingerprintMessage } msg
   * @param { !Object<!string, !Array<!string>> } matches
   */

  onAuthScanDone(msg, matches) {}
  
  /**
   */

  onSessionFailed() {}
}

/**
 * @implements { FingerprintObserverInterface }
 */
export class FingerprintObserverRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FingerprintObserverPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FingerprintObserverPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FingerprintObserverPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   */

  onRestarted() {
    this.proxy.sendMessage(
        0,
        FingerprintObserver_OnRestarted_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @param { !BiometricsManagerStatus } status
   */

  onStatusChanged(
      status) {
    this.proxy.sendMessage(
        1,
        FingerprintObserver_OnStatusChanged_ParamsSpec.$,
        null,
        [
          status
        ],
        false);
  }

  
  /**
   * @param { !ScanResult } scanResult
   * @param { !boolean } isComplete
   * @param { !number } percentComplete
   */

  onEnrollScanDone(
      scanResult,
      isComplete,
      percentComplete) {
    this.proxy.sendMessage(
        2,
        FingerprintObserver_OnEnrollScanDone_ParamsSpec.$,
        null,
        [
          scanResult,
          isComplete,
          percentComplete
        ],
        false);
  }

  
  /**
   * @param { !FingerprintMessage } msg
   * @param { !Object<!string, !Array<!string>> } matches
   */

  onAuthScanDone(
      msg,
      matches) {
    this.proxy.sendMessage(
        3,
        FingerprintObserver_OnAuthScanDone_ParamsSpec.$,
        null,
        [
          msg,
          matches
        ],
        false);
  }

  
  /**
   */

  onSessionFailed() {
    this.proxy.sendMessage(
        4,
        FingerprintObserver_OnSessionFailed_ParamsSpec.$,
        null,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the FingerprintObserver
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FingerprintObserverReceiver {
  /**
   * @param {!FingerprintObserverInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FingerprintObserverRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FingerprintObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FingerprintObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        FingerprintObserver_OnRestarted_ParamsSpec.$,
        null,
        impl.onRestarted.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        FingerprintObserver_OnStatusChanged_ParamsSpec.$,
        null,
        impl.onStatusChanged.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        FingerprintObserver_OnEnrollScanDone_ParamsSpec.$,
        null,
        impl.onEnrollScanDone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        FingerprintObserver_OnAuthScanDone_ParamsSpec.$,
        null,
        impl.onAuthScanDone.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        FingerprintObserver_OnSessionFailed_ParamsSpec.$,
        null,
        impl.onSessionFailed.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class FingerprintObserver {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.FingerprintObserver";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FingerprintObserverRemote}
   */
  static getRemote() {
    let remote = new FingerprintObserverRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the FingerprintObserver
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FingerprintObserverCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FingerprintObserverRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FingerprintObserverRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onRestarted =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        FingerprintObserver_OnRestarted_ParamsSpec.$,
        null,
        this.onRestarted.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onStatusChanged =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        FingerprintObserver_OnStatusChanged_ParamsSpec.$,
        null,
        this.onStatusChanged.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onEnrollScanDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        FingerprintObserver_OnEnrollScanDone_ParamsSpec.$,
        null,
        this.onEnrollScanDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onAuthScanDone =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        FingerprintObserver_OnAuthScanDone_ParamsSpec.$,
        null,
        this.onAuthScanDone.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.onSessionFailed =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        FingerprintObserver_OnSessionFailed_ParamsSpec.$,
        null,
        this.onSessionFailed.createReceiverHandler(false /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}


/**
 * @implements {mojo.internal.interfaceSupport.PendingReceiver}
 */
export class FingerprintPendingReceiver {
  /**
   * @param {!MojoHandle|!mojo.internal.interfaceSupport.Endpoint} handle
   */
  constructor(handle) {
    /** @public {!mojo.internal.interfaceSupport.Endpoint} */
    this.handle = mojo.internal.interfaceSupport.getEndpointForReceiver(handle);
  }

  /** @param {string=} scope */
  bindInBrowser(scope = 'context') {
    mojo.internal.interfaceSupport.bind(
        this.handle, 'device.mojom.Fingerprint', scope);
  }
}

/** @interface */
export class FingerprintInterface {
  
  /**
   * @param { !string } userId
   * @return {!Promise<{
        records: !Object<!string, !string>,
        success: !boolean,
   *  }>}
   */

  getRecordsForUser(userId) {}
  
  /**
   * @param { !string } userId
   * @param { !string } label
   */

  startEnrollSession(userId, label) {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  cancelCurrentEnrollSession() {}
  
  /**
   * @param { !string } recordPath
   * @return {!Promise<{
        label: !string,
   *  }>}
   */

  requestRecordLabel(recordPath) {}
  
  /**
   * @param { !string } recordPath
   * @param { !string } newLabel
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setRecordLabel(recordPath, newLabel) {}
  
  /**
   * @param { !string } recordPath
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  removeRecord(recordPath) {}
  
  /**
   */

  startAuthSession() {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  endCurrentAuthSession() {}
  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  destroyAllRecords() {}
  
  /**
   * @param { !FingerprintObserverRemote } observer
   */

  addFingerprintObserver(observer) {}
  
  /**
   * @return {!Promise<{
        type: !BiometricType,
   *  }>}
   */

  requestType() {}
}

/**
 * @implements { FingerprintInterface }
 */
export class FingerprintRemote {
  /** @param {MojoHandle|mojo.internal.interfaceSupport.Endpoint=} handle */
  constructor(handle = undefined) {
    /**
     * @private {!mojo.internal.interfaceSupport.InterfaceRemoteBase<!FingerprintPendingReceiver>}
     */
    this.proxy =
        new mojo.internal.interfaceSupport.InterfaceRemoteBase(
          FingerprintPendingReceiver,
          handle);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper<!FingerprintPendingReceiver>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceRemoteBaseWrapper(this.proxy);

    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.proxy.getConnectionErrorEventRouter();
  }

  
  /**
   * @param { !string } userId
   * @return {!Promise<{
        records: !Object<!string, !string>,
        success: !boolean,
   *  }>}
   */

  getRecordsForUser(
      userId) {
    return this.proxy.sendMessage(
        0,
        Fingerprint_GetRecordsForUser_ParamsSpec.$,
        Fingerprint_GetRecordsForUser_ResponseParamsSpec.$,
        [
          userId
        ],
        false);
  }

  
  /**
   * @param { !string } userId
   * @param { !string } label
   */

  startEnrollSession(
      userId,
      label) {
    this.proxy.sendMessage(
        1,
        Fingerprint_StartEnrollSession_ParamsSpec.$,
        null,
        [
          userId,
          label
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  cancelCurrentEnrollSession() {
    return this.proxy.sendMessage(
        2,
        Fingerprint_CancelCurrentEnrollSession_ParamsSpec.$,
        Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !string } recordPath
   * @return {!Promise<{
        label: !string,
   *  }>}
   */

  requestRecordLabel(
      recordPath) {
    return this.proxy.sendMessage(
        3,
        Fingerprint_RequestRecordLabel_ParamsSpec.$,
        Fingerprint_RequestRecordLabel_ResponseParamsSpec.$,
        [
          recordPath
        ],
        false);
  }

  
  /**
   * @param { !string } recordPath
   * @param { !string } newLabel
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  setRecordLabel(
      recordPath,
      newLabel) {
    return this.proxy.sendMessage(
        4,
        Fingerprint_SetRecordLabel_ParamsSpec.$,
        Fingerprint_SetRecordLabel_ResponseParamsSpec.$,
        [
          recordPath,
          newLabel
        ],
        false);
  }

  
  /**
   * @param { !string } recordPath
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  removeRecord(
      recordPath) {
    return this.proxy.sendMessage(
        5,
        Fingerprint_RemoveRecord_ParamsSpec.$,
        Fingerprint_RemoveRecord_ResponseParamsSpec.$,
        [
          recordPath
        ],
        false);
  }

  
  /**
   */

  startAuthSession() {
    this.proxy.sendMessage(
        6,
        Fingerprint_StartAuthSession_ParamsSpec.$,
        null,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  endCurrentAuthSession() {
    return this.proxy.sendMessage(
        7,
        Fingerprint_EndCurrentAuthSession_ParamsSpec.$,
        Fingerprint_EndCurrentAuthSession_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        success: !boolean,
   *  }>}
   */

  destroyAllRecords() {
    return this.proxy.sendMessage(
        8,
        Fingerprint_DestroyAllRecords_ParamsSpec.$,
        Fingerprint_DestroyAllRecords_ResponseParamsSpec.$,
        [
        ],
        false);
  }

  
  /**
   * @param { !FingerprintObserverRemote } observer
   */

  addFingerprintObserver(
      observer) {
    this.proxy.sendMessage(
        9,
        Fingerprint_AddFingerprintObserver_ParamsSpec.$,
        null,
        [
          observer
        ],
        false);
  }

  
  /**
   * @return {!Promise<{
        type: !BiometricType,
   *  }>}
   */

  requestType() {
    return this.proxy.sendMessage(
        10,
        Fingerprint_RequestType_ParamsSpec.$,
        Fingerprint_RequestType_ResponseParamsSpec.$,
        [
        ],
        false);
  }
}

/**
 * An object which receives request messages for the Fingerprint
 * mojom interface. Must be constructed over an object which implements that
 * interface.
 */
export class FingerprintReceiver {
  /**
   * @param {!FingerprintInterface } impl
   */
  constructor(impl) {
    /** @private {!mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal<!FingerprintRemote>} */
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
        FingerprintRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FingerprintRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);


    this.helper_internal_.registerHandler(
        0,
        Fingerprint_GetRecordsForUser_ParamsSpec.$,
        Fingerprint_GetRecordsForUser_ResponseParamsSpec.$,
        impl.getRecordsForUser.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        1,
        Fingerprint_StartEnrollSession_ParamsSpec.$,
        null,
        impl.startEnrollSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        2,
        Fingerprint_CancelCurrentEnrollSession_ParamsSpec.$,
        Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec.$,
        impl.cancelCurrentEnrollSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        3,
        Fingerprint_RequestRecordLabel_ParamsSpec.$,
        Fingerprint_RequestRecordLabel_ResponseParamsSpec.$,
        impl.requestRecordLabel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        4,
        Fingerprint_SetRecordLabel_ParamsSpec.$,
        Fingerprint_SetRecordLabel_ResponseParamsSpec.$,
        impl.setRecordLabel.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        5,
        Fingerprint_RemoveRecord_ParamsSpec.$,
        Fingerprint_RemoveRecord_ResponseParamsSpec.$,
        impl.removeRecord.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        6,
        Fingerprint_StartAuthSession_ParamsSpec.$,
        null,
        impl.startAuthSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        7,
        Fingerprint_EndCurrentAuthSession_ParamsSpec.$,
        Fingerprint_EndCurrentAuthSession_ResponseParamsSpec.$,
        impl.endCurrentAuthSession.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        8,
        Fingerprint_DestroyAllRecords_ParamsSpec.$,
        Fingerprint_DestroyAllRecords_ResponseParamsSpec.$,
        impl.destroyAllRecords.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        9,
        Fingerprint_AddFingerprintObserver_ParamsSpec.$,
        null,
        impl.addFingerprintObserver.bind(impl),
        false);
    this.helper_internal_.registerHandler(
        10,
        Fingerprint_RequestType_ParamsSpec.$,
        Fingerprint_RequestType_ResponseParamsSpec.$,
        impl.requestType.bind(impl),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }
}

export class Fingerprint {
  /**
   * @return {!string}
   */
  static get $interfaceName() {
    return "device.mojom.Fingerprint";
  }

  /**
   * Returns a remote for this interface which sends messages to the browser.
   * The browser must have an interface request binder registered for this
   * interface and accessible to the calling document's frame.
   *
   * @return {!FingerprintRemote}
   */
  static getRemote() {
    let remote = new FingerprintRemote;
    remote.$.bindNewPipeAndPassReceiver().bindInBrowser();
    return remote;
  }
}


/**
 * An object which receives request messages for the Fingerprint
 * mojom interface and dispatches them as callbacks. One callback receiver exists
 * on this object for each message defined in the mojom interface, and each
 * receiver can have any number of listeners added to it.
 */
export class FingerprintCallbackRouter {
  constructor() {
    this.helper_internal_ = new mojo.internal.interfaceSupport.InterfaceReceiverHelperInternal(
      FingerprintRemote);

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceReceiverHelper<!FingerprintRemote>}
     */
    this.$ = new mojo.internal.interfaceSupport.InterfaceReceiverHelper(this.helper_internal_);

    this.router_ = new mojo.internal.interfaceSupport.CallbackRouter;

    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.getRecordsForUser =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        0,
        Fingerprint_GetRecordsForUser_ParamsSpec.$,
        Fingerprint_GetRecordsForUser_ResponseParamsSpec.$,
        this.getRecordsForUser.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startEnrollSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        1,
        Fingerprint_StartEnrollSession_ParamsSpec.$,
        null,
        this.startEnrollSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.cancelCurrentEnrollSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        2,
        Fingerprint_CancelCurrentEnrollSession_ParamsSpec.$,
        Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec.$,
        this.cancelCurrentEnrollSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestRecordLabel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        3,
        Fingerprint_RequestRecordLabel_ParamsSpec.$,
        Fingerprint_RequestRecordLabel_ResponseParamsSpec.$,
        this.requestRecordLabel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.setRecordLabel =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        4,
        Fingerprint_SetRecordLabel_ParamsSpec.$,
        Fingerprint_SetRecordLabel_ResponseParamsSpec.$,
        this.setRecordLabel.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.removeRecord =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        5,
        Fingerprint_RemoveRecord_ParamsSpec.$,
        Fingerprint_RemoveRecord_ResponseParamsSpec.$,
        this.removeRecord.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.startAuthSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        6,
        Fingerprint_StartAuthSession_ParamsSpec.$,
        null,
        this.startAuthSession.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.endCurrentAuthSession =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        7,
        Fingerprint_EndCurrentAuthSession_ParamsSpec.$,
        Fingerprint_EndCurrentAuthSession_ResponseParamsSpec.$,
        this.endCurrentAuthSession.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.destroyAllRecords =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        8,
        Fingerprint_DestroyAllRecords_ParamsSpec.$,
        Fingerprint_DestroyAllRecords_ResponseParamsSpec.$,
        this.destroyAllRecords.createReceiverHandler(true /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.addFingerprintObserver =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        9,
        Fingerprint_AddFingerprintObserver_ParamsSpec.$,
        null,
        this.addFingerprintObserver.createReceiverHandler(false /* expectsResponse */),
        false);
    /**
     * @public {!mojo.internal.interfaceSupport.InterfaceCallbackReceiver}
     */
    this.requestType =
        new mojo.internal.interfaceSupport.InterfaceCallbackReceiver(
            this.router_);

    this.helper_internal_.registerHandler(
        10,
        Fingerprint_RequestType_ParamsSpec.$,
        Fingerprint_RequestType_ResponseParamsSpec.$,
        this.requestType.createReceiverHandler(true /* expectsResponse */),
        false);
    /** @public {!mojo.internal.interfaceSupport.ConnectionErrorEventRouter} */
    this.onConnectionError = this.helper_internal_.getConnectionErrorEventRouter();
  }

  /**
   * @param {number} id An ID returned by a prior call to addListener.
   * @return {boolean} True iff the identified listener was found and removed.
   */
  removeListener(id) {
    return this.router_.removeListener(id);
  }
}

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FingerprintObserver_OnRestarted_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FingerprintObserver_OnStatusChanged_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FingerprintObserver_OnEnrollScanDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FingerprintObserver_OnAuthScanDone_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const FingerprintObserver_OnSessionFailed_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_GetRecordsForUser_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_GetRecordsForUser_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_StartEnrollSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_CancelCurrentEnrollSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_RequestRecordLabel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_RequestRecordLabel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_SetRecordLabel_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_SetRecordLabel_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_RemoveRecord_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_RemoveRecord_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_StartAuthSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_EndCurrentAuthSession_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_EndCurrentAuthSession_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_DestroyAllRecords_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_DestroyAllRecords_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_AddFingerprintObserver_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_RequestType_ParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType}}
 */
export const Fingerprint_RequestType_ResponseParamsSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };

/**
 * @const { {$:!mojo.internal.MojomType} }
 */
export const FingerprintMessageSpec =
    { $: /** @type {!mojo.internal.MojomType} */ ({}) };




mojo.internal.Struct(
    FingerprintObserver_OnRestarted_ParamsSpec.$,
    'FingerprintObserver_OnRestarted_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FingerprintObserver_OnRestarted_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    FingerprintObserver_OnStatusChanged_ParamsSpec.$,
    'FingerprintObserver_OnStatusChanged_Params',
    [
      mojo.internal.StructField(
        'status', 0,
        0,
        BiometricsManagerStatusSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class FingerprintObserver_OnStatusChanged_Params {
  constructor() {
    /** @type { !BiometricsManagerStatus } */
    this.status;
  }
}



mojo.internal.Struct(
    FingerprintObserver_OnEnrollScanDone_ParamsSpec.$,
    'FingerprintObserver_OnEnrollScanDone_Params',
    [
      mojo.internal.StructField(
        'scanResult', 0,
        0,
        ScanResultSpec.$,
        0,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'isComplete', 4,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'percentComplete', 8,
        0,
        mojo.internal.Int32,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class FingerprintObserver_OnEnrollScanDone_Params {
  constructor() {
    /** @type { !ScanResult } */
    this.scanResult;
    /** @type { !boolean } */
    this.isComplete;
    /** @type { !number } */
    this.percentComplete;
  }
}



mojo.internal.Struct(
    FingerprintObserver_OnAuthScanDone_ParamsSpec.$,
    'FingerprintObserver_OnAuthScanDone_Params',
    [
      mojo.internal.StructField(
        'msg', 0,
        0,
        FingerprintMessageSpec.$,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'matches', 16,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.Array(mojo.internal.String, false), false),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 32],]);



/**
 * @record
 */
export class FingerprintObserver_OnAuthScanDone_Params {
  constructor() {
    /** @type { !FingerprintMessage } */
    this.msg;
    /** @type { !Object<!string, !Array<!string>> } */
    this.matches;
  }
}



mojo.internal.Struct(
    FingerprintObserver_OnSessionFailed_ParamsSpec.$,
    'FingerprintObserver_OnSessionFailed_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class FingerprintObserver_OnSessionFailed_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Fingerprint_GetRecordsForUser_ParamsSpec.$,
    'Fingerprint_GetRecordsForUser_Params',
    [
      mojo.internal.StructField(
        'userId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_GetRecordsForUser_Params {
  constructor() {
    /** @type { !string } */
    this.userId;
  }
}



mojo.internal.Struct(
    Fingerprint_GetRecordsForUser_ResponseParamsSpec.$,
    'Fingerprint_GetRecordsForUser_ResponseParams',
    [
      mojo.internal.StructField(
        'records', 0,
        0,
        mojo.internal.Map(mojo.internal.String, mojo.internal.String, false),
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'success', 8,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Fingerprint_GetRecordsForUser_ResponseParams {
  constructor() {
    /** @type { !Object<!string, !string> } */
    this.records;
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    Fingerprint_StartEnrollSession_ParamsSpec.$,
    'Fingerprint_StartEnrollSession_Params',
    [
      mojo.internal.StructField(
        'userId', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'label', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Fingerprint_StartEnrollSession_Params {
  constructor() {
    /** @type { !string } */
    this.userId;
    /** @type { !string } */
    this.label;
  }
}



mojo.internal.Struct(
    Fingerprint_CancelCurrentEnrollSession_ParamsSpec.$,
    'Fingerprint_CancelCurrentEnrollSession_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Fingerprint_CancelCurrentEnrollSession_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Fingerprint_CancelCurrentEnrollSession_ResponseParamsSpec.$,
    'Fingerprint_CancelCurrentEnrollSession_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_CancelCurrentEnrollSession_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    Fingerprint_RequestRecordLabel_ParamsSpec.$,
    'Fingerprint_RequestRecordLabel_Params',
    [
      mojo.internal.StructField(
        'recordPath', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_RequestRecordLabel_Params {
  constructor() {
    /** @type { !string } */
    this.recordPath;
  }
}



mojo.internal.Struct(
    Fingerprint_RequestRecordLabel_ResponseParamsSpec.$,
    'Fingerprint_RequestRecordLabel_ResponseParams',
    [
      mojo.internal.StructField(
        'label', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_RequestRecordLabel_ResponseParams {
  constructor() {
    /** @type { !string } */
    this.label;
  }
}



mojo.internal.Struct(
    Fingerprint_SetRecordLabel_ParamsSpec.$,
    'Fingerprint_SetRecordLabel_Params',
    [
      mojo.internal.StructField(
        'recordPath', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
      mojo.internal.StructField(
        'newLabel', 8,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 24],]);



/**
 * @record
 */
export class Fingerprint_SetRecordLabel_Params {
  constructor() {
    /** @type { !string } */
    this.recordPath;
    /** @type { !string } */
    this.newLabel;
  }
}



mojo.internal.Struct(
    Fingerprint_SetRecordLabel_ResponseParamsSpec.$,
    'Fingerprint_SetRecordLabel_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_SetRecordLabel_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    Fingerprint_RemoveRecord_ParamsSpec.$,
    'Fingerprint_RemoveRecord_Params',
    [
      mojo.internal.StructField(
        'recordPath', 0,
        0,
        mojo.internal.String,
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_RemoveRecord_Params {
  constructor() {
    /** @type { !string } */
    this.recordPath;
  }
}



mojo.internal.Struct(
    Fingerprint_RemoveRecord_ResponseParamsSpec.$,
    'Fingerprint_RemoveRecord_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_RemoveRecord_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    Fingerprint_StartAuthSession_ParamsSpec.$,
    'Fingerprint_StartAuthSession_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Fingerprint_StartAuthSession_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Fingerprint_EndCurrentAuthSession_ParamsSpec.$,
    'Fingerprint_EndCurrentAuthSession_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Fingerprint_EndCurrentAuthSession_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Fingerprint_EndCurrentAuthSession_ResponseParamsSpec.$,
    'Fingerprint_EndCurrentAuthSession_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_EndCurrentAuthSession_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    Fingerprint_DestroyAllRecords_ParamsSpec.$,
    'Fingerprint_DestroyAllRecords_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Fingerprint_DestroyAllRecords_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Fingerprint_DestroyAllRecords_ResponseParamsSpec.$,
    'Fingerprint_DestroyAllRecords_ResponseParams',
    [
      mojo.internal.StructField(
        'success', 0,
        0,
        mojo.internal.Bool,
        false,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_DestroyAllRecords_ResponseParams {
  constructor() {
    /** @type { !boolean } */
    this.success;
  }
}



mojo.internal.Struct(
    Fingerprint_AddFingerprintObserver_ParamsSpec.$,
    'Fingerprint_AddFingerprintObserver_Params',
    [
      mojo.internal.StructField(
        'observer', 0,
        0,
        mojo.internal.InterfaceProxy(FingerprintObserverRemote),
        null,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_AddFingerprintObserver_Params {
  constructor() {
    /** @type { !FingerprintObserverRemote } */
    this.observer;
  }
}



mojo.internal.Struct(
    Fingerprint_RequestType_ParamsSpec.$,
    'Fingerprint_RequestType_Params',
    [
    ],
    [[0, 8],]);



/**
 * @record
 */
export class Fingerprint_RequestType_Params {
  constructor() {
  }
}



mojo.internal.Struct(
    Fingerprint_RequestType_ResponseParamsSpec.$,
    'Fingerprint_RequestType_ResponseParams',
    [
      mojo.internal.StructField(
        'type', 0,
        0,
        BiometricTypeSpec.$,
        0,
        false /* nullable */,
        0,
      ),
    ],
    [[0, 16],]);



/**
 * @record
 */
export class Fingerprint_RequestType_ResponseParams {
  constructor() {
    /** @type { !BiometricType } */
    this.type;
  }
}

mojo.internal.Union(
    FingerprintMessageSpec.$, 'FingerprintMessage',
    {
      'fingerprintError': {
        'ordinal': 0,
        'type': FingerprintErrorSpec.$,
      },
      'scanResult': {
        'ordinal': 1,
        'type': ScanResultSpec.$,
      },
    });

/**
 * @typedef { {
 *   fingerprintError: (!FingerprintError|undefined),
 *   scanResult: (!ScanResult|undefined),
 * } }
 */
export const FingerprintMessage = {};
