// services/device/public/mojom/battery_monitor.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/device/public/mojom/battery_monitor.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/debug/alias.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/thread_pool/thread_pool_instance.h"
#include "base/trace_event/trace_event.h"
#include "base/trace_event/typed_macros.h"
#include "base/types/cxx23_to_underlying.h"
#include "mojo/public/cpp/bindings/lib/default_construct_tag_internal.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/proxy_to_responder.h"
#include "mojo/public/cpp/bindings/lib/send_message_helper.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#include "mojo/public/cpp/bindings/urgent_message_scope.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"
#include "third_party/perfetto/include/perfetto/tracing/traced_value.h"

#include "services/device/public/mojom/battery_monitor.mojom-params-data.h"
#include "services/device/public/mojom/battery_monitor.mojom-shared-message-ids.h"

#include "services/device/public/mojom/battery_monitor.mojom-import-headers.h"
#include "services/device/public/mojom/battery_monitor.mojom-test-utils.h"


namespace device::mojom {
// The declaration includes the definition on other builds.

BatteryMonitor::IPCStableHashFunction BatteryMonitor::MessageToMethodInfo_(mojo::Message& message) {
#if !BUILDFLAG(IS_FUCHSIA)
  switch (static_cast<messages::BatteryMonitor>(message.name())) {
    case messages::BatteryMonitor::kQueryNextStatus: {
      return &BatteryMonitor::QueryNextStatus_Sym::IPCStableHash;
    }
  }
#endif  // !BUILDFLAG(IS_FUCHSIA)
  return nullptr;
}


const char* BatteryMonitor::MessageToMethodName_(mojo::Message& message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (!is_response) {
    switch (static_cast<messages::BatteryMonitor>(message.name())) {
      case messages::BatteryMonitor::kQueryNextStatus:
            return "Receive device::mojom::BatteryMonitor::QueryNextStatus";
    }
  } else {
    switch (static_cast<messages::BatteryMonitor>(message.name())) {
      case messages::BatteryMonitor::kQueryNextStatus:
            return "Receive reply device::mojom::BatteryMonitor::QueryNextStatus";
    }
  }
  return "Receive unknown mojo message";
#else
  bool is_response = message.has_flag(mojo::Message::kFlagIsResponse);
  if (is_response) {
    return "Receive mojo reply";
  } else {
    return "Receive mojo message";
  }
#endif // BUILDFLAG(MOJO_TRACE_ENABLED)
}

#if !BUILDFLAG(IS_FUCHSIA)
uint32_t BatteryMonitor::QueryNextStatus_Sym::IPCStableHash() {
  // This method's address is used for identifying the mojo method name after
  // symbolization. So each IPCStableHash should have a unique address.
  // We cannot use NO_CODE_FOLDING() here - it relies on the uniqueness of
  // __LINE__ value, which is not unique across different mojo modules.
  // The code below is very similar to NO_CODE_FOLDING, but it uses a unique
  // hash instead of __LINE__.
  static constexpr uint32_t kHash = 0xa9668452;  // IPCStableHash for device::mojom::BatteryMonitor::QueryNextStatus
  const uint32_t hash = kHash;
  base::debug::Alias(&hash);
  return hash;
}
# endif // !BUILDFLAG(IS_FUCHSIA)

class BatteryMonitor_QueryNextStatus_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  BatteryMonitor_QueryNextStatus_ForwardToCallback(
      BatteryMonitor::QueryNextStatusCallback callback
      ) : callback_(std::move(callback)) {
  }

  BatteryMonitor_QueryNextStatus_ForwardToCallback(const BatteryMonitor_QueryNextStatus_ForwardToCallback&) = delete;
  BatteryMonitor_QueryNextStatus_ForwardToCallback& operator=(const BatteryMonitor_QueryNextStatus_ForwardToCallback&) = delete;

  bool Accept(mojo::Message* message) override;
 private:
  BatteryMonitor::QueryNextStatusCallback callback_;
};

BatteryMonitorProxy::BatteryMonitorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BatteryMonitorProxy::QueryNextStatus(
    QueryNextStatusCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "Send device::mojom::BatteryMonitor::QueryNextStatus");
#endif

  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  const bool kAllowInterrupt = true;
  const bool is_urgent = false;

  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0) |
      ((kAllowInterrupt) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((is_urgent) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BatteryMonitor::kQueryNextStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::BatteryMonitor_QueryNextStatus_Params_Data> params(
          message);
  params.Allocate();

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BatteryMonitor::Name_);
  message.set_method_name("QueryNextStatus");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new BatteryMonitor_QueryNextStatus_ForwardToCallback(
          std::move(callback)));
  ::mojo::internal::SendMojoMessage(*receiver_, message, std::move(responder));
}
class BatteryMonitor_QueryNextStatus_ProxyToResponder : public ::mojo::internal::ProxyToResponder {
 public:
  static BatteryMonitor::QueryNextStatusCallback CreateCallback(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
    std::unique_ptr<BatteryMonitor_QueryNextStatus_ProxyToResponder> proxy(
        new BatteryMonitor_QueryNextStatus_ProxyToResponder(
            message, std::move(responder)));
    return base::BindOnce(&BatteryMonitor_QueryNextStatus_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~BatteryMonitor_QueryNextStatus_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      // Instantiate a ScopedFizzleBlockShutdownTasks to allow this request to
      // fizzle if this happens after shutdown and the endpoint is bound to a
      // BLOCK_SHUTDOWN sequence.
      base::ThreadPoolInstance::ScopedFizzleBlockShutdownTasks fizzler;
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
  }

 private:
  BatteryMonitor_QueryNextStatus_ProxyToResponder(
      ::mojo::Message& message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder)
      : ::mojo::internal::ProxyToResponder(message, std::move(responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
    DCHECK(!connected)
        << "BatteryMonitor::QueryNextStatusCallback was destroyed without "
        << "first either being run or its corresponding binding being closed. "
        << "It is an error to drop response callbacks which still correspond "
        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::device::mojom::BatteryStatusPtr in_status);
};

bool BatteryMonitor_QueryNextStatus_ForwardToCallback::Accept(
    mojo::Message* message) {
  DCHECK(message->is_serialized());
  internal::BatteryMonitor_QueryNextStatus_ResponseParams_Data* params =
      reinterpret_cast<
          internal::BatteryMonitor_QueryNextStatus_ResponseParams_Data*>(
              message->mutable_payload());
  

  // Validation for BatteryMonitor.0
  bool success = true;
  ::device::mojom::BatteryStatusPtr p_status{};
  BatteryMonitor_QueryNextStatus_ResponseParamsDataView input_data_view(params, message);
  
  if (success && !input_data_view.ReadStatus(&p_status))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        BatteryMonitor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null()) {
    std::move(callback_).Run(
std::move(p_status));
  }
  return true;
}

void BatteryMonitor_QueryNextStatus_ProxyToResponder::Run(
    ::device::mojom::BatteryStatusPtr in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "Send reply device::mojom::BatteryMonitor::QueryNextStatus", "async_response_parameters",
    [&](perfetto::TracedValue context){
      auto dict = std::move(context).WriteDictionary();
      perfetto::WriteIntoTracedValueWithFallback(
           dict.AddItem("status"), in_status,
                        "<value of type ::device::mojom::BatteryStatusPtr>");
   });
#endif

  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0) |
      ((true) ? 0 : mojo::Message::kFlagNoInterrupt) |
      ((false) ? mojo::Message::kFlagIsUrgent : 0);

  const size_t estimated_payload_size =
    0;
  mojo::Message message(
      base::to_underlying(messages::BatteryMonitor::kQueryNextStatus), kFlags, estimated_payload_size);
  mojo::internal::MessageFragment<
      ::device::mojom::internal::BatteryMonitor_QueryNextStatus_ResponseParams_Data> params(
          message);
  params.Allocate();
  mojo::internal::MessageFragment<
      typename decltype(params->status)::BaseType> status_fragment(
          params.message());
  
  mojo::internal::Serialize<::device::mojom::BatteryStatusDataView>(
    in_status,
    status_fragment);

  params->status.Set(
      status_fragment.is_null() ? nullptr : status_fragment.data());

  
  MOJO_INTERNAL_CHECK_SERIALIZATION(
    mojo::internal::SendValidation::kDefault,
    !(params->status.is_null()),
    mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
    "null status in ");

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BatteryMonitor::Name_);
  message.set_method_name("QueryNextStatus");
#endif

  message.set_request_id(request_id_);
  message.set_trace_nonce(trace_nonce_);
  ::mojo::internal::SendMojoMessage(*responder_, message);
  // SendMojoMessage() fails silently if the responder connection is closed,
  // or if the message is malformed.
  //
  // TODO(darin): If Accept() returns false due to a malformed message, that
  // may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool BatteryMonitorStubDispatch::Accept(
    BatteryMonitor* impl,
    mojo::Message* message) {
  switch (static_cast<messages::BatteryMonitor>(message->header()->name)) {
    case messages::BatteryMonitor::kQueryNextStatus: {
      break;
    }
  }
  return false;
}

// static
bool BatteryMonitorStubDispatch::AcceptWithResponder(
    BatteryMonitor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  [[maybe_unused]] const bool message_is_sync =
      message->has_flag(mojo::Message::kFlagIsSync);
  [[maybe_unused]] const uint64_t request_id = message->request_id();
  switch (static_cast<messages::BatteryMonitor>(message->header()->name)) {
    case messages::BatteryMonitor::kQueryNextStatus: {
      internal::BatteryMonitor_QueryNextStatus_Params_Data* params =
          reinterpret_cast<
              internal::BatteryMonitor_QueryNextStatus_Params_Data*>(
                  message->mutable_payload());
      

      // Validation for BatteryMonitor.0
      bool success = true;
      BatteryMonitor_QueryNextStatus_ParamsDataView input_data_view(params, message);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BatteryMonitor::Name_, 0, false);
        return false;
      }
      auto callback =
          BatteryMonitor_QueryNextStatus_ProxyToResponder::CreateCallback(
              *message, std::move(responder));
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueryNextStatus(std::move(callback));
      return true;
    }
  }
  return false;
}
namespace {
}  // namespace
static const mojo::internal::GenericValidationInfo kBatteryMonitorValidationInfo[] = {
    { &internal::BatteryMonitor_QueryNextStatus_Params_Data::Validate,
     &internal::BatteryMonitor_QueryNextStatus_ResponseParams_Data::Validate},
};

bool BatteryMonitorRequestValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateRequestGenericPacked(
    message,
    ::device::mojom::BatteryMonitor::Name_,
    kBatteryMonitorValidationInfo);
}

bool BatteryMonitorResponseValidator::Accept(mojo::Message* message) {
  return mojo::internal::ValidateResponseGenericPacked(
    message,
    ::device::mojom::BatteryMonitor::Name_,
    kBatteryMonitorValidationInfo);
}


}  // device::mojom


namespace mojo {

}  // namespace mojo


// Symbols declared in the -test-utils.h header are defined here instead of a
// separate .cc file to save compile time.


namespace device::mojom {


void BatteryMonitorInterceptorForTesting::QueryNextStatus(QueryNextStatusCallback callback) {
  GetForwardingInterface()->QueryNextStatus(std::move(callback));
}
BatteryMonitorAsyncWaiter::BatteryMonitorAsyncWaiter(
    BatteryMonitor* proxy) : proxy_(proxy) {}

BatteryMonitorAsyncWaiter::~BatteryMonitorAsyncWaiter() = default;


void BatteryMonitorAsyncWaiter::QueryNextStatus(
    ::device::mojom::BatteryStatusPtr* out_status) {
  base::RunLoop loop;
  proxy_->QueryNextStatus(
      base::BindOnce(
          [](base::RunLoop* loop,
             ::device::mojom::BatteryStatusPtr* out_status
,
             ::device::mojom::BatteryStatusPtr status) {*out_status = std::move(status);
            loop->Quit();
          },
          &loop,
          out_status));
  loop.Run();
}

::device::mojom::BatteryStatusPtr BatteryMonitorAsyncWaiter::QueryNextStatus(
    ) {
  ::device::mojom::BatteryStatusPtr async_wait_result;
  QueryNextStatus(&async_wait_result);
  return async_wait_result;
}






}  // device::mojom


#if defined(__clang__)
#pragma clang diagnostic pop
#endif