// services/data_decoder/public/mojom/gzipper.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_GZIPPER_MOJOM_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_GZIPPER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <optional>
#include <type_traits>
#include <utility>
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"

#include "third_party/perfetto/include/perfetto/tracing/traced_value_forward.h"

#include "services/data_decoder/public/mojom/gzipper.mojom-features.h"  // IWYU pragma: export
#include "services/data_decoder/public/mojom/gzipper.mojom-shared.h"  // IWYU pragma: export
#include "services/data_decoder/public/mojom/gzipper.mojom-forward.h"  // IWYU pragma: export
#include "mojo/public/mojom/base/big_buffer.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"






namespace data_decoder::mojom {

class GzipperProxy;

template <typename ImplRefTraits>
class GzipperStub;

class GzipperRequestValidator;
class GzipperResponseValidator;


class Gzipper
    : public GzipperInterfaceBase {
 public:
  using IPCStableHashFunction = uint32_t(*)();
  static constexpr const char* Name_ = "data_decoder.mojom.Gzipper";
  static IPCStableHashFunction MessageToMethodInfo_(mojo::Message& message);
  static const char* MessageToMethodName_(mojo::Message& message);
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasUninterruptableMethods_ = false;

  using Base_ = GzipperInterfaceBase;
  using Proxy_ = GzipperProxy;

  template <typename ImplRefTraits>
  using Stub_ = GzipperStub<ImplRefTraits>;

  using RequestValidator_ = GzipperRequestValidator;
  using ResponseValidator_ = GzipperResponseValidator;
  enum MethodMinVersions : uint32_t {
    kDeflateMinVersion = 0,
    kInflateMinVersion = 0,
    kCompressMinVersion = 0,
    kUncompressMinVersion = 0,
  };

// crbug.com/1340245 - this causes binary size bloat on Fuchsia, and we're OK
// with not having this data in traces there.
#if !BUILDFLAG(IS_FUCHSIA)
  struct Deflate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Inflate_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Compress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
  struct Uncompress_Sym {
    NOINLINE static uint32_t IPCStableHash();
  };
#endif // !BUILDFLAG(IS_FUCHSIA)
  virtual ~Gzipper() = default;

  using DeflateCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;
  using DeflateMojoCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;

  virtual void Deflate(::mojo_base::BigBuffer data, DeflateCallback callback) = 0;

  using InflateCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;
  using InflateMojoCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;

  virtual void Inflate(::mojo_base::BigBuffer data, uint64_t max_uncompressed_size, InflateCallback callback) = 0;

  using CompressCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;
  using CompressMojoCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;

  virtual void Compress(::mojo_base::BigBuffer data, CompressCallback callback) = 0;

  using UncompressCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;
  using UncompressMojoCallback = base::OnceCallback<void(std::optional<::mojo_base::BigBuffer>)>;

  virtual void Uncompress(::mojo_base::BigBuffer compressed_data, UncompressCallback callback) = 0;
};



class  GzipperProxy
    : public Gzipper {
 public:
  using InterfaceType = Gzipper;

  explicit GzipperProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Deflate(::mojo_base::BigBuffer data, DeflateCallback callback) final;
  
  void Inflate(::mojo_base::BigBuffer data, uint64_t max_uncompressed_size, InflateCallback callback) final;
  
  void Compress(::mojo_base::BigBuffer data, CompressCallback callback) final;
  
  void Uncompress(::mojo_base::BigBuffer compressed_data, UncompressCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  GzipperStubDispatch {
 public:
  static bool Accept(Gzipper* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Gzipper* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Gzipper>>
class GzipperStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  GzipperStub() = default;
  ~GzipperStub() override = default;

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GzipperStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return GzipperStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  GzipperRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  GzipperResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // data_decoder::mojom

namespace mojo {

}  // namespace mojo

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_GZIPPER_MOJOM_H_